.\" xmandel.1 93/09/09
.TH XMANDEL 1 "22th March 1994" "Phil\'s Software"
.SH NAME
xmandel v2.0 \- displays mandelbrot fractal, with adjustable coordinates
and zoom

.SH FEATURES
 \-\-  Alterable equasion
 \-\-  Zoom/Unzoom to the limits of IEEE F.P. coordinates
 \-\-  Move center view
 \-\-  "Fast" mode
 \-\-  Alterable escape radius check
 \-\-  Alterable level of escape checking
 \-\-  Program keeps working while drawing function
 \-\-  Stop button
 \-\-  Progress line at left side of window

.SH OPTIONS

.TP
\-fast

Use a non-proper method of determining colors. Traditionally, the
position of a point is calculated recursively through the equasion, and
checked using the Pythagorean theorem to see if it is past the radius.
(The radius is normally set to "2", although this is alterable in
xmandel).

HOWEVER. I have discovered that simply checking whether \fIeither\fR the
real element, \fIor\fR the imaginary element is past the radius, still
keeps the general layout of the mandelbrot set. It actually emphasizes
certain features of it, although it loses some of the "fractal dimention"
at places.

Ironically, using full method of determining magnitude seems to be less
true to the common seen representations in some cases . Even when it is
similar, it all too often require extremly high depth (in excess of 300)
to display the more interesting parts, whereas fast mode may be
interesting at 150.

.SH DESCRIPTION

.PP
Xmandel is configured to calculate a fractal, based on Benoit
Mandelbrot's famous equasion. Zooming the image is allowed, and in fact
the main point of the program.

.SH THE EQUASION
If your version of xmandel was compiled without the MANDELONLY option,
you should be able to alter what equasion is used. 

NOTE!! \fIThe equasion value will not be parsed "normally".\fR
Operands are applied in the order encountered.
The good news is, you can override this with parenthesis.

The equasion is parsed cumilatively from left to right. For example,

    C + Z + C * C

will be parsed as

    (((C + Z) + C) * C)

 "C" is "current coordinate, fixed at initial value"
 "Z" is "current coordinate, at last iteration"


Valid equasions are put together as follows:

.RS 5
Initial 'Z' or 'C'

  Then any combination of 

  '-' followed by 'Z' or 'C'
  '+' followed by 'Z' or 'C'
  '*' followed by 'Z' or 'C'
  '^2' 
      \fB^2 is ONE symbol!!\fR
.RE

.SH COLORS
What do all the colors mean??!!!

Assuming you have a color display, the colors are set up in "rainbow"
order:  red, orange, yellow, green, blue, purple, violet, white. 

Red or orange means it escapes very fast. White means it escapes
Sloooowly.  But contradictorily, Black means it escapes the slowest: it
never escapes.


.I Depth
is the definition of "many interations". The program will assume that if
a point does not escape the \fIRadius\fR after \fIDepth\fR iterations, it
is not going anywhere (In which case, the pixel will be colored black).

.I Radius
is distance from the current \fI(CenterX,CenterY)\fR coordinates. Color
of a pixel is determined by whether applying the displayed equasion
recursively (\fIDepth\fR number of times) will generate a number outside the displayed radius.

.I Width
and 
.I Height
are the width and height of the entire viewing window. Adjusting them
gives you Zoom-in/out.


.SH MOUSE CONTROLS
The
.I left 
mouse button sets a new CenterX/CenterY spot.

The 
.I middle
mouse button both sets a new CenterX/CenterY spot, \fBand\fR
zooms in by a factor of two. Repeated clicking of the middle button will
zoom in, with \fBincreasing powers of 2\fR.

The 
.I right
mouse button zooms out by powers of 2.

.SH BUTTONS

.I (Fast/Real) 
Toggle between fast calculations, and real (traditional) calculating method.

.I Quit
quits the program

.I Draw
starts the drawing of the currectly displayed parameters

.I Clear
puts up the initial screen. (handy to see progress if there is lots of
black on the screen).

.I Reset
should restore the parameters to the way they were for the last draw.

.I Stop
stops the drawing process.


.SH HINTS
(Lots of hints!)

Contrary to intuition, it often helps to INCREASE the radius, as you zoom
in. Too much white/orange/red? Increase the radius. Too much black/purple?
Decrease it (and/or increase the \fIDepth\fR).

A good depth to use once you get past the large black areas is about 80,
or 144.

Zooming in (via the middle mouse button, or manually twiddling the width
& height) can be interesting, but generally only along craggy edges.
Staying slightly closer to the colored side of edges will make drawing
times faster. Black is the slowest color to figure out.  Similarly: It's
best to zoom in on a part with Black on the bottom. That way, you can
press Stop after it's drawn the stuff you're interested in.

You do not have to type out numbers to 10 decimal places! Once you start
hitting the zeros, stop, and the program will fill in the rest. OR you
can use IEEE notation! ("1.3E-05", etc).

Depth is best when set to a multiple of the number of colors not
including black. In other words, with the ROYGBIV setup + white,
multiples of 8 should work best.

The Fast/Real mode button can be toggled WHILE the program is drawing!

.SH Warning
Changing the depth and/or radius dramatically, can dramatically alter
the picture. Think of them as "aperture" and "exposure time"; not
neccessarily in that order [although "depth" is often linearly related to
"time it takes to develop a picture".]


.SH BUGS
Well, not BUGS.. just not fully implemented stuff.

Possibly, there is a warping of the display, because of something to do
with scaling? I am suspicious of this because of C^2+Z. Then again, C^2^2+Z
is markedly uneven, so perhaps I just don't know enough about complex mathematics

The "s" accelerator doesnt' seem to STOP while drawing. This seems to be
Xt's fault, not mine. gdb sez it gets called, except while in the draw
loop. The Stop button callback works.. so should the accelerator.
(nasty code in RedrawCallback, though)

Using IEEE doubles, Max useful zoom width is "only" about about 1.0E-14

It "only" uses 8 colors. Although if you just add more color defs to
"color.c", and update NUMOFCOLORS, it should work just fine.

Does not check for bad values yet.

[and of course, it's fairly slow :-(]

.SH AUTHOR
Philip P Brown

.SH COPYRIGHT
Philip Brown is currently a student of the University of California.
This program was not developed using any university resources.  However,
xmandel v1.0 was a final project for a class, and thereby becomes
Copyright material of the University of California, I believe.  Standard
UC copyright thereby applies here.  I think that means that 
 "The Berkeley software License Agreement specifies the terms and
conditions for redistribution." (as noted in "curses.h" on SunOS4.1.2)


Note that versions greater than v1.0 were developed after the class was
over, so I'm not sure of the copyrights there.

