/* widgets.c:
 *  The  purpose:
 *	To make the many widgets in this program.
 *	Also, to install some accelerators
 */

#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Form.h>
#include <Xaw/Simple.h>
#include <Xaw/Command.h>
#include <Xaw/Box.h>

#include "globals.h"
#include "patchlevel.h"


Widget redrawButton,clearButton,resetButton,stopButton;


/* StopCallback:
 *	It's SOLE PURPOSE is to set DoingDraw to False.
 *	If we're in the drawing loop, we will stop drawing
 *	ALso called by accelerator
 */
extern XtWorkProcId workprocID;
void StopCallback(Widget w,XtPointer call_data,XtPointer client_data){
	DoingDraw = False;
	XtRemoveWorkProc(workprocID);
	XtSetSensitive(redrawButton,True);
	return;
}

void Draw_keypress(Widget w,XEvent *event,String *params,Cardinal *num_parags){
	RedrawCallback(w,NULL,NULL);
}
void Stop_keypress(Widget w,XEvent *event,String *params,Cardinal *num_parags){
	StopCallback(w,NULL,NULL);
}

/* So we can make a <Return> accelerator.. */
static XtActionsRec actionlist[] = {
	{ "DialogOK",	DialogOK},
	{ "Draw",	Draw_keypress},
	{ "Stop",	Stop_keypress},
};


static char * ReturnAc=
	"<Key>Return: DialogOK()";
static char * MandelAc =
	" <Key>s:      Stop()     \n \
          <Key>d:      Draw()";

/* FastCallback()
*	Toggled between fast and slow mode
*/
static FastMode = False;
void FastCallback(Widget w,XtPointer call_data,XtPointer client_data){
	switch(FastMode){
		case True:
			FastMode = False;
			CalculateColor = calculatePoint;
			XtVaSetValues(w,XtNlabel,"Real",NULL);
			break;
		case False:
			FastMode = True;
			CalculateColor = fastcalculatePoint;
			XtVaSetValues(w,XtNlabel,"Fast",NULL);
			break;
	}
}
/* MakeHelp:
 *	Makes mouse help labels
 */
void MakeHelp(){
	Widget MouseHelpBox;
	Widget MouseHelpLabel;

	MouseHelpForm = XtVaCreateManagedWidget("mousehelpform",boxWidgetClass,topform,
				XtNfromVert,equasionForm,
				XtNfromHoriz,mandelWidget,
				XtNborderWidth,0,
				NULL);
	MouseHelpLabel = XtVaCreateManagedWidget("mousehelplabel",labelWidgetClass,MouseHelpForm,
				XtNlabel,"Mouse Button Help",
				XtNborderWidth,0,
				NULL);
	MouseHelpBox = XtVaCreateManagedWidget("mousehelpbox",boxWidgetClass,MouseHelpForm,
				XtNfromVert,MouseHelpLabel,
				XtNorientation,XtorientHorizontal,
				NULL);
	XtVaCreateManagedWidget("leftbutton",labelWidgetClass,MouseHelpBox,
				XtNlabel,"Move",
				XtNshapeStyle,XawShapeOval,
				NULL);
	XtVaCreateManagedWidget("middlebutton",labelWidgetClass,MouseHelpBox,
				XtNlabel,"Zoom",
				XtNshapeStyle,XawShapeOval,
				NULL);
	XtVaCreateManagedWidget("leftbutton",labelWidgetClass,MouseHelpBox,
				XtNlabel,"Unzoom",
				XtNshapeStyle,XawShapeOval,
				NULL);
}

/* MakeWidgets:
 *	Top level widget creation routine.
 *	calls MakeHelp(), and MakeEquasionDialog(),
 *	as well as making all the general widgets.
 *	(including the Mandelbrot widget)
 */
void MakeWidgets(){
	Widget fastToggle;
	XtAccelerators MandelAccelerator;	

	XtAppAddActions(Context,actionlist,XtNumber(actionlist));
	ReturnAccelerator = XtParseAcceleratorTable(ReturnAc);
	MandelAccelerator = XtParseAcceleratorTable(MandelAc);

	/* topform holds mandelbrot window, AND
	 * form that holds input stuffs
	 */
	topform = XtVaCreateManagedWidget(
			"topform",formWidgetClass,toplevel,
			NULL);

	mandelWidget = XtVaCreateManagedWidget(
			"mandel",simpleWidgetClass,topform,
			XtNright,XawChainLeft,
			XtNleft,XawChainLeft,
			XtNbottom,XawChainTop,
			XtNtop,XawChainTop,
			XtNwidth,mandelwidth,
			XtNheight,mandelheight,
			NULL);
	XtOverrideTranslations(mandelWidget,MandelAccelerator);

	XtAddEventHandler(mandelWidget,ButtonPressMask,False,
			 MandelHandler,(XtPointer) 1);

	/* equasionForm holds all the equasion controlls */
	equasionForm = XtVaCreateManagedWidget(
			"form",formWidgetClass,topform,
			XtNfromHoriz,mandelWidget,
			XtNleft,XawChainLeft,
			NULL);
	/* title bar on top */
	formLabel =  XtVaCreateManagedWidget(
			"formLabel",labelWidgetClass,equasionForm,
			XtNlabel,VERSION,
			XtNwidth,180,
			XtNright,XawChainRight,
			XtNleft,XawChainRight,
			NULL);

	fastToggle = XtVaCreateManagedWidget("fastToggle",commandWidgetClass,equasionForm,
			XtNfromHoriz,formLabel,
			NULL);
	if(FastMode){
		XtVaSetValues(fastToggle,XtNlabel,"Fast",NULL);
	} else {
		XtVaSetValues(fastToggle,XtNlabel,"Real",NULL);
	}
	buttonBox = XtVaCreateManagedWidget(
			"form",boxWidgetClass,equasionForm,
			XtNfromVert,formLabel,
			XtNborderWidth,2,
			XtNorientation,XtorientHorizontal,
			XtNwidth,150,
			XtNheight,50,
			XtNright,XawChainLeft,
			XtNleft,XawChainLeft,
			NULL);
	redrawButton = XtVaCreateManagedWidget(
			"redraw",commandWidgetClass,buttonBox,
			XtNshapeStyle,XawShapeOval,
			XtNborderWidth,2,
			XtNlabel,"Draw",
			NULL);

	resetButton = XtVaCreateManagedWidget(
			"clear",commandWidgetClass,buttonBox,
			XtNshapeStyle,XawShapeOval,
			XtNlabel,"Reset",
			NULL);
	stopButton =  XtVaCreateManagedWidget(
			"stop",commandWidgetClass,buttonBox,
			XtNshapeStyle,XawShapeOval,
			XtNlabel,"Stop",
			NULL);
	clearButton = XtVaCreateManagedWidget(
			"clear",commandWidgetClass,buttonBox,
			XtNshapeStyle,XawShapeOval,
			XtNlabel,"Clear",
			NULL);

	quitButton = XtVaCreateManagedWidget(
			"quit",commandWidgetClass,buttonBox,
			/*XtNshapeStyle,XawShapeOval,*/
			XtNlabel,"Quit",
			XtNwidth,40,
			NULL);

	XtAddCallback(quitButton,XtNcallback,QuitCallback,NULL);
	XtAddCallback(redrawButton,XtNcallback,RedrawCallback,NULL);
	XtAddCallback(clearButton,XtNcallback,ClearCallback,NULL);
	XtAddCallback(resetButton,XtNcallback,ResetCallback,NULL);
	XtAddCallback(stopButton,XtNcallback,StopCallback,NULL);

	XtAddCallback(fastToggle,XtNcallback,FastCallback,NULL);

	MakeEquasionDialog();

	/* make mouse help buttons */
	MakeHelp();
}
