#define DEBUG 1

/* 
 * main file for xfrac:
 *	Interactive mandelbrot drawing program.
 *
 *	Design goal:
 *	draw a mandlebot interactively
 *
 */

/*
 * Acknowlegements:
 * many thanks to the author of "tetris", for using proper X style, so that
 * I could learn.
 */

#include <stdio.h>
#include <stdlib.h>

#include <Xatom.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Shell.h>
#include <Xaw/Form.h>
#include <Xaw/Simple.h>
#include <Xaw/Command.h>
#include <Xaw/Dialog.h>

  /* Intrinsic also does Xlib.h, Xutil.h, Xresource.h, Xos.h,
   *                     Xfuncproto.h
   */


#define MAIN 1
#include "globals.h"
#undef MAIN

#include "icon_xbm"

static Atom wm_message,delete_message;
void quit(){
	XFreePixmap(display,mandelbrotPixmap);
	XtCloseDisplay(display);
	exit(0);
}

static char * fallbacks[] = {
	"XMandel*mandel.width:  400",
	"XMandel*mandel.height: 400",
	"XMandel*mandel.background: black",
	"XMandel*form.width:    100",
	"XMandel*form.height:   400",
	"XMandel*form.background: white",
	NULL
};


XrmOptionDescRec optionList[] = {
	{"-display", ".display", XrmoptionSepArg, (caddr_t) NULL},
	{"-geometry", "*geometry", XrmoptionSepArg, (caddr_t) NULL},
	{"-iconGeometry", "*iconGeometry", XrmoptionSepArg, (caddr_t) NULL},
	{"-background", "*background", XrmoptionSepArg, (caddr_t) NULL},
	{"-bg", "*background", XrmoptionSepArg, (caddr_t) NULL},
	{"-foreground", "*foreground", XrmoptionSepArg, (caddr_t) NULL},
	{"-fg", "*foreground", XrmoptionSepArg, (caddr_t) NULL},
};



/* handle_delete
 *      Its sole purpose is to handle WM_DELETE messages
 */
void
handle_delete(Widget w,XtPointer closure,XEvent *event,Boolean *cont)
{
        XClientMessageEvent *cevent = (XClientMessageEvent *) event;

        if(cevent->type != ClientMessage) return;
        if(cevent->message_type != wm_message) return;
        if(cevent->data.l[0] != delete_message)  return;

        quit();
}
void QuitCallback(Widget widget,XtPointer data,XtPointer calldata)
/* ARGSUSED */
{
	quit();
}

#include "patchlevel.h"

static char *version = VERSION;
void usage(){
	printf("%s\n",version);
	fflush(stdout);
	puts("");
	puts("    -fast:   uses quicker rendering algorythm");
	puts("");
	puts(" Xmandel draws a mandelbrot in a window, allowing certain parameters");
	puts("  to be changed. It does not draw the mandelbrot until the Draw button is pressed");
	puts(" It is possible to zoom in and out using the middle and right buttons");
	puts(" The left button will change the center of the picture");
	puts("");
	exit(0);
}


/* this routine is solely for internalizing various
 *  "Atoms" neccessary to handle the stupid WM_DELETE_WINDOW
 *  message
 */
void setup_deletewindow(Display *display,Window win, XtEventHandler handler)
{
/* wm_message and delete_message have to be global, to be used with the
 * event handler
 */
	if(display == NULL){
		perror("display var has not been set for setup_deletewindow");
	}
	if(win == 0){
		perror("window var has not been set for setup_deletewindow");
	}

        wm_message=XInternAtom(display,"WM_PROTOCOLS",False);
        delete_message=XInternAtom(display,"WM_DELETE_WINDOW",False);

        XtAddEventHandler(toplevel, NoEventMask, True,
                             handler, (XtPointer)NULL);
        XChangeProperty(display, win, 
                        wm_message, XA_ATOM, 32, PropModeReplace,
                        (unsigned char *) &delete_message, 1);

        if (wm_message == (Atom) NULL) {
                perror("unable to create wm_message property");
                exit(1);
	}
        if (delete_message == (Atom) NULL) {
                perror("unable to create delete property");
                exit(1);
	}

}

int main(int argc,char *argv[])
{
	Pixmap iconpixmap;
	mandelwidth = START_MANDEL_WIDTH;
	mandelheight = START_MANDEL_HEIGHT;
	toplevel = XtVaAppInitialize(&Context,"XMandel",
				   optionList,XtNumber(optionList),
				   &argc,argv,
				   fallbacks,
				   (ArgList) NULL,(Cardinal) NULL);

	CalculateColor = calculatePoint;
	if(argc>1){
		if(strcmp(argv[1],"-fast") == 0){
			CalculateColor = fastcalculatePoint;
			puts("Doing FAST calculation method");
		} else
			usage();
	}
	display = XtDisplay(toplevel);
	screen = XtScreen(toplevel);
	screennum = XScreenNumberOfScreen(screen);
	depth_of_screen = DefaultDepthOfScreen(screen);

	rootwindow = RootWindow(display,screennum);
	blackpixel = BlackPixel(display,screennum);
	whitepixel = WhitePixel(display,screennum);

	mandelbrotPixmap = XCreatePixmap(display,rootwindow,
		      mandelwidth,mandelheight,
		      depth_of_screen);

	MakeWidgets();
	XtRealizeWidget(toplevel);

	mainwindow = XtWindow(toplevel);

	setup_deletewindow(display,mainwindow,handle_delete);

	iconpixmap = XCreateBitmapFromData(display,mainwindow,
			   icon_xbm_bits,icon_xbm_width,icon_xbm_height);

	XtVaSetValues(toplevel,XtNiconName,"xmandel",
				XtNiconPixmap,iconpixmap,
				NULL);

	defaultgc = DefaultGC(display,screennum);
	/* loadcolors also clears the pixmap */
	LoadColors();
	ReadValues(); /* initialize local variables from static strings */
	XtAppMainLoop(Context);
	return 0;
}
