/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char sccsid[] = "@(#)cmds.c	5.4 (Berkeley) 6/30/88";
#endif /* not lint */

/*
 * lpc -- line printer control program -- commands:
 */

#include "../lp.h"
#include "../buffer_names.h"
#include <sys/time.h>
#include <string.h>

#define FALSE 0
#define TRUE 1
#define NIL(type)             (type *) 0

struct  stat fileinfo;					    /* file information from fstat. */
time_t  etc_printcap_mtime;

/*
 * Print the buf0->status of each queue listed or all the queues.
 */
void getStatus()
{
    register int c, status;
    register char *cp1, *cp2;
    char prbuf[100];
    
    if ( stat("/etc/printcap", &fileinfo) ) {		    /* get fstat of /etc/printcap */
	fprintf(stderr,"Failure in fstat of /etc/printcap \n");
	return;
    }
    if (etc_printcap_mtime != fileinfo.st_mtime){		    /* if someone else has changed the file then...*/
	buf0->nitems = 1;
	printer = prbuf;
	while (getprent(line) > 0) {
	    cp1 = prbuf;
	    cp2 = line;
	    while ((c = *cp2++) && c != '|' && c != ':')
		*cp1++ = c;
	    *cp1 = '\0';
	    prstat();
	    if ( buf0->nitems >= MAX_QUEUES ) {
		fprintf(stderr, "ERROR - More queues in /etc/printcap than program supports\n");
		buf0->nitems--;
		break;
	    }
	}
	etc_printcap_mtime = fileinfo.st_mtime;                    /* remember last time /etc/printcap was changed */
	return;
    }
    else{
	c = buf0->nitems;
	buf0->nitems = 1;
	while (buf0->nitems < c)
	    prstat();
	return;
    }
}
/*
 * Print the status of the printer queue.
 */
prstat()
{
	struct stat stbuf;
	register int fd, i;
	register struct direct *dp;
	DIR *dirp;

    if (etc_printcap_mtime != fileinfo.st_mtime){		    /* if someone else has changed the file then...*/
	bp = pbuf;
	if ((SD = pgetstr("sd", &bp)) == NULL)
	    SD = DEFSPOOL;
	strcpy (buf0->qdata[buf0->nitems][SDI], SD);
	if ((LO = pgetstr("lo", &bp)) == NULL)
	    LO = DEFLOCK;
	strcpy (buf0->qdata[buf0->nitems][LOI], LO);
	if ((ST = pgetstr("st", &bp)) == NULL)
	    ST = DEFSTAT;
	strcpy (buf0->qdata[buf0->nitems][STI], ST);
	if ((LF = pgetstr("lf", &bp)) != NULL)
	    strcpy (buf0->qdata[buf0->nitems][LFI],LF);
	else
	    buf0->qdata[buf0->nitems][LFI][0] = NULL;
	if ((OF = pgetstr("of", &bp)) != NULL){
	    if(strstr(OF,"iplpscomm") != NULL){
		LP = strtok(OF, " ");
		LP = strtok(NIL(char), " ");
	    }
	    else if ((LP = pgetstr("lp", &bp)) == NULL)
		LP = DEFDEVLP;
	}
 	else if ((LP = pgetstr("lp", &bp)) == NULL)
	    LP = DEFDEVLP;
	strcpy (buf0->qdata[buf0->nitems][LPI], LP);
	if ((RP = pgetstr("rp", &bp)) == NULL)
	    RP = DEFLP;
	strcpy (buf0->qdata[buf0->nitems][RPI], RP);
	RM = pgetstr("rm", &bp);
	if (RM) strcpy (buf0->qdata[buf0->nitems][RMI], RM);
	
	strcpy (buf0->queNames[buf0->nitems], printer);
	
	if (buf0->qdata[buf0->nitems][LPI][0] != '\000'){
	    strcpy(buf0->assigned_to[buf0->nitems], buf0->qdata[buf0->nitems][LPI]);		    /* get LP name */
	}
	else {
	    strcpy(buf0->assigned_to[buf0->nitems], "@");
	    strcat(buf0->assigned_to[buf0->nitems], buf0->qdata[buf0->nitems][RMI]);		    /* get remote name */
	    strtok(buf0->assigned_to[buf0->nitems],".");				    /* just print NODE part */
	}
    }

/* when we get here we have all static data. Now get and process the dynamic stuff. */

	(void) sprintf(line, "%s/%s", buf0->qdata[buf0->nitems][SDI], buf0->qdata[buf0->nitems][LOI]);
	if (stat(line, &stbuf) >= 0) {
	    buf0->queingEna[buf0->nitems] = (stbuf.st_mode & 010) ? FALSE : TRUE;
	    buf0->printEna[buf0->nitems] = (stbuf.st_mode & 0100) ? FALSE : TRUE;
	} 
	else {
	    buf0->queingEna[buf0->nitems] = TRUE;
	    buf0->printEna[buf0->nitems] = TRUE;
	}
	i = 0;
	if ((dirp = opendir(buf0->qdata[buf0->nitems][SDI])) == NULL) {
	    printf("Spool directory %s doesnt exist for que %s\n", 
		    buf0->qdata[buf0->nitems][SDI],
		    buf0->queNames[buf0->nitems]);
	    return;		/* if no spool directory then printcap entry must be bogus */
	}
	else{
	    i = 0;
	    while ((dp = readdir(dirp)) != NULL) {
		if (*dp->d_name == 'c' && dp->d_name[1] == 'f')
		    i++;
	    }
	    closedir(dirp);
	}
	buf0->numEntries[buf0->nitems] = i;

	buf0->daemonPresent[buf0->nitems] = TRUE;
	strcpy(buf0->status[buf0->nitems],"\0");
	fd = open(line, O_RDONLY);
	if (fd < 0 || flock(fd, LOCK_SH|LOCK_NB) == 0) {
		(void) close(fd);	/* unlocks as well */
		buf0->daemonPresent[buf0->nitems] = FALSE;
		buf0->nitems++;
		return;		/* if no daemon, then dont get buf0->status */
	}
	else
	    (void) close(fd);

	(void) sprintf(line, "%s/%s", buf0->qdata[buf0->nitems][SDI], buf0->qdata[buf0->nitems][STI]);
	fd = open(line, O_RDONLY);
	if (fd >= 0) {
	    (void) flock(fd, LOCK_SH);
	    while ((i = read(fd, line, sizeof(line))) > 0){
		strncpy(line+i, "\0", 1);
		strncpy(buf0->status[buf0->nitems++], line, i+1);
	    }
	    (void) close(fd);	/* unlocks as well */
	}
}

