/*
 * Copyright 1989 O'Reilly and Associates, Inc.
 * See ../Copyright for complete rights and liability information.
 */


/* 
 *  lps.c
 */
#include "../lp.h"
#include "../lps.h"
#include "../buffer_names.h"
/* 
 * Standard Toolkit include files:
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Shell.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <string.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <time.h>
#include <grp.h>
#include <unistd.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ERR ((struct databuf *) -1)

/* #define DEBUG 0 */
/* #define DEBUGMTIME TRUE */
/* #define _Xdebug TRUE****/
#define ATTACH_TO_ALL TRUE
#define MAXLINES 32
#define COL1WIDTH 110		/* queue name */
#define COL2WIDTH 55		/* queueing enabled */
#define COL3WIDTH 70		/* printing enabled */
#define COL4WIDTH 55		/* number of jobs */
#define COL5WIDTH 75		/* daemon enabled */
#define COL6WIDTH 100		/* assigned to colume */
#define COL7WIDTH 75		/* age of oldest file */
#define COLWIDTH 50		/* default */
#define STATCOLWIDTH 400	/* status colume */
#define NUMCOLS 8		/* total number of columes */
#define TOTALWIDTH (COL1WIDTH+COL2WIDTH+COL3WIDTH+COL4WIDTH+COL5WIDTH+COL7WIDTH+STATCOLWIDTH+COL6WIDTH)
#define NAME 0
#define QUEON 1
#define PRINTON 2
#define DAEMONON 3
#define NUMENTRY 4
#define ASSIGNEDTO 5
#define STATUS 6
#define OLDESTJOB 7
#define JOBAGE 8
#define COL1 0
#define COL2 1
#define COL3 2
#define COL4 3
#define COL5 4
#define XtNinterval "interval"
#define XtNcount "count"
#define XtCCount "Count"
#define XtNhelpFile "helpFile"
#define XtCHelpFile "HelpFile"
#define XtNcontrolTerm "controlTerm"
#define XtCControlTerm "ControlTerm"
#define ON TRUE
#define OFF FALSE
#define DEF_INTERVAL	1
#define DEF_COUNT	-1

extern Dimension width, height, offset;
extern int slot[MAX_QUEUES][4];
extern Widget       new_text[MAX_QUEUES], new_window[MAX_QUEUES];
extern struct oldval OldVal[MAX_QUEUES];
extern void changeLabel();
extern void PopupDialog();
extern void mygetvalues();
extern void getformWnH();
extern void Yes();
extern void No();
extern load_font();
extern void Syntax();
extern void NewWindow();
extern calculateSlots();
extern struct popupIds popupIDs[MAX_QUEUES];
extern struct LogWindows logWindows[NUM_PRNTRS+1];
extern Bool lpsd[MAX_QUEUES];
extern XtTimerCallbackProc ring_bell();
extern XtIntervalId bellID;
extern Widget fileName[MAX_QUEUES], lineShell, moveMenu;
extern char   *devBuf[NUM_PRNTRS+1];
extern char   *progname;
extern checkForNewLogs();
extern int    devcp[NUM_PRNTRS+1];
extern void PopupHelp();
extern char line[BUFSIZ];
extern  char *  old_status_page[MAX_BUFFERS];
extern key_t   key;
extern Bool bell, lineWup;
Bool   old_bell;

Widget  Line[MAXLINES], form, topLevel, colums[MAXLINES*NUMCOLS], buttonbox, labelbox;
Widget  pshell, dialog, quit, allqueues, menuShell, menuPane[4];
Widget  menuItem[2], dataMenuItem[3], longForm, dataMenu;
Widget  warning, noServer, unused, prompt_label, vport1, inner_form;
XtAppContext app_context;
Dimension    wWidth, wHeight;
XFontStruct  *font_info, *font5x8, *font9x15bold, *font10x20bold;
XtIntervalId DoAgainintervalID, ScreenSaverID;
Bool   ApplicationScreenSaver=ON;
Bool   HardwareScreenSaver=OFF;
Bool   EnablePopups=TRUE;
Bool   EnableLogFiles = FALSE;
Bool   reverse[MAX_QUEUES] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }; 
Bool   first_time;
Bool   right=TRUE;
Bool   warningVisible = FALSE;
Display *display;
char   name[] = "line  \0";
char   version[] = LPS_VERSION;
char   display_name[32];
char   label[64];
char   *npt = &name[4];
char   *myargv, myargvs[10][20];
char   geometry_string[16];
static int defaultInterval = DEF_INTERVAL;
static int defaultCount = DEF_COUNT;
Arg    args[15];
int    lineNum=0, colNum=0, lastLine;
int     itemNum;
int    screentimeout=600, screeninterval=600, prefer_blanking=1, allow_exposures=1;
int    count, interval;
int    shmid[MAX_BUFFERS];
int    totalWidth;
int    motion=0;
Position actual_y=0;
Pixel  white, black;
Screen *myscreen;
extern time_t mtime[MAX_BUFFERS];
int    sid, sid_control, sid_readReady, sid_writeLock, sid_clientActive;
int    clientNum;
int    pid;
short  uid, euid;
gid_t  gid, egid;
int    screen_width, screen_height;
char   *controlterm[6];
Bool   writeAccess;
Bool   ControlTerm;
struct stat fileinfo;					    /* file information from fstat. */
struct stat stbuf;
struct outputage outputAge;

/* Application Resources - no particular widget */

static XtResource application_resources[] = {
    {"interval", "Interval", XtRInt, sizeof(int),
	    (Cardinal)&interval, XtRInt, (caddr_t) &defaultInterval},
    {"count", "Count", XtRInt, sizeof(int),
	    (Cardinal)&count, XtRInt, (caddr_t) &defaultCount},
};

/*
*  Command line options table. The command line is parsed for these,
*  and it sets/overrides the appropriate values in the resource
*  database
*/
static XrmOptionDescRec optionDescList[] = {
    {"-interval",   ".interval",    XrmoptionSepArg,    (caddr_t) NULL},
    {"-count",	    ".count",	    XrmoptionSepArg,    (caddr_t) NULL},
};
AppData app_data;
/* resource list */
static XtResource resources[] = {
    {
	XtNinterval,
	XtCInterval,
	XtRInt,
	sizeof(int),
	XtOffsetOf(AppData, interval),
	XtRImmediate,
	(caddr_t) DEF_INTERVAL
	},
	{
	XtNcount,
	XtCCount,
	XtRInt,
	sizeof(int),
	XtOffsetOf(AppData, count),
	XtRImmediate,
	(caddr_t) DEF_COUNT
	},
	{
	XtNhelpFile,
	XtCHelpFile,
	XtRString,
	sizeof(String),
	XtOffsetOf(AppData, helpFile),
	XtRString,
	HELPFILE
	},
	{
	    XtNcontrolTerm,
	    XtCControlTerm,
	    XtRString,
	    sizeof(String),
	    XtOffsetOf(AppData, ControlTerm),
	    XtRString,
	    NULL,
	}
};
/*ARGSUSED*/
void PlaceMenu(w, client_data, call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
    Position x, y;

    /*
     * translate coordinates in application top-level window
     * into coordinates from root window origin.
     */
    XtTranslateCoords(longForm,                /* Widget */
        (Position) 0,        /* x */
        (Position) 0,       /* y */
        &x, &y);          /* coords on root window */

    /* move popup shell one pixel above and left of this position 
     * (it's not visible yet) */
    XtVaSetValues(dataMenu, 
            XtNx, x - 1,
            XtNy, y - 1,
            NULL);
    /* Popup the widget */
    XtPopup(dataMenu, XtGrabNone);
    XtSetSensitive(longForm, FALSE);
}
/* data area manager popup menu parser */

void dataManagerMenu(w, client_data, garbage, it)
Widget w;
XtPointer client_data, garbage;
int it;
{
    int MenuItem = (int) client_data;
    int i;

    printf ("In dataManagerMenu, menu item %s has been selected.\n", XtName(w));
    switch(MenuItem) {
    case 0:		                                    /* enable/disable popup queue windows */
	if (EnablePopups){
	    EnablePopups = FALSE;
	    for (i=1; i<=buf0->nitems-1; i++)
		if (OldVal[i].isPopedUp){
		    popdownWindow(i);
		    OldVal[i].isPopedUp = FALSE;
		}
	    XtVaSetValues(menuPane[MenuItem], XtNlabel, "Enable Display of \"Queued Jobs Pending\" in Data Area", NULL);
	}
	else {
	    XtVaSetValues(menuPane[MenuItem], XtNlabel, "Disable Display of \"Queued Jobs Pending\" in Data Area", NULL);
	    EnablePopups = TRUE;
	    XtSetSensitive(menuPane[2], TRUE);
	}
	if (!EnablePopups && !EnableLogFiles) XtSetSensitive(menuPane[2], FALSE);
	break;
    case 1:						    /* enable/disable popup log file windows */
#ifdef LOGFILES
	if (EnableLogFiles){
	    EnableLogFiles = FALSE;
	    for (i=0; i<NUM_PRNTRS; i++)
		if (logWindows[i].isVisible){
		    XtPopdown(logWindows[i].topId);
		    logWindows[i].isVisible = FALSE;
		}
	    XtVaSetValues(menuPane[MenuItem], XtNlabel, "Enable Display of \"Tailed Log Files\" in Data Area", NULL);
	}
	else {
	    for (i=0; i<NUM_PRNTRS; i++)
		if (logWindows[i].topId){
		    sprintf(geometry_string,"+%d+%d",logWindows[i].x + motion, logWindows[i].y + motion);
		    XtSetArg(args[0], XtNx, logWindows[i].x + motion);
		    XtSetArg(args[1], XtNy, logWindows[i].y + motion);
		    XtSetValues(logWindows[i].textId, args, (Cardinal)2);
		    printf ("geometry for window #%d = %s\n", i, geometry_string);
		    XtPopup(logWindows[i].topId, XtGrabNone);
		    logWindows[i].isVisible = TRUE;
		}
	    XtVaSetValues(menuPane[MenuItem], XtNlabel, "Disable Display of \"Tailed Log Files\" in Data Area", NULL);
	    EnableLogFiles = TRUE;
	    XtSetSensitive(menuPane[2], TRUE);
	}
	if (!EnablePopups && !EnableLogFiles) XtSetSensitive(menuPane[2], FALSE);
#else
	XtSetSensitive(menuPane[2], FALSE);
#endif
	break;
    case 2:						    /* enable/disable dynamic data area */
	EnablePopups = FALSE;
	for (i=1; i<=buf0->nitems-1; i++)
	    if (OldVal[i].isPopedUp){
		popdownWindow(i);
		OldVal[i].isPopedUp = FALSE;
	    }
#ifdef LOGFILES
	if (EnableLogFiles)
	    EnableLogFiles = FALSE;
	    for (i=0; i<NUM_PRNTRS; i++)
		if (logWindows[i].isVisible){
		    XtPopdown(logWindows[i].topId);
		    logWindows[i].isVisible = FALSE;
		}
#endif
	XtSetSensitive(menuPane[2], FALSE);
	break;
    case 3:						    /* do nothing */
	break;
    }
    XtPopdown(dataMenu);
    XtSetSensitive(longForm,TRUE);

}
/* screen saver popup menu parser */

void screenSaverMenu(w, client_data, garbage, it)
Widget w;
XtPointer client_data, garbage;
int it;
{
    extern XtTimerCallbackProc ScreenSaver();
    int menuItem = (int) client_data;
#ifdef DEBUG
    printf ("menu item %s has been selected.\n", XtName(w));
#endif
    if (menuItem == 0)
	if (ApplicationScreenSaver==ON){
	    XtVaSetValues(w, XtNlabel, "Enable Application Screen Saver", NULL);
	    XtRemoveTimeOut (ScreenSaverID);
	    ApplicationScreenSaver = OFF;
	}
	else {
	    XtVaSetValues(w, XtNlabel, "Disable Application Screen Saver", NULL);
	    ScreenSaverID = XtAppAddTimeOut(app_context, 
					    (unsigned long)(SCREENSAVERINTERVAL), 
					    ScreenSaver,
					    (caddr_t)NULL); /* restore the screen saver timeout */
	    ApplicationScreenSaver = ON;
	}
    else if (menuItem == 1)
	if (HardwareScreenSaver==ON){
	    XtVaSetValues(w, XtNlabel, "Enable Hardware Screen Saver", NULL);
	    XSetScreenSaver(display, 0, 0, 0, 0); /* turn off hardware screen saver */
	    HardwareScreenSaver = OFF;
	}
	else {
	    XSetScreenSaver(display, 
			    screentimeout, 
			    screeninterval, prefer_blanking, allow_exposures);
	    XtVaSetValues(w, XtNlabel, "Disable Hardware Screen Saver", NULL);
	    HardwareScreenSaver = ON;
	}
}

/*
 * allQueues callback function.  Brings up all child windows for all queues.
 */

/*ARGSUSED*/
void allQueues(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to dialog */
XtPointer call_data;
{
    int   i;
    extern void removeAllQueues();

    printf ("entering allQueues\n");
    for (i=1; i<=buf0->nitems-1; i++)
	NewWindow(w, i, 5);
    XtRemoveTimeOut (ScreenSaverID);
    XtSetArg (args[0], XtNlabel,"UNdisplay All\nQue  Contents" ); /* relabel the allqueues command box */
    XtSetValues (allqueues, args, 1);
    ScreenSaverID = XtAppAddTimeOut(app_context, (unsigned long)(SCREENSAVERINTERVAL), ScreenSaver,
				    (caddr_t)NULL); /* restore the screen saver timeout */
}

/*
 * remove all queues callback function. Destroys all child windows.
 */
/*ARGSUSED*/
void removeAllQueues(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to dialog */
XtPointer call_data;
{
    int   i;

    for (i=1; i<=buf0->nitems-1; i++)
	if (OldVal[i].isrealized){
	    popdown_window(w, i, 0);
	}
}

/*
 * move window function used by the screen saver function
 */
/*ARGSUSED*/
void movewindow(w, newx, newy)
Widget w;
Position newx, newy;
{
    if (right)
	if (motion < 5){
	    newx += 1;
	    actual_y +=1;
	    motion += 1;
	}
        else {
	    motion -= 1;
	    right = FALSE;
	    newx -= 1;
	    actual_y -= 1;
	}
    else {
	if (motion > -5) {
	    motion -= 1;
	    newx -= 1;
	    actual_y -= 1;
	}
	else {
	    motion += 1;
	    right = TRUE;
	    newx += 1;
	    actual_y += 1;
	}
    }
    XMoveWindow(XtDisplay(w), 
		XtWindow(w),
		newx,
		actual_y);
/*    printf ("screen saver offset = %d, old x=%d, new x=%d, oldy=%d, newy=%d, actualy=%d\n", motion,
	    window_attributes.x, x, window_attributes.y, y, actual_y);*/
}
/* 
 * Screen Saver timer function
 */

/*ARGSUSED*/
XtTimerCallbackProc
ScreenSaver(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    XWindowAttributes window_attributes;
    Position new_x, new_y;
    int      i;


    XGetWindowAttributes (display,
			  XtWindow(topLevel),
			  &window_attributes);
    XtTranslateCoords(topLevel, window_attributes.x, window_attributes.y, &new_x, &new_y);

    if (right)
	if (motion < 5){
	    motion += 1;
	}
        else {
	    motion -= 1;
	    right = FALSE;
	}
    else {
	if (motion > -5) {
	    motion -= 1;
	}
	else {
	    motion += 1;
	    right = TRUE;
	}
    }
    if (right){
	new_x += 1;
	actual_y += 1;
    }
    else {
	new_x -= 1;
	actual_y -= 1;
    }
    XMoveWindow(display, 
		XtWindow(topLevel),
		new_x,
		actual_y);
#ifdef DEBUG
    printf ("screen saver offset = %d, old x=%d, new x=%d, oldy=%d, newy=%d, actualy=%d\n", motion,
	    window_attributes.x, new_x, window_attributes.y, new_y, actual_y);
#endif
    for (i=0; i<MAX_QUEUES; i++){
	if (OldVal[i].isrealized || OldVal[i].isPopedUp) {
	    XGetWindowAttributes (XtDisplay(new_window[i]),
				  XtWindow(new_window[i]),
				  &window_attributes);
	    XtTranslateCoords(new_window[i], window_attributes.x, window_attributes.y, &new_x, &new_y);
	    new_y = new_y - (window_attributes.y*2);  /* must account for height of window manager title bar */
	    if (right) {
		new_x += 1;
		new_y += 1; 
	    }
	    else{
		new_x -= 1;
		new_y -= 1;
	    }

	    if (window_attributes.map_state != 0)
		XMoveWindow(XtDisplay(new_window[i]), 
			    XtWindow(new_window[i]),
			    new_x,
			    new_y);
#ifdef DEBUG
	    printf ("%d screen saver offset = %d, old x=%d, new x=%d, oldy=%d, newy=%d, mapstate=%d\n", 
		    i, motion,
		    window_attributes.x, new_x, 
		    window_attributes.y, new_y, 
		    window_attributes.map_state);
#endif
	}
    }
#ifdef LOGFILES
    for (i=0; i<NUM_PRNTRS; i++){
	if (logWindows[i].isVisible) {
	    XGetWindowAttributes (XtDisplay(logWindows[i].topId),
				  XtWindow(logWindows[i].topId),
				  &window_attributes);
	    XtTranslateCoords(logWindows[i].topId, window_attributes.x, window_attributes.y, &new_x, &new_y);
	    new_y = new_y - (window_attributes.y*2);  /* must account for height of window manager title bar */
	    if (right) {
		new_x += 1;
		new_y += 1; 
	    }
	    else{
		new_x -= 1;
		new_y -= 1;
	    }

	    if (window_attributes.map_state != 0)
		XMoveWindow(XtDisplay(logWindows[i].topId), 
			    XtWindow(logWindows[i].topId),
			    new_x,
			    new_y);
#endif
#ifdef DEBUG
	    printf ("%d screen saver offset = %d, old x=%d, new x=%d, oldy=%d, newy=%d, mapstate=%d\n", 
		    i, motion,
		    window_attributes.x, new_x, 
		    window_attributes.y, new_y, 
		    window_attributes.map_state);
#endif
#ifdef LOGFILES
	}
    }
#endif
/*    XtFree(&window_attributes);*/
    ScreenSaverID = XtAppAddTimeOut(app_context, (unsigned long)(SCREENSAVERINTERVAL), ScreenSaver, (caddr_t)NULL);
}
/*
 * Do Again timer function mainLoop. checks to make server is alive
 * if not, puts up warning to user.
 */
static XtTimerCallbackProc mainLoop(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    int i, rdy;

    if ((i = semgetval(sid_control, 0))<0)                  /* make sure server is alive */
	syserr("semgetval in client", NULL, NULL);
    if (!i){						    /* if i=0 server has died */
	if (!warningVisible) XtPopup(warning, XtGrabNone);  /* popup warning window */
	warningVisible = TRUE;				    /* set flag */
	XBell(display, 0);			    /* hit the gong */
	interval = 5;					    /* set interval so bell don't ring so often */
    }
    else						    /* come here when i != 0, i.e. server is alive now */
	if(warningVisible){				    /* if warning window is poped up */
	    XtPopdown(warning);				    /* pop it down */
	    warningVisible = FALSE;			    /* reset flag */
	    signOn(&myargv);				    /* must re-register with new server */
	    semdec(sid_readReady, clientNum);		    /* unset readReady flag */
	    interval = 1;				    /* set interval back to normal */
	}
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*1000), mainLoop, (caddr_t) 0);
}
/*
  routine to service sigalrm sent by server to all processes.
*/
/*ARGSUSED*/
static serviceData (sig)
unsigned sig;
{
    register int    i;
    char myName[16];
    extern char *sys_siglist[];

    signal(SIGUSR1, SIG_IGN);				    /* ignore further signals */
    setpriority(PRIO_PROCESS, pid, -10);                    /* raise our priority */

/*    printf("caught signal #%d in %s#%d: %s\n", 
	    sig, progname, clientNum, sys_siglist[sig]); */

    if ((i = semgetval(sid_readReady, clientNum)) < 0)	    /* see if new data is ready */
	syserr("semgetval in windows of client", NULL, NULL);
    if (i){			                            /* if new data is ready... */
/*	printf("in %s#%d readReady data flag is up\n", progname, clientNum);*/
	if (semwait(sid_writeLock, 0) != 0) syserr("semwait in lps", NULL, NULL); /* take out a lock on buf0 */
	for (i=1; i<buf0->nitems; i++){			    /* set up to scan all buffers */
	    old_bell = bell;

	    if(mtime[i] != buf0->mtime[i]){		    /* new time stamp in this buffer??? */
#ifdef DEBUGMTIME 
		printf ("in %s#%d mtime for buf#%d old=%d new=%d\n", progname, 
			clientNum, i, mtime[i], buf0->mtime[i]);
#endif
		mtime[i] = buf0->mtime[i];		    /* remember this update time */

#if !ATTACH_TO_ALL
		printf ("attaching to shmemseg#%d\n", i);
		if ((status_page[i] = (char *) shmat(shmid[i], 0, SHM_RDONLY)) == (char *)-1)
		    syserr("shmat in lps.serviceData", NULL, NULL);
#endif
		if ((!OldVal[i].isrealized) && EnablePopups){ /* if window is NOT realized */
		    gethostname(host, sizeof(host));
		    printer = buf0->queNames[i];
		    if ( strlen(status_page[i]) >0 && strstr(status_page[i], "no entries") == NULL){ /* if text = other than "no entries" & */
			if (!OldVal[i].isPopedUp) {		    /* if NOT poped up, then */
#ifdef DEBUGMTIME           
			    printf("poping up window #%d\n", i);
			    printf("status_page=%s\n", status_page[i]);
#endif
			    popupWindow(i);			    /* pop it up */
			}
			XtVaSetValues(new_text[i], 
				      XtNstring, status_page[i], 
				      NULL);			    /* display new data on screen */
		    }
		    else					    /* otherwise */
			if (OldVal[i].isPopedUp)		    /* if already poped up */
			    popdownWindow(i);			    /* pop it down */
		}
		if (OldVal[i].isrealized || OldVal[i].isPopedUp){
/*		    printf ("checking for keywords in buf#%d\n", i);*/
		    XRaiseWindow(XtDisplay(new_window[i]), 
				 XtWindow(new_window[i])); /* raise this window to top of stack */
		    if ((strstr(status_page[i], "stalled") != NULL ||
			 strstr(status_page[i], "Warning") != NULL ||
			 strstr(status_page[i], "Error") != NULL ||
			 strstr(status_page[i], "down") != NULL)) {
/*			printf("found a keyword  in buf#%d\n",i);*/
			if (!bell){			    /* if bell is not on */
			    bellID = XtAppAddTimeOut(app_context, (unsigned long) 1000, ring_bell,
						     (caddr_t) 0);  /* turn it on */
			}
			bell = bell|(sigmask(i));	    /* set the bell bit for this wndo */
			if (reverse[i] == FALSE){
/*			    printf("setting reverse to true for %d\n", i);*/
			    XtSetArg(args[0], XtNbackground, black);
			    XtSetArg(args[1], XtNforeground, white);
			    XtSetValues(fileName[i], args, (Cardinal)2);
			    reverse[i] = TRUE;
			}
		    }		
		    else{	                            /* come here when keyword not present */
/*			printf("no keywords present in buf#%d\n", i);*/
			if (reverse[i] == TRUE){
/*			    printf("reverse was true for %d - setting to FALSE\n", i);*/
			    XtSetArg(args[0], XtNbackground, white);
			    XtSetArg(args[1], XtNforeground, black);
			    XtSetValues(fileName[i], args, (Cardinal)2);
			    reverse[i] = FALSE;
			}
			if (bell&(sigmask(i))){
			    bell = bell^(sigmask(i));
			}
		    }

		    if ((!bell) && (bellID!=0)){
			XtRemoveTimeOut(bellID);
			bellID = 0;
		    }
		}
		if (!OldVal[i].isrealized && !OldVal[i].isPopedUp){ /* turn the bell off if not realized or popedUp */
		    if (bell&(sigmask(i))) 
			bell = bell^(sigmask(i));
		    if ( !bell && bellID != 0 ) {
			XtRemoveTimeOut(bellID);
			bellID = 0;
		    }
		}
#if !ATTACH_TO_ALL
		printf ("calling XFlush for buffer#%d\n", i);
		XFlush(display);
		XSync(display, FALSE);
		shmdt(status_page[i]);
#endif
	    }						    /* if (mtime...) */
/*	    if (old_bell != bell)
		printf("while processing buffer#%d bell changed from %o to %o\n", i, old_bell, bell);*/
	}						    /* for (i=0 ...) */
    }							    /* if (i) */
    first_time = FALSE;
#ifdef LOGFILES
    checkForNewLogs(); 
#endif
/*
  now check the main buffer
*/
    if (mtime[0] != buf0->mtime[0]){			    /* new buf0 time stamp? */
	for (lineNum=1; lineNum<=buf0->nitems-1; lineNum++){
	    if (strcmp(buf0->queNames[lineNum], old_buf0->queNames[lineNum])!=0)
		changeLabel(NAME);
	    if (buf0->queingEna[lineNum] != old_buf0->queingEna[lineNum])
		changeLabel(QUEON);
	    if (buf0->printEna[lineNum] != old_buf0->printEna[lineNum])
		changeLabel(PRINTON);
	    if (buf0->daemonPresent[lineNum] != old_buf0->daemonPresent[lineNum])
		changeLabel(DAEMONON);
	    if (buf0->numEntries[lineNum] != old_buf0->numEntries[lineNum])
		changeLabel(NUMENTRY);
	    if (buf0->oldestJob[lineNum] != old_buf0->oldestJob[lineNum])
		changeLabel(OLDESTJOB);
	    if (strcmp(buf0->assigned_to[lineNum], old_buf0->assigned_to[lineNum]) != 0)
		changeLabel(ASSIGNEDTO);
	    if (strcmp(buf0->status[lineNum], old_buf0->status[lineNum])!=0)
		changeLabel(STATUS);
	    strcpy(old_buf0->queNames[lineNum], buf0->queNames[lineNum]);
	    old_buf0->queingEna[lineNum] = buf0->queingEna[lineNum];
	    old_buf0->printEna[lineNum] = buf0->printEna[lineNum];
	    old_buf0->numEntries[lineNum] = buf0->numEntries[lineNum];
	    old_buf0->oldestJob[lineNum] = buf0->oldestJob[lineNum];
	    old_buf0->daemonPresent[lineNum] = buf0->daemonPresent[lineNum];
	    strcpy(old_buf0->assigned_to[lineNum], buf0->assigned_to[lineNum]);
	    strcpy(old_buf0->status[lineNum], buf0->status[lineNum]);
	}
	for (lineNum=0; lineNum<buf0->numPrinters; lineNum++){
	    if (buf0->data[lineNum].numJobs != old_buf0->data[lineNum].numJobs ||
		buf0->data[lineNum].oldestJob != old_buf0->data[lineNum].oldestJob)
		changeLabel(JOBAGE);
	    old_buf0->data[lineNum].numJobs = buf0->data[lineNum].numJobs;
	    old_buf0->data[lineNum].oldestJob = buf0->data[lineNum].oldestJob;
	}
	mtime[0] = buf0->mtime[0];			    /* remember new buf0 time stamp */
    }
    if ( lineWup ) { 		                            /* manage job control panel */
	XRaiseWindow(XtDisplay(lineShell), XtWindow(lineShell));
	XFlush(display);
	if ( (XtDisplay(moveMenu)) && (XtWindow(moveMenu)) )
	    XRaiseWindow(XtDisplay(moveMenu), XtWindow(moveMenu));
    }    
    if (seminc(sid_writeLock, 0) != 0) syserr("seminc of buf0 in lps", NULL, NULL); /* release lock */
    semdec(sid_readReady, clientNum);			    /* unset readReady flag */
    setpriority(PRIO_PROCESS, pid, 0);			    /* restore default priority */
    signal(SIGUSR1, serviceData);			    /* reset signal catching */

}
/* 
 * finish initializing screens
 */
/*ARGSUSED*/
static XtTimerCallbackProc
FinishInit(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    if (semwait(sid_writeLock, 0) != 0) syserr("semwait in lps", NULL, NULL); /* take out a lock on buf0 */
    createPopupStructures();				    /* go create popup window structures */
    createPopupControlPanel();
    calculateSlots();					    /* go calculate positions for child windows */
#ifdef LOGFILES
    initLogs();						    /* initialize log file monitoring */
    createLogWindows();	        /* create log file window structures (wont be made visible for now) */
#endif
    if (seminc(sid_writeLock, 0) != 0) syserr("seminc of buf0 in lps", NULL, NULL); /* release lock */
    first_time = TRUE;
    serviceData(0);					    /* for first time through */
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*1000), mainLoop, (caddr_t) NULL);
}

/*
 * quit button callback function
 */
/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{ 
    SetPopup(pshell);
}

/*
 * function to toggle queing on and off
 */
/*ARGSUSED*/
void toggleQueing(w, client_data, call_data)
Widget w;
XtPointer client_data;		/* XtPointer replaces caddr_t */
XtPointer call_data;
{
    int item = (int)client_data;
    register int fd;

    if(ControlTerm && writeAccess){
	(void)sprintf(line, "%s/%s", 
		      buf0->qdata[item][SDI], 
		      buf0->qdata[item][LOI]);		    /* get spooling dir & lock file name */
	printf ("working with %s\n", line);
	printer = buf0->queNames[item];			    /* get printer name */
    }
    else{
	sprintf (label,"YOU ARE NOT AUTHORIZED TO START OR STOP QUEUEING");
	XtVaSetValues (prompt_label, XtNlabel, label, NULL);
	return;
    }
    if (buf0->queingEna[item]){	                            /* if queing was on */
/*
 * Turn on the group execute bit of the lock file to disable queuing.
 */
	if (stat(line, &stbuf) >= 0) {
	    if (chmod(line, (stbuf.st_mode & 0777) | 010) < 0)
		printf("\tcannot disable queuing\n");
	    else
		printf("\tqueuing disabled\n");
	} else if (errno == ENOENT) {
	    if ((fd = open(line, O_WRONLY|O_CREAT, 0670)) < 0)
		printf("\tcannot create lock file\n");
	    else {
		(void) close(fd);
		printf("\tqueuing disabled\n");
	    }
	    return;
	} else
	    printf("\tcannot stat lock file\n");
    }
    else						    /* if queing was off */
/*
 * Turn off the group execute bit of the lock file to enable queuing.
 */
	if (stat(line, &stbuf) >= 0) {
	    if (chmod(line, stbuf.st_mode & 0767) < 0)
		printf("\tcannot enable queuing\n");
	    else
		printf("\tqueuing enabled\n");
	}
    printf("for %s ", printer);
    if (stat(line, &stbuf) >= 0) {
	printf("\tqueuing is %s\n",
	       (stbuf.st_mode & 010) ? "disabled" : "enabled");
	printf("\t\tprinting is %s\n",
	       (stbuf.st_mode & 0100) ? "disabled" : "enabled");
    } else {
	printf("couldnt stat %s\n", line);
    }
}

/*
 * function to toggle printing on and off
 */
/*ARGSUSED*/
void togglePrinting(w, client_data, call_data)
Widget w;
XtPointer client_data;		/* XtPointer replaces caddr_t */
XtPointer call_data;
{
    int item = (int)client_data;
    register int fd;

    if(writeAccess){
	(void)sprintf(line, "%s/%s", 
		      buf0->qdata[item][SDI], 
		      buf0->qdata[item][LOI]);		    /* get spooling dir & lock file name */
	printf ("working with %s\n", line);
	printer = buf0->queNames[item];			    /* get printer name */
    }
    else{
	sprintf (label,"YOU ARE NOT AUTHORIZED TO START OR STOP PRINTING");
	XtVaSetValues (prompt_label, XtNlabel, label, NULL);
	return;
    }

    if (buf0->printEna[item]){	                            /* if printing was on */
/*
 * Turn on the owner execute bit of the lock file to disable printing.
 */
	if (stat(line, &stbuf) >= 0){
	    if (chmod(line, (stbuf.st_mode & 0777) | 0100) < 0)
		printf("\tcannot disable printing\n");
	    else
		printf("\tprinting disabled\n");
	} else if (errno == ENOENT) {
	    if ((fd = open(line, O_WRONLY|O_CREAT, 0760)) < 0)
		printf("\tcannot create lock file\n");
	    else {
		(void) close(fd);
		printf("\tprinting disabled\n");
	    }
	    return;
	} else {
	    printf("\tcannot stat lock file\n");
	    return;
	}
    }
    else{						    /* if printing was off */
/*
 * Turn off the owner execute bit of the lock file to enable printing.
 */
	if (stat(line, &stbuf) >= 0) {
	    if (chmod(line, stbuf.st_mode & 0677) < 0)
		printf("\tcannot enable printing\n");
	    else{
		printf("\tprinting enabled\n");
		if (!startdaemon(printer))
		    printf("\tcouldn't start daemon\n");
		else
		    printf("\tdaemon started\n");
	    }
	}
    }
    printf("for %s ", printer);
    if (stat(line, &stbuf) >= 0) {
	printf("\tqueuing is %s\n",
	       (stbuf.st_mode & 010) ? "disabled" : "enabled");
	printf("\t\tprinting is %s\n",
	       (stbuf.st_mode & 0100) ? "disabled" : "enabled");
    } else {
	printf("couldnt stat %s\n", line);
    }
}

/*
 * function to toggle printing on and off
 */
/*ARGSUSED*/
void toggleDaemon(w, client_data, call_data)
Widget w;
XtPointer client_data;		/* XtPointer replaces caddr_t */
XtPointer call_data;
{
    int item = (int)client_data;
    register FILE *fp;
    int pid, fd;

    if(writeAccess){
	(void)sprintf(line, "%s/%s", 
		      buf0->qdata[item][SDI], 
		      buf0->qdata[item][LOI]);		    /* get spooling dir & lock file name */
	printf ("working with %s\n", line);
	printer = buf0->queNames[item];			    /* get printer name */
    }
    else{
	sprintf (label,"YOU ARE NOT AUTHORIZED TO START OR STOP THE DAEMON");
	XtVaSetValues (prompt_label, XtNlabel, label, NULL);
	return;
    }
    if (buf0->daemonPresent[item]){	                            /* if printing was on */
/*
 * Kill the current daemon to stop printing now.
 */
	if ((fp = fopen(line, "r")) == NULL) {
	    printf("\tcannot open lock file\n");
	    return;
	}
	if (!getline(fp) || flock(fileno(fp), LOCK_SH|LOCK_NB) == 0) {
	    (void) fclose(fp);	/* unlocks as well */
	    printf("\tno daemon to abort\n");
	    return;
	}
	(void) fclose(fp);
	if (kill(pid = atoi(line), SIGTERM) < 0)
	    printf("\tWarning: daemon (pid %d) not killed\n", pid);
	else
	    printf("\tdaemon (pid %d) killed\n", pid);
    }
    else{
	if (!startdaemon(printer))
	    printf("\tcouldn't start daemon\n");
	else
	    printf("\tdaemon started\n");
    }
}



void makeLine(parent, fromHoriz, fromVert)
    Widget  parent, fromHoriz, fromVert;
{
    int    i;
    int    curCol;
    XFontStruct  *fontp;

    if (buf0->queingEna[lineNum])
	strcpy(label,"YES");
    else
	strcpy(label, "NO");

    colums[colNum++] = XtVaCreateManagedWidget(
		"Que Ena",	/* widget name	 */
		commandWidgetClass,	/* widget class */
		parent,	/* parent widget*/
		XtNfromHoriz,	fromHoriz,
		XtNfromVert,    fromVert,
		XtNlabel,       label,
		XtNwidth,       COL2WIDTH,
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/
    curCol = colNum -1;
    XtAddCallback (colums[curCol], XtNcallback, toggleQueing, lineNum);
    sprintf (label, "<Leave>: unprompt() reset()");
    XtOverrideTranslations (colums[curCol], XtParseTranslationTable(label));
    sprintf (label, "<Enter>: prompt(%d,%d,%s) highlight()", lineNum, 2, buf0->queNames[lineNum]);
    XtOverrideTranslations (colums[curCol], XtParseTranslationTable(label));
    if (strcmp(label,"NO")==0){
	XtSetArg(args[0], XtNbackground, black);
	XtSetArg(args[1], XtNforeground, white);
	XtSetValues (colums[curCol], args, (Cardinal) 2);
    }
    if(writeAccess)
	XtSetSensitive(colums[curCol], TRUE);
    else
	XtSetSensitive(colums[curCol], FALSE);
    if (buf0->printEna[lineNum])
	strcpy(label,"YES");
    else
	strcpy(label, "NO");

    colums[colNum++] = XtVaCreateManagedWidget(
		"Prt Ena",	/* widget name	 */
		commandWidgetClass,	/* widget class */
		parent,	/* parent widget*/
		XtNfromHoriz,	colums[curCol],
		XtNfromVert,    fromVert,
		XtNlabel,       label,
		XtNwidth,       COL3WIDTH,
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/
    curCol = colNum -1;
    XtAddCallback (colums[curCol], XtNcallback, togglePrinting, lineNum);
    sprintf (label, "<Leave>: unprompt() reset()");
    XtOverrideTranslations (colums[curCol], XtParseTranslationTable(label));
    sprintf (label, "<Enter>: prompt(%d,%d,%s) highlight()", lineNum, 3, buf0->queNames[lineNum]);
    XtOverrideTranslations (colums[curCol], XtParseTranslationTable(label));
    if (strcmp(label,"NO")==0){
	XtSetArg(args[0], XtNbackground, black);
	XtSetArg(args[1], XtNforeground, white);
	XtSetValues (colums[curCol], args, (Cardinal) 2);
    }
    if(writeAccess)
	XtSetSensitive(colums[curCol], TRUE);
    else
	XtSetSensitive(colums[curCol], FALSE);
    sprintf (label, "%0d\0", buf0->numEntries[lineNum]);
    if (buf0->numEntries[lineNum] == 0) sprintf(label, " \0");
    colums[colNum++] = XtVaCreateManagedWidget(
		"Num Jobs",	/* widget name	 */
		labelWidgetClass,	/* widget class */
		parent,	/* parent widget*/
		XtNfromHoriz,	colums[curCol],
		XtNfromVert,    fromVert,
		XtNwidth,       COL4WIDTH,
		XtNborderWidth,     (Dimension) 1,
		XtNlabel,       label,
		NULL);	/* argument list*/
    curCol = colNum -1;
    colums[colNum++] = XtVaCreateManagedWidget(
		"oldest Job",	/* widget name	 */
		labelWidgetClass,	/* widget class */
		parent,	/* parent widget*/
		XtNfromHoriz,	colums[curCol],
		XtNfromVert,    fromVert,
		XtNwidth,       COL7WIDTH,
		XtNlabel,       " ",
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/
    curCol = colNum -1;
    if (buf0->daemonPresent[lineNum])
	strcpy(label, "YES");
    else
	strcpy(label, "NO");

    colums[colNum++] = XtVaCreateManagedWidget(
		"Demon Ena",	/* widget name	 */
		commandWidgetClass,	/* widget class */
		parent,	/* parent widget*/
		XtNfromHoriz,	colums[curCol],
		XtNfromVert,    fromVert,
		XtNlabel,       label,
		XtNwidth,       COL5WIDTH,
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/

    curCol = colNum -1;
    XtAddCallback (colums[curCol], XtNcallback, toggleDaemon, lineNum);
    sprintf (label, "<Leave>: unprompt() reset()");
    XtOverrideTranslations (colums[curCol], XtParseTranslationTable(label));
    sprintf (label, "<Enter>: prompt(%d,%d,%s) highlight()", lineNum, 4, buf0->queNames[lineNum]);
    XtOverrideTranslations (colums[curCol], XtParseTranslationTable(label));
    if(writeAccess)
	XtSetSensitive(colums[curCol], TRUE);
    else
	XtSetSensitive(colums[curCol], FALSE);

    colums[colNum++] = XtVaCreateManagedWidget(
		"assignment",				    /* widget name	 */
		labelWidgetClass,			    /* widget class */
		parent,					    /* parent widget*/
		XtNfromHoriz,	colums[curCol],
		XtNfromVert,    fromVert,
		XtNwidth,       COL6WIDTH,
		XtNlabel,       buf0->assigned_to[lineNum],
		XtNborderWidth,     (Dimension) 1,
		NULL);					    /* argument list*/

    curCol = colNum -1;
    colums[colNum++] = XtVaCreateManagedWidget(
		"status",	/* widget name	 */
		labelWidgetClass,	/* widget class */
		parent,	/* parent widget*/
		XtNfromHoriz,	colums[curCol],
		XtNfromVert,    fromVert,
		XtNwidth,       STATCOLWIDTH,
		XtNlabel,       buf0->status[lineNum],
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/
    i = 0;
    XtSetArg (args[i], XtNwidth, &wWidth), i++;
    XtSetArg (args[i], XtNheight, &wHeight), i++;
    XtGetValues (Line[lineNum], args, i);
#ifdef DEBUG
    printf ("width = %d, height = %d\n", wWidth, wHeight);
#endif

    return;
}
/* ManagePopups button press.  Turn popup windows on and off. */

void ManagePopups(w, Client_data, Call_data)
Widget w;
XtPointer Client_data, Call_data;
{
    int   i;

    if(EnablePopups){
	EnablePopups = FALSE;
	XtVaSetValues(w, XtNlabel, "  Enable\nPopup Windows", NULL);
	for (i=1; i<=buf0->nitems-1; i++){
	    if (OldVal[i].isPopedUp){
		popdownWindow(i);
		OldVal[i].isPopedUp = FALSE;
	    }
	}
    }
    else{
	XtVaSetValues(w, XtNlabel, "  Disable\nPopup Windows", NULL);
	EnablePopups = TRUE;
    }
}

void ResizeWindow (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XWindowAttributes window_attributes;

    XGetWindowAttributes (display,
			  XtWindow(topLevel),
			  &window_attributes);
    XResizeWindow(display, 
		  XtWindow(topLevel),
		  window_attributes.width,
		  window_attributes.height + 50);
}
void ResizeWidget(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XWindowAttributes window_attributes;

    XGetWindowAttributes (display,
			  XtWindow(topLevel),
			  &window_attributes);
    XtResizeWidget(form, 
	     window_attributes.width,
	     window_attributes.height - 50,
	     window_attributes.border_width);
}
/*ARGSUSED*/
void DialogDone(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to dialog */
XtPointer call_data;
{
	Widget dialog = (Widget) client_data;

	String string;

	XtPopdown(pshell);

	XtSetSensitive(quit, TRUE);

	string = XawDialogGetValueString(dialog);

	printf("User typed: %s\n", string);
}
	
/* 
 * callback to update prompt area. Invoked from translation table interface 
 * we come here with params set to (lineNum, colNum, quename) where colNum
 * is 1=quename, 2=queing on/off, 3=printing on/off, 4=daemon on/off.
*/

void prompt(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    int    iparam, mitem;
    int    i, i1;
    char   on_off[8];
#ifdef DEBUG
    printf ("In prompt num_params = %d", *num_params);
    for (i=0; i<*num_params; i++)
	printf (" param#%d = %s", i, params[i]);
    printf ("\n");
#endif
    itemNum = atoi(params[0]);
    mitem = atoi(params[1]);
    switch (mitem){
    case 1:
	sprintf (label, "Popup job display window for queue %s", params[2]);
	break;
    case 2:
	if (!buf0->queingEna[itemNum])
	    strcpy(on_off,"ENABLE");
	else
	    strcpy(on_off, "DISABLE");
	sprintf (label, "%s Queing for queue %s", on_off, params[2]);
	break;
    case 3:
	if (!buf0->printEna[itemNum])
	    strcpy(on_off,"ENABLE");
	else
	    strcpy(on_off, "DISABLE");
	sprintf (label, "%s Printing for queue %s", on_off, params[2]);
	break;
    case 4:
	if (!buf0->daemonPresent[itemNum])
	    strcpy(on_off, "ENABLE");
	else
	    strcpy(on_off, "DISABLE");
	sprintf (label, "%s Daemon for queue %s", on_off, params[2]);
	break;
    case 5:						    /* outputAge window */
	sprintf (label, "Clear Output Pickup Age statistics for printer %s", params[2]);
	break;
    }
    XtVaSetValues (prompt_label, XtNlabel, label, NULL);
}

/* callback to clear prompt area. Invoked from translation table interface */

void unprompt(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{

    XtVaSetValues (prompt_label, XtNlabel, " ", NULL);
}

do_windows(argc, argv)
int argc;
char **argv;
{
    Widget pane1, pane2, yes, no, new;
    int    i, *p, n;
    char   *geometry;
    char   *myborder;
    char   warning_geometry[16];
    int    border=1;
    int    flags=0;
    Window root;
    Widget top;
    int    status, screen;
    Cursor cursor;
    XEvent event;
    char   newstring[1024];
    Position master_x;
    gid_t  opergid, xadmin_gid;
    char   *user_name;
    struct group *gr;
    static XtActionsRec window_actions[] = {
	{"prompt", prompt},
	{"unprompt", unprompt}
    };

    int    button = 0;

    if ((display = XOpenDisplay(NULL))==0)		    /* open display, connect to server */
	syserr("Display variable not set", NULL, NULL);
    screen = DefaultScreen(display);                        /* get screen NUMBER */
    screen_width = display->screens[0].width;
    screen_height = display->screens[0].height;
    strcpy(display_name, display->display_name);
    XCloseDisplay(display);				    /* disconnect from server */
/*
 * totalWidth equals the width of all boxes + the inter-box spacing (4) + the width of borders
 */
    totalWidth = TOTALWIDTH + (NUMCOLS*5) + ((NUMCOLS*2)*border) + 10;
    master_x = screen_width-(totalWidth+20);
    if (master_x < 0) master_x = 0;			    /* make sure we dont go beyond lh edge of screen */
    sprintf(geometry_string,"+%d+%d", master_x, 0);

    topLevel = XtVaAppInitialize(
				 &app_context,		    /* Application context */
				 "LpsV2",		    /* application class name */
				 optionDescList, 
				 XtNumber(optionDescList),  /* command line option list */
				 &argc, argv,		    /* command line args */
				 NULL,			    /* for missing app-defaults file */
				 XtNgeometry, geometry_string,
				 XtNiconName,  LPS_VERSION,
				 NULL);			    /* terminate varargs list */

    display = XtDisplay(topLevel);
/*    XSynchronize(display, TRUE);*/
    myscreen = XtScreen(topLevel);			    /* get screen CORE STRUCTURE */
    white = WhitePixelOfScreen(myscreen);		    /* get default white pixel */
    black = BlackPixelOfScreen(myscreen);		    /* ditto for black */
/*
 * check command line options for range
 */
    if (argc > 1)
	Syntax(argc, argv);
    strcpy(argv[0], version);
/*
 * set custom default application resources
 */
    XtGetApplicationResources(topLevel, 0, application_resources,
			      XtNumber(application_resources), NULL, 0 );
    XtGetApplicationResources(topLevel, &app_data, resources,
			      XtNumber(resources), NULL, 0 );
    XtAppAddActions (app_context, window_actions, 2);
/*
 * get the controlTerm list
*/
    controlterm[0] = app_data.ControlTerm;
    i = 1;
    while ( controlterm[i-1] != NULL ) {
	if ((controlterm[i] = strchr(controlterm[i-1], ',')) != NULL){
	    controlterm[i][0] = '\0';
	    controlterm[i]++;
	    if ( ++i >= 6 ) break;
	}
	else
	    break;
    }
    ControlTerm = FALSE;
    for (n=0; n<i; n++){
	if ( controlterm[n] != NULL ) {
	    if (strcmp(controlterm[n], display_name) == 0)
		ControlTerm = TRUE;
	}
    }
/* find out who we are running as */

    uid = getuid();
    euid = geteuid();
    gid = getgid();
    egid = getegid();
    if ( (user_name = getlogin()) == (char *)0 ) {
	struct passwd *passwd;
	passwd = getpwuid(uid);
	user_name = passwd->pw_name;
}
    printf ("uid=%d euid=%d gid=%d egid=%d user=%s\n", uid, euid, gid, egid, user_name);
    gr = getgrnam("operator");
    if (gr != (struct group *) 0)
	opergid = gr->gr_gid;
    setgrent();
    gr = getgrnam("xadmin");
    if (gr != (struct group *) 0)
	xadmin_gid = gr->gr_gid;
    endgrent();
    if ((gid == opergid && ControlTerm) ||		    /* if groupID = operator or */
	(egid == opergid && ControlTerm) ||		    /* if egroupID = operator or */
	(gid == 0) ||					    /* if groupID = root or */
	(egid == 0)||					    /* if egroupID = root or */
	(uid == 0) ||					    /* if userID = root or */
	(euid == 0 && ControlTerm))			    /* if euserID = root then */
	writeAccess = TRUE;				    /* grant write access */
    else
	writeAccess = FALSE;
    if ( !writeAccess && gr ) {	                            /* see if mbr of xadmin group */
	i = 0;
	while ( (gr->gr_mem[i]) != (char *)0 ) {
	    if ( strstr(gr->gr_mem[i++], user_name) ){	    /* is this user mbr of xadmin */
		writeAccess = TRUE;
		break;
	    }
	}
    }
    printf ("write access %s\n", writeAccess?"GRANTED":"DENIED");
    if ( writeAccess ) {
	if ( (setuid(euid)) == -1 )
	    perror("setting uid");
	if ( (setgid(egid)) == -1 )
	    perror("setting gid");
    }
/* 
 * now check for out of range options specifications
 */
    if (app_data.interval < 1 || app_data.interval > 60){
	fprintf (stderr, "%s: error in resource settings for interval: \n  %s",
		 argv[0], "   interval specification must be 1 to 60 inclusive\n");
	exit(1);
	}

    form = XtVaCreateManagedWidget(
		"form", 	/* widget name */
		formWidgetClass,	/* widget class */
		topLevel,	/* parent widget*/
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/

    pane1 = XtVaCreateManagedWidget(
		"pane1",
		panedWidgetClass,
		form,
		XtNwidth,           totalWidth,
		XtNborderWidth,     (Dimension) 2,
		NULL);

    load_font(&font_info, "8x13bold");
    load_font(&font5x8, "5x8");
    load_font(&font9x15bold, "9x15bold");
    load_font(&font10x20bold, "-adobe-times-bold-r-normal-*-20-140-*-*-*-*-iso8859-1");
    
    create_buttonbox(pane1);

	pane2 = XtVaCreateManagedWidget(
		"pane1",
		panedWidgetClass,
		form,
		XtNwidth,         totalWidth,
		XtNfromVert,      pane1,
		XtNborderWidth,   (Dimension) 1,
		NULL);

	create_labelBox(pane2);

/*	getStatus();	*/	/* find out how many queues to display */

    printf ("in %s key = %d, pid = %d\n", argv[0], key, pid);

/* 
  now attach to the shared memory sections created by the server
*/
    if (writeAccess)
	flags = NULL;
    else
	flags = SHM_RDONLY;
    shmid[0] = getshmset(key, sizeof(struct databuf), "buf0"); /* get buf0 first */
    printf ("in %s shmid%d = %d\n", argv[0], i, shmid[0]);
    if ((buf0 = (struct databuf *) shmat(shmid[0], 0, flags)) == ERR)
	syserr("shmat in shmem", NULL, NULL);

/*
  and create a local memory region for the old stuff.
*/
    old_buf0 = (struct old_databuf *)malloc(sizeof(struct old_databuf));
    (void) memset(old_buf0, '9', sizeof(struct old_databuf)); /* init the region */
/*
  Take out a lock on buf0. This makes sure that the server is done building
  the main control data buffer, just in case we are the first client to 
  start up.
*/
    if (semwait(sid_writeLock, 0) != 0) syserr("semwait in lps", NULL, NULL); /* take out a lock on buf0 */
/*
  get the remainder of the shared memory regions.
*/
    for (i=1; i<buf0->nitems; i++){
	sprintf (errmsg, "buffer #%d", i);
	shmid[i] = getshmset(key+i, SHMSIZE, errmsg);	    /* start out with 2048 bytes */

#if ATTACH_TO_ALL

	if ((status_page[i] = (char *) shmat(shmid[i], 0, flags)) == (char *)-1)
	    syserr("shmat in shmem", NULL, NULL);
#endif
    }
/*
 * now create a viewport containing another form widget. All the rest of the
 * widgets are contained by this inner form widget.
*/
    vport1 = XtVaCreateManagedWidget(
				    "vport1",
				    viewportWidgetClass,
				    form,
				    XtNwidth,          totalWidth,
				    XtNheight,         screen_height/2,	/* 1/3 of screen */
				    XtNfromVert,       pane2,
				    
				    XtNallowVert,      TRUE,
				    XtNborderWidth,    (Dimension) 1,
				    NULL);

    inner_form = XtVaCreateManagedWidget(
				   "form", 	       /* widget name */
				   formWidgetClass,    /* widget class */
				   vport1,	       /* parent widget*/
				   XtNborderWidth,     (Dimension) 1,
				   NULL);	       /* argument list*/

/*
  create one line on the main form for each queue in the system
*/
    {
	Line[0] = (Widget)NULL;
	for (lineNum=1; lineNum<=buf0->nitems-1; lineNum++){
	    Line[lineNum] = XtVaCreateManagedWidget(
						    buf0->queNames[lineNum],                    /* widget name */
						    commandWidgetClass,	/* widget class */
						    inner_form,		/* parent widget*/
						    XtNfromVert,        Line[lineNum-1],
						    XtNwidth,           COL1WIDTH,
						    XtNborderWidth,     (Dimension) 1,
						    NULL);		/* argument list*/
	    sprintf (label, "<Leave>: unprompt() reset()");
	    XtOverrideTranslations (Line[lineNum], XtParseTranslationTable(label));
	    sprintf (label, "<Enter>: prompt(%d,%d,%s) highlight()", lineNum, 1, buf0->queNames[lineNum]);
	    XtOverrideTranslations (Line[lineNum], XtParseTranslationTable(label));
	    makeLine(inner_form, Line[lineNum], Line[lineNum-1]);
	    XtAddCallback (Line[lineNum], XtNcallback, NewWindow, lineNum);
	}
	lineNum--;
	lastLine = lineNum;
    }
    if (seminc(sid_writeLock, 0) != 0) syserr("seminc of buf0 in lps", NULL, NULL); /* release lock */
/*
  Now create the quit box... wont be visible for now.
*/
    pshell = XtVaCreatePopupShell(
				  "pshell",
				  transientShellWidgetClass,
				  topLevel,
				  NULL);		    /* terminate varargs list */

    dialog = XtVaCreateManagedWidget(
				     "dialog",		    /* widget name   */
				     dialogWidgetClass,	    /* widget class */
				     pshell,		    /* parent widget*/
				     NULL);		    /* terminate varargs list */

    yes = XtVaCreateManagedWidget(
				  "yes",		    /* widget name   */
				  commandWidgetClass,	    /* widget class */
				  dialog,		    /* parent widget*/
				  XtNlabel,   "YES",
				  NULL);		    /* terminate varargs list */

    no = XtVaCreateManagedWidget(
				 "no",			    /* widget name   */
				 commandWidgetClass,	    /* widget class */
				 dialog,		    /* parent widget*/
				 XtNlabel,   "NO",
				 NULL);			    /* terminate varargs list */

    XtAddCallback(yes, XtNcallback, Yes, 0);
    XtAddCallback(no, XtNcallback, No, 0);
    XtRealizeWidget(topLevel);

    for (i=0; i<MAX_QUEUES; i++){
	OldVal[i].isrealized = FALSE;			    /* initialize child window structure */
	OldVal[i].isPopedUp = FALSE;
/*	buf0->oldestJob[i] = -1; */
	lpsd[i] = FALSE;	                            /*  init "which socket" table */
    }
/* now build a popup window for later display to notify of server malfunctions */

    sprintf(warning_geometry,"+%d+%d", screen_width-(TOTALWIDTH)+20, 30);
    warning = XtVaCreatePopupShell("warning", 
				    transientShellWidgetClass,
				    form, 
				    XtNborderWidth,  (Dimension) 10,
				    XtNallowShellResize, (XtArgVal) FALSE,
				    XtNgeometry, warning_geometry,
				    NULL);

    noServer = XtVaCreateManagedWidget("NoServer",
					    labelWidgetClass,
					    warning,
					    XtNlabel, "WARNING - Server\nmalfunction",
					    XtNjustify, XtJustifyCenter,
					    NULL);
    XFlush(display);

#if !ATTACH_TO_ALL

#endif
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*2000), FinishInit, (caddr_t) NULL);
    ScreenSaverID = XtAppAddTimeOut(app_context, (unsigned long)(SCREENSAVERINTERVAL), ScreenSaver, (caddr_t)NULL);

    for (lineNum=1; lineNum<=buf0->nitems-1; lineNum++){
	if (buf0->numEntries[lineNum] !=0 && !buf0->daemonPresent[lineNum]){ /* set reverse video on the daemon presetn colume? */
	    XtSetArg(args[0], XtNbackground, black);
	    XtSetArg(args[1], XtNforeground, white);
	    XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+4], args, 2);
	}
    }
    XtAppMainLoop(app_context);
}

load_font(font_info, fontname)
XFontStruct **font_info;
char        *fontname;
{

        /* Access font */
        if ((*font_info = XLoadQueryFont(display,fontname)) == NULL)
        {
                (void) fprintf( stderr, "Basic: Cannot open %s font\\n", fontname);
		XSetScreenSaver(display, 
				screentimeout, 
				screeninterval, prefer_blanking, allow_exposures);
                exit( -1 );
        }
}
void changeLabel(type)
int     type;
{
    char    label[12];
    int     i, n;

    switch (type){
    case NAME:
	XtSetArg (args[0], XtNlabel, buf0->queNames[lineNum]);
	XtSetValues (Line[lineNum], args, 1);
	break;
    case QUEON:
	if (buf0->queingEna[lineNum]){
	    strcpy(label,"YES");
	    XtSetArg(args[0], XtNbackground, white);
	    XtSetArg(args[1], XtNforeground, black);
	}
	else{
	    strcpy(label, "NO");
	    XtSetArg(args[0], XtNbackground, black);
	    XtSetArg(args[1], XtNforeground, white);
	}
	XtSetArg (args[2], XtNlabel, label);
	XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))], args, (Cardinal) 3);
	break;
    case PRINTON:
	if (buf0->printEna[lineNum]){
	    strcpy(label,"YES");
	    XtSetArg(args[0], XtNbackground, white);
	    XtSetArg(args[1], XtNforeground, black);
	}
	else{
	    strcpy(label, "NO");
	    XtSetArg(args[0], XtNbackground, black);
	    XtSetArg(args[1], XtNforeground, white);
	}
	XtSetArg (args[2], XtNlabel, label);
	XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+1], args, (Cardinal) 3);
	break;
    case NUMENTRY:
	if (buf0->numEntries[lineNum] != 0)
	    sprintf (label, "%0d\0", buf0->numEntries[lineNum]);
	else{
	    XtSetArg(args[0], XtNbackground, white);    /* unset reverse video on the daemon present colume */
	    XtSetArg(args[1], XtNforeground, black);
	    XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+4], args, 2);
	    sprintf (label, " \0");
/*	    buf0->oldestJob[lineNum] = -1;*/
	}
	XtSetArg (args[0], XtNlabel, label);
	XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+2], args, 1);
	if (buf0->numEntries[lineNum] !=0 && !buf0->daemonPresent[lineNum]){ /* set reverse video on the daemon presetn colume? */
	    XtSetArg(args[0], XtNbackground, black);
	    XtSetArg(args[1], XtNforeground, white);
	    XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+4], args, 2);
	}
	break;
    case OLDESTJOB:
	if (buf0->oldestJob[lineNum] == -1)
	    sprintf(label, " \0");
	else
	    sprintf(label, "%0d min\0", buf0->oldestJob[lineNum]);
	XtSetArg (args[0], XtNlabel, label);
	XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+3], args, 1);
	break;
    case JOBAGE:
	if (buf0->data[lineNum].numJobs != 0){
	    sprintf(label, "%0d\0", buf0->data[lineNum].numJobs);
	    XtSetArg (args[0], XtNlabel, label);
	    XtSetValues (outputAge.dataLine[lineNum].numJobs, args, 1);
	    sprintf (label, "%d min\0", buf0->data[lineNum].oldestJob);
	    XtSetArg (args[0], XtNlabel, label);
	    XtSetValues (outputAge.dataLine[lineNum].oldestJob, args, 1);
	}
	else{
	    sprintf(label, " \0");
	    XtSetArg(args[0], XtNlabel, label);
	    XtSetValues (outputAge.dataLine[lineNum].numJobs, args, 1);
	    XtSetValues (outputAge.dataLine[lineNum].oldestJob, args, 1);
	}
	break;
    case DAEMONON:
	i = 0;
	if (!buf0->daemonPresent[lineNum] && buf0->numEntries[lineNum] == 0){
	    XtSetArg(args[i], XtNbackground, white), i++;
	    XtSetArg(args[i], XtNforeground, black), i++;
	}
	if (!buf0->daemonPresent[lineNum] && buf0->numEntries[lineNum] >= 1){
	    XtSetArg(args[i], XtNbackground, black), i++;
	    XtSetArg(args[i], XtNforeground, white), i++;
	}
	if (buf0->daemonPresent[lineNum]){
	    strcpy(label, "YES");
	    XtSetArg(args[i], XtNbackground, white), i++;
	    XtSetArg(args[i], XtNforeground, black), i++;
	}
	else
	    strcpy(label, "NO");
	XtSetArg (args[i], XtNlabel, label);
	XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+4], args, i+1);
	break;
    case ASSIGNEDTO:
	XtSetArg (args[0], XtNlabel, buf0->assigned_to[lineNum]);
	XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+5], args, 1);
	break;
    case STATUS:
	XtSetArg (args[0], XtNlabel, buf0->status[lineNum]);
	XtSetValues (colums[((lineNum-1)*(NUMCOLS-1))+6], args, 1);
	break;
    }
}

static String labels[] = {
			  "Disable Display of \"Queued Jobs Pending\" in Data Area",
			  "Disable Display of \"Tailed Log Files\" in Data Area",
			  "Disable All Displays in Dynamic Data Area",
			  "Leave everything the way it is.",
		      };

create_buttonbox(parent)
Widget parent;
{
    Widget    resizewindow, helpwidget, screen_saver, menu, menuLabel;
    char      buf[50];
    int       i;
    static XtCallbackRec callback[2];

    buttonbox = XtVaCreateManagedWidget("buttonbox",        boxWidgetClass,
					parent, 
					XtNwidth,           totalWidth,
					XtNborderWidth,     (Dimension) 2,
					NULL);

    quit = XtVaCreateManagedWidget(
		"quit",		/* widget name */
		commandWidgetClass,	/* widget class */
		buttonbox,	/* parent widget*/
                XtNlabel,          "\nQuit",
		XtNborderWidth,     (Dimension) 2,
		NULL);	/* argument list*/

    XtAddCallback(quit, XtNcallback, SetPopup, topLevel);

    longForm = XtVaCreateManagedWidget(
		"LongForm",	/* widget name */
		commandWidgetClass,	/* widget class */
		buttonbox,	/* parent widget*/
		XtNfromHoriz,      quit,
                XtNlabel,          "Data Display\n  Manager",
		XtNborderWidth,     (Dimension) 2,
		NULL);	/* argument list*/

    XtAddCallback(longForm, XtNcallback, PlaceMenu, longForm);

    dataMenu = XtCreatePopupShell("DataMenu", transientShellWidgetClass,
				  longForm, NULL, 0);
    menuShell = XtVaCreateManagedWidget("menuBox",	    /* Widget name */
					boxWidgetClass,	    /* widget class */
					dataMenu,	    /* parent widget */
					XtNborderWidth,	(Dimension) 2,	    /* size of border */
					XtNfont,  font10x20bold,
					NULL);		    /* end of argument list */
    menuLabel = XtVaCreateManagedWidget("menulabel",
					labelWidgetClass,
					menuShell,
					XtNfont,  font10x20bold,
					XtNlabel, "DISPLAY MANAGER MENU",
					XtNwidth, 500,
					XtNjustify, XtJustifyCenter,
					NULL);
    for (i=0; i<4; i++){
	sprintf(buf, "menupane%d", i);
	menuPane[i] = XtVaCreateManagedWidget(buf, 
					      commandWidgetClass, 
					      menuShell, 
					      XtNlabel, labels[i],
					      XtNwidth, 500,
					      XtNjustify, XtJustifyLeft,
					      NULL);
	XtAddCallback (menuPane[i], XtNcallback, dataManagerMenu, i);
    }

    allqueues = XtVaCreateManagedWidget(
		"AllQueues",	/* widget name */
		commandWidgetClass,	/* widget class */
		buttonbox,	/* parent widget*/
		XtNfromHoriz,      longForm,
                XtNlabel,          " Display All\nQue  Contents",
		XtNborderWidth,     (Dimension) 2,
		NULL);	/* argument list*/


    callback[0].callback = PopupHelp;
    callback[0].closure = NULL;
    helpwidget = XtVaCreateManagedWidget(
		"helpwidget",	/* widget name */
		commandWidgetClass,	/* widget class */
		buttonbox,	/* parent widget*/
		XtNfromHoriz,      allqueues,
		XtNcallback,       callback,
                XtNlabel,          "\nHelp",
		XtNborderWidth,     (Dimension) 2,
		NULL);	/* argument list*/

    screen_saver = XtVaCreateManagedWidget(
		"screensaver",	                        /* widget name */
		menuButtonWidgetClass,	                /* widget class */
		buttonbox,	                        /* parent widget*/
		XtNfromHoriz,      helpwidget,
                XtNlabel,          "Screen\nSaver",
		XtNborderWidth,     (Dimension) 2,
		NULL);	                                /* argument list*/

    menu = XtCreatePopupShell("menu", simpleMenuWidgetClass, 
			      screen_saver, NULL, 0);
    menuItem[0] = XtVaCreateManagedWidget ("Disable Application Screen Saver",
					smeBSBObjectClass,
					menu, NULL);
    XtAddCallback (menuItem[0], XtNcallback, screenSaverMenu, (XtPointer) 0);

    menuItem[1] = XtVaCreateManagedWidget ("Enable Hardware Screen Saver",
					smeBSBObjectClass,
					menu, NULL);
    XtAddCallback (menuItem[1], XtNcallback, screenSaverMenu, (XtPointer) 1);
/*    XGetScreenSaver(display,
		    &screentimeout, &screeninterval, &prefer_blanking, &allow_exposures);*/
    XSetScreenSaver(display, 0, 0, 0, 0); /* turn off hardware screen saver */

    XtAddCallback(allqueues, XtNcallback, allQueues, 0);

    prompt_label = XtVaCreateManagedWidget ("PromptLabel",
					    labelWidgetClass,
					    buttonbox,
					    XtNfont,     font9x15bold,
					    XtNwidth,    250,
					    XtNborderWidth,     (Dimension) 2,
					    XtNlabel,    " ",
					    XtNfromHoriz, screen_saver,
					    XtNjustify, XtJustifyLeft,
					    NULL);

}

create_labelBox(parent)
Widget parent;
{
    Widget   qname, qon, pon, njobs, OldestJob, don, mystatus, assignedTo, spaceh;

    labelbox = XtVaCreateManagedWidget("labelbox", boxWidgetClass,
					parent, 
					XtNwidth,   totalWidth,
					NULL);

    spaceh = XtVaCreateManagedWidget(
		"space holder",		/* widget name */
		labelWidgetClass,	/* widget class */
		labelbox,	/* parent widget*/
		XtNlabel,       "\n",
		XtNwidth,        10,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/

    qname = XtVaCreateManagedWidget(
		"qname",		/* widget name */
		labelWidgetClass,	/* widget class */
		labelbox,	/* parent widget*/
		XtNlabel,       "\nQueue Name",
		XtNwidth,       COL1WIDTH-2,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/

    qon = XtVaCreateManagedWidget(
		"qon",		                 /* widget name */
		labelWidgetClass,	         /* widget class */
		labelbox,	                 /* parent widget*/
		XtNfromHoriz,    qname,
		XtNlabel,        "Queing\n  On",
		XtNwidth,        COL2WIDTH,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	                         /* argument list*/

    pon = XtVaCreateManagedWidget(
		"pon",		                 /* widget name */
		labelWidgetClass,	         /* widget class */
		labelbox,	                 /* parent widget*/
		XtNfromHoriz,    qon,
		XtNlabel,        "Printing\n   On",
		XtNwidth,        COL3WIDTH,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	                         /* argument list*/

    njobs = XtVaCreateManagedWidget(
		"njobs",		                 /* widget name */
		labelWidgetClass,	         /* widget class */
		labelbox,	                 /* parent widget*/
		XtNfromHoriz,    pon,
		XtNlabel,        "\n# Jobs",
		XtNwidth,        COL4WIDTH,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	                         /* argument list*/

    OldestJob = XtVaCreateManagedWidget(
		"oldest",		                 /* widget name */
		labelWidgetClass,	         /* widget class */
		labelbox,	                 /* parent widget*/
		XtNfromHoriz,    njobs,
		XtNlabel,        "Oldest\nJob Age",
		XtNwidth,        COL7WIDTH,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	                         /* argument list*/

    don = XtVaCreateManagedWidget(
		"don",		                 /* widget name */
		labelWidgetClass,	         /* widget class */
		labelbox,	                 /* parent widget*/
		XtNfromHoriz,    OldestJob,
		XtNlabel,        "  Local\nDaemon On",
		XtNwidth,        COL5WIDTH,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	                         /* argument list*/

    assignedTo = XtVaCreateManagedWidget(
		"assignedto",		                 /* widget name */
		labelWidgetClass,	         /* widget class */
		labelbox,	                 /* parent widget*/
		XtNfromHoriz,    don,
		XtNlabel,        "Assigned\n   To",
		XtNwidth,        COL6WIDTH,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	                         /* argument list*/

    mystatus = XtVaCreateManagedWidget(
		"status",		                 /* widget name */
		labelWidgetClass,	         /* widget class */
		labelbox,	                 /* parent widget*/
		XtNfromHoriz,    assignedTo,
		XtNlabel,        "\nLocal Status",
		XtNwidth,        STATCOLWIDTH,
                XtNfont,         font_info,
		XtNbackground,   black,
		XtNforeground,   white,
		XtNborderWidth,     (Dimension) 1,
		NULL);	                         /* argument list*/
}
