
#include "../lp.h"
#include "../lps.h"
#include "../buffer_names.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <grp.h>
#include <unistd.h>
#include <string.h>
#ifndef SHM_RDONLY
#include <sys/shm.h>
#endif
#ifndef ENOENT
#include <errno.h>
#endif

#ifndef NULL
#define NULL 0
#endif

#define XtNinterval "interval"
#define XtNcount "count"
#define XtCCount "Count"
#define XtNhelpFile "helpFile"
#define XtCHelpFile "HelpFile"
#define XtNcontrolTerm "controlTerm"
#define XtCControlTerm "ControlTerm"
#define ON TRUE
#define OFF FALSE
#define DEF_INTERVAL	1
#define DEF_COUNT	-1
#define TOTALWIDTH 250

extern void Yes();
extern void No();
extern void getformWnh();
extern int      ret_width, ret_height;

int      lineNum;
char     label[132]; 
Arg      args[15];
struct   outputage outputAge;
XtIntervalId DoAgainintervalID;
char     *progname;
char     *myargv;
key_t    key;
Display  *display;
int      screen_width, screen_height;
int      totalWidth;
XtAppContext app_context;
int      interval;
Widget   topLevel, form, unused, pshell, dialog, warning, noServer;
char     geometry_string[16];
Screen   *myscreen;
Pixel    white, black;
char     *controlterm[6];
short    uid, euid;
gid_t    gid, egid;
Bool     writeAccess;
Bool     ControlTerm;
int      shmid[1];
time_t   mtime[1];
int      count, interval;

static int defaultInterval = DEF_INTERVAL;
static int defaultCount = DEF_COUNT;

/* Application Resources - no particular widget */

static XtResource application_resources[] = {
    {"interval", "Interval", XtRInt, sizeof(int),
	    (Cardinal)&interval, XtRInt, (caddr_t) &defaultInterval},
    {"count", "Count", XtRInt, sizeof(int),
	    (Cardinal)&count, XtRInt, (caddr_t) &defaultCount},
};

/*
*  Command line options table. The command line is parsed for these,
*  and it sets/overrides the appropriate values in the resource
*  database
*/
static XrmOptionDescRec optionDescList[] = {
    {"-interval",   ".interval",    XrmoptionSepArg,    (caddr_t) NULL},
    {"-count",	    ".count",	    XrmoptionSepArg,    (caddr_t) NULL},
};
AppData app_data;
/* resource list */
static XtResource resources[] = {
    {
	XtNinterval,
	XtCInterval,
	XtRInt,
	sizeof(int),
	XtOffsetOf(AppData, interval),
	XtRImmediate,
	(caddr_t) DEF_INTERVAL
	},
	{
	XtNcount,
	XtCCount,
	XtRInt,
	sizeof(int),
	XtOffsetOf(AppData, count),
	XtRImmediate,
	(caddr_t) DEF_COUNT
	},
	{
	XtNhelpFile,
	XtCHelpFile,
	XtRString,
	sizeof(String),
	XtOffsetOf(AppData, helpFile),
	XtRString,
	HELPFILE
	},
	{
	    XtNcontrolTerm,
	    XtCControlTerm,
	    XtRString,
	    sizeof(String),
	    XtOffsetOf(AppData, ControlTerm),
	    XtRString,
	    NULL,
	}
};

void clearOutputAge(w, Client_data, Call_data)
Widget w;
XtPointer Client_data, Call_data;
{
    int i = (int)Client_data;

    printf ("clearing line %d in output age window\n", (int)Client_data);
    sprintf(label, "\0");
    buf0->data[i].oldestJob = 0;
    buf0->data[i].numJobs = 0;
    buf0->oldestJobTime[i] = 0;
    XtVaSetValues(outputAge.dataLine[i].numJobs, XtNlabel, label, NULL);
    XtVaSetValues(outputAge.dataLine[i].oldestJob, XtNlabel, label, NULL);
    
}

static XtTimerCallbackProc
serviceData(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    for (lineNum=0; lineNum<buf0->numPrinters; lineNum++){
	if (buf0->data[lineNum].numJobs != old_buf0->data[lineNum].numJobs ||
	    buf0->data[lineNum].oldestJob != old_buf0->data[lineNum].oldestJob)
	    if (buf0->data[lineNum].numJobs != 0){
		sprintf(label, "%0d\0", buf0->data[lineNum].numJobs);
		XtSetArg (args[0], XtNlabel, label);
		XtSetValues (outputAge.dataLine[lineNum].numJobs, args, 1);
		sprintf (label, "%d min\0", buf0->data[lineNum].oldestJob);
		XtSetArg (args[0], XtNlabel, label);
		XtSetValues (outputAge.dataLine[lineNum].oldestJob, args, 1);
	    }
	    else{
		sprintf(label, " \0");
		XtSetArg(args[0], XtNlabel, label);
		XtSetValues (outputAge.dataLine[lineNum].numJobs, args, 1);
		XtSetValues (outputAge.dataLine[lineNum].oldestJob, args, 1);
	    }
	
	old_buf0->data[lineNum].numJobs = buf0->data[lineNum].numJobs;
	old_buf0->data[lineNum].oldestJob = buf0->data[lineNum].oldestJob;
    }
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*1000), serviceData, (caddr_t) NULL);
}

main(argc, argv)
int argc;
char **argv;
{
    Widget pane1, pane2, yes, no, new;
    int    i, *p, n;
    char   *geometry;
    char   *myborder;
    char   warning_geometry[16];
    int    border=1;
    int    flags=0;
    Window root;
    Widget top;
    int    status, screen, opergid;
    struct group *gr;
    Cursor cursor;
    XEvent event;
    char   newstring[1024];
    Position master_x;
    int    button = 0;

    strcpy(argv[0], "outputAgeV1.0");
    progname = argv[0];
    myargv = *argv;

    key = getkey();

    if ((display = XOpenDisplay(NULL))==0)		    /* open display, connect to server */
	syserr("Display variable not set", NULL, NULL);
    screen = DefaultScreen(display);
    screen_width = display->screens[0].width;
    screen_height = display->screens[0].height;
    XCloseDisplay(display);				    /* disconnect from server */
    topLevel = XtVaAppInitialize(
				 &app_context,		    /* Application context */
				 "LpsV2",		    /* application class name */
				 optionDescList, 
				 XtNumber(optionDescList),  /* command line option list */
				 &argc, argv,		    /* command line args */
				 NULL,			    /* for missing app-defaults file */
				 XtNiconName,  progname,
#ifdef FORCE_PLACEMENT		 XtNmappedWhenManaged, FALSE,
#endif
				 NULL);			    /* terminate varargs list */

    myscreen = XtScreen(topLevel);			    /* get screen core structure */
    white = WhitePixelOfScreen(myscreen);		    /* get default white pixel */
    black = BlackPixelOfScreen(myscreen);		    /* ditto for black */
/*
 * check command line options for range
 */
    if (argc > 1)
	Syntax(argc, argv);
/*
 * set custom default application resources
 */
    XtGetApplicationResources(topLevel, 0, application_resources,
			      XtNumber(application_resources), NULL, 0 );
    XtGetApplicationResources(topLevel, &app_data, resources,
			      XtNumber(resources), NULL, 0 );
/*
 * get the controlTerm list
*/
    controlterm[0] = app_data.ControlTerm;
    for (i=1; i<6; i++){
	if ((controlterm[i] = strchr(controlterm[i-1], ',')) != NULL){
	    controlterm[i][0] = '\0';
	    controlterm[i]++;
	}
	else
	    break;
    }
    ControlTerm = FALSE;
    for (n=0; n<i; n++){
	if (strcmp(controlterm[n], display->display_name) == 0)
	    ControlTerm = TRUE;
    }
/* find out who we are running as */

    uid = getuid();
    euid = geteuid();
    gid = getgid();
    egid = getegid();
    printf ("uid=%d euid=%d gid=%d egid=%d\n", uid, euid, gid, egid);
    gr = getgrnam("operator");
    if (gr != (struct group *) 0)
	opergid = gr->gr_gid;
    endgrent();
    if ((gid == opergid && ControlTerm) ||		    /* if groupID = operator or */
	(egid == opergid && ControlTerm) ||		    /* if egroupID = operator or */
	(gid == 0) ||					    /* if groupID = root or */
	(egid == 0)||					    /* if egroupID = root or */
	(uid == 0) ||					    /* if userID = root or */
	(euid == 0 && ControlTerm))			    /* if euserID = root then */
	writeAccess = TRUE;				    /* grant write access */
    else
	writeAccess = FALSE;

/* 
 * now check for out of range options specifications
 */
    if (app_data.interval < 1 || app_data.interval > 60){
	fprintf (stderr, "%s: error in resource settings for interval: \n  %s",
		 argv[0], "   interval specification must be 1 to 60 inclusive\n");
	exit(1);
    }
/* 
  now attach to the main shared memory section created by the server
*/
    if (writeAccess)
	flags = NULL;
    else
	flags = SHM_RDONLY;
    shmid[0] = getshmset(key, sizeof(struct databuf), "buf0"); /* get buf0 first */
    printf ("in %s shmid%d = %d\n", argv[0], i, shmid[0]);
    if ((buf0 = (struct databuf *) shmat(shmid[0], 0, flags)) == ERR)
	syserr("shmat in shmem", NULL, NULL);
    mtime[0] = buf0->mtime[0];				    /* remember last update time */
/*
  and create a local memory region for the old stuff.
*/
    old_buf0 = (struct old_databuf *)malloc(sizeof(struct old_databuf));
    (void) memset(old_buf0, '9', sizeof(struct old_databuf)); /* init the region */
/*
  finish creating the form
*/
    form = XtVaCreateManagedWidget(
				   "form",		    /* widget name */
				   formWidgetClass,	    /* widget class */
				   topLevel,		    /* parent widget*/
				   XtNborderWidth,     (Dimension) 1,
				   NULL);                   /* argument list*/
    outputAge.heading = XtVaCreateManagedWidget("NoServer",
						labelWidgetClass,
						form,
						XtNlabel, "Output Pickup Ageing",
						XtNjustify, XtJustifyCenter,
						XtNwidth, 230,
						NULL);
    outputAge.title1 = XtVaCreateManagedWidget ("outputAge",
						labelWidgetClass,
						form,
						XtNfromVert, outputAge.heading,
						XtNjustify, XtJustifyCenter,
						XtNwidth,       75,
						XtNlabel, "\nPrinter",
						NULL);
    outputAge.title2 = XtVaCreateManagedWidget ("Title",
						labelWidgetClass,
						form,
						XtNfromVert, outputAge.heading,
						XtNfromHoriz, outputAge.title1,
						XtNjustify, XtJustifyCenter,
						XtNwidth,     70,
						XtNlabel, "\n# Jobs",
						NULL);
    outputAge.title3 = XtVaCreateManagedWidget ("title",
						labelWidgetClass,
						form,
						XtNfromVert, outputAge.heading,
						XtNfromHoriz, outputAge.title2,
						XtNjustify, XtJustifyCenter,
						XtNwidth,       70,
						XtNlabel, "Oldest\nJob Age",
						NULL);
    unused = outputAge.title1;
    for (i=0; i<buf0->numPrinters; i++){
	outputAge.dataLine[i].prntrName = XtVaCreateManagedWidget(
						    "printer", /* widget name */
						    commandWidgetClass,	/* widget class */
						    form,		/* parent widget*/
						    XtNfromVert,    unused,
						    XtNwidth,       75,
						    XtNborderWidth,     (Dimension) 1,
						    XtNlabel, buf0->data[i].printer,
						    NULL);		/* argument list*/
	sprintf(label, "%d", buf0->data[i].numJobs);
	outputAge.dataLine[i].numJobs = XtVaCreateManagedWidget(
								"numjobs",
								labelWidgetClass,
								form,
								XtNfromVert, unused,
								XtNwidth,       70,
								XtNfromHoriz, outputAge.dataLine[i].prntrName,
								XtNlabel, label,
								NULL);
	if (buf0->data[i].numJobs != 0)
	    sprintf(label, "%d min", buf0->data[i].oldestJob);
	else
	    sprintf(label, "0 min");
	outputAge.dataLine[i].oldestJob = XtVaCreateManagedWidget(
						     "oldest",
						     labelWidgetClass,
						     form,
						     XtNfromVert, unused,
						     XtNfromHoriz, outputAge.dataLine[i].numJobs,
						     XtNwidth,       70,
						     XtNlabel, label,
						     NULL);
	unused = outputAge.dataLine[i].prntrName;
    }
/*
 * now set the command widgets sensitivity to off if we are not a control term.
 * The control term list is taken from the application resource database.
 */
    for (i=0; i<buf0->numPrinters; i++)
	if (!writeAccess)		                            /* if we are not a control term */
	    XtSetSensitive(outputAge.dataLine[i].prntrName, FALSE);
	else
	    XtAddCallback(outputAge.dataLine[i].prntrName , XtNcallback, clearOutputAge, i);

/*
  Now create the quit box... wont be visible for now.
*/
    pshell = XtVaCreatePopupShell(
				  "pshell",
				  transientShellWidgetClass,
				  topLevel,
				  NULL);		    /* terminate varargs list */

    dialog = XtVaCreateManagedWidget(
				     "dialog",		    /* widget name   */
				     dialogWidgetClass,	    /* widget class */
				     pshell,		    /* parent widget*/
				     NULL);		    /* terminate varargs list */

    yes = XtVaCreateManagedWidget(
				  "yes",		    /* widget name   */
				  commandWidgetClass,	    /* widget class */
				  dialog,		    /* parent widget*/
				  XtNlabel,   "YES",
				  NULL);		    /* terminate varargs list */

    no = XtVaCreateManagedWidget(
				 "no",			    /* widget name   */
				 commandWidgetClass,	    /* widget class */
				 dialog,		    /* parent widget*/
				 XtNlabel,   "NO",
				 NULL);			    /* terminate varargs list */

    XtAddCallback(yes, XtNcallback, Yes, 0);
    XtAddCallback(no, XtNcallback, No, 0);
    XtRealizeWidget(topLevel);				    /* wont map for now if FORCE_PLACEMENT is set*/
#ifdef FORCE_PLACEMENT
    getformWnH(topLevel, ret_width, ret_height);	    /* get actual width & height */
    sprintf(geometry_string,"+%d+%d", screen_width-ret_width, screen_height-ret_height);
    XtSetArg(args[0], XtNgeometry, geometry_string);	    /* park it in lower right hand corner */
    XtSetValues(topLevel, args, 1);			    /* setvalues wont work for topLevel */
    XtMoveWidget(topLevel,				    /* must use movewidget instead */
		 (Position)screen_width-ret_width, 
		 (Position)screen_height-ret_height);
    getformWnH(topLevel, ret_width, ret_height);	    /* get actual width & height */
    XtMapWidget(topLevel);				    /* now map it (make it visible) */
    getformWnH(topLevel, ret_width, ret_height);	    /* get actual width & height */
#endif
/* now build a popup window for later display to notify of server malfunctions */

    sprintf(warning_geometry,"+%d+%d", screen_width-(TOTALWIDTH)+20, 30);
    warning = XtVaCreatePopupShell("warning", 
				    transientShellWidgetClass,
				    form, 
				    XtNborderWidth,  (Dimension) 10,
				    XtNallowShellResize, (XtArgVal) FALSE,
				    XtNgeometry, warning_geometry,
				    NULL);

    noServer = XtVaCreateManagedWidget("NoServer",
					    labelWidgetClass,
					    warning,
					    XtNlabel, "WARNING - Server\nmalfunction",
					    XtNjustify, XtJustifyCenter,
					    NULL);
    XFlush(display);
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*1000), serviceData, (caddr_t) NULL);
    XtAppMainLoop(app_context);
}

/*
 * yes button ( quit function)
 */
/*ARGSUSED*/
void Yes(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
    extern XtTimerCallbackProc done();
    int i = 1;
    client_data = (char *)i;
    exit;
}
/*
 * no button
 */
/*ARGSUSED*/
void No(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
    XtPopdown (pshell);
/*    XtSetSensitive(quit,TRUE);*/
    return;
}
