
#include "../lp.h"
#include "../lps.h"
#include "../buffer_names.h"
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/IntrinsicP.h>
#include <X11/ShellP.h>
#include <X11/Vendor.h>
#include <X11/VendorP.h>
#include <string.h>

#define NUMTOKENS 16
#define TIMEFORCHANGE 15				    /* allow 15 seconds */

extern Widget topLevel;
extern XtAppContext app_context;
extern int clientNum;
extern char *progname;
extern void quit_selections();
extern int screen_width, screen_height;

Widget lineShell, removeW, moveW, quitW, textW, moveMenu;
XtWidgetGeometry request, reply;
Arg    args[15];
char   geometry_string[16];
char   label_string[132];
Bool   poppedUpFirst = FALSE, lineWup = FALSE;
char   *queLines;
int    queNumber, to_queNum;
char   *tok[NUMTOKENS];

/*
  routine to service sigalrm generated by alarm.
*/
/*ARGSUSED*/
static  jobcontrol_timer(sig)
unsigned sig;
{
    extern char *sys_siglist[];

    signal(SIGALRM, SIG_IGN);				    /* ignore further signals */

/*    printf("caught signal #%d in %s#%d: %s\n", 
	    sig, progname, clientNum, sys_siglist[sig]);*/

    if ( lineWup ) {
/*	printf("in jobcontrol_timer lineWup = %d\n", lineWup);*/
	quit_selections();
	alarm(0);					    /* cancel alarm clock */
    }
}

void insert_selection(w, client_data, selection, type, value, length, format)
Widget w;
caddr_t client_data;
Atom *selection, *type;
caddr_t value;
unsigned long *length;
int *format;
{
/*    printf("from window #%d\n", (int)client_data);*/
    if ( value ) {
	if ( !poppedUpFirst ) {
	    request.request_mode = CWX | CWY;
	    request.x = screen_width - 410;
	    request.y = screen_height - 282;
	    XtMakeGeometryRequest(lineShell, &request, &reply);
	    sprintf(geometry_string,"+%d+%d",request.x,request.y);
	    XtSetArg(args[0], XtNgeometry, geometry_string);
	    XtSetValues(lineShell, args, 1);   
	    XtPopup (lineShell ,XtGrabNone);
	    XtMoveWidget(lineShell, request.x, request.y);
	    poppedUpFirst = lineWup = TRUE;
	}
	if ( !lineWup ){
	    XtPopup (lineShell ,XtGrabNone);
	    lineWup = TRUE;
	}
	XtVaSetValues(textW, 
		      XtNstring, value, 
		      NULL);				    /* display new data on screen */
	queLines = (char *) XtMalloc(strlen(value)+1);
	strcpy (queLines, value);
	signal(SIGALRM, jobcontrol_timer);	    /* enable signal catching */
	alarm(TIMEFORCHANGE);				    /* set a 15 second timer */
    }
    else {
	fprintf(stderr,"Warning: insert_selection was passed a null string. Try selecting a \
line again\n");
	XBell(XtDisplay(topLevel),0);
    }
}

void get_selection(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    int i;
    queNumber = atoi(*params);
    XtGetSelectionValue(w, XA_PRIMARY, XA_STRING, insert_selection, 
			queNumber, event->xbutton.time);
}

void quit_selections(w, client, call)
Widget w;
XtPointer client, call;
{
    alarm(0);
    signal(SIGALRM, SIG_IGN);				    /* ignore further signals */
/*    printf("here we are in quit_selections\n");*/
    (void)XtFree(queLines);
    XtPopdown(lineShell);
    lineWup = FALSE;
}

parseJobNums()
{
    char   *tok1, *tok2, *tok3, *tok4;
    int    i=0;

    bzero(tok, sizeof(tok));
    tok1 = strtok(queLines, " ");
    tok1 = strtok(NULL, " ");
    tok[i] = strtok(NULL, " ");				    /* got job number of first line here */
/*    printf("got job #%s\n", tok[0]);*/
    
    while ( (tok4 = strtok(NULL, "\n")) != NULL ) {
	if ( !isdigit(tok[i][0]) ) i--;
	if ( i == NUMTOKENS-1 ) {
	    fprintf(stderr, "Warning: Too many jobs in job list.\n");
	    return(i);
	}
	tok1 = strtok(NULL, " ");
	tok1 = strtok(NULL, " ");
	tok[++i] = strtok(NULL, " ");                       /* got job number of next line here */
/*	printf("got job #%s\n", tok[i]);*/
    }
/*    printf("found %d jobs. no more jobs\n", i);*/
    return(i);
}

void remove_selections(w, client, call)
Widget w;
XtPointer client, call;
{
    int    numFound, i;
    char   queueName[32];

/*    printf("here we are in remove_selections\nqueLines=%s\n", queLines);
    printf("for queue %s found:\n", buf0->queNames[queNumber]);*/
    numFound = parseJobNums();
    if ( numFound ) {
	sprintf(queueName, "-P%s", buf0->queNames[queNumber]);
	
	switch (fork()) {
	case -1:			/* fork failed */
	    perror("fork failed in remove_selections");
	    break;
	case 0:			/* child process */
	    execl("/usr/ucb/lprm", "lprm", queueName , tok[0], 
		  tok[1], tok[2], tok[3], tok[4], tok[5], 
		  tok[6], tok[7], tok[8], tok[9], tok[10],
		  tok[11], tok[12], tok[13], tok[14], tok[15], (char *)0 );
	    perror("execl failed in remove_selections");
	    exit(-1);
	    break;
	default:			/* parent process */
	    quit_selections();
	}
    }
    else
	quit_selections();
}

void move_selections(w, client, call)
Widget w;
XtPointer client, call;
{
    int    numFound;

/*    printf("here we are in move_selections\nqueLines=%s\n", queLines);
    printf("in get_to_queNum queNum = %d, queName = %s\n", 
	   (int)client, buf0->queNames[(int)client]);*/
    to_queNum = (int)client;
/*    printf("for queue %s found:\n", buf0->queNames[queNumber]);*/
    numFound = parseJobNums();
    if ( numFound ) {
	switch (fork()) {
	case -1:			/* fork failed */
	    perror("fork failed in move_selections");
	    break;
	case 0:			/* child process */
	    execl("/usr/local/bin/lpmv", "lpmv", 
		  buf0->queNames[queNumber], 
		  buf0->queNames[(int)client], 
		  tok[0], tok[1], tok[2], tok[3], tok[4], tok[5], 
		  tok[6], tok[7], tok[8], tok[9], tok[10],
		  tok[11], tok[12], tok[13], tok[14], tok[15], (char *)0 );
	    perror("execl failed in move_selections");
	    exit(-1);
	    break;
	default:			/* parent process */
	    quit_selections();
	}
    }
    else
	quit_selections();
}

void topq_selections(w, client, call)
Widget w;
XtPointer client, call;
{
    int    numFound, i;
    char   queueName[32];

/*    printf("here we are in topq_selections\nqueLines=%s\n", queLines);
    printf("for queue %s found:\n", buf0->queNames[queNumber]);*/
    numFound = parseJobNums();
    if ( numFound ) {
	sprintf(queueName, "%s", buf0->queNames[queNumber]);
	
	switch (fork()) {
	case -1:			/* fork failed */
	    perror("fork failed in remove_selections");
	    break;
	case 0:			/* child process */
	    execl("/usr/etc/lpc", "lpc", "topq", queueName, tok[0], 
		  tok[1], tok[2], tok[3], tok[4], tok[5], 
		  tok[6], tok[7], tok[8], tok[9], tok[10],
		  tok[11], tok[12], tok[13], tok[14], tok[15], (char *)0 );
	    perror("execl failed in remove_selections");
	    exit(-1);
	    break;
	default:			/* parent process */
	    quit_selections();
	}
    }
    else
	quit_selections();
}

#define JOB_PANEL_WIDTH 400

createPopupControlPanel()
{
    Widget lineForm, lineTitle, moveMenuItem[MAX_QUEUES], topQ;
    int i;

    static XtActionsRec window_actions[] = {
	{"get_selection", get_selection},
    };

    XtAppAddActions (app_context, window_actions, 1);

    lineShell = XtVaCreatePopupShell("Job Control Panel",
				     transientShellWidgetClass,
				     topLevel,
				     NULL);
    lineForm = XtVaCreateManagedWidget("formW",
				       formWidgetClass,
				       lineShell,
				       NULL);
    sprintf(label_string, "Job Control Panel");
    lineTitle = XtVaCreateManagedWidget("title",
					labelWidgetClass,
					lineForm,
					XtNheight,    25,
					XtNwidth,     JOB_PANEL_WIDTH,
					XtNlabel,     label_string, /* LABEL for child window */
					NULL);
    sprintf(label_string, "  Remove\nSelections");
    removeW = XtVaCreateManagedWidget ("Remove Selections",
				       commandWidgetClass,
				       lineForm,
				       XtNfromVert,  lineTitle,
				       XtNheight,    35,
				       XtNlabel,     label_string, 
				       NULL);
    XtAddCallback (removeW, XtNcallback, remove_selections, NULL);
    sprintf(label_string, "   Move\nSelections");
    moveW = XtVaCreateManagedWidget("move Selections",	                        /* widget name */
				    menuButtonWidgetClass,	                /* widget class */
				    lineForm,
				    XtNfromVert,  lineTitle,
				    XtNfromHoriz, removeW,
				    XtNheight,    35,
				    XtNlabel,     label_string, 
				    NULL);
    sprintf(label_string, "Destination Queue");
    moveMenu = XtVaCreatePopupShell("menu", simpleMenuWidgetClass, 
				  moveW, 
				  XtNlabel,       label_string,
				  NULL);
    for ( i=1; i<buf0->nitems; i++ ) {
	moveMenuItem[i] = XtVaCreateManagedWidget ("move Menu Item",
						   smeBSBObjectClass,
						   moveMenu, 
						   XtNlabel, buf0->queNames[i],
						   NULL);
	XtAddCallback ( moveMenuItem[i], XtNcallback, move_selections, (int)i );
    }
/*    XtAddCallback (moveW, XtNcallback, move_selections, NULL);*/

    sprintf(label_string, "  \nTOPQ");
    topQ = XtVaCreateManagedWidget("topq",	                        /* widget name */
				    commandWidgetClass,	                /* widget class */
				    lineForm,
				    XtNfromVert,  lineTitle,
				    XtNfromHoriz, moveW,
				    XtNheight,    35,
				    XtNlabel,     label_string, 
				    NULL);
    XtAddCallback (topQ, XtNcallback, topq_selections, NULL);

    sprintf(label_string, "Quit");
    quitW = XtVaCreateManagedWidget ("Quit Selections",
				     commandWidgetClass,
				     lineForm,
				     XtNheight,    35,
				     XtNfromVert,  lineTitle,
				     XtNfromHoriz, topQ,
				     XtNlabel,     label_string, 
				     NULL);
    XtAddCallback (quitW, XtNcallback, quit_selections, (Widget)lineShell);
    textW= XtVaCreateManagedWidget ("Text",
				    asciiTextWidgetClass,
				    lineForm,
				    XtNheight,      200,
				    XtNwidth,       JOB_PANEL_WIDTH,
				    XtNfromVert,    removeW,
				    XtNscrollVertical, XawtextScrollWhenNeeded,
				    NULL);
}
