
#include "../lp.h"
#include "../lps.h"
#include "../buffer_names.h"
#include <string.h>

#define DEBUG 1
#define MAX_LINES 48

extern unsigned int display_width, display_height;
extern XWindowAttributes window_attributes;
extern Dimension width, height, offset, border;
extern XtIntervalId ScreenSaverID;
extern int screentimeout, screeninterval, prefer_blanking, allow_exposures;
extern Widget  topLevel;
extern XtAppContext app_context;
extern XtTimerCallbackProc ScreenSaver();
extern Arg args[15];
extern load_font();
extern char * strstr();
extern int motion;
extern int slot[MAX_QUEUES][4];

char   logs[MAX_QUEUES][MAX_LINES][132];	/* MAX_QUEUES possible queues, MAX_LINES lines each, max of 132 chars/line */
char   devLogs[NUM_PRNTRS+1][MAX_LINES][132];
int    cp[32];		/* pointers to next available (oldest) line, one per queue */
int    devcp[NUM_PRNTRS+1];
FILE   *fd[MAX_QUEUES];		/* one for each prospective queue */
FILE   *devfd[NUM_PRNTRS+1];
struct LogWindows logWindows[NUM_PRNTRS+1];
char   *devBuf[NUM_PRNTRS+1];
char   NullText[8] = " shit \0";
char   *NULLtext = NullText;

getLogLine(l,lsize,fp)
char *l;
int  lsize;
FILE *fp;
{
    char *i;

    i = fgets(l, lsize, fp);
    if (i == l)
	return(1);
    else if ((int)i == 0)
	return(0);
    else
	return(-1);
}

checkForNULL(ndev,pntr)
int  pntr, ndev;
{
    int i;

    for (i=0; i<MAX_LINES; i++){
	if (logs[ndev][pntr][0] == NULL) logs[ndev][pntr][0] = '\n';
#ifdef DEBUG1
	printf ("%2d %1d %2d %8s %s", pntr, ndev, i, buf0->queNames[ndev], logs[ndev][pntr++]);
#endif
	if (pntr >= MAX_LINES) pntr = 0;
    }
}

initLogs()			/* called by main in screen.c */
{

    int      i, i1;

    strcpy(logWindows[0].name, "Remote");		    /* reserve first window for printers remotely serviced */
    strcpy(logWindows[1].name, PRINTER1);
    strcpy(logWindows[2].name, PRINTER2);
    strcpy(logWindows[3].name, PRINTER3);
    strcpy(logWindows[4].name, PRINTER4);
    strcpy(logWindows[5].name, PRINTER5);
    strcpy(logWindows[6].name, PRINTER6);
    strcpy(logWindows[1].logFile, LOG1);
    strcpy(logWindows[2].logFile, LOG2);
    strcpy(logWindows[3].logFile, LOG3);
    strcpy(logWindows[4].logFile, LOG4);
    strcpy(logWindows[5].logFile, LOG5);
    strcpy(logWindows[6].logFile, LOG6);
    cp[0] = 0;
    for (i=1; i<=buf0->nitems-1; i++){                       /* process log files for queues first */
#ifdef DEBUG1
	(void) printf ("attempting to open %s\n", buf0->qdata[i][LFI]);
#endif
	if (buf0->qdata[i][LFI][0] != NULL){
	    for (i1=1; i1<=i-1; i1++){
		if (strcmp(buf0->qdata[i][LFI],buf0->qdata[i1][LFI])==0){
		    fd[i] = fd[i1];
#ifdef DEBUG1
		    printf ("%s already opened on channel %d\n", buf0->qdata[i1][LFI], i1);
#endif
		    goto no_dups;
		}
	    }
	    cp[i] = 0;
	    if ((fd[i] = fopen(buf0->qdata[i][LFI], "r"))==0)
		(void)fprintf(stderr,"error on fopen of %s, errno= %d\n", buf0->qdata[i][LFI], errno);
	    else{
#ifdef DEBUG1
		printf ("reading %s\n", buf0->qdata[i][LFI]);
#endif
		while (getLogLine(logs[i][cp[i]], sizeof(logs[i][cp[i]]), fd[i]) > 0){
		    cp[i]++;
		    if (cp[i] >= MAX_LINES) cp[i] = 0;
		}
		checkForNULL(i, cp[i]);
	    }
	}
no_dups:
	continue;
    }					               /* done with log files for queues */
    devBuf[0] = (char *) XtMalloc(MAX_LINES*132);	       /* create memory for status buffer */
    devcp[0] = 0;
    logWindows[0].numchars = 0;
    for (i=1; i<=NUM_PRNTRS; i++){		       /* now do log files for printers */
	devcp[i] = 0;
	logWindows[i].numLines = 0;
	logWindows[i].numchars = 0;
	if (logWindows[i].name[0] != NULL){
	    devBuf[i] = (char *) XtMalloc(MAX_LINES*132);	       /* create memory for status buffer */
	    if ((devfd[i] = fopen(logWindows[i].logFile, "r"))==0)
		(void)fprintf(stderr,"error on fopen of %s, errno= %d\n", logWindows[i].logFile, errno);
	    else{
#ifdef DEBUG1
		printf ("reading %s\n", logWindows[i].logFile);
#endif
		while (getLogLine(devLogs[i][devcp[i]], sizeof(devLogs[i][devcp[i]]), devfd[i]) > 0){
		    devcp[i]++;
		    logWindows[i].oldLines = TRUE;
		    logWindows[i].numLines++;
		    if (devcp[i] >= MAX_LINES) devcp[i] = 0;
		}
	    }
	}
    }
}

checkForNewLogs()
{
    int  i, numLines, i1;

    for (i=1; i<=buf0->nitems-1; i++){                            /* Get new lines (if any) */
	if (fd[i] <= (FILE *)0) continue;
	numLines = 0;
	while (getLogLine(logs[i][cp[i]], sizeof(logs[i][cp[i]]), fd[i]) > 0){
	    cp[i]++, numLines++;
	    if (cp[i] >= MAX_LINES) cp[i] = 0;
	}
	if (numLines){					    /* If we got some lines, now find out which printer */
	    for (i1=0; i1<=NUM_PRNTRS; i1++){
		if (strstr(buf0->assigned_to[i], "@") != 0) break;
		if (strcmp(buf0->assigned_to[i], logWindows[i1].name) == 0) break;
	    }
	    if (i1-1 == NUM_PRNTRS){
		fprintf (stderr,"Warning - no device match for queue %s\n", buf0->assigned_to[i]);
		return;
	    }
	    showLogs(i, i1, numLines, 0);
	}
    }

    for (i=0; i<=NUM_PRNTRS; i++){
	if (devfd[i] <= (FILE *)0) continue;
	numLines = 0;
	while (getLogLine(devLogs[i][devcp[i]], sizeof(devLogs[i][devcp[i]]), devfd[i]) > 0){
	    devcp[i]++, numLines ++, logWindows[i].numLines++;
	    if (devcp[i] >= MAX_LINES) devcp[i] = 0;
	}
	if (numLines) showLogs(i, i, numLines, 1);
    }
}
static String words[] = {
    "corrected",		/* "corrected" MUST be first in list */
    "abort",
    "fail",
    "malfunction",
    "can't",
    "Engine",
    "open",
    "error"
};
#define NUMWORDS 8

findKeyWords(p, left, right)
char            *p;		/* pointer to input buffer */
XawTextPosition  *left, *right;	/* start and end of return values */
{
    char *p1[NUMWORDS];
    int  i1, i2, i3, i4;
    register char *p2;
    register int i;

    *left = 0, *right = 0;
    for (i=0; i<NUMWORDS; i++){
	p1[i] = 0;
	if ((p2 = strstr(p, words[i])) != 0){
	    p1[i] = p2;
	    while ((p2 = strstr(p+1+(p1[i]-p), words[i])) != 0) p1[i] = p2; /* find last occurance (if any) of words[i] */
	}
    }
/* now figure out which occurance of words[i] was last */

    i1 = 0;
 startover:
    for (i=0; i<NUMWORDS; i++){	/* find last occurance of any key word */
	if ((int)p1[i] > (int)p1[i1]){
	    i1 = i;
	    goto startover;
	}
    }
/* now see if the word "corrected" was last */

    if (p1[0] !=0 && p1[0] >= p1[i1]){
	*left = -1;
	return;
    }

    if (p1[i1] != 0){		        /* if we found a keyword then */
	for (p2=p1[i1]; p2>=p; p2--)	/* backup to previous newline */
	    if (p2[0] == '\n') break;
	*left = (p2 - p) + 1; 		/* compute character offset to start of line containing keyword */
	p2 = strchr(p+(*left), '\n');   /*  find end of that line */
	*right = p2 - p;		/* character offset to end of line containing keyword */
    }
}

/* showLogs copies numLines # of newlines from the source buffer to the common intermediate
 * buffer. From there it appends the new data to the end of the text widgets source(sink) by
 * calling XtReplaceText. Remember we are using an asciiStringWidget (not an asciiTextWidget)
 * so the source and the sink are the same. The source(sink) in this case is devBuf[i].
 */
showLogs(ptr, window, numLines, wbuf)
int  ptr;			/* # of queue with lines to display */
int  window;			/* which window to display data in */
int numLines;			/* number of new lines to display */
int  wbuf;			/* which buffer? 0 = logs, 1 = devLogs */
{
    int    i, i1, place;
    char   *p1;
    static XawTextBlock block = { 0, 0, NULL, };
    char   textBuf[MAX_LINES*132];	/* intermediate text buffer */
    XawTextPosition left, right;
    Bool   foundAword;

    switch(wbuf){		/* start by building the intermediate text buffer */
    case 0:
	i = cp[ptr] -numLines;
	if (i < 0) i = MAX_LINES + i;
	textBuf[0] = 0;		/* start with a clean buffer */
	for (i1=0; i1<numLines; i1++){
	    if (i>=MAX_LINES) i = 0;
	    if (logs[ptr][i][0] != NULL){
		place = strlen(textBuf);
		sprintf(textBuf+place,"%10sQu \0", buf0->queNames[ptr]); /* add a label to the beginning of each line */
		strcat(textBuf, logs[ptr][i++]);	       /* copy first line (oldest) */
	    }
	}
	break;
    case 1:
	i = devcp[ptr] -numLines;
	if (i < 0) i = MAX_LINES + i;
	textBuf[0] = 0;
	for (i1=0; i1<numLines; i1++){
	    if (i>=MAX_LINES) i = 0;
	    if (devLogs[ptr][i][0] != NULL){
		place = strlen(textBuf);
		sprintf(textBuf+place,"%10sEv \0", logWindows[window].name);
		strcat(textBuf, devLogs[ptr][i++]);	       /* copy first line (oldest) */
	    }
	}
	break;
    }				/* end of switch(wbuf){ */
#ifdef DEBUG1
    printf("before findkeywords window #%d left=%d, right=%d, strlen textBuf=%d\n", window, 
	   logWindows[window].left, logWindows[window].right, strlen(textBuf));
#endif
    findKeyWords(textBuf, &i, &i1);
#ifdef DEBUG1
    printf("after  findkeywords window #%d i=%d, i1=%d\n", window, 
	   i, i1);
#endif
    if (i>=0 && i1>i){
	logWindows[window].left = logWindows[window].numchars + i;
	logWindows[window].right = logWindows[window].numchars + i1;
    }
    else if (i<0){
	logWindows[window].left = 0;
	logWindows[window].right = 0;
    }
#ifdef DEBUG1
    printf("after  findkeywords window #%d left=%d, right=%d\n", window, 
	   logWindows[window].left, logWindows[window].right);
#endif
/* now remove the same number of lines from the top of the buffer, as we are about to add to the end. 
 */
    if (logWindows[window].numLines >= MAX_LINES){ /* only remove lines if buffer is full */
	block.length = 0;
	block.ptr = NULLtext;
	
	p1 = devBuf[window];
	i1 = 0;
	for (i=0; i<numLines; i++){	                      /* find numLines number of newline characters */
	    if ((p1 = strchr(devBuf[window]+i1, '\n')) != 0)
		i1 = (p1 - devBuf[window]) + 1;
	}
#ifdef DEBUG1
	printf("now attempting to remove %d lines and %d characters. pntr to devBuf[%d]=%x p1=%x\n",
	       numLines, i1, window, &devBuf[window], &p1);
	printf("BEFORE removing lines strlen of buf =%d, contents of buf for window %d=\n%s\n", 
	       strlen(devBuf[window]), window, devBuf[window]);
#endif
    }
    if (logWindows[window].oldLines && logWindows[window].numLines >= MAX_LINES){
	if (i1>0){
	    i = XawTextReplace(logWindows[window].textId,            /* remove i1 # of chars from top of buffer */
			      (XawTextPosition)0,                    /* start position */
			      (XawTextPosition)i1,       	    /* end position */
			      &block);
	    if (i != XawEditDone) {
		fprintf(stderr,"Internal error in write to logFile window text area - ");
		if (i == XawPositionError)
		    fprintf(stderr, "Position Error.\n");
		else
		    fprintf(stderr, "Edit Error.\n");
		logWindows[window].left = 0;
		logWindows[window].right = 0;
	    }
	    else{
		logWindows[window].left -= i1;
		logWindows[window].right -= i1;
		logWindows[window].numchars -= i1;
	    }
	}
    }
    XawTextSetInsertionPoint(logWindows[window].textId, 9999);    /* put the insertion point on last line to force text to scroll up */
#ifdef DEBUG1
    printf("AFTER removing lines strlen of buf=%d, insertion point=%d, contents of buf for window %d=\n%s\n", 
	   strlen(devBuf[window]), XawTextGetInsertionPoint(logWindows[window].textId), window, devBuf[window]);
#endif

/* append the new lines to the end of the current source(sink). */

    if (logWindows[window].oldLines){
#ifdef DEBUG1
	printf("attempting to insert %d lines (%d characters), text = \n%s",
	       numLines, strlen(textBuf), textBuf);
#endif
	block.length = strlen(textBuf);	                       /* adding block.length # of characters to end of buffer */
	block.ptr = textBuf;
	i = XawTextReplace(logWindows[window].textId, 
			  XawTextGetInsertionPoint(logWindows[window].textId),
			  XawTextGetInsertionPoint(logWindows[window].textId),
			  &block);
	if (i != XawEditDone) {
	    fprintf(stderr,"Internal error in write to logFile window text area - ");
	    if (i == XawPositionError)
		fprintf(stderr, "Position Error.\n");
	    else
		fprintf(stderr, "Edit Error.\n");
	    logWindows[window].left = 0;
	    logWindows[window].right = 0;
	}
	else
	    logWindows[window].numchars += block.length;
#ifdef DEBUG1
	printf("AFTER text replace strlen of buf=%d, insertion point=%d, \ncontents of buf for window %d=\n%s\n", 
	       strlen(devBuf[window]), XawTextGetInsertionPoint(logWindows[window].textId), window, devBuf[window]);
#endif
    }
    else{			              /* come here if window is still empty (i.e., never written to yet) */
	strcpy(devBuf[window], textBuf);
	XtSetArg(args[0], XtNstring, devBuf[window]);
	XtSetValues(logWindows[window].textId, args, (Cardinal)1);
	logWindows[window].oldLines = TRUE;
	logWindows[window].numchars = strlen(devBuf[window]);
    }
    if (logWindows[window].isVisible)
	XRaiseWindow(XtDisplay(logWindows[window].topId), 
		     XtWindow(logWindows[window].topId));

/* now see if there are any keywords to highlight */

    if(logWindows[window].left>=0 && logWindows[window].right>logWindows[window].left) {
	XawTextSetSelection(logWindows[window].textId,
			   logWindows[window].left,
			   logWindows[window].right);
	XBell (XtDisplay(topLevel), 0);                 /* hit the gong */
    }
    else if (logWindows[window].left<0){
	logWindows[window].left = 0;
	logWindows[window].right = 0;
    }
}
showDevLogs(dev)
int   dev;
{
    int i, curlen;

    if (devLogs[dev][devcp[dev]][0] != NULL){
	sprintf(devBuf[dev],"%10sEv \0", logWindows[dev].name);
	strcat(devBuf[dev], devLogs[dev][devcp[dev]]);	       /* copy first line (oldest) */
    }
    for (i=devcp[dev]+1; i<MAX_LINES; i++){
	if (devLogs[dev][i][0] != NULL){
	    curlen = strlen(devBuf[dev]);
	    sprintf(devBuf[dev]+curlen, "%10sEv \0", logWindows[dev].name);
	    strcat(devBuf[dev], devLogs[dev][i]);	       /* copy from there until end */
	}
    }
    for (i=0; i<devcp[dev]; i++){
	if (devLogs[dev][i][0] != NULL){
	    curlen = strlen(devBuf[dev]);
	    sprintf(devBuf[dev]+curlen, "%10sEv \0", logWindows[dev].name);
	    strcat(devBuf[dev], devLogs[dev][i]);	       /* copy from beginning to first */
	}
    }
    XtSetArg(args[0], XtNstring, devBuf[dev]);
    XtSetValues(logWindows[dev].textId, args, (Cardinal)1);
    i = strlen(devBuf[dev]);
    if (i != 0){
	XawTextSetInsertionPoint(logWindows[dev].textId, 
				(XawTextPosition)i);    /* put the insertion point on last line to force text to scroll up */
	logWindows[dev].numchars = i;
    }
#ifdef DEBUG1
    printf ("size of buf #%d = %d, insertion point = %d\ncontents=\n%s\n", dev, i, 
		      XawTextGetInsertionPoint(logWindows[dev].textId), devBuf[dev]);
#endif

}

createLogWindows()
{
    int i, count, pcount[NUM_PRNTRS];
    Dimension log_height, log_width;
    char icon_name[MAX_INPUT];
    Position x=0, y=0;
    char label_string[132];
    char  quit_win_num[6];
    char  geometry_string[16];
    XFontStruct *logfont;

    for (i=0; i<NUM_PRNTRS; i++)
	pcount[i] = 0;

/* first find out how many windows we will need */

    for (i=1; i<=buf0->nitems-1; i++)	{
	if (strcmp(buf0->assigned_to[i], PRINTER1) == 0) {pcount[0]++; continue;}
 	if (strcmp(buf0->assigned_to[i], PRINTER2) == 0) {pcount[1]++; continue;}
 	if (strcmp(buf0->assigned_to[i], PRINTER3) == 0) {pcount[2]++; continue;}
 	if (strcmp(buf0->assigned_to[i], PRINTER4) == 0) {pcount[3]++; continue;}
 	if (strcmp(buf0->assigned_to[i], PRINTER5) == 0) {pcount[4]++; continue;}
 	if (strcmp(buf0->assigned_to[i], PRINTER6) == 0) {pcount[5]++; continue;}
    }
    count = 1;			/* window zero is always reserved for queues serviced by remote printers */
    for (i=0; i<NUM_PRNTRS; i++)
	if (pcount[i]) count++;
    printf("count = %d\n",count);
				/* Now we must determine if count is odd or even. On most machines */
				/* we would just use the drem function, but this dont work on a dec */
				/* mips so rather than conditionalize the code we will just use the */
				/* following simple loop. */
    i = count;
    while (i>0)
	i--, i--;
    if (i < 0)			/* count was odd */
	count++;		/* bump count by one to make it even and.. */
    count /= 2;			/* divide by two to get # of rows */

/* now divide the number of pixels below the main window by */
/* count to get the height of each log window */

    log_width = (display_width - ((window_attributes.border_width + (border * 2)) * 2)) / 2;    /* child windows will be two across */
    log_height = ((display_height - ((window_attributes.height + offset) + (offset*count))) / count); /* room for count rows */
    printf ("height of log windows = %d, width = %d\n", log_height, log_width);

/* now calculate x and y for each window */

    logWindows[0].x = 0;				    /* first window is on extreme left side of screen... */
    logWindows[0].y = window_attributes.height + offset - 1; /* and just below the parent(main) window */
    i = 2;
    do {						    /* compute remaining left side window positions */
	logWindows[i].x = 0;
	logWindows[i].y = logWindows[i-2].y + log_height + offset;
	i +=2;
    } while(i < (count*2));
    i = 1;						    /* compute remaining right side window positions */
    do {
	logWindows[i].x = log_width + (border * 2);
	logWindows[i].y = logWindows[i-1].y;
	i += 2;
    } while (i < (count*2));

/* ***change*** try placing all windows in the fourth location, stacked on top of each other
 * and depend on raise window to display most recently written to.
 */
    for (i=0; i<(count*2); i++){
	logWindows[i].x = logWindows[(count*2)-1].x;
	logWindows[i].y = logWindows[(count*2)-1].y;
    }
/* now disable the window slot(s) that are fully occluded by this location */
    for (i=0; i<MAX_QUEUES; i++)
	if (slot[i][X]+border+1 > logWindows[0].x && slot[i][Y]+border+1 > logWindows[0].y)
	    slot[i][STAT] = NOTAVAIL;
/* now choose a font */

    if (display_width <= 1100)
	load_font(&logfont, "5x8");
    else if (display_width > 1100 && display_width < 1200)
	load_font(&logfont, "-schumacher-clean-medium-r-normal-*-8-80-75-75-c-50-iso8859-1");
    else if (display_width > 1200)
	load_font(&logfont, "6x10");
    else
	load_font(&logfont, "5x8");                        /* default font (just in case of a wierd terminal) */

/* Now create the structures */

    for (i=0; i<(count*2); i++){
	sprintf(geometry_string,"+%d+%d",logWindows[i].x+motion, logWindows[i].y+motion);

	logWindows[i].topId = XtVaAppCreateShell(NULL, showLogs, applicationShellWidgetClass, 
			   XtDisplay(topLevel),
			   XtNwidth,  log_width,
			   XtNheight, log_height,
			   XtNmappedWhenManaged, FALSE,
			   XtNallowShellResize, TRUE,
			   XtNgeometry, geometry_string,
			   XtNiconName,  logWindows[i].name,
			   NULL);

	logWindows[i].paneId = XtVaCreateManagedWidget("new_outer",
					panedWidgetClass,
					logWindows[i].topId,
					XtNallowResize, TRUE,
					NULL);

	logWindows[i].textId = XtVaCreateManagedWidget ("Text", 
							asciiTextWidgetClass,
							logWindows[i].paneId,
							XtNfromVert, logWindows[i].labelId,
							XtNscrollVertical, XawtextScrollWhenNeeded,
							XtNeditType, XawtextAppend,
							XtNfont,  logfont,
							XtNallowResize, TRUE,
							NULL);
	XtRealizeWidget(logWindows[i].topId);

	XtPopup(logWindows[i].topId, XtGrabNone);
	logWindows[i].isVisible = TRUE;

	if (logWindows[i].oldLines) showDevLogs(i);

    }
}
