#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef LOG_WARNING
#include <syslog.h>
#endif
extern void rmqueue();
extern void rmsem();
extern int sid;

void syserr(msg, qid, sid)
char *msg;
int qid;
{
    extern int errno, sys_nerr;
    extern char *sys_errlist[];

    fprintf(stderr, "ERROR: %s (errno=%d", msg, errno);
    syslog(LOG_WARNING, "FATAL errno=%d:%m", errno, NULL);
    if (errno > 0 && errno < sys_nerr)
	fprintf(stderr, "; %s)\n", sys_errlist[errno]);
    else
	fprintf(stderr, ")\n");
    if (qid) rmqueue(qid);
    if (sid) rmsem(sid);
    exit(-1);
}

void printenv()
{
    extern char **environ;
    int i;
    for (i=0; environ[i] != NULL; i++)
	printf ("%s\n", environ[i]);
    return;
}
void rmqueue(qid)
long qid;
{
    if ((msgctl(qid, IPC_RMID, NULL)) == -1)
	syserr("rmqueue",NULL, NULL);
}
void rmsem(sid)
long sid;
{
    if ((semctl(sid, IPC_RMID, (struct semid_ds *)0)) == -1)
	syserr("rmsem in ipc_misc.c",NULL, NULL);
}

void rmshm(sid)
long sid;
{
    if ((shmctl(sid, IPC_RMID, (struct shmid_ds *)0)) < 0)
	syserr("rmshm in ipc_misc.c",NULL, NULL);
}

int getshmset(key, size, name)
key_t key;
char *name;
int size;
{
    int sid;

    if ((sid = shmget(key, size, 0777|IPC_CREAT)) <0)
	if (errno == EINVAL){
	    printf("error creating shmseg for key %d. Recreating with new size.\n", key);
	    if ((sid = shmget(key, 0, 0777|IPC_CREAT)) <0)
		syserr ("second shmget1 in server", NULL, NULL);
	    else{
		rmshm(sid);
		if ((sid = shmget(key, size, 0777|IPC_CREAT)) <0)
		    syserr ("retry of shmget1", NULL, NULL);
	    }
	}
	else
	    syserr("shmget1 in shmem",NULL,NULL);
    return(sid);
}
