
/*
 * Routines to display the state of the queue.
 */

#include "../lp.h"
#include "../lps.h"
#include "../buffer_names.h"
#include <string.h>
#include <setjmp.h>

/*#define DEBUG 0*/
/*#define DEBUGIO*/
#define JOBCOL	40		/* column for job # in -l format */
#define OWNCOL	7		/* start of Owner column in normal */
#define SIZCOL	58		/* start of Size column in normal */
#define AGECOL  SIZCOL + 17	/* start of age column */
#define ON TRUE
#define OFF FALSE
/*
 * Stuff for handling job specifications
 */
#ifdef mips
extern char * strstr();
#endif

extern char	*user[];	/* users to process */
extern int	users;		/* # of users in user array */
extern int	requ[];		/* job number of spool entries */
extern int	requests;	/* # of spool requests */
extern int	fflag;		/* forever output option */
extern int      queue_count, q_count;
extern Bool     lpsd[MAX_QUEUES];
extern int      s[MAX_QUEUES];
extern Bool     socket_alive[MAX_QUEUES];
extern Bool     bell;
extern Bool     verbose;

char *   old_status_page[MAX_BUFFERS];

static int	lflag;		/* long output option */
static char	current[40];	/* current file being printed */
static int	garbage;	/* # of garbage cf files */
static int	rank;		/* order to be printed (-1=none, 0=active) */
static long	totsize;	/* total print job size in bytes */
static int	first;		/* first file in ``files'' column? */
static int	col;		/* column on screen */
static int	sendtorem;	/* are we sending to a remote? */
static char	file[132];	/* print file name */

char	*user[MAXUSERS];	/* users to process */
int	users;			/* # of users in user array */
int	requ[MAXREQUESTS];	/* job number of spool entries */
int	requests;		/* # of spool requests */
int	fflag;			/* forever output option */
char    new_string[1024];
time_t  now_time, age, oldest;
jmp_buf broken_pipe;
static  char	*head0 = "Rank   Owner      Job  Files";
static  char	*head1 = "Total Size      Age\n";
int     status_page_size[MAX_BUFFERS];
Bool    changed;
Bool    more_set = FALSE;
Bool    sigpipe = FALSE;
int     charcnt, totchar;

/*
 * Display the current state of the queue. Format = 1 if long format.
 */
displayq(format,ptr)
	int format,ptr;
{
	register struct queue *q;
	register int i, nitems, fd, i1;
	struct queue **queue;
	struct stat statb;
	FILE *fp;
	static char lastprinter[64];
	Arg args[3];
	char  * old_string;
	extern void printTo_status_page();
	Bool myeot = FALSE;
	
	lflag = format;
	totsize = 0;
	rank = -1;
	totchar = 0;
	printer = buf0->queNames[ptr];
	oldest = 0;
	changed = FALSE;
	
#ifdef DEBUG
	printf ("updating info for que %s number %d\n", printer, ptr);
#endif
	if ( status_page_size[0] < SHMSIZE )
	    for (i=0; i<MAX_BUFFERS; i++)
		status_page_size[i] = SHMSIZE;
	if ( !socket_alive[ptr] ) {
	    strcpy (old_status_page[ptr], status_page[ptr]);
	    (void) sprintf (status_page[ptr],"\0");		/* clear the page*/
	}
	sendtorem = 0;
	more_set = FALSE;
	(void) setjmp(broken_pipe);
	if(sigpipe) {
	    sigpipe = FALSE;
	    (void)setjmp(broken_pipe);
	    goto fixpipe;
	}
	/*
	 * If there is no local printer, then print the queue on
	 * the remote machine and then what's in the queue here.
	 * Note that a file in transit may not show up in either queue.
	 */
	if (buf0->qdata[ptr][LPI][0] == '\000') {
	    register char *cp;
	    char c;
		    
	    sendtorem++;
	    (void) sprintf(line, "%c%s", format + '\3', buf0->qdata[ptr][RPI]);
	    cp = line;
	    for (i = 0; i < requests; i++) {
		cp += strlen(cp);
		(void) sprintf(cp, " %d", requ[i]);
	    }
	    for (i = 0; i < users; i++) {
		cp += strlen(cp);
		*cp++ = ' ';
		strcpy(cp, user[i]);
	    }
	    strcat(line, "\n");
	    
	    fd = getport(buf0->qdata[ptr][RMI], ptr);
	    if (fd < 0) {
		if (from != host){
		    (void) sprintf(new_string, 
				   "%s: ", host);
		    printTo_status_page(new_string, ptr);
		}
		(void) sprintf(new_string, 
			       "connection to %s is down\n", buf0->qdata[ptr][RMI]);
		printTo_status_page(new_string, ptr);
	    } 
	    else {
		if ( socket_alive[ptr] == 1 || lpsd[ptr] ) {
		    i = strlen(line);                                /* get length of remote printer (RP) name  */
		    if (write(fd, line, i) != i){		     /* tell RM to return status about RP */
	    fixpipe:
			fprintf(stderr, "Lost connection to %s\n", buf0->qdata[ptr][RMI]);
			i = s[ptr];
			for (i1=0; i1<MAX_QUEUES; i1++){
			    if (s[i1] == i){
				s[i1] = 0;
				lpsd[i1] = FALSE;
			    }
			}
			goto getspool;
		    }
		    if ( socket_alive[ptr] ) socket_alive[ptr]++; /* indicate written once */
		}
#ifdef DEBUG
		line[strlen(line)-1]='\0';
		printf ("using %s to read port #%d on socket %d for %s using %s I/O\n", 
			lpsd[ptr]?"lpsd":"lpd", ptr, s[ptr], line, 
			socket_alive[ptr]?"NON-Blocking":"Blocking");
#endif
		while ((i = read(fd, line, sizeof(line))) > 0){
		    myeot = FALSE;
#ifdef DEBUGIO
		    printf ("read port #%d, numchars=%d\n", ptr, i);
#endif
		    line[i] = '\0';                          /* terminate line */
#ifdef DEBUGIO
		    printf ("portLine: %s\n", line);
#endif
		    if ( lpsd[ptr] ) {
			char * j = strstr(line, "/eof/");
			if ( j ) {
			    *j = '\0';                     /* get rid of trailing /eof/ */
			    i = strlen(line);
#ifdef DEBUGIO		    
			    printf ("NEWportLine: %s\n", line);
#endif
			    myeot = TRUE;
			}
		    }
		    (void)memcpy(new_string, line, i);
		    new_string[i] = 0;                /* terminate the line */
		    printTo_status_page(new_string, ptr);
		    socket_alive[ptr] = FALSE;
		    if (myeot) goto getspool;
		}
		if ( i == 0 )
		    socket_alive[ptr] = FALSE;
		if ( i < 0 ) {
		    if (errno == EWOULDBLOCK) {
#ifdef DEBUGIO		
			fprintf(stderr, "******** EWOULDBLOCK on port #%d, socket #%d\n",
				ptr, s[ptr]);
#endif
			return(FALSE);               /* dont close if waiting for block to clear */
		    }
		    else
			fprintf(stderr,"Error #%d seen on socket #%d, i=%d\n", errno, ptr, i);
		}
		if (!lpsd[ptr]) 
		    (void) close(fd);               /* dont close if our own daemon */
	    }
	}
	/*
	 * Find all the control files in the spooling directory
	 */

    getspool:
	if (chdir(buf0->qdata[ptr][SDI]) < 0)
	    fatal("cannot chdir to spooling directory");
	if ((nitems = getq(&queue, ptr)) < 0)
	    fatal("cannot examine spooling area\n");
	if (stat(buf0->qdata[ptr][LOI], &statb) >= 0 && (statb.st_mode & 010)) {
	    if (sendtorem){
		(void) sprintf(new_string, "\n%s: ", host);
		printTo_status_page(new_string, ptr);
	    }
	    sprintf(new_string, "Warning: %s queue is turned off\n", printer);
	    printTo_status_page(new_string, ptr);
	}
	if (nitems == 0) {
	    if (!sendtorem){
		(void) sprintf(new_string,"no entries\n");
		printTo_status_page(new_string, ptr);
	    }
	    if ( strcmp(old_status_page[ptr], status_page[ptr]) !=0 ) {
		changed = TRUE;
		if ( verbose )
		    printf ("new string for buf%d:\n %s\n",
			    ptr, status_page[ptr]);
		buf0->mtime[ptr] = time(NULL);              /* buffer was modified at this time */
	    }
	    free(queue);
	    return(changed);
	}
	fp = fopen(buf0->qdata[ptr][LOI], "r");
	if (fp == NULL)
	    warn(ptr);
	else {
	    register char *cp;
	    
	    /* get daemon pid */
	    cp = current;
	    while ((*cp = getc(fp)) != EOF && *cp != '\n')
		cp++;
	    *cp = '\0';
	    i = atoi(current);
	    if (kill(i, 0) < 0)
		warn(ptr);
	    else {
		/* read current file name */
		cp = current;
		while ((*cp = getc(fp)) != EOF && *cp != '\n')
		    cp++;
		*cp = '\0';
		/*
		 * Print the status file.
		 */
		if (sendtorem){
		    (void) sprintf (new_string, "\n%s: ", host);
		    printTo_status_page(new_string, ptr);
		}
		fd = open(buf0->qdata[ptr][STI], O_RDONLY);
		if (fd >= 0) {
		    (void) flock(fd, LOCK_SH);
		    while ((i = read(fd, line, sizeof(line))) > 0)  {
			(void) memcpy(new_string, line, i);
			sprintf (new_string+i,"\0");               /* terminate the line */
			printTo_status_page(new_string,ptr);
			/*					(void) fwrite(line, 1, i, stdout);*/
		    }
		    (void) close(fd);	/* unlocks as well */
		} 
		else {
		    (void) sprintf(new_string, "\n");
		    printTo_status_page(new_string,ptr);
		}
	    }
	    (void) fclose(fp);
	}
	/*
	 * Now, examine the control files and print out the jobs to
	 * be done for each user.
	 */
	if (!lflag)
	    header(ptr);
	(void) time(&now_time);
	for (i = 0; i < nitems; i++) {
	    q = queue[i];
	    inform(q->q_name, ptr, q->q_time);
	    if (oldest < age) oldest = age;
	    free(q); 
	}
	free(queue);
	if (strcmp(old_status_page[ptr], status_page[ptr])!=0){
	    buf0->mtime[ptr] = time(NULL);              /* buffer was modified at this time */
	    changed=TRUE;
	}
	
	/* update the oldest file column */
	buf0->oldestJob[ptr] = oldest;
	return(changed);
    }



/*
 * Print a warning message if there is no daemon present.
 */
warn(ptr)
int   ptr;
{
	struct stat statb;

	if (sendtorem) {
		(void) sprintf(new_string, "\n%s: ", host);
		printTo_status_page(new_string, ptr);
	}
	if (stat(buf0->qdata[ptr][LOI], &statb) >= 0 && (statb.st_mode & 0100))
		(void) sprintf(new_string, "Warning: %s is down\n", printer);
	else
		(void) sprintf(new_string, "Warning: no daemon present\n");
	current[0] = '\0';
	printTo_status_page(new_string, ptr);
}

/*
 * Print the header for the short listing format
 */
static
header(ptr)
int  ptr;
{
	(void) sprintf(new_string, head0);
	printTo_status_page(new_string, ptr);
	col = strlen(head0)+1;
	blankfill(SIZCOL, ptr);
	(void) sprintf(new_string, head1);
	printTo_status_page(new_string, ptr);
}

static
inform(cf, ptr, ttime)
    char *cf;
    int  ptr;
    time_t ttime;
{
	register int j, k;
	register char *cp;
	FILE *cfp;
	char tmp_string[32];

	/*
	 * There's a chance the control file has gone away
	 * in the meantime; if this is the case just keep going
	 */
	if ((cfp = fopen(cf, "r")) == NULL){
	    (void) sprintf(new_string,"File open failed for %s: ", cf);
	    printTo_status_page(new_string,ptr);
	    return;
	}

	if (rank < 0)
		rank = 0;
	if (sendtorem || garbage || strcmp(cf, current))
		rank++;
	age = (now_time - ttime)/60;
	j = 0;
	while (getline(cfp)) {
		switch (line[0]) {
		case 'P':				    /* Was this file specified in the user's list? */
			if (!inlist(line+1, cf)) {
				fclose(cfp);
				printf("error, file name not in namelist\n");
				return;
			}
			if (lflag) {
				(void) sprintf(new_string,"\n%s: ", line+1);
				printTo_status_page(new_string, ptr);
				col = strlen(line+1) + 2;
				prank(rank, ptr);
				blankfill(JOBCOL, ptr);
				(void) sprintf(new_string," [job %s]\n", cf+3);
				printTo_status_page(new_string, ptr);
			} else {
				col = 0;
				prank(rank, ptr);
				blankfill(OWNCOL, ptr);
				(void) sprintf(new_string,"%-10s %-3d  ", line+1, atoi(cf+3));
				printTo_status_page(new_string, ptr);
				col += 16;
				first = 1;
			}
			continue;
		default: /* some format specifer and file name? */
			if (line[0] < 'a' || line[0] > 'z')
				continue;
			if (j == 0 || strcmp(file, line+1) != 0)
				strcpy(file, line+1);
			j++;
			continue;
		case 'N':
			show(line+1, file, j, ptr);
			file[0] = '\0';
			j = 0;
		}
	}
	fclose(cfp);
	if (!lflag) {
		blankfill(SIZCOL, ptr);
		(void) sprintf(new_string,"%D bytes", totsize);
		(void) sprintf(tmp_string,"%D bytes", totsize);
		printTo_status_page(new_string, ptr);
		col += strlen(tmp_string);
		totsize = 0;
	}
	blankfill(AGECOL, ptr);
	(void) sprintf(new_string, "%d min\n", age);
	printTo_status_page(new_string, ptr);
}

static
inlist(name, file)
	char *name, *file;
{
	register int *r, n;
	register char **u, *cp;

	if (users == 0 && requests == 0)
		return(1);
	/*
	 * Check to see if it's in the user list
	 */
	for (u = user; u < &user[users]; u++)
		if (!strcmp(*u, name))
			return(1);
	/*
	 * Check the request list
	 */
	for (n = 0, cp = file+3; isdigit(*cp); )
		n = n * 10 + (*cp++ - '0');
	for (r = requ; r < &requ[requests]; r++)
		if (*r == n && !strcmp(cp, from))
			return(1);
	return(0);
}

static
show(nfile, file, copies, ptr)
    register char *nfile, *file;
    int      ptr;
{
	if (strcmp(nfile, " ") == 0)
		nfile = "(standard input)";
	if (lflag)
		ldump(nfile, file, copies, ptr);
	else
		dump(nfile, file, copies, ptr);
}

/*
 * Fill the line with blanks to the specified column
 */
static
blankfill(n, ptr)
    register int n;
    int ptr;
{
	while (col++ < n){
		(void) sprintf(new_string," ");
		printTo_status_page(new_string, ptr);
	}
}

/*
 * Give the abbreviated dump of the file names
 */
static
dump(nfile, file, copies, ptr)
    char *nfile, *file;
    int ptr;
{
	register short n, fill;
	struct stat lbuf;

	/*
	 * Print as many files as will fit
	 *  (leaving room for the total size)
	 */
	 fill = first ? 0 : 2;	/* fill space for ``, '' */
	 if (((n = strlen(nfile)) + col + fill) >= SIZCOL-4) {
		if (col < SIZCOL) {
			(void) sprintf(new_string," ..."), col += 4;
			printTo_status_page(new_string, ptr);
			blankfill(SIZCOL, ptr);
		}
	} else {
		if (first)
			first = 0;
		else{
			(void) sprintf(new_string,", ");
			printTo_status_page(new_string, ptr);
		    }
		(void) sprintf(new_string,"%s", nfile);
		printTo_status_page(new_string, ptr);
		col += n+fill;
	}
	if (*file && !stat(file, &lbuf))
		totsize += copies * lbuf.st_size;
}

/*
 * Print the long info about the file
 */
static
ldump(nfile, file, copies, ptr)
    char *nfile, *file;
    int  ptr;
{
	struct stat lbuf;

	(void) sprintf(new_string, "\t");
	printTo_status_page(new_string, ptr);
	if (copies > 1)
		(void) sprintf(new_string,"%-2d copies of %-19s", copies, nfile);
	else
		(void) sprintf(new_string,"%-32s", nfile);
	printTo_status_page(new_string,ptr);
	if (*file && !stat(file, &lbuf))
		(void) sprintf(new_string," %D bytes", lbuf.st_size);
	else
		(void) sprintf(new_string," ??? bytes");
	printTo_status_page(new_string, ptr);
	(void) sprintf(new_string, "\n");
	printTo_status_page(new_string, ptr);
}

/*
 * Print the job's rank in the queue,
 *   update col for screen management
 */
static
prank(n, ptr)
    int ptr;
{
	char line[100];
	static char *r[] = {
		"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"
	};

	if (n == 0) {
		(void) sprintf(new_string,"active");
		printTo_status_page(new_string, ptr);
		col += 6;
		return;
	}
	if ((n/10) == 1)
		(void)  sprintf(line, "%dth", n);
	else
		(void) sprintf(line, "%d%s", n, r[n%10]);
	col += strlen(line);
	(void) sprintf(new_string,"%s", line);
	printTo_status_page(new_string, ptr);
}


void printTo_status_page(string, ptr)
char *string;
int  ptr;
{
    int string_size;
    unsigned new_size;

    string_size = strlen(string);
    totchar = strlen(status_page[ptr]);
    if (totchar+string_size > status_page_size[ptr]){
	if (more_set)
	    return;
	if (totchar + strlen("***MORE***") < status_page_size[ptr] && !more_set) {
	    sprintf(string, "***MORE***");
	    more_set = TRUE;
	}
	else {
	    fprintf(stderr, "Warning - buffer #%d too small to hold all entries\n", ptr);
	    return;
	}
    }
    (void) sprintf(status_page[ptr]+totchar, "%s", string);
    totchar = strlen(status_page[ptr]);
    if (totchar > status_page_size[ptr])
	fprintf(stderr,
		"ERROR - Status page overflow\n"), exit(-1);
}
pipelost(sig, code, scp)
int sig, code;
struct sigcontext *scp;
{
    extern char *sys_siglist[];
    fprintf(stderr,"Signal: %s, PC + %#x\n", sys_siglist[sig], scp->sc_pc);
    sigpipe=TRUE;
    (void)longjmp(broken_pipe, 0);
    return;
}  
