#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>

#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

extern char **environ;
extern void printenv();
extern int openset();

struct sembuf setflag;
struct sembuf clrflag;
int sid, sid_control, sid_readReady, sid_writeLock, sid_clientActive;
int   clientNum;
char   *progname;
key_t key;
int   pid;
int   status = 0;

main (argc, argv)
char *argv[];
int argc;
{ 
    extern int errno;
    char **eptr;
    int i;
    int oldval;
    int retval;
    Bool retry = TRUE;

    signal(SIGUSR1, SIG_IGN);				    /* ignore further signals */
    progname = argv[0];
    pid = getpid();

    key = getkey();
    printf ("in %s key = %d, pid = %d\n", argv[0], key, pid);

/* now attempt to open a semaphore set. */
         
    if ((sid_control=openset(key))==-1){                  
	printf ("in %s openset of control set failed\nServer is probably not running... Try running starter instead\n", argv[0]);		  
	exit(-1);
    }
    if ((sid_readReady=openset(key+1))==-1){                  
	printf ("in %s openset of readReady set failed\n", argv[0]);		  
	exit(-1);
    }
    if ((sid_writeLock=openset(key+2))==-1){                  
	printf ("in %s openset of writeLock set failed\n", argv[0]);		  
	exit(-1);
    }
    if ((sid_clientActive=openset(key+3))==-1){                  
	printf ("in %s openset of clientActive set failed\n", argv[0]);		  
	exit(-1);
    }
    printf ("in %s openset succeeded, sid_control = %d\n", argv[0], sid_control);
/*
  Check flag 0 of the control set to make sure server is alive.
*/
    if (semgetval(sid_control, 0) != 1)
	syserr("Startup of new client failed... Server not responding", NULL, NULL);
/*
  now register this client with the server.
*/
    signOn(argv);

    do_windows(argc, argv);
}

int signOn(argv)
char *argv[];
{
    struct mymsg {
	long mtype;
	char c_clientNum[12];
    } msg;
    int retval;
    int qid;
    setflag.sem_num = 1;
    setflag.sem_op = 1;
    setflag.sem_flg = SEM_UNDO;

/*
  Increment flag #1 so server can keep count of active clients.
*/
    if ((status = semop(sid_control, &setflag, 1))==-1)
	syserr("semop in client", NULL, sid_control);
    printf ("in %s after semop status = %d\n", argv[0], status);
/*
  Open a msgque and tell the server we are here.  Server
  will respond with our client number.
*/
    if ((qid = msgget((key_t)key, 0644)) == -1)		    /* open message queue */
	syserr("msgget in client", NULL, NULL);
    sprintf(msg.c_clientNum, "%d", pid);
    msg.mtype = 1;		                            /* mtype must be non zero */
    printf("in client sending notice to server\n");
    if ((retval = msgsnd(qid, &msg, sizeof(msg), (int)NULL)) == -1) /* send msg to server */
	syserr ("msgsnd in client", NULL, NULL);
    printf("in client waiting for msgrcv from server\n");
    if ((retval = msgrcv(qid, &msg, sizeof(msg), (long)pid, 0)) == -1)	/* rcv msg from server */
	syserr ("msgrcv in client", NULL, NULL);
    printf("in client received msg, mtype=%d, msg=%s\n",
	   msg.mtype, msg.c_clientNum);
    clientNum = atoi(msg.c_clientNum);			    /* get our clientNum from servers responding msg */
    printf ("In %s clientNum = %d\n", argv[0], clientNum);
    if (clientNum == -1)				    /* too many clients? */
	syserr("Max number of clients exceeded", NULL, NULL);
    setflag.sem_num = clientNum;
    if ((status = semop(sid_clientActive, &setflag, 1))==-1) /* set our clientAlive flag */
	syserr("semop of clientActive set in client", NULL, sid);
/*
  lastly, make sure that some timing glitch didnt cause two clients to be assigned
  the same clientNum. This would be seen as a clientNum flag with a value >1.
*/
    if ((semctl(sid_clientActive, clientNum, GETVAL, 0)) != 1) /* get value of clientNum flag of clientActive set */
	syserr("More than one client assigned same clientNum", NULL, NULL);
}
