#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#ifndef ENOENT
#include <errno.h>
#endif

#ifndef NULL
#define NULL 0
#endif

extern char **environ;
extern void printenv();
extern int openset();

int    shit[NUMQUEUES+2];
int    sid;

main (argc, argv)
int argc;
char *argv[];
{ 
    extern int errno;
    long key;
    char **eptr;
    int i;
    int sem_num, retval;
    union semun {
	int val;
	struct semid_ds *stat;
	ushort *array;
    } ctl_arg;

    key=getkey();
    printf ("key = %d\n", key);

/* now attempt to open a semaphore set. If open succeeds, then server is/has been alive, otherwise server
   is not running and we need to start it.
*/
    if (openset(key)==-1){			  /* wont return from openset if failure is... */
	printf ("in %s openset failed\n", argv[0]);		  /* anything other than "no such queue". */
	switch (fork()){
	case -1:
	    syserr("fork", NULL, sid);
	case 0:
	    execlp("./server","server",NULL);	  /* start up a new server */
	    syserr("execlp of server in starter", NULL, NULL);			  /* fatal error if execlp returns */
	}
    }
/*
  openset succeeded, either outright, or by exec'ing the server.
  That means that the server has already opened a semaphore set. Now check set 0 
  semaphore 0 to make sure that the server is really alive.  if it is, 
  exec a new client.  If it is not, then exec a new server.
*/
    sleep(1);
    if (openset(key)==-1)
	syserr("opening semset in starter", NULL, NULL);
    printf ("in %s openset succeeded, sid = %d\n",argv[0], sid);
    if ((retval = semctl(sid, 0, GETVAL, ctl_arg)) == -1)
	syserr("semctl in starter", NULL, sid);
    printf ("in %s after semctl retval = %d\n", argv[0], retval);
    if (retval != 1){		                  /* if retval not equal to 1 then... */
	switch (fork()){			  /* server must have died... */
	case -1:				  /* fork another process... */
	    syserr("fork", NULL, sid);
	case 0:					  /* to exec another server with. */
	    execlp("./server","server",NULL);	  /* start up a new server */
	    syserr("execlp of server in starter", NULL, NULL);			  /* fatal error if execlp returns */
	}
	sleep(1);
	if (openset(key)==-1)			  /* try opening the semaphore set now */
	    syserr("opening semset in starter", NULL, NULL);
	printf ("in %s openset succeeded, sid = %d\n",argv[0], sid);
	if ((retval = semctl(sid, 0, GETVAL, ctl_arg)) == -1) /* recheck retval. If we cant get value... */
	    syserr("semctl in starter", NULL, sid); /* fatal error */
    }
    printf ("in %s after semctl retval = %d\n", argv[0], retval);
    if (retval != 1)				  /* recheck retval. If still not equal to 1... */
	syserr("wrong value for semaphore #0 in starter", NULL, NULL); /* fatal error, else... */
    execlp("./client", "client",NULL);		  /* exec new client. */
    syserr("execlp of client in starter", NULL, sid); /* fatal error if return from execlp. */
    exit(0);					  /* NOTREACHED */
}

