
#include "../lp.h"
#include "../lps.h"
/*
 *  So that we can use fprintf:
 */
#include <stdio.h>
#include <signal.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ERR ((struct databuf *) -1)
#define MAX_READERS 12
#define MAX_BUFFERS NUMQUEUES+2

/* 
 * Standard Toolkit include files:
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Shell.h>
#include <time.h>

extern char **environ;
extern void printenv();
extern int openset();
extern int clientNum;
extern long key;
extern int sid, sid_control, sid_readReady, sid_writeLock, sid_clientActive;
extern int  clientNum;
extern int pid;
extern int signOn();

char   status_page[64];
int    status_page_size[32];
Widget       new_text[32];
Widget       fileName[32];
Widget       new_window[32], controlSet[3], readReadySet[MAX_READERS];
Widget       writeLockSet[MAX_BUFFERS], clientActiveSet[MAX_READERS];
Widget       new_outer[32], lastWidget;
Widget       Qquit[32];
Widget       topLevel, form;
Widget       warning, noServer;
Display *display;
XtAppContext app_context;
XtAppContext formApp[16];
int          context_count=0;
XtIntervalId intervalID[32];
XtIntervalId quitSoon, DoAgainintervalID;
int          slot[32][4];
Dimension    width=220, height=100;
int          interval = 1;
Bool         miss = FALSE;
Bool         warningVisible = FALSE;
char         *myargv;
struct databuf {
    time_t mtime;
    char buf[1024];
}*buffer[4];

time_t mtime[4];
char *asctime();
struct tm *localtime();

struct sembuf setflag;
struct sembuf clrflag;
int sid, sid_control, sid_readReady, sid_writeLock, sid_clientActive;
int  clientNum;
long key;
int pid;
int status = 0;
int control[3], readReady[MAX_READERS], writeLock[MAX_BUFFERS], clientActive[MAX_READERS];
void quit(w, client_data, call_data)
Widget w;
XtPointer client_data; 
XtPointer call_data;
{
    exit(0);
}
static XtTimerCallbackProc mainLoop(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    int i, n, rdy;
    char  newLabel[5];
    Bool changed;

    changed = FALSE;
    for (i=0; i<3; i++){
	if ((n = semgetval(sid_control, i))<0)                  /* make sure server is alive */
	    syserr("semgetval in showSemaphores", NULL, NULL);
	if (n != control[i]){
	    sprintf(newLabel, "%d", n);
	    XtVaSetValues(controlSet[i],
			  XtNlabel, newLabel,
			  NULL);
	    control[i] = n;
	    changed=TRUE;
	}
    }
    for (i=0; i<MAX_READERS; i++){
	if ((n = semgetval(sid_readReady, i))<0)                  /* make sure server is alive */
	    syserr("semgetval in showSemaphores", NULL, NULL);
	if (n != readReady[i]){
	    sprintf(newLabel, "%d", n);
	    XtVaSetValues(readReadySet[i],
			  XtNlabel, newLabel,
			  NULL);
	    changed=TRUE;
	    readReady[i] = n;
	}
	if ((n = semgetval(sid_clientActive, i))<0)                  /* make sure server is Active */
	    syserr("semgetval in showSemaphores", NULL, NULL);
	if (n != clientActive[i]){
	    sprintf(newLabel, "%d", n);
	    XtVaSetValues(clientActiveSet[i],
			  XtNlabel, newLabel,
			  NULL);
	    changed=TRUE;
	    clientActive[i] = n;
	}
    }
    for (i=0; i<MAX_BUFFERS; i++){
	if ((n = semgetval(sid_writeLock, i))<0)                  /* make sure server is Active */
	    syserr("semgetval in showSemaphores", NULL, NULL);
	if (n != writeLock[i]){
	    sprintf(newLabel, "%d", n);
	    XtVaSetValues(writeLockSet[i],
			  XtNlabel, newLabel,
			  NULL);
	    changed=TRUE;
	    writeLock[i] = n;
	}
    }
    if (changed)
	interval = 250;		                            /* reset interval to 1/4 sec if changed */
    else
	interval = 100;

    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) interval, mainLoop, (caddr_t) 0);
}

do_windows(argc, argv)
int argc;
char *argv[];
{
    extern int errno;
    int shmid[4], i, pid;
    XWindowAttributes window_attributes;
    Position new_x, new_y;
    char  geometry_string[16], warning_geometry[16];
    char  iconname[64];
    int screen;
    Window root;
    Widget top;
    int status;
    Cursor cursor;
    XEvent event;
    int button = 0;
    char newstring[1024];

    myargv = *argv;
    display = XOpenDisplay(NULL);                           /* open display, connect to server */
    screen = DefaultScreen(display);
    XSynchronize(display, TRUE);			    /* turn on synchronization */
    root = RootWindow(display, screen);			    /* get id of root */
    cursor = XCreateFontCursor (display, XC_crosshair);	    /* create another cursor shape */
    status = XGrabPointer (display, root, FALSE,	    /* Grab pointer with new cursor, allow ptr to roam all over */
			   ButtonPressMask|ButtonReleaseMask, GrabModeSync,
			   GrabModeAsync, root, cursor, CurrentTime);
    if (status != GrabSuccess) printf("FATAL, cant grab mouse\n"), exit();
    printf ("Place cursor to where you want the upper-left-hand corner of the new window to go\n\
and press left mouse\n");
    for (;;){
	XAllowEvents(display, SyncPointer, CurrentTime);    /* pop an event from the event queue */
	XWindowEvent(display, root, ButtonPressMask|ButtonReleaseMask, &event);	/* copy it to our structure */

	switch (event.type){				    /* process it if... */
	case ButtonPress:				    /* it was a button press. ignore all other events */
	    printf ("ButtonPress #%d found. x = %d, y = %d\n", 
		    event.xbutton.button, event.xbutton.x_root, event.xbutton.y_root);
	    button = event.xbutton.button;
	    while (1){					    /* wait for button release of same button */
		XAllowEvents(display, SyncPointer, CurrentTime);
		XWindowEvent(display, root, ButtonPressMask|ButtonReleaseMask, &event);
		if (event.xbutton.button == button){
		    XUngrabPointer(display, CurrentTime);   /* let go of pointer */
		    XSynchronize(display, FALSE);	    /* turn off synchronization */
		    break;				    /* break out of while(1) */
		}
	    }
	    break;					    /* break out of switch */
	}
	break;						    /* break out of for(;;) */
    }
    printf ("ButtonRelease #%d found. x = %d, y = %d\n", 
	    event.xbutton.button, event.xbutton.x_root, event.xbutton.y_root);
    XCloseDisplay(display);				    /* disconnect from server */

    sprintf(geometry_string,"+%d+%d", event.xbutton.x_root, event.xbutton.y_root);
    sprintf(iconname, "showSemaphores");
    topLevel = XtVaAppInitialize(
				 &app_context,       /* Application context */
				 "LpsV1",            /* application class name */
				 NULL, 
				 NULL,            /* command line option list */
				 &argc, argv,        /* command line args */
				 NULL,               /* for missing app-defaults file */
				 XtNx,  (Position) 1,
				 XtNy,  (Position) 2,
				 XtNgeometry, geometry_string,
				 XtNiconName,  iconname,
				 NULL);              /* terminate varargs list */

    form = XtVaCreateManagedWidget(
		"form", 	/* widget name */
		formWidgetClass,	/* widget class */
		topLevel,	/* parent widget*/
		XtNborderWidth,     (Dimension) 1,
		NULL);	/* argument list*/

    fileName[0] = XtVaCreateManagedWidget("NoServer",
					  labelWidgetClass,
					  form,
					  XtNwidth, 150,
					  XtNlabel, "sid_control",
					  XtNjustify, XtJustifyCenter,
					  NULL);
    lastWidget = fileName[0];
    for (i=0; i<3; i++){
	controlSet[i] = XtVaCreateManagedWidget("NoServer",
						labelWidgetClass,
						form,
						XtNlabel, "99",
						XtNjustify, XtJustifyCenter,
						XtNfromHoriz, lastWidget,
						NULL);
	control[i] = 99;
	lastWidget = controlSet[i];
    }
    fileName[1] = XtVaCreateManagedWidget("NoServer",
					  labelWidgetClass,
					  form,
					  XtNlabel, "sid_readReady",
					  XtNwidth, 150,
					  XtNfromVert,  fileName[0],
					  XtNjustify, XtJustifyCenter,
					  NULL);
    lastWidget = fileName[1];

    for (i=0; i<MAX_READERS; i++){
	readReadySet[i] = XtVaCreateManagedWidget("NoServer",
					  labelWidgetClass,
					  form,
					  XtNlabel, "99",
					  XtNfromVert,  fileName[0],
					  XtNfromHoriz, lastWidget,
					  XtNjustify, XtJustifyCenter,
					  NULL);
	readReady[i] = 99;
	lastWidget = readReadySet[i];
    }
    fileName[2] = XtVaCreateManagedWidget("NoServer",
					  labelWidgetClass,
					  form,
					  XtNlabel, "sid_writeLock",
					  XtNwidth, 150,
					  XtNfromVert,  fileName[1],
					  XtNjustify, XtJustifyCenter,
					  NULL);
    lastWidget = fileName[2];
    for (i=0; i<MAX_BUFFERS; i++){
	writeLockSet[i] = XtVaCreateManagedWidget("NoServer",
					  labelWidgetClass,
					  form,
					  XtNlabel, "99",
					  XtNfromVert,  fileName[1],
					  XtNfromHoriz, lastWidget,
					  XtNjustify, XtJustifyCenter,
					  NULL);
	writeLock[i] = 99;
	lastWidget = writeLockSet[i];
    }
    fileName[3] = XtVaCreateManagedWidget("NoServer",
					  labelWidgetClass,
					  form,
					  XtNlabel, "sid_clientActive",
					  XtNwidth, 150,
					  XtNfromVert,  fileName[2],
					  XtNjustify, XtJustifyCenter,
					  NULL);
    lastWidget = fileName[3];
    for (i=0; i<MAX_READERS; i++){
	clientActiveSet[i] = XtVaCreateManagedWidget("NoServer",
					  labelWidgetClass,
					  form,
					  XtNlabel, "99",
					  XtNfromVert,  fileName[2],
					  XtNfromHoriz, lastWidget,
					  XtNjustify, XtJustifyCenter,
					  NULL);
	clientActive[i] = 99;
	lastWidget = clientActiveSet[i];
    }

    Qquit[0] = XtVaCreateManagedWidget("Quit", 
				       commandWidgetClass,
				       form,	/* parent */
				       XtNlabel,  "Quit",
				       XtNfromVert, lastWidget,
				       XtNallowResize, TRUE,
				       NULL);

    XtAddCallback(Qquit[0], XtNcallback, quit, 0);
    XtRealizeWidget(topLevel);
    XFlush(XtDisplay(topLevel));

    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (500), mainLoop, (caddr_t) NULL);
    XtAppMainLoop(app_context);
}

main (argc, argv)
char *argv[];
int argc;
{ 
    extern int errno;
    char **eptr;
    int i;
    int oldval;
    int retval;
    Bool retry = TRUE;

    signal(SIGALRM, SIG_IGN);				    /* ignore further signals */
    setflag.sem_num = 1;
    setflag.sem_op = 1;
    setflag.sem_flg = SEM_UNDO;

    pid = getpid();

    key=getkey();
    printf ("in %s key = %d, pid = %d\n", argv[0], key, pid);

/* now attempt to open a semaphore set. */
         
    if ((sid_control=openset(key))==-1){                  
	printf ("in %s openset of control set failed\n", argv[0]);		  
	exit(-1);
    }
    if ((sid_readReady=openset(key+1))==-1){                  
	printf ("in %s openset of readReady set failed\n", argv[0]);		  
	exit(-1);
    }
    if ((sid_writeLock=openset(key+2))==-1){                  
	printf ("in %s openset of writeLock set failed\n", argv[0]);		  
	exit(-1);
    }
    if ((sid_clientActive=openset(key+3))==-1){                  
	printf ("in %s openset of clientActive set failed\n", argv[0]);		  
	exit(-1);
    }
    printf ("in %s openset succeeded, sid_control = %d\n", argv[0], sid_control);
/*
  Check flag 0 of the control set to make sure server is alive.
*/
    if (semgetval(sid_control, 0) != 1)
	syserr("Startup of new showSemaphores failed... Server not responding", NULL, NULL);

    do_windows(argc, argv);
}


