#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <time.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ERR ((struct databuf *) -1)

extern char **environ;

struct databuf {
    time_t mtime;
    char buf[1024];
};

time_t mtime[4];
int    sid;

main (argc, argv)
int argc;
char *argv[];
{
    extern int errno;
    long key;
    int shmid[4], i, pid;
    struct databuf *buffer[4];

    pid = getpid();

    key=getkey();
    printf ("in %s key = %d, pid = %d\n", argv[0], key, pid);

    for (i=0; i<4; i++){
	if ((shmid[i] = shmget(key+i, sizeof(struct databuf), 0644)) <0)
	    syserr("shmget in shmem",NULL,NULL);

	printf ("in %s shmid%d = %d\n", argv[0], i, shmid[i]);
	if ((buffer[i] = (struct databuf *) shmat(shmid[i], 0, 0)) == ERR)
	    syserr("shmat in shmem", NULL, NULL);
	mtime[i] = buffer[i]->mtime;
	printf ("shmem region #%d = %s\n", i, buffer[i]->buf);
    }
    for (;;){
	for (i=0; i<4; i++){
	    if (mtime[i] != buffer[i]->mtime){
		printf ("in shmrd region #%d changed.\n new string = %s\n", i, buffer[i]->buf);
		mtime[i] = buffer[i]->mtime;
	    }
	}
	sleep(1);
    }
}
