#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <time.h>
#include <fcntl.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif
#ifndef Bool
typedef ushort Bool;
#endif
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define ERR ((struct databuf *) -1)

extern char **environ;

struct databuf {
    time_t mtime;
    char buf[1024];
};
int    sid;

main (argc, argv)
int argc;
char *argv[];
{
    extern int errno;
    long   key;
    int    shmid[4], i, n, pid;
    struct databuf *buffer[4];
    int    fd[4];
    struct stat sb;
    char   path[12];
    char *asctime();
    struct tm *localtime();

    pid = getpid();

    key=getkey();
    printf ("in %s key = %d, pid = %d\n", argv[0], key, pid);

    for (i=0; i<4; i++){
	if ((shmid[i] = shmget(key+i, sizeof(struct databuf), 0644|IPC_CREAT)) <0)
	    syserr("shmget1 in shmem",NULL,NULL);

	printf ("in %s shmid%d = %d\n", argv[0], i, shmid[i]);
	if ((buffer[i] = (struct databuf *) shmat(shmid[i], 0, 0)) == ERR)
	    syserr("shmat in shmem", NULL, NULL);
	sprintf(path, "./test%d", i+1);
	if ((fd[i] = open(path, O_RDONLY)) == -1)
	    syserr("open in shmem", NULL, NULL);
	if ((n=read(fd[i],buffer[i]->buf,sizeof(buffer[i]->buf)))<=0)
	    syserr("read in shmem", NULL, NULL);
	printf ("in %s read %d characters from %s on fd %d\n", argv[0], n, path, fd[i]);
	buffer[i]->buf[n]=NULL;
	if (stat(path, &sb) == -1)
	    syserr("stat in shmem", NULL, NULL);
	buffer[i]->mtime = sb.st_mtime;
	close(fd[i]);
/*	sprintf(buffer[i]->buf, "in buffer%d now is the time", i);*/

/*	shmdt(buffer[i]);*/
    }
    for (;;){
	for (i=0; i<4; i++){
	    sprintf(path, "./test%d", i+1);
	    if (stat(path, &sb) == -1)
		syserr("stat in shmem", NULL, NULL);
	    if (buffer[i]->mtime != sb.st_mtime){
/*		printf ("in shmem, stats have changed\n");
		printf ("Last Access:          %s", asctime(localtime(&sb.st_atime)));
		printf ("Last Modification:    %s", asctime(localtime(&sb.st_mtime)));
		printf ("Last Status Change:   %s", asctime(localtime(&sb.st_ctime)));*/
		if ((fd[i] = open(path, O_RDONLY)) == -1)
		    syserr("open in shmem", NULL, NULL);
		if ((n=read(fd[i], buffer[i]->buf, sizeof(buffer[i]->buf)))<=0){
		    if (errno == EINTR){
			close(fd[i]);
			continue;
		    }
		    else
			syserr("read in shmem", NULL, NULL);
		}
		buffer[i]->buf[n]=NULL;
		printf ("in %s read %d characters from %s on fd %d\n", argv[0], n, path, fd[i]);
		buffer[i]->mtime = sb.st_mtime;
		close(fd[i]);
	    }
	}
	sleep(1);
    }
}
