#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif

int sid;

main()
{
    long key;
    char **eptr;
    int i;
    int qid;

    key=getkey();
    printf ("key = %d\n", key);

/* now attempt to open a msg que. */

    if ((qid=openque(key))==-1){			  /* wont return from openque if failure is... */
	printf ("openque failed\n");		  /* anything other than "no such queue". */
	exit(-1);
    }
    printf ("openque succeeded, qid = %d\n", qid);
    rmqueue(qid);
}

static int openque(key)
long key;
{
    int qid;

    if ((qid = msgget(key, IPC_NOWAIT)) == -1 && errno != ENOENT){
	syserr("msgget",NULL);
	return(-1);
    }
    return(qid);
}
