#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#ifndef ENOENT
#include <errno.h>
#endif
#ifndef NULL
#define NULL 0
#endif

extern void rmqueue();
extern void rmsem();
extern int sid;

void syserr(msg, qid, sid)
char *msg;
int qid;
{
    extern int errno, sys_nerr;
    extern char *sys_errlist[];

    fprintf(stderr, "ERROR: %s (errno=%d", msg, errno);
    if (errno > 0 && errno < sys_nerr)
	fprintf(stderr, "; %s)\n", sys_errlist[errno]);
    else
	fprintf(stderr, ")\n");
    if (qid) rmqueue(qid);
    if (sid) rmsem(sid);
    exit(-1);
}

void printenv()
{
    extern char **environ;
    int i;
    for (i=0; environ[i] != NULL; i++)
	printf ("%s\n", environ[i]);
    return;
}
void rmqueue(qid)
long qid;
{
    if ((msgctl(qid, IPC_RMID, NULL)) == -1)
	syserr("rmqueue",NULL, NULL);
}
void rmsem(sid)
long sid;
{
    if ((semctl(sid, 0, IPC_RMID, 1)) == -1)
	syserr("rmsem in misc.c",NULL, NULL);
}




