/*
 * Author: Roger Smith
 *	   NASA - Ames Research Center
 *	   rsmith@george.arc.nasa.gov
 *
 *
 *      This is the file lps.h for the lps, a Berkeley line printer spooler
 *      status reporting utility.
 *      built upon Xlib and the XToolkit.
 *      It Contains: Lots of good defintions.
 *
 *	$Header: /d/convex/rsmith/src/lps/lps.h, v 1.0 90/13/09 20:34:28 rsmith$
 *
 */

/* Std system and C include files */

#include <stdio.h>
#include <X11/Xos.h>
#include <sys/dir.h>

/* X include files */

#include <X11/X.h>
#include <X11/Xatom.h>
#include <X11/StringDefs.h>

/* X toolkit Include files */

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>

/*
 * Public include files for widgets used in this file.
 */
#ifdef X11R3
#include <X11/Box.h>
#include <X11/Form.h>
#include <X11/VPaned.h>
#include <X11/Command.h>
#include <X11/Scroll.h>
#else /* R4 or later */
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>      /* now V or H paned */
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Scroll.h>
#include <X11/Xaw/Dialog.h>
#endif /* X11R3 */

#ifdef ATHENA
#  include <X11/AsciiText.h>
#  include <X11/Text.h>
#  include <X11/Command.h>
#  include <X11/Viewport.h>
#  include <X11/Box.h>
#  include <X11/Label.h>
#  include <X11/Paned.h>
#  include <X11/Form.h>
#else
#include <X11/Xaw/AsciiSrc.h>
#include <X11/Xaw/AsciiText.h>
#  include <X11/Xaw/Text.h>
#  include <X11/Xaw/Command.h>
#  include <X11/Xaw/Viewport.h>
#  include <X11/Xaw/Box.h>
#  include <X11/Xaw/Label.h>
#  include <X11/Xaw/Paned.h>
#  include <X11/Xaw/Form.h>
#endif

/* Usefull defines */

#define MEMBUF		512000
#define TEXTWIDTH       500
#define TEXTHEIGHT      500
#define BOXWIDTH        500
#define BOXHEIGHT       50
#define BUTTONWIDTH     100
#define BUTTONHEIGHT    18
#define DIALOGWIDTH     350
#define DIALOGHEIGHT    150
#define MAX_INPUT	256
#define DEF_INPUT_W	200
#define INPUT_HEIGHT	6
#define SCREENSAVERINTERVAL 60000 /* one minute */
#define X 1
#define Y 2
#define STAT 0
#define NUM 3
#define AVAIL 1
#define NOTAVAIL 0
#define ON TRUE
#define OFF FALSE
#ifndef HELPFILE
#define HELPFILE "/usr/lib/X11/Lps.help"
#endif

struct oldval {
    Bool       isrealized;
    Bool       isPopedUp;
    Bool       resized;
    Dimension  old_width;
    Dimension  old_height;
};

struct popupIds {
    Widget     outerShell;
    Widget     box;
    Widget     title;
    Widget     fileName;
    Widget     textArea;
};

struct  LogWindows{
    Widget   topId;
    Position x;
    Position y;
    Widget   paneId;
    Widget   labelId;
    Widget   textId;
    char     name[16];		/* device name */
    Bool     isVisible;		/* is window visible? */
    char     logFile[32];	/* name of log file for this device */
    Bool     oldLines;		/* flag to indicate window was written to during init phase */
    int      numLines;		/* flag showing total # of lines processed, used to determine if window is full */
    int      numchars;		/* total # of chars currently contained in this buffer */
    XawTextPosition left, right;	/* start and end position of text to hightlight */
} ;

#define LOG1 "/usr/adm/prtlogs/cevent_cpflps1.log"
#define LOG2 "/usr/adm/prtlogs/cevent_cpflps2.log"
#define LOG3 "/usr/adm/prtlogs/cpflp.log"
#define LOG4 ""
#define LOG5 ""
#define LOG6 ""
#define PRINTER1 "cpflps1"
#define PRINTER2 "cpflps2"
#define PRINTER3 "/dev/lp0"
#define PRINTER4 ""
#define PRINTER5 ""
#define PRINTER6 ""
#define NUM_PRNTRS 6

/* data structure for custom application resources */
typedef struct {
    int interval;
    int count;
    char *helpFile;
}AppData, *AppDataPtr;
