/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n";
#endif /* not lint */

/*  
  8-28-90   R. Smith     Original draft
*/

#ifndef lint
static char sccsid[] = "@(#)lpmv.c	1.0 (NASA-Ames) 8-28-90";
#endif /* not lint */

/*
 * lpmv - move a print job from one queue to another
 *
 * lpmv source-que destination-que [-] [[job #] [user] ...]
 *
 * Using information in the source lock file, lpmv will kill the
 * currently active daemon (if necessary), move the associated files to the new que,
 * startup a new daemon for the source que (if necessary), and startup a new
 * daemon for the destination queue.  Priviledged users may move anyone's spool
 * entries, otherwise one can only move their own.
 */

#include "lp.h"

/*
 * Stuff for handling job specifications
 */
char	*user[MAXUSERS];	/* users to process */
int	users;			/* # of users in user array */
int	requ[MAXREQUESTS];	/* job number of spool entries */
int	requests;		/* # of spool requests */
char	*person;		/* name of person doing lpmv */
char    *source;		/* source queue */
char    *dest;			/* destination queue */

static char	luser[16];	/* buffer for person */

char    *SDSOURCE;		/* source spool directory */
char    *LOSOURCE;		/* source lock file name */
char    *LPSOURCE;		/* source line printer device name */
char    *RPSOURCE;		/* source remote printer name */
char    *RMSOURCE;		/* source remote machine name */
char    *SDDEST;		/* destination spool directory */
char    *LODEST;		/* destination lock file name */
char    *LPDEST;		/* destination line printer device name */
char    *RPDEST;		/* destination remote printer name */
char    *RMDEST;		/* destination remote machine name */

struct passwd *getpwuid();

main(argc, argv)
	char *argv[];
{
	register char *arg;
	register int i;
	struct passwd *p;
	struct direct **files;
	int nitems, assasinated = 0;

	if ( argc < 2 ) usage();
	name = argv[0], argc--;
	if ((arg = *++argv)[0] != '-' && --argc != 0){
	    source = &arg[0];
	    if ((i = pgetent(line, source)) < 0)
	        fatal("cannot open printer description file");
	    else if (i == 0){
		printer = source;
		fatal("unknown source printer");
	    }
	    if ((SDSOURCE = pgetstr("sd", &bp)) == NULL)
		SDSOURCE = DEFSPOOL;
	    if ((LOSOURCE = pgetstr("lo", &bp)) == NULL)
		LOSOURCE = DEFLOCK;
	    if ((LPSOURCE = pgetstr("lp", &bp)) == NULL)
		LPSOURCE = DEFDEVLP;
	    if ((RPSOURCE = pgetstr("rp", &bp)) == NULL)
		RPSOURCE = DEFLP;
	    RMSOURCE = pgetstr("rm", &bp);
	}
	else
	    usage();
	if ((arg = *++argv)[0] != '-' && argc != 0){
	    dest = &arg[0];
	    if ((i = pgetent(line, dest)) < 0)
	        fatal("cannot open printer description file");
	    else if (i == 0){
		printer = dest;
	        fatal("unknown dest printer");
	    }
	    if ((SDDEST = pgetstr("sd", &bp)) == NULL)
		SDDEST = DEFSPOOL;
	    if ((LODEST = pgetstr("lo", &bp)) == NULL)
		LODEST = DEFLOCK;
	    if ((LPDEST = pgetstr("lp", &bp)) == NULL)
		LPDEST = DEFDEVLP;
	    if ((RPDEST = pgetstr("rp", &bp)) == NULL)
		RPDEST = DEFLP;
	    RMDEST = pgetstr("rm", &bp);
	}
	else
	    usage();

	gethostname(host, sizeof(host));
/*	openlog("lpd", 0, LOG_LPR); */
	if ((p = getpwuid(getuid())) == NULL)
		fatal("Who are you?");
	if (strlen(p->pw_name) >= sizeof(luser))
		fatal("Your name is too long");
	strcpy(luser, p->pw_name);
	person = luser;
	while (--argc) {
		if ((arg = *++argv)[0] == '-')
			switch (arg[1]) {
			case '\0':
				if (!users) {
					users = -1;
					break;
				}
			default:
				usage();
			}
		else {
			if (users < 0)
				usage();
			if (isdigit(arg[0])) {
				if (requests >= MAXREQUESTS)
					fatal("Too many requests");
				requ[requests++] = atoi(arg);
			} else {
				if (users >= MAXUSERS)
					fatal("Too many users");
				user[users++] = arg;
			}
		}
	}
	printer = source;
	if (printer == NULL && (printer = getenv("PRINTER")) == NULL)
		printer = DEFLP;

	mvjob();
}

static
usage()
{
	printf("usage: lpmv source-que target-que [-] [[job #] [user] ...]\n");
	exit(2);
}
