/* 
   printcapwin.c
   Roger Smith
   NASA-Ames Research Center
   First Written: December 1990

   Program to display all of the data in the printcap file in tabular format in a window.
   Operators, and other personal with limited privilages, can change certain
   entries by clicking on the appropriate box within the window. Choices allowed are
   closely controlled, removing most of the threat of typo's.
*/

#include "../lp.h"
#include "../lps.h"
#include "editprintcap.h"
#include <string.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Shell.h>
#include <X11/bitmaps/gray1>

#define VERSION "EditPrintcapV1-1"

/*********************************************************************
                       EDIT HISTORY

3-4-91  RJS     fixed bug in the "Enter New Value" Menu choice.

*********************************************************************/

#define COL1WIDTH 110		/* queue name */

extern  int     nitems, row, colume;
extern  char    *progname;
extern  char    *buff;
extern  char    stringList[NUM_QUEUES][80];
extern  Entry entry[];
extern  struct Pcap{
    char   *printer[NUM_NAMES];
    Entry  entry[NPCAPS];
} pcap[NUM_QUEUES], *pcap_ptr;

int  maxPnameLength[NUM_NAMES];				    /* max length in pixels of names in pcap.printer list */

extern char line[BUFSIZ];
extern char pbuf[BUFSIZ/2];
Widget  Line[NUM_QUEUES], form, topLevel, colums[NUM_QUEUES*NPCAPS], buttonbox, labelbox;
Widget  nameBox, dataBox, pshell, dialog, quit, allqueues, menuShell, menuPane[4];
Widget  dataMenu, pcapVport, fromHoriz, yes, no, currentBox, commit, menuShell;
Widget  Dialog, pcaperr, warning, changedList[32];
Widget  prompt_box, prompt_label, notRoot, slowDeath;
int     numChanged=0;
XtAppContext app_context;
XFontStruct  *font_info, *font5x8, *font9x15bold, *font10x20bold, *font7x13bold;
XtIntervalId DoAgainintervalID;
Dimension maxLength;
Bool    formHasChanged=FALSE;
Bool    writeAccess;
Bool    altname=FALSE;
Arg     args[10];
int     totalWidth=0;		/* total width of the form inside of the viewport */
int     interval = 1;
int     colNum=0;
short   uid, euid;
Pixmap  gray;
GC      cgc;
Screen  *screen;
XtIntervalId checkModTimeID;

extern  int totActiveColums, maxAltNames;
extern  struct  stat fileinfo;					    /* file information from fstat. */
extern  time_t  fileModTime;					    /* time stamp from st_mtime field */
extern  char *bp;
extern saveData();
extern void Yes();
extern void No();
extern void SetPopup();
extern void getLabelValues();
extern void getFormValues();
extern void getBoxValues();
extern void getVportValues();
extern void done_dialog();
extern void return_key();
extern Dimension getBoxHeight();
extern Dimension getFormWidth();
extern Dimension getFormHeight();
extern Dimension getFormBorder();
extern Dimension getVportBorder();
extern Dimension getVportWidth();
extern Dimension getPreferHeight();
extern Dimension showDialogStruct();
extern Dimension showTextWidth();
extern Dimension showTextHeight();
extern Dimension getLabelWidth();
extern Dimension getLabelHeight();
extern Position  getLabelXpos();
extern Position  getLabelYpos();
extern Bool isDialogVisible();
extern void setDialogWidth();
extern void dspstatus();

  /* The translation table for the text widget.  Things such as <RETURN>
  ** confirm the user's choice.  Other keys which would move out of
  ** the range of a one-line window are disabled. */

  static char *translationtable = 
    "Ctrl<Key>J:    DoneDialog()\n\
     Ctrl<Key>M:    DoneDialog()\n\
     <Key>Linefeed: DoneDialog()\n\
     <Key>Return:   DoneDialog()\n\
     Ctrl<Key>O:    Nothing()\n\
     Meta<Key>I:    Nothing()\n\
     Ctrl<Key>N:    Nothing()\n\
     Ctrl<Key>P:    Nothing()\n\
     Ctrl<Key>Z:    Nothing()\n\
     Meta<Key>Z:    Nothing()\n\
     Ctrl<Key>V:    Nothing()\n\
     Meta<Key>V:    Nothing()";

  /* What the actions in the translation table correspond to. */

  static XtActionsRec actiontable[] = {
    {"DoneDialog", return_key},
    {"Done",      NULL},
    {"Nothing",   NULL}
  };

/* 
 * finish initializing screens
 */
/*ARGSUSED*/
static XtTimerCallbackProc
FinishInit(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    int wd[10], i;
    Dimension internalheight, height;
    int vertdistance;
#ifdef DEBUG
    getLabelValues(colums[6],"for label boxes inside viewport ");
    getLabelValues(Line[6],"for label boxes inside name pane ");
    getFormValues(form,"for form inside viewport ");
    getBoxValues(nameBox,"for name box ");
    i = 0;
    XtSetArg(args[i], XtNinternalHeight, &internalheight);  i++;
    XtSetArg(args[i], XtNheight, &height); i++; 
    XtSetArg(args[i], XtNvertDistance, &vertdistance); i++;
    XtGetValues(colums[6], args, (Cardinal)i);
    printf("for colums: internalheight = %d, height=%d, vertdistance=%d\n", internalheight, height, vertdistance);
    XtGetValues(form, args, (Cardinal)i);
    printf("for form:   internalheight = %d, height=%d, vertdistance=%d\n", internalheight, height, vertdistance);
    printf("\n");
#endif
    DoAgainintervalID = XtAppAddTimeOut (app_context, (unsigned long) (interval*1000), FinishInit, (caddr_t) NULL);
}

/* background work procedure, Check mod time of file once per second and warn user
   if it has changed. */

/*ARGSUSED*/
XtTimerCallbackProc
checkModTime(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    Dimension w, h;
    Position  x, y, new_x, new_y;
    Widget    slowDeathLabel;

    if ( stat("/etc/printcap", &fileinfo) ) {		    /* get fstat of /etc/printcap */
	fprintf(stderr,"Failure in fstat of /etc/printcap \n");
	XBell (XtDisplay(topLevel), 0);
	return(FALSE);
    }
    if (fileModTime != fileinfo.st_mtime){		    /* if someone else has changed the file then...*/
	XtSetSensitive(commit, FALSE);			    /* turn off the commit button and... */

/* build a popup window to warn the user that the printcap file has been changed by someone else */

	w = getLabelWidth(prompt_label);		    /* get width of prompt box */
	h = getLabelHeight(prompt_label);		    /* get height */
	x = getLabelXpos(prompt_label);			    /* get x */
	y = getLabelYpos(prompt_label);			    /* get y */
	XtTranslateCoords(prompt_label, x, y, &new_x, &new_y);
	new_x += 375;
	new_y -= 64;

/* display the popup window just below the prompt box */

	slowDeath = XtVaCreatePopupShell("DataMenu", 
					transientShellWidgetClass,
					topLevel, 
					XtNborderWidth,  (Dimension) 3,
					XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
					XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
					XtNallowShellResize, (XtArgVal) FALSE,
					XtNinput,        (XtArgVal) FALSE,
					XtNx,     new_x,  /* just to the right of the left hand side */
					XtNy,     new_y,
					NULL);
	
	slowDeathLabel = XtVaCreateManagedWidget("menulabel",
					    labelWidgetClass,
					    slowDeath,
					    XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
					    XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
					    XtNfont,  font_info,
					    XtNlabel, "WARNING - Some other user has just changed /etc/printcap\n\
Exit program and restart",
					    XtNjustify, XtJustifyLeft,
					    NULL);
	XtPopup(slowDeath, XtGrabNone);
	XBell (XtDisplay(topLevel), 0);
    }
    else
	checkModTimeID = XtAppAddTimeOut(app_context, 
					 (unsigned long)(1000), 
					 checkModTime, 
					 (caddr_t)NULL); /* reset timer */
}
	
Bool commitChanges(w, client_data, garbage)
Widget w;
XtPointer client_data, garbage;
{
    int i;

    if (writeAccess){					    /* if this user has write access to /etc/printcap then... */
	XtRemoveTimeOut(checkModTimeID);		    /* turn off checking for unauth file mods and... */
	if (saveData() != -1){  			    /* go save all data in new file. if save succeeded then... */
	    goto finito;				    /* update form to indicate changes were saved. */
	}
	else{
	    checkModTimeID = XtAppAddTimeOut(app_context, (unsigned long)(1000), checkModTime, (caddr_t)NULL);
	    XtMapWidget(pcaperr);				    /* display warning if error occurred writing new file and - */
	    XBell (XtDisplay(topLevel), 0);			    /* hit the gong */
	    return;
	}
    }
    else{
	XBell (XtDisplay(topLevel), 0);			    /* hit the gong */
	fprintf("You are not authorized to change /etc/printcap");
	return;
    }							    /* otherwise... */
 finito:
    for (i=0; i<numChanged; i++){
	gray = XCreatePixmapFromBitmapData(XtDisplay(changedList[i]), 
					   XtWindow(changedList[i]),	/* build a  grayscale pixmap*/
					   gray1_bits, gray1_width, gray1_height,
					   WhitePixelOfScreen(screen), 
					   BlackPixelOfScreen(screen),
					   DefaultDepthOfScreen(screen));
	XtVaSetValues(changedList[i], 
		      XtNbackgroundPixmap, gray,	    /* set grayscale */
		      XtNbackground, (Pixel) WhitePixelOfScreen(screen), /* unset reverse video */
		      XtNforeground, (Pixel) BlackPixelOfScreen(screen),
		      NULL);
    }
    numChanged = 0;
    formHasChanged = FALSE;
    XtUnmapWidget(commit);
    XtUnmapWidget(warning);
    XtUnmapWidget(pcaperr);
    if ( stat("/etc/printcap", &fileinfo) ) {		    /* get fstat of /etc/printcap */
	fprintf(stderr,"Failure in fstat of /etc/printcap \n");
	return(FALSE);
    }
    fileModTime = fileinfo.st_mtime;		    /* remember the time we changed the file*/
}

/* data area manager popup menu parser. parses the return from the change data menu */

void dataManagerMenu(w, client_data, garbage, it)
Widget w;
XtPointer client_data, garbage;
int it;
{
    int MenuItem = (int) client_data;
    int ClassItem = (int)garbage;
    int i;

/*#ifdef DEBUG*/
    printf ("In dataManagerMenu, menu item %d, class %d, named %s has been selected.\n", 
	    MenuItem, ClassItem, XtName(w));
    printf ("parent widget = %s\n", XtName(XtParent(w)));
    printf ("row=%d, colume=%d\n", row, colume);
/*#endif*/

    XtVaSetValues(currentBox, 
		  XtNlabel, stringList[MenuItem], 
		  XtNbackground, (Pixel) BlackPixelOfScreen(screen), /* set reverse video */
		  XtNforeground, (Pixel) WhitePixelOfScreen(screen),
		  NULL);

    if (altname){				    /* means we are working on an alt name entry */
	strcpy (buff, stringList[MenuItem]);
	pcap[row].printer[colume+1] = buff;
	buff += strlen(buff) + 1;
    }
    else{
	if (strcmp(stringList[MenuItem], "n/a") == 0)
	    pcap[row].entry[colume].cvalueptr = 0;              /* null out this entry */
	else{
	    strcpy (buff, stringList[MenuItem]);		    /* copy the data to our buffer */
	    pcap[row].entry[colume].cvalueptr = buff;		    /* make our control structure point to this data */
	}
	entry[colume].bvalue = TRUE;			    /* remember that we found at least one of this switch */
	if (pcap[row].entry[colume].cvalueptr != 0)
	    if (strlen(pcap[row].entry[colume].cvalueptr) != 0)
		buff += strlen(buff) + 1;			    /* update the buffer pointer */
	    else
		buff += 1;					    /* leave room for a null entry */
    }
    XtMapWidget(commit);
    formHasChanged = TRUE;
    changedList[numChanged++] = currentBox;
    XtPopdown(dataMenu);
    XtDestroyWidget(dataMenu);
    dataMenu = 0;
}

/* data area manager popup menu parser */

void noChange(w, client_data, garbage, it)
Widget w;
XtPointer client_data, garbage;
int it;
{
    XtPopdown(dataMenu);
    XtDestroyWidget(dataMenu);
    dataMenu = 0;
}

void return_key()
{
    done_dialog(dataMenu, Dialog);
}

/* routine to parse string returned from "Enter New Value" menu choice. */

void done_dialog(w, client_data, garbage)
Widget     w;
XtPointer  client_data, garbage;
{
    Widget dialog = (Widget) client_data;
    String string;

    string = XawDialogGetValueString(dialog);
    strcpy(stringList[0], string);

    if (strlen(stringList[0]) != 0)
	dataManagerMenu(dataMenu, 0, -1, altname);
    else
	noChange();
}

void createDialogBox(w)
Widget w;
{
    char   value[2], *cvalue;
    Widget quitDialog, doneDialog, typein;

    value[0] = 0;					    /* create null string */
    Dialog = XtVaCreateManagedWidget(
				     "dialog",
				     dialogWidgetClass,
				     w,
				     XtNlabel, "Enter New String",
				     XtNvalue, value,
				     XtNwidth, maxLength,
				     XtNheight, 78,
				     NULL);
    quitDialog = XtVaCreateManagedWidget(
					 "quit",
					 commandWidgetClass,
					 Dialog,
					 XtNlabel, "QUIT",
					 NULL);
    XtAddCallback(quitDialog, XtNcallback, noChange, dialog);
    doneDialog = XtVaCreateManagedWidget(
					 "done",
					 commandWidgetClass,
					 Dialog,
					 XtNlabel, "DONE",
					 NULL);
    XtAddCallback(doneDialog, XtNcallback, done_dialog, Dialog);
    XtResizeWidget(dataMenu, maxLength+10, 80, 1);
    setDialogWidth(Dialog, (Dimension)maxLength);
    XtResizeWindow(Dialog);				    /* force new width */

/* Register actions, translations, callbacks */

    if ((typein = XtNameToWidget(Dialog, "value")) != 0) {  /* find a child of Dialog whose name is value */
	XtSetKeyboardFocus(menuShell, typein);		    /* send all keyboard input to that child */

/*now we must resize the value box contained within the dialog widget.  We do this
  because the dialog widget sizes itself unconditonally based upon the XtTextWidth of the
  value box. If we pass a null string to the value box, as we are doing here, then the
  dialog widget will not be sized correctly. Note that we call the value box a box instead 
  of a widget, because its actually a text widget. Note also that we keep the same height 
  fetched from the core structure of the value (text) widget. */

	XtResizeWidget(typein, maxLength-10, showTextHeight(typein), 1);
    }
    XtOverrideTranslations(typein, XtParseTranslationTable(translationtable));
}


/* data area manager popup menu parser to prompt for a new string.  */
/* We come here with row, colume, and currentBox set by the caller. */

void newValue(w, client_data, garbage, it)
Widget w;
XtPointer client_data, garbage;
int it;
{
    XtDestroyWidget(menuShell);
    menuShell = XtVaCreateManagedWidget("menuBox",	    /* Widget name */
					boxWidgetClass, /* widget class */
					dataMenu,	    /* parent widget */
					XtNborderWidth, (Dimension) 10,
					XtNfont,  font_info,
					XtNwidth, maxLength,
					XtNheight, 88,
					NULL);	    /* end of argument list */
    createDialogBox(menuShell);
}

/* callback to update prompt area. Invoked from translation table interface */

void prompt(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    int    iparam, mitem;
    int    i, i1;
#ifdef DEBUG
    printf ("In prompt num_params = %d", *num_params);
    for (i=0; i<*num_params; i++)
	printf (" param#%d = %s", i, params[i]);
    printf ("\n");
#endif
    if (*num_params > 1){
	mitem = atoi(params[3]);
	switch (mitem){
	case 0:
	    sprintf (pbuf, "CHANGE %s ENTRY FOR %s TO %s", 
		     pcap[row].entry[colume].name, 
		     pcap[row].printer[0],
		     params[2]);
	    break;
	case 1:
	    sprintf (pbuf, "ENTER NEW VALUE FOR %s ENTRY FOR %s",
		     pcap[row].entry[colume].name,
		     pcap[row].printer[0]);
	    break;
	case 2:
	    sprintf (pbuf, "CANCEL ENTERING CHANGES TO %s ENTRY FOR %s",
		     pcap[row].entry[colume].name,
		     pcap[row].printer[0]);
	    break;
       	case 3:
	    sprintf (pbuf, "CHANGE %s ENTRY FOR %s TO %s", 
		     pcap[row].entry[colume].name, 
		     pcap[row].printer[0],
		     "n/a");
	}
	XtVaSetValues (prompt_label, XtNlabel, pbuf, NULL);
    }
    else{
	iparam = atoi(params[0]);

/* find out which row and colume.  We do it the hard way because there is no rem function on a DEC Mips machine.*/

	row = -1;
	for (i=iparam; i>=0; i-=totActiveColums){
	    colume = i;
	    row++;
	}
	if (colume < maxAltNames){
	    sprintf (pbuf, "CHANGE ALTERNATE NAME FOR %s\n", pcap[row].printer[0]);
	    XtVaSetValues (prompt_label, XtNlabel, pbuf, NULL);
	}
	else{
	    colume -= maxAltNames;				    /* offset for the altNames colume(s) */
	    i1 = -1;
	    for (i=0; i<NPCAPS; i++){			    /* skip to real colume */
		if (entry[i].bvalue) i1++;
		if (i1 == colume){
		    colume = i;
		    break;
		}
	    }
	    sprintf (pbuf, "CHANGE %s ENTRY FOR %s\n", pcap[row].entry[colume].name, pcap[row].printer[0]);
	    XtVaSetValues (prompt_label, XtNlabel, pbuf, NULL);
	}
    }
}

/* callback to clear prompt area. Invoked from translation table interface */

void unprompt(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    if (!dataMenu)
	XtVaSetValues (prompt_label, XtNlabel, " ", NULL);
}

/* menu choice popup menu parser. pop up a menu of change choices */

void processChoice(w, client_data, garbage, it)
Widget w;
XtPointer client_data, garbage;
int it;
{
    int menuItem = (int) client_data;
    int       i, i1, i2;
    Widget    menuLabel, menuPane[NUM_QUEUES];
    char      buf[50];
    int       numStrings;
    Bool      gotDuplicate;
    XWindowAttributes window_attributes;
    Position new_x, new_y;

    XGetWindowAttributes (XtDisplay(w),
			  XtWindow(w),
			  &window_attributes);
    XtTranslateCoords(form, window_attributes.x, window_attributes.y, &new_x, &new_y);

    currentBox = w;
#ifdef DEBUG
    printf ("\nmenu item #%d named %s has been selected.\n", menuItem, XtName(w));
    printf ("width=%d, height=%d, x=%d, y=%d, newx=%d, newy=%d\n",
	    window_attributes.width, window_attributes.height,
	    window_attributes.x, window_attributes.y, new_x, new_y);
#endif

/* find out which row and colume.  We do it the hard way because there is no rem function on a DEC Mips machine.*/

    row = -1;
    for (i=menuItem; i>=0; i-=totActiveColums){
	colume = i;
	row++;
    }
#ifdef dEBUG
    printf ("row=%d, colume=%d\n", row, colume);
#endif

    new_y += ((2*window_attributes.height) + (2*window_attributes.border_width)); /*  move window to jsut below current*/

/* now build a popup window and display it at the current pointer position */

    dataMenu = XtVaCreatePopupShell("DataMenu", 
				    transientShellWidgetClass,
				    colums[menuItem], 
				    XtNborderWidth,  (Dimension) 10,
				    XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
				    XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
				    XtNallowShellResize, (XtArgVal) FALSE,
				    XtNinput,        (XtArgVal) TRUE,
				    XtNx,     new_x,
				    XtNy,     new_y,
				    NULL);
    if (colume < maxAltNames){
	altname = TRUE;
	maxLength = 0;
	for (i=0; i<nitems; i++){
	    if (pcap[i].printer[colume+1] != 0){
		i2 = XTextWidth(font_info, 
				pcap[i].printer[colume+1], 
				strlen(pcap[i].printer[colume+1]));
		if (maxLength<i2) maxLength = i2;
	    }
	}
	if (maxLength < 150) maxLength = 150;

	menuShell = XtVaCreateManagedWidget("menuBox",	    /* Widget name */
					    boxWidgetClass, /* widget class */
					    dataMenu,	    /* parent widget */
					    XtNborderWidth, (Dimension) 10,
					    XtNfont,   font_info,
					    XtNwidth,  (Dimension) maxLength,
					    XtNheight, (Dimension) 88,
					    NULL);	    /* end of argument list */
	createDialogBox(menuShell);

    }
    else{
	altname = FALSE;
	menuShell = XtVaCreateManagedWidget("menuBox",	    /* Widget name */
					    boxWidgetClass, /* widget class */
					    dataMenu,	    /* parent widget */
					    XtNborderWidth, (Dimension) 10,
					    XtNfont,  font_info,
					    NULL);	    /* end of argument list */
	colume -= maxAltNames;				    /* offset for the altNames colume(s) */
	i1 = -1;
	for (i=0; i<NPCAPS; i++){			    /* skip to real colume */
	    if (entry[i].bvalue) i1++;
	    if (i1 == colume){
		colume = i;
		break;
	    }
	}

	strcpy(buf,"CHANGE ASSIGNMENT MENU");
	maxLength = XTextWidth(font_info, buf, strlen(buf));
	for (i=0; i<nitems; i++)
	    if (maxLength<pcap[i].entry[colume].length) 
		maxLength = pcap[i].entry[colume].length;
	maxLength += 10;
	menuLabel = XtVaCreateManagedWidget("menulabel",
					    labelWidgetClass,
					    menuShell,
					    XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
					    XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
					    XtNfont,  font_info,
					    XtNlabel, buf,
					    XtNwidth, maxLength,
					    XtNjustify, XtJustifyCenter,
					    NULL);
	numStrings = 0;
	for (i=0; i<nitems; i++){
	    pcap_ptr = &pcap[i];
	    if (pcap_ptr->entry[colume].cvalueptr != ZERO){
		gotDuplicate = FALSE;
		for (i1=0; i1<numStrings; i1++)
		    if (strcmp(stringList[i1], pcap_ptr->entry[colume].cvalueptr)==0){
			gotDuplicate = TRUE;
			break;
		    }
		if (gotDuplicate) continue;
		strcpy(stringList[numStrings], pcap_ptr->entry[colume].cvalueptr);
		sprintf(buf, "menupane%d", i);                      /* build name */
#ifdef DEBUG
		printf("win #%d named %s = %s\n", i, buf, pcap_ptr->entry[colume].cvalueptr);
#endif
		menuPane[numStrings] = XtVaCreateManagedWidget(buf, 
						      commandWidgetClass, 
						      menuShell, 
						      XtNlabel, pcap_ptr->entry[colume].cvalueptr,
						      XtNwidth, maxLength,
						      XtNfont, font_info,
						      XtNjustify, XtJustifyLeft,
						      NULL);
		XtAddCallback (menuPane[numStrings], XtNcallback, dataManagerMenu, numStrings);/* callback to handle menu choice*/
		sprintf (pbuf, "<Enter>: prompt(%d,%d,%s,%d) highlight()", 
			 row, numStrings, pcap_ptr->entry[colume].cvalueptr, 0);
		XtOverrideTranslations (menuPane[numStrings], XtParseTranslationTable(pbuf));
		numStrings++;
	    }
	}
	strcpy(stringList[numStrings], "n/a");
	sprintf(buf, "menupane%d", i++);                      /* build name */
	menuPane[numStrings] = XtVaCreateManagedWidget(buf, 
						       commandWidgetClass, 
						       menuShell, 
						       XtNlabel, "n/a",
						       XtNwidth, maxLength,
						       XtNfont, font_info,
						       XtNjustify, XtJustifyLeft,
						       NULL);
	XtAddCallback (menuPane[numStrings], XtNcallback, dataManagerMenu, numStrings);/* callback to handle n/a menu choice*/
	sprintf (pbuf, "<Enter>: prompt(%d,%d,%s,%d) highlight()", 
		 row, colume, "n/a", 3);
	XtOverrideTranslations (menuPane[numStrings], XtParseTranslationTable(pbuf));
	numStrings++;
	sprintf(buf, "menupane%d", i++);                      /* build name */
	menuPane[numStrings] = XtVaCreateManagedWidget(buf, 
						       commandWidgetClass, 
						       menuShell, 
						       XtNlabel, "Enter New Value",
						       XtNwidth, maxLength,
						       XtNfont, font_info,
						       XtNjustify, XtJustifyLeft,
						       NULL);
	XtAddCallback (menuPane[numStrings], XtNcallback, newValue, numStrings); /* callback to handle ENTER NEW VALUE */
	sprintf (pbuf, "<Enter>: prompt(%d,%d,%s,%d) highlight()", 
		 row, colume, "garbage", 1);
	XtOverrideTranslations (menuPane[numStrings], XtParseTranslationTable(pbuf));
	numStrings++;
	sprintf(buf, "menupane%d", i++);                      /* build name */
	menuPane[numStrings] = XtVaCreateManagedWidget(buf, 
						       commandWidgetClass, 
						       menuShell, 
						       XtNlabel, "CANCEL - NO CHANGE",
						       XtNwidth, maxLength,
						       XtNfont, font_info,
						       XtNjustify, XtJustifyLeft,
						       NULL);
	XtAddCallback (menuPane[numStrings], XtNcallback, noChange, numStrings);
	sprintf (pbuf, "<Enter>: prompt(%d,%d,%s,%d) highlight()", 
		 row, colume, "garbage", 2);
	XtOverrideTranslations (menuPane[numStrings], XtParseTranslationTable(pbuf));
	numStrings++;
    }

    if (new_x + maxLength + 16 > (Dimension)screen->width){
	new_x -= ((new_x + maxLength + 16) - (Dimension)screen->width);
	XtMoveWidget(dataMenu, new_x, new_y);
    }
    else if (new_x < 0){
	new_x = 0;
	XtMoveWidget(dataMenu, new_x, new_y);
    }

    XtPopup(dataMenu, XtGrabExclusive);
}

void makeLine(parent, fromVert, itemNum)
Widget  parent, fromVert;
int     itemNum;
{
    int    i;
    char   label[64];
    int    curCol;

    colums[colNum] = XtVaCreateManagedWidget(             /* display all of the printer names, starting with the SECOND one */
					     "n/a",
					     commandWidgetClass,	                  /* widget class */
					     parent,	                          /* parent widget*/
					     XtNfont,         font_info,
					     XtNfromVert,    fromVert,
					     XtNlabel,       pcap_ptr->printer[1],
					     XtNwidth,       maxPnameLength[1],
					     XtNborderWidth, (Dimension) 1,
					     NULL);	                           /* argument list*/
    XtAddCallback (colums[colNum], XtNcallback, processChoice, (XtPointer) colNum);
    sprintf (label, "<Enter>: prompt(%d) highlight()", colNum);
    XtOverrideTranslations (colums[colNum], XtParseTranslationTable(label));

    fromHoriz = colums[colNum++];

    for (i=2; i<=maxAltNames; i++){                         /* finish displaying alternate printer names */
	colums[colNum] = XtVaCreateManagedWidget(
						 "n/a",
						 commandWidgetClass,	                  /* widget class */
						 parent,	                          /* parent widget*/
						 XtNfromHoriz,   fromHoriz,
						 XtNfromVert,    fromVert,
						 XtNfont,         font_info,
						 XtNlabel,       pcap_ptr->printer[i],
						 XtNwidth,       maxPnameLength[i],
						 XtNborderWidth, (Dimension) 1,
						 NULL);	                           /* argument list*/

	XtAddCallback (colums[colNum], XtNcallback, processChoice, (XtPointer) colNum);
	sprintf (label, "<Enter>: prompt(%d) highlight()", colNum);
	XtOverrideTranslations (colums[colNum], XtParseTranslationTable(label));
	
	fromHoriz = colums[colNum++];
    }
    for (i=0; i<NPCAPS; i++)
	if (entry[i].bvalue){
	    colums[colNum] = XtVaCreateManagedWidget(
						     "n/a",
						     commandWidgetClass,	                  /* widget class */
						     parent,	                          /* parent widget*/
						     XtNfromHoriz,   fromHoriz,
						     XtNfromVert,    fromVert,
						     XtNfont,         font_info,
						     XtNlabel,       pcap_ptr->entry[i].cvalueptr,
						     XtNwidth,       entry[i].length,
						     XtNborderWidth, (Dimension) 1,
						     NULL);	                           /* argument list*/

	    XtAddCallback (colums[colNum], XtNcallback, processChoice, (XtPointer) colNum);
	    sprintf (label, "<Enter>: prompt(%d) highlight()", colNum);
	    XtOverrideTranslations (colums[colNum], XtParseTranslationTable(label));
	    fromHoriz = colums[colNum++];
	}
}

load_font(font_info, fontname)
XFontStruct **font_info;
char        *fontname;
{

        /* Access font */
        if ((*font_info = XLoadQueryFont(XtDisplay(topLevel),fontname)) == NULL)
        {
                (void) fprintf( stderr, "Basic: Cannot open %s font\\n", fontname);
                exit( -1 );
        }
}
main(argc, argv)
int argc;
char **argv;
{
    Widget  pane1, pane2, yes, no;
    Widget new, label[NPCAPS], lastLabel, names[NUM_NAMES];
    int    i, i1, i2, *p;
    char *geometry;
    char *myborder;
    int  border=1;
    register int c, status;
    register char *cp1, *cp2;
    char myname[100];
    Dimension minStrLen;
    Display *display;
    int     screen_num;
    static XtActionsRec window_actions[] = {
	{"prompt", prompt},
	{"unprompt", unprompt}
    };

    nitems = 0;
    progname = argv[0];

/* go get data and populate all of the arrays and structures */

    if ((getData()) != 0) exit;

/* find out who we are running as */

    uid = getuid();
    euid = geteuid();
    if ((fileinfo.st_uid == euid && ((fileinfo.st_mode & S_IWUSR) == S_IWUSR)) || /* if uid = file uid and has write access or-- */
	(fileinfo.st_gid == euid && ((fileinfo.st_mode & S_IWGRP) == S_IWGRP)))   /* if gid = file gid and has wriate access */
	writeAccess = TRUE;
    else
	writeAccess = FALSE;

/* got all of the data... Now its time to do WINDOWS.*/

    topLevel = XtVaAppInitialize(
        &app_context,       /* Application context */
	VERSION,            /* application class name */
        NULL, ZERO,         /* command line option list */
        &argc, argv,        /* command line args */
        NULL,               /* for missing app-defaults file */
        XtNx,  (Position) 1,
        XtNy,  (Position) 2,
	XtNiconName,  VERSION,
        NULL);              /* terminate varargs list */

    screen = XtScreen(topLevel);
#ifdef DEBUG
    printf ("white pixel=%d, black pixel=%d\n",	WhitePixelOfScreen(screen), 
					   BlackPixelOfScreen(screen));
#endif
/* get the font structures we may want to use */

    load_font(&font_info, "8x13bold");
    load_font(&font7x13bold, "7x13bold");
    load_font(&font5x8, "5x8");
    load_font(&font9x15bold, "9x15bold");
    load_font(&font10x20bold, "-adobe-times-bold-r-normal-*-20-140-100-100-p-100-iso8859-1");

/* update actions tables to include local actions */

    XtAppAddActions (app_context, window_actions, 2);
    XtAppAddActions (app_context, actiontable, XtNumber(actiontable));

/* find out how many alternate names we have to deal with on this machine */

    maxAltNames = 0;
    for (i=0; i<NUM_QUEUES; i++){
	i2 = 0;
	pcap_ptr = &pcap[i];
	for (i1=1; i1<NUM_NAMES; i1++)
	    if (pcap_ptr->printer[i1] != 0) i2++;
	if (i2 > maxAltNames) maxAltNames = i2;
    }

    minStrLen = XTextWidth(font_info, "n/a", strlen("n/a")) + 10;
    totActiveColums = maxAltNames;

/* now compute the length of the longest string for each item */

    for (i=0; i<NPCAPS; i++){
	if (entry[i].bvalue){
	    totActiveColums += 1;
	    entry[i].length = XTextWidth(font_info, entry[i].name, strlen(entry[i].name));
	    for (i1=0; i1<NUM_QUEUES; i1++){
		pcap_ptr = &pcap[i1];
		if (pcap_ptr->printer[0] != ZERO)
		    if (pcap_ptr->entry[i].cvalueptr != ZERO){
			pcap_ptr->entry[i].length = XTextWidth(font_info, 
								pcap_ptr->entry[i].cvalueptr,
								strlen(pcap_ptr->entry[i].cvalueptr));
			if (pcap_ptr->entry[i].length > entry[i].length)
			    entry[i].length = pcap_ptr->entry[i].length;
		    }
	    }
	}
	entry[i].length += 10;
	if (entry[i].length < minStrLen) entry[i].length = minStrLen;
    }

/* now do the same for alternate printer(queue) names */

    for (i1=1; i1<NUM_NAMES; i1++){
	for (i=0; i<NUM_QUEUES; i++){
	    pcap_ptr = &pcap[i];
	    if (pcap_ptr->printer[i1] != 0){
		i2 = XTextWidth(font_info, pcap_ptr->printer[i1], strlen(pcap_ptr->printer[i1]));
		if (i2 > maxPnameLength[i1]) maxPnameLength[i1] = i2;
	    }
	}
	maxPnameLength[i1] += 10; /* make room for the borders */
    }

/* calculate the total width of the form inside of the viewport */

    for (i=0; i<NPCAPS; i++)
	totalWidth += (entry[i].length +6); /* plus five pixels for the borders and spacing */
#ifdef DEBUG
    printf("totalWidth=%d\n", totalWidth);
#endif
    form = XtVaCreateManagedWidget(
				   "form", 	/* widget name */
				   formWidgetClass,	/* widget class */
				   topLevel,	/* parent widget*/
				   XtNwidth,       (Dimension)screen->width-4,
				   XtNborderWidth, (Dimension) 1,
				   XtNx,           0,
				   XtNy,           0,
				   NULL);	/* argument list*/

    pane1 = XtVaCreateManagedWidget(
				    "pane1",
				    panedWidgetClass,
				    form,
				    XtNwidth,       (Dimension)screen->width-16,
				    XtNborderWidth, (Dimension) 2,
				    NULL);
    
    create_buttonbox(pane1);				    /* go make the buttons for the command box */

    prompt_label = XtVaCreateManagedWidget ("PromptLabel",
					    labelWidgetClass,
					    pane1,
					    XtNfont,     font9x15bold,
					    XtNlabel,    " ",
					    XtNfromVert, buttonbox,
					    XtNwidth,  totalWidth,
					    XtNjustify, XtJustifyLeft,
					    NULL);

    nameBox = XtVaCreateManagedWidget("buttonbox", boxWidgetClass, /* make a box to contain the queue names */
				      form, 
				      XtNfromVert,  pane1,
				      XtNborderWidth,     (Dimension) 1,
				      NULL);

    Line[0] = XtVaCreateManagedWidget("Labels",	            /* put up the first queue name */
				      labelWidgetClass,	/* widget class */
				      nameBox,		/* parent widget*/
				      XtNfont,         font_info,
				      XtNwidth,        COL1WIDTH,
				      XtNborderWidth,  (Dimension) 1,
				      XtNheight,       31,
				      XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
				      XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
				      NULL);		/* argument list*/

    for (i=1; i<=NUM_QUEUES; i++){			    /* now create a vertical list of queue names */
	pcap_ptr = &pcap[i-1];
	if (pcap_ptr->printer[0] != ZERO){
	    Line[i] = XtVaCreateManagedWidget(
					      pcap_ptr->printer[0],                    /* widget name */
					      labelWidgetClass,	/* widget class */
					      nameBox,		/* parent widget*/
					      XtNfont,         font_info,
					      XtNfromVert,    Line[i-1],
					      XtNwidth,       COL1WIDTH,
					      XtNborderWidth,     (Dimension) 1,
					      NULL);		/* argument list*/
	}
    }

    pcapVport = XtVaCreateManagedWidget(		    /* create a viewport to contain the data */
					"vport",
					viewportWidgetClass,
					form,
					XtNallowHoriz, TRUE,
					XtNallowVert, FALSE,
					XtNforceBars, TRUE,
					XtNwidth, screen->width-(COL1WIDTH+30), 
					XtNfromVert,  pane1,
					XtNfromHoriz, nameBox,
					XtNborderWidth,     (Dimension) 1,
					NULL);
    form = XtVaCreateManagedWidget(			    /* form widget is only child of viewport */
				   "form", 	        /* widget name */
				   formWidgetClass,	/* widget class */
				   pcapVport,   	/* parent widget*/
				   XtNwidth, totalWidth,
				   XtNbottom, XtChainBottom,
				   XtNleft,   XtChainLeft,
				   XtNright,  XtChainRight,
				   XtNtop,    XtChainTop,
				   XtNborderWidth, (Dimension) 1,
				   NULL);       	/* argument list*/

    sprintf (label, "<Leave>: unprompt()");
    XtOverrideTranslations (form, XtParseTranslationTable(label));

/* start a horizontal row of colume headings. starting with "alt names" */

    names[1] =  XtVaCreateManagedWidget ("Alt Name #1",	    /* first label widget doesnt specify fromHoriz */
					 labelWidgetClass,
					 form,
					 XtNwidth,        maxPnameLength[1],
					 XtNfont,         font_info,
					 XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
					 XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
					 XtNborderWidth,  (Dimension) 1,
					 NULL);	                             /* end of argument list*/
    lastLabel = names[1];
    
    for (i=2; i<=maxAltNames; i++){			    /* continue row of alt names, horiz aligned with previous box */
	sprintf (myname, "Alt Name #%d", i);
	names[i] =  XtVaCreateManagedWidget (myname,
					 labelWidgetClass,
					 form,
					 XtNwidth,        maxPnameLength[i],
					 XtNfont,         font_info,
					 XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
					 XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
					 XtNborderWidth,  (Dimension) 1,
					 XtNfromHoriz,    lastLabel,
					 NULL);	                             /* end of argument list*/
	lastLabel = names[i];
    }

/* complete the horizontal row of colume headings with the list of value specifiers */

    for (i=0; i<NPCAPS; i++) {				    /* check all entries in the pcap table */
	label[i] = 0;					    /* NULL init the widget list */
	if (entry[i].bvalue){				    /* if any printer specified an entry for this specifier... */

	    label[i] = XtVaCreateManagedWidget (pcap_ptr->entry[i].name, /* build the columne heading... */
						labelWidgetClass,
						form,
						XtNlabel,       pcap_ptr->entry[i].name,
						XtNwidth,       entry[i].length,
						XtNfont,         font_info,
						XtNfromHoriz,    lastLabel, /* horiz aligned with previous box. */
						XtNbackground,   (Pixel) BlackPixelOfScreen(screen),
						XtNforeground,   (Pixel) WhitePixelOfScreen(screen),
						XtNborderWidth,     (Dimension) 1,
						NULL);	    /* argument list */
	    lastLabel = label[i];			    /* remember previous box */
	}
    }

/* now fill in the data. Each call to makeLine will create an entire row, one row per printer. */

    for (i=1; i<=NUM_QUEUES; i++){
	pcap_ptr = &pcap[i-1];
	if (pcap_ptr->printer[0] != ZERO){		    /* if name present */
	    makeLine(form, lastLabel, i);		    /* lastLabel becomes XtNfromVert */
	    lastLabel = fromHoriz;			    /* makeLine resets fromHoriz */
	}
    }
#ifdef DEBUG
    
#endif
    XtRealizeWidget(topLevel);
#ifdef DEBUG
    getLabelValues(colums[6],"for label boxes inside viewport ");
    getLabelValues(Line[6],"for label boxes inside name pane ");
    getFormValues(form,"for form inside viewport ");
    getBoxValues(nameBox,"for name box ");
    getVportValues(pcapVport,"for viewport");
#endif
    XtResizeWidget(pcapVport, 
		   getVportWidth(pcapVport),                /* original width */
		   getBoxHeight(nameBox),		    /* height of nameBox */
		   getVportBorder(pcapVport));		    /* original border_width */
#ifdef DEBUG
    getVportValues(pcapVport,"after viewport resizefor viewport");
    getFormValues(form,"after viewport resize for form inside viewport ");
#endif
    XtResizeWidget(form, 
		   getFormWidth(form), 
		   (Dimension)((getFormHeight(form))-4), 
		   getFormBorder(form));
#ifdef DEBUG
    getFormValues(form,"After form resize for form inside viewport ");
    for (i=0; i<NPCAPS; i++) 				    /* check all entries in the pcap table */
	if (entry[i].bvalue)
	    printf("\t%d",getFormHeight(colums[i]));
#endif

    if (!writeAccess) XtMapWidget(notRoot);                    /* warn user if not logged in as root */
    checkModTimeID = XtAppAddTimeOut(app_context, (unsigned long)(5000), checkModTime, (caddr_t)NULL);

    XtAppMainLoop(app_context);
    
}
create_buttonbox(parent)
Widget parent;
{
    Widget    resizewindow, helpwidget, screen_saver, menu, menuLabel;
    char      buf[50];
    int       i;
    static XtCallbackRec callback[2];
    XFontStruct *myfont;

/* find the right font for this display screen */

    if (screen->width >= 1280)
	myfont = font9x15bold;
    else if (screen->width <1280 && screen->width > 1100)
	myfont = font_info;				    /* 8x13bold */
    else if (screen->width <= 1100)
	myfont = font7x13bold;

    buttonbox = XtVaCreateManagedWidget("buttonbox", boxWidgetClass,
					parent, 
					XtNwidth,   totalWidth,
					XtNborderWidth,     (Dimension) 2,
					NULL);

    quit = XtVaCreateManagedWidget(
				   "quit",		/* widget name */
				   commandWidgetClass,	/* widget class */
				   buttonbox,	/* parent widget*/
				   XtNfont,           myfont,
				   XtNlabel,          "\nQuit",
				   XtNborderWidth,     (Dimension) 2,
				   NULL);	/* argument list*/
    
    XtAddCallback(quit, XtNcallback, SetPopup, topLevel);

    pshell = XtVaCreatePopupShell(
				  "pshell",
				  transientShellWidgetClass,
				  topLevel,
				  NULL);              /* terminate varargs list */
    
    dialog = XtVaCreateManagedWidget(
				     "dialog",               /* widget name   */
				     formWidgetClass,              /* widget class */
				     pshell,                         /* parent widget*/
				     NULL);              /* terminate varargs list */
    
    menu = XtVaCreateManagedWidget("prompt",
				   labelWidgetClass,
				   dialog,
				   XtNlabel, "Quit: Are You Sure?",
				   NULL);

    yes = XtVaCreateManagedWidget(
				  "yes",           /* widget name   */
				  commandWidgetClass,             /* widget class */
				  dialog,                         /* parent widget*/
				  XtNlabel,   "YES",
				  XtNfromVert, menu,
				  NULL);              /* terminate varargs list */
    
    no = XtVaCreateManagedWidget(
				 "no",           /* widget name   */
				 commandWidgetClass,             /* widget class */
				 dialog,                         /* parent widget*/
				 XtNlabel,   "NO - Abort",
				 XtNfromHoriz, yes,
				 XtNfromVert, menu,
				 NULL);              /* terminate varargs list */

    XtAddCallback(yes, XtNcallback, Yes, 0);
    XtAddCallback(no, XtNcallback, No, 0);

    commit = XtVaCreateManagedWidget("quit",		/* widget name */
				     commandWidgetClass,	/* widget class */
				     buttonbox,	/* parent widget*/
				     XtNfont,           myfont,
				     XtNlabel,          "Commit\nChanges",
				     XtNborderWidth,    (Dimension) 2,
				     XtNsensitive,      writeAccess,
				     XtNmappedWhenManaged, FALSE,
				     NULL);	/* argument list*/

    XtAddCallback(commit, XtNcallback, commitChanges, 0);

    warning = XtVaCreateManagedWidget("warningLabel",
				      labelWidgetClass,
				      buttonbox,
				      XtNfont,  myfont,
				      XtNlabel, "WARNING - Changes have been made and NOT saved!",
				      XtNjustify, XtJustifyCenter,
				      XtNmappedWhenManaged, FALSE, 
				      NULL);

    pcaperr = XtVaCreateManagedWidget("errorLabel",
				      labelWidgetClass,
				      buttonbox,
				      XtNfont,  myfont,
				      XtNlabel, "ERROR Writing printcap file!",
				      XtNjustify, XtJustifyCenter,
				      XtNmappedWhenManaged, FALSE, 
				      NULL);

    notRoot = XtVaCreateManagedWidget("NotRoot",
				      labelWidgetClass,
				      buttonbox,
				      XtNfont,  myfont,
				      XtNlabel, "  Printcap file opened READONLY\nYou must be ROOT for write access",
				      XtNjustify, XtJustifyCenter,
				      XtNmappedWhenManaged, FALSE, 
				      NULL);

}

char  filename[]="/etc/printcap.tmp";

saveData()
{
    FILE *fdin, *fdout;
    int  i, i1, i2;
    struct tm *ptr;
    time_t lt;

    if ((fdin=fopen("/etc/printcap", "r"))==NULL){
	fprintf(stderr,"ERROR-Cant open /etc/printcap\n"); 
	perror("error opening file ");
	return(-1);
    }

    if ((fdout=fopen(filename, "w"))==NULL){
	fprintf(stderr,"ERROR-Cant open %s\n", filename); 
	perror("error opening file ");
	return(-1);
    }

    while ((fgets(line, 132, fdin)) != NULL){      /* keep the comments at the head of file */
	if (line[0] != '#') break;		   /* up to first line that doesnt start with "#" */
	fprintf (fdout,"%s", line);
    }
    fprintf (fdout, "\n");
    fclose(fdin);
    lt = time(NULL);				   /* now put a time & date stamp  */
    ptr = localtime(&lt);
    fprintf (fdout, "# *** This file created by %s on ", VERSION);
    fprintf (fdout, asctime(ptr));
    fprintf (fdout, "\n");

    for (i=0; i<nitems; i++){			   /* now write the data */
	fprintf(fdout,"%s", pcap[i].printer[0]);
	for (i1=1; i1<=maxAltNames; i1++)
	    if (pcap[i].printer[i1] != 0)
		fprintf(fdout, "|%s", pcap[i].printer[i1]);
	for (i1=0; i1<NPCAPS; i1++)
	    if (entry[i1].bvalue)
		if (pcap[i].entry[i1].cvalueptr != NULL)
		    if (pcap[i].entry[i1].type == NUMV)
			fprintf (fdout, ":\\\n\t:%s#%s", 
				 pcap[i].entry[i1].name,
				 pcap[i].entry[i1].cvalueptr);
		    else
			fprintf (fdout, ":\\\n\t:%s=%s", 
				 pcap[i].entry[i1].name,
				 pcap[i].entry[i1].cvalueptr);
	
	fprintf (fdout, ":\n\n");
    }
    fclose(fdout);
    if ((i = rename("/etc/printcap", "/etc/printcap.old")) != NULL){
	fprintf(stderr,"ERROR-Cant rename /etc/printcap to /etc/printcap.old\n"); 
	perror("error renaming file ");
	return(-1);
    }
    if ((i = rename(filename, "/etc/printcap")) != NULL){
	fprintf(stderr,"ERROR-Cant rename %s to /etc/printcap\n", filename); 
	perror("error renaming file ");
	return(-1);
    }
}

