#include "../lp.h"
#include "../lps.h"
#include <ctype.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/LabelP.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xaw/FormP.h>
#include	<X11/Xmu/Misc.h>
#include	<X11/Xaw/BoxP.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/ViewportP.h>
#include <X11/Xaw/DialogP.h>
#include <X11/Xaw/TextP.h>
/*
 *  So that we can use fprintf:
 */
#include <stdio.h>

extern Widget topLevel;
extern XtAppContext app_context;
extern Widget quit, pshell, buttonbox, warning;
extern Arg    args[10];
extern Bool   formHasChanged;
extern XFontStruct  *font_info, *font5x8, *font9x15bold, *font10x20bold;

XtIntervalId quitSoon;

void getLabelValues(lw,c)
LabelWidget lw;
char *c;
{
    register XFontStruct  *fs = lw->label.font;

    printf("%s:\n",c);
    printf("\tascent=%d, descent=%d, label_height=%d, internalHeight=%d, core_height=%d\n",
	   fs->max_bounds.ascent, 
	   fs->max_bounds.descent, 
	   lw->label.label_height,
	   lw->label.internal_height,
	   lw->core.height);
    printf ("\tlabel_width=%d, internalWidth=%d, core_width=%d, border_width=%d\n",
	    lw->label.label_width,
	    lw->label.internal_width,
	    lw->core.width,
	    lw->core.border_width);
}

void getFormValues(lw,c)
FormWidget lw;
char *c;
{

    printf("%s:\n",c);
    printf("\tcore.width=%d, core.height=%d, num_children=%d, num_slots=%d, border_width=%d\
\n\told.width=%d, \
old.height=%d, prefer.width=%d, prefer.height=%d, default_spacing=%d\n",
	   lw->core.width,
	   lw->core.height,
	   lw->composite.num_children,
	   lw->composite.num_slots,
	   lw->core.border_width,
	   lw->form.old_width,
	   lw->form.old_height,
	   lw->form.preferred_width,
	   lw->form.preferred_height,
	   lw->form.default_spacing);

}

void getBoxValues(lw, c)
BoxWidget lw;
char *c;
{

    printf("%s:\n",c);
    printf("\tcore.width=%d, core.height=%d, core.border_width=%d\n",
	   lw->core.width,
	   lw->core.height,
	   lw->core.border_width);

}
void getVportValues(lw, c)
ViewportWidget lw;
char *c;
{

    printf("%s:\n",c);
    printf("\tcore.width=%d, core.height=%d, core.border_width=%d\n",
	   lw->core.width,
	   lw->core.height,
	   lw->core.border_width);

}
Dimension getBoxHeight(lw)
BoxWidget lw;
{
    return(lw->core.height);
}
Dimension getPreferHeight(lw)
FormWidget lw;
{
    return(lw->form.preferred_height);
}
Dimension getLabelWidth(w)
LabelWidget w;
{
    return(w->core.width);
}
Dimension getLabelHeight(w)
LabelWidget w;
{
    return(w->core.height);
}
Position getLabelXpos(w)
LabelWidget w;
{
    return(w->core.x);
}
Position getLabelYpos(w)
LabelWidget w;
{
    return(w->core.y);
}
Dimension getFormWidth(lw)
FormWidget lw;
{
    return(lw->core.width);
}
Dimension getVportBorder(lw)
ViewportWidget lw;
{
    return(lw->core.border_width);
}
Dimension getFormBorder(lw)
FormWidget lw;
{
    return(lw->core.border_width);
}
Dimension getFormHeight(lw)
FormWidget lw;
{
    return(lw->core.height);
}
void setDialogWidth(w,size)
DialogWidget w;
Dimension size;
{
    w->core.width = size;
}
Bool isDialogVisible(w)
DialogWidget w;
{
    return(w->core.visible);
}
Dimension showDialogStruct(w)
DialogWidget w;
{
    return(w->core.width);
}
Dimension showTextWidth(w)
TextWidget w;
{
    return(w->core.width);
}
Dimension showTextHeight(w)
TextWidget w;
{
    return(w->core.height);
}
Dimension getVportWidth(lw)
ViewportWidget lw;
{
    return(lw->core.width);
}
void Syntax(argc, argv)
int argc;
char * argv[];
{
    int i;
    static int errs = FALSE;
    for (i=1; i<argc; i++) {
	if (!errs++)		/* for first time through */
	    fprintf(stderr, "%s: command line option %s unknown:\n", argv[0], argv[i]);
    }
    fprintf(stderr, "%s understands all standard Xt command line options.\n", argv[0]);

    fprintf(stderr, "Additional options are:\n");
    fprintf(stderr, "OPTION     FUNCTION                   VALID RANGE      DEFAULT\n");
    fprintf(stderr, "-interval  update interval            1 to 60 seconds  1 second\n");
    fprintf(stderr, "-count     quit after count updates   1 to 1000        0 (no limit)\n");
    exit();
}
/*
 * yes button ( quit function)
 */
/*ARGSUSED*/
void Yes(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
    extern XtTimerCallbackProc done();

    int i = 1;
    client_data = (char *)i;
    done();
    quitSoon = XtAppAddTimeOut (app_context, (unsigned long)(1000), done, (caddr_t)0);
}
/*
 * no button
 */
/*ARGSUSED*/
void No(w, client_data, call_data)
Widget w;
XtPointer client_data; /* cast to topLevel */
XtPointer call_data;
{
    XtPopdown (pshell);
    XtSetSensitive(quit,TRUE);
    return;
}
/*
  Done routine.  In this routine you can put any sort of exit processing you wish!
*/
/*ARGSUSED*/
XtTimerCallbackProc
done(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
    int i;

    exit();
}

/*
 *	Function name:	SetPopup
 *	Description:	This function pops up the specified dialog box.
 *	Arguments:	wdg - the widget to be popped up.
 *	Returns:	None.
 */

void SetPopup(wdg)
Widget wdg;
{
    Position x=0, y=0;
    Window rwin;
    Window chwin;
    int rx, ry, wx, wy;
    Dimension wd = 0;
    Dimension he = 0;
    unsigned int mask;
    
    /* Make the popup shell "wdg" come up at the current pointer position */

    XQueryPointer(XtDisplay(topLevel),XtWindow(topLevel),&rwin,&chwin,&rx,&ry,
		  &wx,&wy,&mask);
    
    XtSetArg(args[0], XtNwidth, &wd);
    XtSetArg(args[1], XtNheight, &he);
    XtGetValues(wdg, args, (Cardinal)2);
    if (wd == 0) wd = DIALOGWIDTH;
    if (he == 0) he = DIALOGHEIGHT;
    
    x = rx - wd/2;
    y = (ry - he/2) + he;
    
    XtSetArg(args[0], XtNx, x);
    XtSetArg(args[1], XtNy, y);
    XtSetValues(pshell, args, (Cardinal)2);
    XtSetSensitive(quit, FALSE);

/* see if any changes were made and not saved */

    if (formHasChanged){
	XtMapWidget(warning);
	XBell (XtDisplay(topLevel), 0);
    }
    /* Popup the widget */

    XtPopup(pshell, XtGrabExclusive);
}

