#include "../lp.h"
#include "../lps.h"
#include "editprintcap.h"
#include <string.h>

extern  int     nitems, row, colume;
extern  char    *progname;
extern  char    *buff;
extern  char    stringList[NUM_QUEUES][80];
extern  Entry entry[];
extern  struct Pcap{
    char   *printer[NUM_NAMES];
    Entry  entry[NPCAPS];
} pcap[NUM_QUEUES], *pcap_ptr, *pc;
extern char line[BUFSIZ];
extern char pbuf[BUFSIZ/2];

char assignedTo[32][32];

static void printQueueList()
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<NUM_QUEUES; i++){
	if (pcap[i].printer[0] != NULL){
	    sprintf (cp, "%s ", pcap[i].printer[0]);
	    cp += strlen(pcap[i].printer[0]) + 1;
	}
    }
    printf ("%s\n", pbuf);
}

static void printTestQueueList()
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<NUM_QUEUES; i++){
	if (pcap[i].printer[0] != NULL){
	    if (strstr(pcap[i].printer[0],"test")!=NULL){
		sprintf (cp, "%s ", pcap[i].printer[0]);
		cp += strlen(pcap[i].printer[0]) + 1;
	    }
	}
    }
    printf ("%s\n", pbuf);
}

static void printCPFQueueList()
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<NUM_QUEUES; i++){
	if (pcap[i].printer[0] != NULL){
	    if (strstr(pcap[i].printer[0],"cpf")!=NULL){
		sprintf (cp, "%s ", pcap[i].printer[0]);
		cp += strlen(pcap[i].printer[0]) + 1;
	    }
	}
    }
    printf ("%s\n", pbuf);
}

static void printDeviceList()
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<NUM_QUEUES; i++){
	if (assignedTo[i] != NULL){
	    if (strstr(pbuf, assignedTo[i]) == NULL){
		sprintf (cp, "%s ", assignedTo[i]);
		cp += strlen(assignedTo[i]) + 1;
	    }
	}
    }
    if (cp != pbuf) printf ("%s\n", pbuf);
}

static void printLocalDeviceList()
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<NUM_QUEUES; i++){
	if (assignedTo[i] != NULL){
	    if (strstr(assignedTo[i], "@") == NULL)
		if (strstr(pbuf, assignedTo[i]) == NULL){
		    sprintf (cp, "%s ", assignedTo[i]);
		    cp += strlen(assignedTo[i]) + 1;
		}
	}
    }
    if (cp != pbuf) 
	printf ("%s\n", pbuf);
    else
	printf ("NO local assignments\n");

}

static void printRemoteDeviceList()
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<NUM_QUEUES; i++){
	if (assignedTo[i] != NULL){
	    if (strstr(assignedTo[i], "@") != NULL){
		if (strstr(pbuf, assignedTo[i]) == NULL){
		    sprintf (cp, "%s ", assignedTo[i]);
		    cp += strlen(assignedTo[i]) + 1;
		}
	    }
	}
    }
    if (cp != pbuf) 
	printf ("%s\n", pbuf);
    else
	printf ("NO remote assignments\n");
}

static void printQueAssign(dev)	/* print a list of queues assigned to device dev */
char *dev;
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<nitems; i++){
	if (strcmp(dev,assignedTo[i]) == NULL){
	    sprintf (cp, "%s ", pcap[i].printer[0]);
	    cp += strlen(pcap[i].printer[0]) + 1;
	}
    }
    if (cp != pbuf) 
	printf ("%s\n", pbuf);
    else
	printf ("NO assignments to device %s\n", dev);
}

static void printDevAssign(que)	/* print the device queue que is assigned to*/
char *que;
{
    int i;
    char * cp;

    cp = pbuf;
    for (i=0; i<nitems; i++){
	if (strcmp(que, pcap[i].printer[0]) == NULL){
	    sprintf (cp, "%s ", assignedTo[i]);
	    cp += strlen(pcap[i].printer[0]) + 1;
	    break;
	}
    }
    if (cp != pbuf) 
	printf ("%s\n", pbuf);
    else
	printf ("ERROR - Can't find queue %s\n", que);
}

static void syntax()
{
    fprintf(stderr, "Command Line Options are one only of:\n");
    fprintf (stderr, "\t[-][qQ]\t\tList all queue names (Default)\n");
    fprintf (stderr, "\t[-][qQ] dev\tReturn all queue names assigned to device dev\n");
    fprintf (stderr, "\t[-][tT]\t\tList all non-production queue names (i.e. test queues)\n");
    fprintf (stderr, "\t[-][pP]\t\tList all Production queue names\n");
    fprintf (stderr, "\t[-][dD]\t\tList all devices assigned by printcap \n");
    fprintf (stderr, "\t[-][dD] que\tReturn device assignment for queue que\n");
    fprintf (stderr, "\t[-][lL]\t\tList only local devices assigned by printcap\n");
    fprintf (stderr, "\t[-][rR]\t\tList only remote devices assigned by printcap\n");
    fprintf (stderr, "\t[-][hH]\t\tHELP - print this list\n");
}

static void badSwitch(badswitch)
char *badswitch;
{
    fprintf(stderr, "ERROR - Can't recognize command line option %s\n", badswitch);
    syntax();
}

main(argc, argv)
int argc;
char **argv;
{
    int      i, i1, i2, *p;
    int      rm, lp, of;
    register char *cp1, *cp2, *cp;

    nitems = 0;
    progname = argv[0];

/* go get data and populate all of the arrays and structures */

    if ((getData()) != 0) exit(); 

/* figure out which device each queue is assigned to*/
    
    for (i1=0; i1<NPCAPS; i1++){
	if (strcmp(entry[i1].name, "of") == NULL) of = i1; /* find the index to the "of" field */
	if (strcmp(entry[i1].name, "lp") == NULL) lp = i1; /* find index to lp field */
	if (strcmp(entry[i1].name, "rm") == NULL) rm = i1; /* find index to rm field */
    }
    for (i=0; i<nitems; i++){
	pc = &pcap[i];
	cp1 = NULL;
	if (pc->entry[of].cvalueptr != NULL){
	    if (strstr(pc->entry[of].cvalueptr, "iplpscomm") != NULL){
		cp1 = strtok(pc->entry[of].cvalueptr, " ");
		cp1 = strtok(NULL, " ");
	    }
	    else if ((pc->entry[lp].cvalueptr) != NULL)
		cp1 = pc->entry[lp].cvalueptr;
	}
	else if ((pc->entry[lp].cvalueptr) != NULL)
	    cp1 = pc->entry[lp].cvalueptr;
	if (cp1 != NULL){
	    strcpy (assignedTo[i], cp1);
	    if (cp1[0] == NULL){
		strcpy (assignedTo[i], "@");
		strcat (assignedTo[i], pc->entry[rm].cvalueptr);
		strtok (assignedTo[i], ".");
	    }
	}
    }
    if (argc == 1){
	printQueueList();
    }
    else if (argc >= 2 && argc <= 3){
	cp = argv[1];
	if (cp[0] == '-') cp++;
	switch (cp[0]){
	case 'q':
	case 'Q':
	    if (argc == 2){
		printQueueList();
	    }
	    else if (argc == 3)
		printQueAssign(argv[2]);
	    break;
	case 't':
	case 'T':
	    printTestQueueList();
	    break;
	case 'p':
	case 'P':
	    printCPFQueueList();
	    break;
	case 'd':
	case 'D':
	    if (argc == 2){
		printDeviceList();
	    }
	    else if (argc == 3)
		printDevAssign(argv[2]);
	    break;
	case 'l':
	case 'L':
	    printLocalDeviceList();
	    break;
	case 'r':
	case 'R':
	    printRemoteDeviceList();
	    break;
	case 'h':
	case 'H':
	    syntax();
	    break;
	default:
	    badSwitch(argv[1]);
	    break;
	}
    }
    else{
	printf ("ERROR - too many arguments\n");
	syntax();
    }
}    
