#include "../lp.h"
#include "../lps.h"
#include "editprintcap.h"

Entry entry[] = {
    {STR, "af", NULL, NULL, NULL, NULL},
    {NUMV, "br", NULL, NULL, NULL, NULL},
    {STR, "cf", NULL, NULL, NULL, NULL},
    {STR, "ct", NULL, NULL, NULL, NULL},
    {NUMV, "db", NULL, NULL, NULL, NULL},
    {STR, "df", NULL, NULL, NULL, NULL},
    {NUMV, "du", NULL, NULL, NULL, NULL},
    {NUMV, "fc", NULL, NULL, NULL, NULL},
    {STR, "ff", NULL, NULL, NULL, NULL},
    {BOOL,"fo", NULL, NULL, NULL, NULL},
    {NUMV, "fs", NULL, NULL, NULL, NULL},
    {STR, "gf", NULL, NULL, NULL, NULL},
    {STR, "if", NULL, NULL, NULL, NULL},
    {STR, "lf", NULL, NULL, NULL, NULL},
    {STR, "lo", NULL, NULL, NULL, NULL},
    {STR, "lp", NULL, NULL, NULL, NULL},
    {NUMV, "mc", NULL, NULL, NULL, NULL},
    {NUMV, "mx", NULL, NULL, NULL, NULL},
    {STR, "nf", NULL, NULL, NULL, NULL},
    {STR, "of", NULL, NULL, NULL, NULL},
    {STR, "op", NULL, NULL, NULL, NULL},
    {STR, "os", NULL, NULL, NULL, NULL},
    {NUMV, "pl", NULL, NULL, NULL, NULL},
    {STR, "pp", NULL, NULL, NULL, NULL},
    {STR, "ps", NULL, NULL, NULL, NULL},
    {NUMV, "pw", NULL, NULL, NULL, NULL},
    {NUMV, "px", NULL, NULL, NULL, NULL},
    {NUMV, "py", NULL, NULL, NULL, NULL},
    {STR, "rf", NULL, NULL, NULL, NULL},
    {STR, "rm", NULL, NULL, NULL, NULL},
    {STR, "rp", NULL, NULL, NULL, NULL},
    {BOOL,"rs", NULL, NULL, NULL, NULL},
    {BOOL,"rw", NULL, NULL, NULL, NULL},
    {BOOL,"sb", NULL, NULL, NULL, NULL},
    {BOOL,"sc", NULL, NULL, NULL, NULL},
    {STR, "sd", NULL, NULL, NULL, NULL},
    {BOOL,"sf", NULL, NULL, NULL, NULL},
    {BOOL,"sh", NULL, NULL, NULL, NULL},
    {STR, "st", NULL, NULL, NULL, NULL},
    {STR, "tf", NULL, NULL, NULL, NULL},
    {STR, "tr", NULL, NULL, NULL, NULL},
    {STR, "ts", NULL, NULL, NULL, NULL},
    {STR, "uv", NULL, NULL, NULL, NULL},
    {STR, "vf", NULL, NULL, NULL, NULL},
    {NUMV, "xc", NULL, NULL, NULL, NULL},
    {STR, "xf", NULL, NULL, NULL, NULL},
    {NUMV, "xs", NULL, NULL, NULL, NULL},
    {STR, "Da", NULL, NULL, NULL, NULL},
    {STR, "It", NULL, NULL, NULL, NULL},
    {STR, "Lu", NULL, NULL, NULL, NULL},
    {STR, "Ml", NULL, NULL, NULL, NULL},
    {STR, "Nu", NULL, NULL, NULL, NULL},
    {STR, "Or", NULL, NULL, NULL, NULL},
    {STR, "Ot", NULL, NULL, NULL, NULL},
    {STR, "Ps", NULL, NULL, NULL, NULL},
    {STR, "Sd", NULL, NULL, NULL, NULL},
    {STR, "Si", NULL, NULL, NULL, NULL},
    {STR, "Ss", NULL, NULL, NULL, NULL},
    {STR, "Ul", NULL, NULL, NULL, NULL},
    {STR, "Xf", NULL, NULL, NULL, NULL},
    {STR, "Lf", NULL, NULL, NULL, NULL},
    {STR, "Dl", NULL, NULL, NULL, NULL}
};

struct Pcap{
    char   *printer[NUM_NAMES];
    Entry  entry[NPCAPS];
} pcap[NUM_QUEUES], *pcap_ptr, *pc;

int  maxPnameLength[NUM_NAMES];				    /* max length in pixels of names in pcap.printer list */

char line[BUFSIZ];
char pbuf[BUFSIZ/2];
char *bp = pbuf;
char    *progname;
char    *buff;
char    stringList[NUM_QUEUES][80];
int     maxAltNames, totActiveColums=0;
int     nitems, row, colume;
struct  stat fileinfo;					    /* file information from fstat. */
time_t  fileModTime;					    /* time stamp from st_mtime field */

getData()
{
    int    i, i1, i2, *p;
    int  border=1;
    register int c, status;
    register char *cp1, *cp2;
    char prbuf[100];

    nitems = 0;

/*
 * Get file size and allocate a chunk of memory for the file to be 
 * copied into.
 */

    if ( stat("/etc/printcap", &fileinfo) ) {		    /* get fstat of /etc/printcap */
	fprintf(stderr,"Failure in fstat of /etc/printcap \n");
	return(FALSE);
    }
    fileModTime = fileinfo.st_mtime;                        /* remember time file was modified */

  /* leave space for the NULL */

    buff = (char *) XtMalloc(fileinfo.st_size + 1);	    /* get enough memory to hold the data */

    if (buff == NULL) {
	fprintf(stderr,
		"Could not allocate memory for parsing /etc/printcap.\n");
	return(FALSE);
    }

    for (i=0; i<NUM_QUEUES; i++){			    /* init structures */
	pcap_ptr = &pcap[i];
	bcopy(entry, pcap_ptr->entry, sizeof(entry));
    }
    while (getprent(line) > 0) {			    /* get a line from the printcap file */
	pcap_ptr = &pcap[nitems];
	cp1 = prbuf;
	cp2 = line;
	for (i=0; i<NUM_NAMES; i++){
	    while ((c = *cp2++) && c != '|' && c != ':')
		*cp1++ = c;
	    *cp1 = '\0';
	    strcpy(buff, prbuf);			    /* copy the queue name to our buffer */
	    pcap_ptr->printer[i] = buff;		    /* remember pointer to this name */
	    buff += strlen(buff) + 1;			    /* update the buffer pointer */
	    cp1 = prbuf;				    /* reset pointer to prbuf */
	    if (c == ':') break;			    /* quit parsing names when colon is seen */
	}
	bp = pbuf;
	for (i1=0; i1<NPCAPS; i1++){			    /* parse this entry for switches */
	    if (pcap_ptr->entry[i1].type == STR ||
		pcap_ptr->entry[i1].type == BOOL){
		if ((pcap_ptr->entry[i1].cvalueptr = pgetstr(pcap_ptr->entry[i1].name, &bp)) != NULL){
		    strcpy (buff, pcap_ptr->entry[i1].cvalueptr); /* copy the data to our buffer */
		    pcap_ptr->entry[i1].cvalueptr = buff;	    /* make our control structure point to this data */
		    entry[i1].bvalue = TRUE;		    /* remember that we found at least one of this switch */
		    if (strlen(pcap_ptr->entry[i1].cvalueptr) != 0)
			buff += strlen(buff) + 1;		    /* update the buffer pointer */
		    else
			buff += 1;				    /* leave room for a null entry */
		}
	    }
	    else if (pcap_ptr->entry[i1].type == NUMV){	    /* if type=NUM then get value and convert to string */
		if ((pcap_ptr->entry[i1].num = pgetnum(pcap_ptr->entry[i1].name, &bp)) != -1){
		    sprintf(buff, "%d", pcap_ptr->entry[i1].num);
		    pcap_ptr->entry[i1].cvalueptr = buff;	    /* make our control structure point to this data */
		    entry[i1].bvalue = TRUE;		    /* remember that we found at least one of this switch */
		    if (strlen(pcap_ptr->entry[i1].cvalueptr) != 0)
			buff += strlen(buff) + 1;		    /* update the buffer pointer */
		    else
			buff += 1;				    /* leave room for a null entry */
		}
	    }
	}
	if (nitems++ >= NUM_QUEUES) break;		    /* increment queue-name pointer */
    }

}
