#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>

#define NULL 0

/* function to print out statistics about a file. Taken from
   "Advanced UNIX Programming", Page 65. Invoke with:
                dspstatus(&sb)
    where sb is the stat structure returned from the stat
    system call. the call site should look like this:
    {
        struct stat sb;
	if (stat(path, &sb) == -1){
	   syserrmsg("stat");
	   return;
	   }
	dspstatus(&sb);
     }
******************************/

void dspstatus(sbp)
struct stat *sbp;
{
    struct passwd *pw, *getpwuid();
    struct group  *gr, *getgrgid();
    char   *name;

    if ((pw = getpwuid(sbp->st_uid)) == NULL)
	name = "???";
    else
	name = pw->pw_name;
    printf ("Owner ID: %d; Name: %s\n", sbp->st_uid, name);

    if ((gr = getgrgid(sbp->st_gid)) == NULL)
	name = "???";
    else
	name = gr->gr_name;
    printf ("Group ID: %d; Name: %s\n", sbp->st_gid, name);

    if ((sbp->st_mode & S_ISUID) == S_ISUID)
	printf ("Set user ID\n");
    if ((sbp->st_mode & S_ISGID) == S_ISGID)
	printf ("Set group ID\n");
    if ((sbp->st_mode & S_ISVTX) == S_ISVTX)
	printf ("Save Swapped text after use\n");
    printf ("Permissions: %o\n", sbp->st_mode & 0777);
    if ((sbp->st_mode & S_IWUSR) == S_IWUSR)
	printf ("Write by owner\n");
    if ((sbp->st_mode & S_IWGRP) == S_IWGRP)
	printf ("Write by group\n");
    if ((sbp->st_mode & S_IWOTH) == S_IWOTH)
	printf ("write by others\n");
}
    
