
/*
 * Routines and data common to all the line printer status functions.
 */

#include "lp.h"
#include "lps.h"
#include "buffer_names.h"

int     queue_count=0, q_count=0;

int	DU;		/* daeomon user-id */
int	MX;		/* maximum number of blocks to copy */
int	MC;		/* maximum number of copies allowed */
char	*LP;		/* line printer device name */
char	*RM;		/* remote machine name */
char	*RP;		/* remote printer name */
char	*LO;		/* lock file name */
char	*ST;		/* status file name */
char	*SD;		/* spool directory */
char	*AF;		/* accounting file */
char	*LF;		/* log file for error messages */
char	*OF;		/* name of output filter (created once) */
char	*IF;		/* name of input filter (created per job) */
char	*RF;		/* name of fortran text filter (per job) */
char	*TF;		/* name of troff filter (per job) */
char	*NF;		/* name of ditroff filter (per job) */
char	*DF;		/* name of tex filter (per job) */
char	*GF;		/* name of graph(1G) filter (per job) */
char	*VF;		/* name of vplot filter (per job) */
char	*CF;		/* name of cifplot filter (per job) */
char	*PF;		/* name of vrast filter (per job) */
char	*FF;		/* form feed string */
char	*TR;		/* trailer string to be output when Q empties */
short	SC;		/* suppress multiple copies */
short	SF;		/* suppress FF on each print job */
short	SH;		/* suppress header page */
short	SB;		/* short banner instead of normal header */
short	HL;		/* print header last */
short	RW;		/* open LP for reading and writing */
short	PW;		/* page width */
short	PL;		/* page length */
short	PX;		/* page width in pixels */
short	PY;		/* page length in pixels */
short	BR;		/* baud rate if lp is a tty */
int	FC;		/* flags to clear if lp is a tty */
int	FS;		/* flags to set if lp is a tty */
int	XC;		/* flags to clear for local mode */
int	XS;		/* flags to set for local mode */
short	RS;		/* restricted to those with local accounts */

char	line[BUFSIZ];
char	pbuf[BUFSIZ/2];	/* buffer for printcap strings */
char	*bp = pbuf;	/* pointer into pbuf for pgetent() */
char	*name;		/* program name */
char	*printer;	/* printer name */
char	host[MAX_QUEUES];	/* host machine name */
char	*from = host;	/* client's machine name */
char    RMnames[MAX_QUEUES][28];
int     s[MAX_QUEUES] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; /* socket number */
Bool    socket_alive[MAX_QUEUES];
struct  sockaddr_in sin;
struct  in_addr local_in_addr[MAX_QUEUES];
int     h_length[MAX_QUEUES];
short   local_h_addrtype[MAX_QUEUES];
unsigned short local_sin_port[MAX_QUEUES];
Bool    lpsd[MAX_QUEUES];       /* each element of this array is set to true if the socket is a lpsd socket, false if not */

/*
 * Create a connection to the remote printer server.
 * Most of this code comes from rcmd.c.
 */
getport(rhost, ptr)
	char *rhost;
        int  ptr;
{
    int timo = 1, lport = IPPORT_RESERVED - 1;
    int err, i;
    int retrycnt = 1;
    struct hostent *thp;
    struct servent *sp;
    /*
     * Get the host address and port number to connect to.
     * the s[] array contains the socket descriptor for each active address.
     * the lpsd array contains true if the address was connected to via the "printer_status" port,
     * and false if it was connected to via the "printer" port.
     *
     *                                **** NOTE ****
     * you must create another entry in the /etc/services file on both the local host,
     * and each remote host, for the new service socket:
     *  	  printer_status  516/tcp         spooler         # lps - line printer status program
     * this also assumes that you have properly installed and started the lpsd daemon on
     * each remote host, and possibly the local host (if any queues are serviced by a 
     * locally connected printer).
     */

    if (s[ptr] != 0 && lpsd[ptr]) {
	return(s[ptr]);
    }
    if (s[ptr] && !lpsd[ptr] && socket_alive[ptr])
	return(s[ptr]);
    if (s[ptr] == 0) {
	if (rhost == NULL)
	    fatal("no remote host to connect to");
	for (i=0; i<MAX_QUEUES; i++)
	    if (strcmp(RMnames[i], rhost) == NULL && lpsd[i] ){
		s[ptr] = s[i];
		lpsd[ptr] = TRUE;
		return(s[ptr]);
	    }
	thp = gethostbyname(rhost);
	if (thp->h_name == NULL)
	    fatal("unknown host %s", rhost);
	h_length[ptr] = thp->h_length;
	bcopy (thp->h_addr, &local_in_addr[ptr], h_length[ptr]);
	local_h_addrtype[ptr] = thp->h_addrtype;
	sp = getservbyname("printer_status", "tcp");
	if (sp == NULL){
retry:
	    fprintf(stderr, "Warning - printer_status/tcp: unknown service. Trying printer/tcp...\n");
	    sp = getservbyname("printer", "tcp");
	    if (sp == NULL)
		fatal("printer/tcp: unknown service");
	    else
		lpsd[ptr] = FALSE;
	}
	else
	    lpsd[ptr] = TRUE;
	local_sin_port[ptr] = sp->s_port;
	printf("for host %s portid for #%d = %d\n", rhost, ptr, htons(local_sin_port[ptr]));
    }
    bzero((char *)&sin, sizeof(sin));
    bcopy(&local_in_addr[ptr], (caddr_t)&sin.sin_addr, h_length[ptr]);
    sin.sin_family = local_h_addrtype[ptr];
    sin.sin_port = local_sin_port[ptr];
    
    /*
     * Try connecting to the server.
     */
    s[ptr] = rresvport(&lport);
    if (s[ptr] < 0){
	fprintf(stderr,"Warning - Couldnt reserve port for queue #%d for host %s\n", ptr, rhost);
	return(-1);
    }
    if (connect(s[ptr], (caddr_t)&sin, sizeof(sin)) < 0) {
	err = errno;
	(void) close(s[ptr]);
	errno = err;
	s[ptr]=0;
	lpsd[ptr]=FALSE;
	if (errno == EADDRINUSE)
	    fprintf(stderr,"ERROR - Address already in use for host %s\n",
		    rhost);
	else if (errno == ECONNREFUSED)
	    fprintf(stderr, "ERROR - Connection refused by host %s\n",
		    rhost);
	if (retrycnt){
	    retrycnt--;
	    goto retry;
	}
	return(-1);
    }
/*
 * perform non-blocking I/O on sockets which are not talking to lpsd.
 */
    if ( !lpsd[ptr] ) {
	socket_alive[ptr] = 1;
	if (fcntl(s[ptr], F_SETFL, FNDELAY) < 0) {
	    fprintf(stderr,"setting non-blocking fcntl bit in common for port %d on host %s",
		    s[ptr], rhost);
	    socket_alive[ptr]=FALSE;
	}
    }
    strcpy(RMnames[ptr], rhost);
    return(s[ptr]);
}

/*
 * Getline reads a line from the control file cfp, removes tabs, converts
 *  new-line to null and leaves it in line.
 * Returns 0 at EOF or the number of characters read.
 */
getline(cfp)
	FILE *cfp;
{
	register int linel = 0;
	register char *lp = line;
	register c;

	while ((c = getc(cfp)) != '\n') {
		if (c == EOF)
			return(0);
		if (c == '\t') {
			do {
				*lp++ = ' ';
				linel++;
			} while ((linel & 07) != 0);
			continue;
		}
		*lp++ = c;
		linel++;
	}
	*lp++ = '\0';
	return(linel);
}

/*
 * Scan the current directory and make a list of daemon files sorted by
 * creation time.
 * Return the number of entries and a pointer to the list.
 */
getq(namelist, item)
    struct queue *(*namelist[]);
    int  item;
{
	register struct direct *d;
	register struct queue *q, **queue;
	register int nitems;
	struct stat stbuf;
	int arraysz, compar();
	DIR *dirp;

	if ((dirp = opendir(buf0->qdata[item][SDI])) == NULL){
	    fprintf(stderr, "in getq couldn't open dir %s: errno = %d\n",
		    buf0->qdata[item][SDI],
		    errno);
	    return(-1);
	}
	if (fstat(dirp->dd_fd, &stbuf) < 0)
	    goto errdone;

	/*
	 * Estimate the array size by taking the size of the directory file
	 * and dividing it by a multiple of the minimum size entry. 
	 */
	arraysz = (stbuf.st_size / 24);
	queue = (struct queue **)malloc(arraysz * sizeof(struct queue *));
#ifdef DEBUG
	queue_count++;
	printf("malloc for queue for item #%d\n",item);
#endif
	if (queue == NULL)
		goto errdone;

	nitems = 0;
	while ((d = readdir(dirp)) != NULL) {
		if (d->d_name[0] != 'c' || d->d_name[1] != 'f')
			continue;	/* daemon control files only */
		if (stat(d->d_name, &stbuf) < 0)
			continue;	/* Doesn't exist */
		q = (struct queue *)malloc(sizeof(time_t)+strlen(d->d_name)+1);
#ifdef DEBUG
		q_count++;
		printf("malloc for q for item #%d\n",item);
#endif
		if (q == NULL)
			goto errdone;
		q->q_time = stbuf.st_mtime;
		strcpy(q->q_name, d->d_name);
		/*
		 * Check to make sure the array has space left and
		 * realloc the maximum size.
		 */
		if (++nitems > arraysz) {
			queue = (struct queue **)realloc((char *)queue,
				(stbuf.st_size/12) * sizeof(struct queue *));
			if (queue == NULL)
				goto errdone;
		}
		queue[nitems-1] = q;
	}
	closedir(dirp);
	if (nitems)
		qsort(queue, nitems, sizeof(struct queue *), compar);
	*namelist = queue;
	return(nitems);

errdone:
	closedir(dirp);
	return(-1);
}

/*
 * Compare modification times.
 */
static
compar(p1, p2)
	register struct queue **p1, **p2;
{
	if ((*p1)->q_time < (*p2)->q_time)
		return(-1);
	if ((*p1)->q_time > (*p2)->q_time)
		return(1);
	return(0);
}

/*VARARGS1*/
fatal(msg, a1, a2, a3)
	char *msg;
{
	if (from != host)
		printf("%s: ", host);
	printf("%s: ", name);
	if (printer)
		printf("%s: ", printer);
	printf(msg, a1, a2, a3);
	putchar('\n');
	exit(1);
}
