/* units.c -- stuff for the units dialog				*/
/*
 * Copyright (c) 1993  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */

#include "xdatplot.h"

#ifdef	__STDC__
static	void	units_ok_cb(Widget, Widget, XmPushButtonCallbackStruct *);
static	void	units_apply_cb(Widget, Widget, XmPushButtonCallbackStruct *);
static	void	units_cancel_cb(Widget, Widget, XmPushButtonCallbackStruct *);
static	void	units_help_cb(Widget, Widget, XmPushButtonCallbackStruct *);
static	void	toggle_changed_cb(Widget, Widget,
				  XmToggleButtonCallbackStruct *);
static	void	copy_fields_into_resources(void);
#else	/* __STDC__ */
static	void	units_ok_cb();
static	void	units_apply_cb();
static	void	units_cancel_cb();
static	void	units_help_cb();
static	void	toggle_changed_cb();
static	void	copy_fields_into_resources();
#endif	/* __STDC__ */

Widget	t_units_field = NO_WIDGET;
Widget	t_gain_field = NO_WIDGET;
Widget	t_mul_field = NO_WIDGET;
Widget	t_mul_toggle = NO_WIDGET;
Widget	v_units_field = NO_WIDGET;
Widget	v_gain_field = NO_WIDGET;
Widget	v_mul_field = NO_WIDGET;
Widget	v_mul_toggle = NO_WIDGET;

Widget
make_units_dialog()
{
    Widget		units_sh;
    char		lbuf[LLEN];
    String		s;
    Widget		units_form;
    Widget		units_ok_button;
    Widget		units_apply_button;
    Widget		units_cancel_button;
    Widget		units_help_button;
    Widget		units_action_frame;
    Widget		units_action_form;
    Widget		units_units_frame;
    Widget		units_units_form;
    Widget		label;
    
    /*
     * Create the dialog shell and a form widget to go in it
     */
    XtVaGetValues(toplevel, XmNtitle, &s, NULL);
    sprintf(lbuf, "%s Analyze Units", s);
    units_sh = XtVaAppCreateShell("unitsShell", "UnitsShell",
	topLevelShellWidgetClass, XtDisplay(toplevel),
	XtNtitle, lbuf,
	XmNiconName, "units",
	XmNiconPixmap, app_data.icon,
	XmNdeleteResponse, XmUNMAP,
    NULL);
    units_form = XtVaCreateWidget("unitsForm",
	xmFormWidgetClass, units_sh,
    NULL);
    /*
     * Create the action area
     */
    units_action_frame = XtVaCreateManagedWidget("unitsActionFrame",
	xmFrameWidgetClass, units_form,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
    NULL);
    units_action_form = XtVaCreateWidget("unitsActionForm",
	xmFormWidgetClass, units_action_frame,
    NULL);
    units_ok_button = XtVaCreateManagedWidget("unitsOkButton",
	xmPushButtonWidgetClass, units_action_form,
    NULL);
    AddCallback(units_ok_button, XmNactivateCallback, units_ok_cb, units_sh);
    units_apply_button = XtVaCreateManagedWidget("unitsApplyButton",
	xmPushButtonWidgetClass, units_action_form,
    NULL);
    AddCallback(units_apply_button, XmNactivateCallback,
		units_apply_cb, units_sh);
    units_cancel_button = XtVaCreateManagedWidget("unitsCancelButton",
	xmPushButtonWidgetClass, units_action_form,
    NULL);
    AddCallback(units_cancel_button, XmNactivateCallback,
		units_cancel_cb, units_sh);
    units_help_button = XtVaCreateManagedWidget("unitsHelpButton",
	xmPushButtonWidgetClass, units_action_form,
    NULL);
    AddCallback(units_help_button, XmNactivateCallback,
		units_help_cb, units_sh);
    XtManageChild(units_action_form);
    /*
     * Create the widget for editing units
     */
    units_units_frame = XtVaCreateManagedWidget("unitsFrame",
	xmFrameWidgetClass, units_form,
	XmNshadowType, XmSHADOW_ETCHED_IN,
	XmNbottomAttachment, XmATTACH_WIDGET,
	XmNbottomWidget, units_action_frame,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
    NULL);
    units_units_form = XtVaCreateManagedWidget("unitsUnitsForm",
	xmFormWidgetClass, units_units_frame,
    NULL);
    t_mul_field = XtVaCreateManagedWidget("tMultiplierField",
	xmTextFieldWidgetClass, units_units_form,
    NULL);
    AddCallback(t_mul_field, XmNactivateCallback, units_apply_cb, units_sh);
    t_mul_toggle = XtVaCreateManagedWidget("tMultiplierToggle",
	xmToggleButtonWidgetClass, units_units_form,
	XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
	XmNtopWidget, t_mul_field,
	XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	XmNbottomWidget, t_mul_field,
    NULL);
    AddCallback(t_mul_toggle, XmNvalueChangedCallback,
		toggle_changed_cb, t_mul_field);
    label = XtVaCreateManagedWidget("tMultiplierLabel",
	xmLabelWidgetClass, units_units_form,
	XmNbottomAttachment, XmATTACH_WIDGET,
	XmNbottomWidget, t_mul_field,
    NULL);
    t_gain_field = XtVaCreateManagedWidget("tGainField",
	xmTextFieldWidgetClass, units_units_form,
    NULL);
    AddCallback(t_gain_field, XmNactivateCallback, units_apply_cb, units_sh);
    label = XtVaCreateManagedWidget("tGainLabel",
	xmLabelWidgetClass, units_units_form,
	XmNbottomAttachment, XmATTACH_WIDGET,
	XmNbottomWidget, t_gain_field,
    NULL);
    t_units_field = XtVaCreateManagedWidget("tUnitsField",
	xmTextFieldWidgetClass, units_units_form,
    NULL);
    AddCallback(t_units_field, XmNactivateCallback, units_apply_cb, units_sh);
    label = XtVaCreateManagedWidget("tUnitsLabel",
	xmLabelWidgetClass, units_units_form,
	XmNbottomAttachment, XmATTACH_WIDGET,
	XmNbottomWidget, t_units_field,
    NULL);
    v_mul_field = XtVaCreateManagedWidget("vMultiplierField",
	xmTextFieldWidgetClass, units_units_form,
    NULL);
    AddCallback(v_mul_field, XmNactivateCallback, units_apply_cb, units_sh);
    v_mul_toggle = XtVaCreateManagedWidget("vMultiplierToggle",
	xmToggleButtonWidgetClass, units_units_form,
	XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
	XmNtopWidget, v_mul_field,
	XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	XmNbottomWidget, v_mul_field,
    NULL);
    AddCallback(v_mul_toggle, XmNvalueChangedCallback,
		toggle_changed_cb, v_mul_field);
    label = XtVaCreateManagedWidget("vMultiplierLabel",
	xmLabelWidgetClass, units_units_form,
	XmNbottomAttachment, XmATTACH_WIDGET,
	XmNbottomWidget, v_mul_field,
    NULL);
    v_gain_field = XtVaCreateManagedWidget("vGainField",
	xmTextFieldWidgetClass, units_units_form,
    NULL);
    AddCallback(v_gain_field, XmNactivateCallback, units_apply_cb, units_sh);
    label = XtVaCreateManagedWidget("vGainLabel",
	xmLabelWidgetClass, units_units_form,
	XmNbottomAttachment, XmATTACH_WIDGET,
	XmNbottomWidget, v_gain_field,
    NULL);
    v_units_field = XtVaCreateManagedWidget("vUnitsField",
	xmTextFieldWidgetClass, units_units_form,
    NULL);
    AddCallback(v_units_field, XmNactivateCallback, units_apply_cb, units_sh);
    label = XtVaCreateManagedWidget("vUnitsLabel",
	xmLabelWidgetClass, units_units_form,
	XmNbottomAttachment, XmATTACH_WIDGET,
	XmNbottomWidget, t_units_field,
    NULL);
    copy_resources_into_fields();
    /*
     * manage the dialog form and return
     */
    XtManageChild(units_form);
    return(units_sh);
}

static void
copy_fields_into_resources()
{
    String		s;
    String		t;
    double		tmul, tgain;
    double		vmul, vgain;
    Bool		err;
    String		**fp;

    s = XmTextFieldGetString(t_gain_field);
    tgain = strtod(s, &t);
    err = ('\0' != t[strspn(t, WHITE)]);
    Free(s);
    if (err) {
	PU_error("t gain is not a number", "units.html");
	return;
    }
    if (0.0 >= tgain) {
	PU_error("t gain must be positive", "units.html");
	return;
    }

    s = XmTextFieldGetString(v_gain_field);
    vgain = strtod(s, &t);
    err = ('\0' != t[strspn(t, WHITE)]);
    Free(s);
    if (err) {
	PU_error("V gain is not a number", "units.html");
	return;
    }
    if (0.0 >= vgain) {
	PU_error("V gain must be positive", "units.html");
	return;
    }

    if (err = XmToggleButtonGetState(t_mul_toggle)) {
	s = XmTextFieldGetString(t_mul_field);
	tmul = strtod(s, &t);
	err = ('\0' != t[strspn(t, WHITE)]);
	Free(s);
	if (err) {
	    PU_error("t multiplier is not a number", "units.html");
	    return;
	}
	if (0.0 >= tmul) {
	    PU_error("multiplier must be positive", "units.html");
	    return;
	}
    }
    else {
	tmul = quiet_nan(0);
    }

    if (err = XmToggleButtonGetState(v_mul_toggle)) {
	s = XmTextFieldGetString(v_mul_field);
	vmul = strtod(s, &t);
	err = ('\0' != t[strspn(t, WHITE)]);
	Free(s);
	if (err) {
	    PU_error("v multiplier is not a number", "units.html");
	    return;
	}
	if (0.0 >= vmul) {
	    PU_error("multiplier must be positive", "units.html");
	    return;
	}
    }
    else {
	vmul = quiet_nan(0);
    }

    /*
     * if we arrived here, there are no format errors
     */
    fp = save_filter_params(destination_filter(&DF_FIL));
    Nfree(T_UNITS);
    s = XmTextFieldGetString(t_units_field);
    T_UNITS = XtNewString(s);
    Free(s);
    Nfree(V_UNITS);
    s = XmTextFieldGetString(v_units_field);
    V_UNITS = XtNewString(s);
    Free(s);
    T_GAIN = tgain;
    T_MULTIPLIER = tmul;
    set_tmul(tmul);
    V_GAIN = vgain;
    V_MULTIPLIER = vmul;
    set_vmul(vmul);
    restore_filter_params(destination_filter(&DF_FIL), fp);
    redo_whole();
}

void
copy_resources_into_fields()
{
    char		lbuf[LLEN];
    Bool		state;

    if (NO_WIDGET == t_units_field) return;
    XmTextFieldSetString(t_units_field, T_UNITS);
    XmTextFieldSetString(v_units_field, V_UNITS);
    sprintf(lbuf, "%g", T_GAIN);
    XmTextFieldSetString(t_gain_field, lbuf);
    sprintf(lbuf, "%g", V_GAIN);
    XmTextFieldSetString(v_gain_field, lbuf);
    state = !T_MUL_DEF;
    XmToggleButtonSetState(t_mul_toggle, state, FALSE);
    XmTextFieldSetEditable(t_mul_field, state);
    if (state)
	sprintf(lbuf, "%g", T_MULTIPLIER);
    else
	sprintf(lbuf, "%g", default_tmul());
    XmTextFieldSetString(t_mul_field, lbuf);
    state = !V_MUL_DEF;
    XmToggleButtonSetState(v_mul_toggle, state, FALSE);
    XmTextFieldSetEditable(v_mul_field, state);
    if (state)
	sprintf(lbuf, "%g", V_MULTIPLIER);
    else
	sprintf(lbuf, "%g", default_vmul());
    XmTextFieldSetString(v_mul_field, lbuf);
}

static void
toggle_changed_cb(toggle, field, cbs)
Widget				toggle;
Widget				field;
XmToggleButtonCallbackStruct	*cbs;
{
    char		lbuf[LLEN];

    dprintf("toggle_changed_cb\n");
    XmTextFieldSetEditable(field, cbs->set);
    if (!cbs->set) {
	sprintf(lbuf, "%g",
	    ((toggle == t_mul_toggle) ? default_tmul() : default_vmul())
	);
	XmTextFieldSetString(field, lbuf);
    }
}

static void
units_ok_cb(widget, units_sh, cbs)
Widget				widget;
Widget				units_sh;
XmPushButtonCallbackStruct	*cbs;
{
    dprintf("units_ok_cb\n");
    copy_fields_into_resources();
    XtPopdown(units_sh);
}

static void
units_apply_cb(widget, units_sh, cbs)
Widget				widget;
Widget				units_sh;
XmPushButtonCallbackStruct	*cbs;
{
    dprintf("units_apply_cb\n");
    copy_fields_into_resources();
}

static void
units_cancel_cb(widget, units_sh, cbs)
Widget				widget;
Widget				units_sh;
XmPushButtonCallbackStruct	*cbs;
{
    dprintf("units_cancel_cb\n");
    XtPopdown(units_sh);
}

static void
units_help_cb(widget, units_sh, cbs)
Widget				widget;
Widget				units_sh;
XmPushButtonCallbackStruct	*cbs;
{
    help_window("units.html");
}
