/* config.h.  Generated automatically by configure.  */
/* config.h.in -- configuration header source				*/
/*
 * Copyright (c) 1993  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */

/*
 * This header file should be included in all C programs, usually
 * following the #include's for system header files (e.g. stdio.h) and
 * preceding the #include's for program-specific headers.
 *
 * It defines the following:
 *
 * delete -- The function that deletes a file (unlink in unix)
 * bcopy, bcmp, bzero -- copy, compare, and clear bytes.  May be
 *	defined in terms of memmove, memcmp, memset
 * ON_EXIT -- defined as on_exit if available, otherwise empty
 * VFORK -- defined as VFORK if available, otherwise fork
 *
 * const, volatile -- defined as empty if not supported
 * void -- defined as int if not supported
 * INLINE -- defined as inline in gcc, empty otherwise
 * VOIDST -- generic pointer type (void * or char *)
 * SIGRET -- signal returns type SIGRET *
 * pid_t -- defined as int if not in sys/types.h
 *
 * MAXINT, MININT -- limits of int type
 * MAXLONG, MINLONG -- limits of long type
 * NOERR -- exit argument for success
 * ERROR -- exit argument for error
 *
 * These next three if not defined by stdio.h:
 * TRUE -- 1
 * FALSE -- 0
 * NULL -- ((VOIDST) 0)
 *
 * STARTUP -- { PROGNAME = *argv; argv++; argc--; }
 * EXITOK -- exit(NOERR)
 */
#ifndef	CONFIG_H
#define	CONFIG_H

/* These defines are set up by configure				*/
/* #undef	STDC_HEADERS */
#define	HAVE_LIMITS_H 1
#define	HAVE_STRING_H 1
#define	HAVE_MEMORY_H 1
#define	HAVE_MALLOC_H 1
#define	HAVE_VFORK_H 1
#define	HAS_FUNC_ATTR 1
/* #undef	INT_16_BITS */
/* #undef	LONG_64_BITS */
#define	WORDS_BIGENDIAN 1
/* #undef	const */
/* #undef	volatile */
/* #undef	void */
/* #undef	inline */
#define	RETSIGTYPE void
/* #undef	pid_t */
/* #undef	size_t */
#define	HAVE_ON_EXIT 1
#define	HAVE_VFORK 1
#define	HAVE_BCOPY 1
/* #undef	HAVE_MEMMOVE */

#include <stdio.h>
#include <sys/types.h>

#ifdef	__GNUC__
# define	INLINE	inline
#else	/* __GNUC__ */
# define	INLINE
#endif	/* __GNUC__ */

#ifdef	void
# define	VOIDST	char *
#else
# define	VOIDST	void *
#endif

#define	SIGRET	RETSIGTYPE

#define	delete	unlink
#define	LLEN	(0x400)

#ifdef	HAVE_MALLOC_H
# include <malloc.h>
#else	/* HAVE_MALLOC_H */
# ifdef	__STDC__
VOIDST	malloc(size_t)
VOIDST	realloc(VOIDST, size_t);
# else	/* __STDC__ */
VOIDST	malloc();
VOIDST	erealloc();
# endif	/* __STDC__ */
#endif	/* HAVE_MALLOC_H */

#ifdef	HAVE_LIMITS_H
/*
 * Pointless definitions of new symbols for limits.  This happened because
 * I initially defined my own values for these before limits.h was
 * common, and now I don't want to go back and change all my programs.
 */
# include <limits.h>
# define	MAXSHRT	SHRT_MAX
# define	MINSHRT	SHRT_MIN
# define	MAXINT	INT_MAX
# define	MININT	INT_MIN
# define	MAXLONG	LONG_MAX
# define	MINLONG	LONG_MIN
#else  /* HAVE_LIMITS_H */		/* conservative guesses		*/
# define	MAXSHRT	(32767)
# define	MINSHRT	(-32768)
# ifdef	INT_16_BITS
# define	MAXINT	(0x7fff)
# define	MININT	(-0x10000)
# else	/* INT_16_BITS */
# define	MAXINT	(0x7fffffff)
# define	MININT	(-0x100000000)
# endif	/* INT_16_BITS */
# ifdef	LONG_64_BITS
# define	MAXLONG	(0x7fffffffffffffff)
# define	MINLONG	(-0x10000000000000000)
# else	/* LONG_64_BITS */
# define	MAXLONG	(0x7fffffff)
# define	MINLONG	(-0x100000000)
# endif	/* LONG_64_BITS */
#endif	/* HAVE_LIMITS_H */

#ifndef	TRUE
# define	TRUE	(1)
#endif
#ifndef	FALSE
# define	FALSE	(0)
#endif
#ifndef	NULL
# define	NULL	(0)
#endif

#if	STDC_HEADERS || HAVE_STRING_H
# include <string.h>
# if 	!STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# define	STRCHR	strchr
# define	STRRCHR	strrchr
# if	!HAVE_BCOPY && HAVE_MEMMOVE
#  define	bcopy(s, d, n)	memmove((d), (s), (n))
# endif
# define	bcmp(s1, s2, n)	memcmp((s1), (s2), (n))
# define	bzero(s, n)	memset((s), 0, (n))
#else	/* not STDC_HEADERS and not HAVE_STRING_H */
# include <strings.h>
# define	STRCHR	index
# define	STRRCHR	rindex
#endif	/* not STDC_HEADERS and not HAVE_STRING_H */

#ifdef	HAVE_ON_EXIT
# ifdef __STDC__
int	on_exit(void (*)(), VOIDST);
# else
int	on_exit();
# endif
# define	ON_EXIT(x, y)	on_exit((x), (y))
#else
# define	ON_EXIT(x, y)
#endif

#ifdef	HAVE_VFORK
# ifdef	HAVE_VFORK_H
#  include <vfork.h>
# else
#  ifdef __STDC__
int	vfork(void);
#  else
int	vfork();
#  endif
# endif
# define VFORK	vfork
#else
# define VFORK	fork
#endif

#ifdef	STDC_HEADERS
# include <stdlib.h>
# ifdef	EXIT_SUCCESS
#  define	NOERR	EXIT_SUCCESS
#  define	ERROR	EXIT_FAIL
# endif
#endif	/* _STDC_HEADERS */
#ifndef	NOERR
# define	NOERR	0
# define	ERROR	1
#endif

#define	STARTUP	{ PROGNAME = *argv; argv++; argc--; }
#define	EXITOK	exit(NOERR)

#endif	/* not CONFIG_H */
