#ifndef _XBUFFY_H_
#define _XBUFFY_H_

#include <X11/Intrinsic.h>
#include "libdyn/dyn.h"
#include "patchlevel.h"

#define NEWSSERVER "murdoch.acc.Virginia.EDU"

#define MAX_STRING 256

#define NEW_MSG 1
#define OLD_MSG 2
#define READ_MSG 4
#define UNKNOWN 8
#define LINEFEED (char) 10

#define X_RESOURCE_CLASS "XBuffy" 

enum BoxType_e {
  MAILBOX = 0,
  NNTPBOX,
};
typedef enum BoxType_e BoxType_t;

enum BoxNameType_e {NONE = 0, SHORT, LONG, USR, UNDEF};
typedef enum BoxNameType_e BoxNameType_t;

struct articles_s
{
	long firstNum;
	long lastNum;
};

typedef struct articles_s Articles_t;	


struct BoxInfo_s{
  Widget w;
  int boxNum;			/* the box number */
  char *box;			/* the box filename or newsgroup */
  BoxType_t type;		/* the box type (mail, news, etc) */

  DynObject articles; /* for newsgroups, the read pairs  */

  time_t box_mtime;		/* last time read */
  off_t st_size;		/* size of file on last read */
  int n;				/* the number of messages in the box */
  
  char *command;
  char *audioCmd;
  char *boxTitle;
  int last;
  int pollTime;
  int headerTime;
  int nobeep;
  int origMode;
  BoxNameType_t BoxNameType;	
  
};
typedef struct BoxInfo_s BoxInfo_t;


extern char *header_cmp();
#endif /* _XBUFFY_H_ */
