/*
 * Programm XBLAST V1.00 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * January 16th 1994
 * started August 1993
 *
 * File: blastx11.c
 * graphics using X11 standard
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if defined(Lynx)
#define cfree free
#endif

#define MOUSE_CONTROL
#undef  MOUSE_CONTROL

#ifdef MOUSE_CONTROL
#include <X11/X.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <stdio.h>
#include "blastincl.h"
#include "blasttypes.h"
#include "blastconst.h"

#define BELL_VOLUME 80

#define QUIT_WITH_CONTROL_Q TRUE
#define USE_COPY_AREA FALSE


  /* Some constants */

#ifdef MOUSE_CONTROL
#define NORMAL_EVENT_MASK ( ExposureMask | StructureNotifyMask | KeyPressMask \
			   | ButtonPressMask | ButtonReleaseMask \
			   | Button3MotionMask )
#else
#define NORMAL_EVENT_MASK ( ExposureMask | StructureNotifyMask | KeyPressMask )
#endif

static char xbomb_font[]="-*-helvetica-bold-r-*-*-24-*-*-*-*-*-iso8859-*";
static char xbomb_alt_font[]="10x20";



  /* Extern Varaiables of bitmap data */

extern char sprite_mask[MAX_ANIME-1][SIZE_OF_SPRITE];
extern char sprite_bits[MAX_PLAYER][MAX_ANIME-1][SIZE_OF_SPRITE];
extern char winner_mask[SIZE_OF_WINNER];
extern char winner_bits[MAX_PLAYER][SIZE_OF_WINNER];
extern char expl_mask[MAX_EXPLOSION][SIZE_OF_BLOCK];
extern char expl_bits[MAX_EXPLOSION][SIZE_OF_BLOCK];
extern char block_tile[MAX_BLOCK_TILES][SIZE_OF_BLOCK];
extern char score_led[2][SIZE_OF_LED];
extern char score_tile[MAX_SCORE_TILES][SIZE_OF_BLOCK];



  /* Global Variables */

static Display *dpy[MAX_PLAYER];
static Window win[MAX_PLAYER];
static Pixmap pix[MAX_PLAYER];
static Pixmap pix_block[MAX_PLAYER][MAX_BLOCK];
static Pixmap pix_sprite_mask[MAX_PLAYER][MAX_ANIME];
static Pixmap pix_sprite_bits[MAX_PLAYER][MAX_PLAYER][MAX_ANIME];
static Pixmap pix_expl_mask[MAX_PLAYER][MAX_EXPLOSION];
static Pixmap pix_expl_bits[MAX_PLAYER][MAX_EXPLOSION];
static Pixmap pix_expl_block[MAX_PLAYER][MAX_EXPLOSION];
static Pixmap pix_leds[MAX_PLAYER][2];
static Pixmap pix_score[MAX_PLAYER][MAX_SCORE_TILES + MAX(MAX_LIVES,9)];


static GC gc_frompix[MAX_PLAYER];
static GC gc_window[MAX_PLAYER];
static GC gc_clearpix[MAX_PLAYER];
static GC gc_drawblock[MAX_PLAYER];
static GC gc_sprite_mask[MAX_PLAYER];
static GC gc_sprite_bits[MAX_PLAYER];
static GC gc_text_black[MAX_PLAYER];
static GC gc_text_white[MAX_PLAYER];

static  XFontStruct *actfont;

static int winX[MAX_PLAYER],winY[MAX_PLAYER];
static int winW[MAX_PLAYER],winH[MAX_PLAYER];

static  int fg,bg; /* Black & White */

static Sprite sprite_list[255];
static Sprite *sprite_max = sprite_list;
static XRectangle xrec[MAZE_W*MAZE_H];
static XRectangle *xrec_max = xrec;

static int iconified[MAX_PLAYER] = { FALSE, FALSE, FALSE, FALSE };



/* Local function : x_fatal */

static void x_fatal(disp, text1, text2)
     int disp;
     char *text1,*text2;
{
  fprintf(stderr,"ERROR: Display(%d), %s %s.\n",disp, text1, text2);
  exit(1);
}



/* Local function : x_warning */

static void x_warning(disp, text1, text2)
     int disp;
     char *text1,*text2;
{
  fprintf(stderr,"WARNING: Disp(%d), %s %s.\n", disp, text1, text2);
}



/* local function: init_font */

static int init_font(disp, gc, fontname)
     GC *gc;
     char *fontname;
{
  int return_value;

  if ( (actfont = XLoadQueryFont(dpy[disp], fontname)) == NULL)
    {
      x_warning(disp,"Couldn't load Font",fontname);
      return_value = FALSE;
    }
  else
    {
      XSetFont(dpy[disp], *gc, actfont->fid);
      return_value = TRUE;
    }
  return(return_value);
}



static void use_default_font( disp, gc )
     int disp;
     GC *gc;

{
  XGCValues xgcv;

  XGetGCValues(dpy[disp], *gc, GCFont, &xgcv);
  actfont = XQueryFont( dpy[disp], xgcv.font );
    
}


/* local function : init_window */

static void init_window(disp)
     int disp;
{
  static char window_title[MAX_PLAYER][80];

  XWindowAttributes xwa;
  XSetWindowAttributes xswa;
  XWMHints *wmh;
  XEvent xev;
  XGCValues xgcv;

  /* Get Root Window Size */
  if ( XGetWindowAttributes(dpy[disp], DefaultRootWindow(dpy[disp]), &xwa)
       == 0 )
    x_fatal(disp,"couldn't get root window size","");

  winX[disp] = 0;
  winY[disp] = 0;
  winW[disp] =  PIXW;
  winH[disp] =  PIXH + SCOREH;

  /* Set Window Attributes */
  xswa.event_mask = NORMAL_EVENT_MASK;
  xswa.background_pixel = fg;
  xswa.border_pixel = fg;

  /* Open the Window */
  win[disp]
    = XCreateWindow(dpy[disp], DefaultRootWindow(dpy[disp]),
                    winX[disp],winY[disp], winW[disp],winH[disp], 0,
                    DefaultDepth(dpy[disp], DefaultScreen(dpy[disp])),
                    InputOutput,
                    DefaultVisual(dpy[disp], DefaultScreen(dpy[disp]) ),
                    CWEventMask | CWBackPixel | CWBorderPixel,
                    &xswa );

  /* Change Window Title */
  sprintf(window_title[disp],"XBlast [%d]",disp+1);
  XChangeProperty(dpy[disp], win[disp], XA_WM_NAME, XA_STRING,
                  8, PropModeReplace, (unsigned char *) window_title[disp],
                  strlen(window_title[disp]));

  /* Set Icon */
  wmh = XAllocWMHints();
  wmh->flags = IconPixmapHint;
  wmh->icon_pixmap
    = XCreatePixmapFromBitmapData(dpy[disp], win[disp],
                                  sprite_bits[disp%MAX_PS][0],
                                  SPRITE_WIDTH, SPRITE_HEIGHT, bg, fg,
                                  DefaultDepth(dpy[disp],
                                               DefaultScreen(dpy[disp]))
                                               );
  XSetWMHints(dpy[disp], win[disp], wmh);


  xgcv.foreground = fg;
  xgcv.background = bg;
  gc_window[disp] = XCreateGC(dpy[disp], win[disp], 
				GCForeground | GCBackground, &xgcv);

  /* Set Cursor */
  XDefineCursor(dpy[disp], win[disp],
                XCreateFontCursor(dpy[disp], XC_trek) );


  /* Map the Window */
  XMapRaised(dpy[disp], win[disp]);

  /* wait for an ExposeEvent */
  do
    XNextEvent(dpy[disp], &xev);
  while (xev.type != Expose );


  /* get actual window size */
  if ( XGetWindowAttributes(dpy[disp], win [disp], &xwa) == 0)
    x_fatal(disp,"could not get window size","");

  winW[disp] = xwa.width;
  winH[disp] = xwa.height;

  if ( (winW[disp] < PIXW) || (winH[disp] <PIXH) )
    x_warning(disp,"display is to small","");
}



/* Local function : init_pixmap */

static void init_pixmap(disp)
     int disp;
{
  XGCValues xgcv;
  static char LivesText[10];
  int i;

  /* where to draw pixmap */
  pix[disp]
    = XCreatePixmap(dpy[disp], win[disp], PIXW, PIXH + SCOREH, 1 );

  /* gc : text to pixmap */
  xgcv.foreground = 0;
  xgcv.background = 1;
  xgcv.line_width = 2;
  gc_text_black[disp] = XCreateGC(dpy[disp], pix[disp],
                              GCForeground | GCBackground | GCLineWidth,
                              &xgcv);
  if ( (!init_font(disp,gc_text_black + disp, xbomb_font))
    && (!init_font(disp,gc_text_black + disp, xbomb_alt_font)) )
    use_default_font( disp, gc_text_black + disp );

  xgcv.foreground = 1;
  xgcv.background = 0;
  xgcv.line_width = 2;
  gc_text_white[disp] = XCreateGC(dpy[disp], pix[disp],
                              GCForeground | GCBackground| GCLineWidth,
                              &xgcv);
  if ( (!init_font(disp,gc_text_white + disp, xbomb_font)) 
      && (!init_font(disp,gc_text_white + disp, xbomb_alt_font)) )
    use_default_font( disp, gc_text_white + disp );

  /* gc : copy pixmap to window */
  if ( DefaultDepth(dpy[disp], DefaultScreen(dpy[disp])) == 1 )
    {
      /* Monochrome Display */
      xgcv.fill_style = FillTiled;
      xgcv.tile = pix[disp];
      xgcv.foreground = fg;
      xgcv.background = bg;
      gc_frompix[disp] = XCreateGC(dpy[disp], win[disp],
                                     GCTile | GCFillStyle | GCForeground
                                     | GCBackground , &xgcv );
    }
  else
    {
      /* Color or Grexscale */
      xgcv.fill_style = FillOpaqueStippled;
      xgcv.stipple = pix[disp];
      xgcv.foreground = bg;
      xgcv.background = fg;
      gc_frompix[disp] = XCreateGC(dpy[disp], win[disp],
                                     GCStipple | GCFillStyle |
                                     GCForeground | GCBackground, &xgcv );
    }

  /* gc : clear pixmap */

  xgcv.tile
    = XCreatePixmapFromBitmapData(dpy[disp], pix[disp],
                                  block_tile[BLScoreFloor],
                                  BLOCK_WIDTH, BLOCK_HEIGHT, 0, 1, 1);
  xgcv.fill_style = FillTiled;
  gc_clearpix[disp] = XCreateGC(dpy[disp], pix[disp],
                                  GCFillStyle | GCTile,
                                  &xgcv );

  /* gc : draw block */
  xgcv.fill_style = FillTiled;
  xgcv.foreground = 0;
  xgcv.background = 1;
  gc_drawblock[disp] = XCreateGC(dpy[disp], pix[disp],
                                   GCFillStyle | GCForeground | GCBackground,
                                   &xgcv );

  /* init score_board tiles */
  for (i=0; i<2; i++)
    pix_leds[disp][i]
      = XCreatePixmapFromBitmapData(dpy[disp], pix[disp],
                                    score_led[i], LED_WIDTH, LED_HEIGHT,
                                    0, 1, 1);


  for (i=0; i < MAX_SCORE_TILES -1 ; i++)
    pix_score[disp][i]
      = XCreatePixmapFromBitmapData(dpy[disp], pix[disp],
                                    score_tile[i], BLOCK_WIDTH, BLOCK_HEIGHT,
                                    0, 1, 1);

  for (i=0; i <= 9; i++)
    {
      pix_score[disp][MAX_SCORE_TILES+i-1]
        = XCreatePixmapFromBitmapData(dpy[disp], pix[disp],
                                      score_tile[MAX_SCORE_TILES-1],
                                      BLOCK_WIDTH, BLOCK_HEIGHT,
                                      0, 1, 1);
      sprintf(LivesText,"%1d",(unsigned int) i);
      XDrawString(dpy[disp], pix_score[disp][MAX_SCORE_TILES+i-1],
                  gc_text_white[disp],
                  25 - XTextWidth(actfont,LivesText,strlen(LivesText))/2, 34,
                  LivesText, strlen(LivesText));
    }
}



/* local function init_disp_sprites */

static void init_player_sprites(disp)
     int disp;
{
  XGCValues xgcv;
  int i,j;

  /* gc for drawing mask */
  xgcv.foreground = 1;
  xgcv.background = 0;
  xgcv.fill_style = FillStippled;
  gc_sprite_mask[disp] = XCreateGC(dpy[disp], pix[disp],
                                     GCFillStyle | GCForeground
                                     | GCBackground , &xgcv);

  /* gc for drawing bitmap */
  xgcv.fill_style = FillStippled;
  xgcv.foreground = 0;
  xgcv.background = 1;
  gc_sprite_bits[disp] = XCreateGC(dpy[disp], pix[disp],
                                     GCFillStyle | GCForeground | GCBackground,
                                     &xgcv);

  /* pixmaps for sprite_masks and bits */

  /* explosions */
  for (i = 0; i < MAX_EXPLOSION; i++)
    {
      /* mask */
      pix_expl_mask[disp][i]
        = XCreatePixmapFromBitmapData(dpy[disp], pix[disp], expl_mask[i],
                                      BLOCK_WIDTH, BLOCK_HEIGHT, 1, 0, 1);
      pix_expl_bits[disp][i]
       = XCreatePixmapFromBitmapData(dpy[disp], pix[disp], expl_bits[i],
                                     BLOCK_WIDTH, BLOCK_HEIGHT, 1, 0, 1);
    }


  /* disp sprites */
  for (i = 0; i < (MAX_ANIME-1); i++)
    {
      /* mask */
      pix_sprite_mask[disp][i]
       = XCreatePixmapFromBitmapData(dpy[disp], pix[disp], sprite_mask[i],
                                     SPRITE_WIDTH, SPRITE_HEIGHT, 1, 0, 1);
      /* the disp_Sprites */
      for (j =0; j < MAX_PLAYER; j++)
        pix_sprite_bits[disp][j][i]
         = XCreatePixmapFromBitmapData(dpy[disp], pix[disp],
                                       sprite_bits[j%MAX_PS][i],
                                       SPRITE_WIDTH, SPRITE_HEIGHT, 1, 0, 1);
    }

  /* Winner Sprite */
  pix_sprite_mask[disp][WINNER_ANIME]
    = XCreatePixmapFromBitmapData(dpy[disp], pix[disp], winner_mask,
				  WINNER_WIDTH, WINNER_HEIGHT, 1, 0, 1);
  /* the disp_Sprites */
  for (j =0; j < MAX_PLAYER; j++)
    pix_sprite_bits[disp][j][WINNER_ANIME]
      = XCreatePixmapFromBitmapData(dpy[disp], pix[disp],
				    winner_bits[j%MAX_PS],
				    WINNER_WIDTH, WINNER_HEIGHT, 1, 0, 1);

}



/* Public function : init_graphics */

void init_graphics(disp, display)
     int disp;
     char *display;
{

  /* Check Player */
  if ( (disp < 0) || (disp >= MAX_PLAYER) )
    x_fatal(disp,"wrong player","");

  /* open display */
  if ( !(dpy[disp] = XOpenDisplay(display)) )
    x_fatal(disp,"Couldn't open Display",display);

  /* set black and white */
  fg = BlackPixel(dpy[disp], DefaultScreen(dpy[disp]) );
  bg = WhitePixel(dpy[disp], DefaultScreen(dpy[disp]) );

  init_window(disp);
  init_pixmap(disp);
  init_player_sprites(disp);
}





  /* public function : wait_event */
  /* int (*expose_func)(disp, send_event) */
  /* int (*key_func)(disp, key, pressed) */

int wait_event( disp, expose_func, key_func )
     int disp;
     int (*expose_func)();
     int (*key_func)();
{
#ifdef MOUSE_CONTROL
  static struct {
    int x, y;
  } last[MAX_PLAYER] = { {0,0}, {0,0}, {0,0}, {0,0} };
  int x_change, y_change;
  char tkey;
#endif

  XEvent xev;
  int num_keys;
  char key[10];
  KeySym keysym;
  int num_events;
  int return_value = 0;

  (*expose_func)(disp, (int)TRUE);

  num_events = XPending( dpy[disp] );

  while ( (num_events != 0) && (return_value == 0)  )
    {
      num_events --;

      /* get event */
      XNextEvent(dpy[disp], &xev);

      switch(xev.type)
        {
        case UnmapNotify:
          iconified[disp] = TRUE;
          break;

        case MapNotify:
          iconified[disp] = FALSE;
          break;


        case Expose:
          if ((xev.xexpose.count == 0) )
            return_value = (*expose_func)(disp, xev.xexpose.send_event);
          break;

#ifdef MOUSE_CONTROL
	case ButtonRelease:
	  if (xev.xbutton.button = Button3)
	    {
	      /* Stop */
	      tkey = '5';
	      return_value = (*key_func)(disp, tkey);
	    }
	  break;

	case ButtonPress:
	  switch(xev.xbutton.button)
	    {
	    case Button1:
	      /* Bomb */
	      tkey = '0';
	      break;
	    case Button2:
	      /* Special */
	      tkey = '+';
	      break;
	    case Button3:
	      last[disp].x = xev.xbutton.x;
	      last[disp].y = xev.xbutton.y;
	      break;
	    }
	  return_value = (*key_func)(disp, tkey);
	  break;

	case MotionNotify:
	  if (xev.xmotion.state & Button3Mask)
	    {
	      x_change = xev.xmotion.x - last[disp].x;
	      y_change = xev.xmotion.y - last[disp].y;
	    }
	  if (ABS(x_change) > ABS(y_change))
	    {
	      if (x_change < 0 )
		/* Left */
		tkey = '4';
	      else
		/* Right */
		tkey = '6';
	    }
	  else
	    {
	      if (y_change < 0 )
		/* Up */
		tkey = '8';
	      else
		/* Down */
		tkey = '2';
	    }
	  return_value = (*key_func)(disp, tkey);

	  break;
#endif	  

        case KeyPress:
          num_keys = XLookupString(&xev.xkey, key, 10, &keysym, NULL);
	  
	  switch (keysym)
	    {
	      
	      /* Num-Pad 0*/
	    case XK_Insert:
	      return_value = (*key_func)(disp, '0');
	      break;
	      
	      /* Num-Pad 2*/
	    case XK_Down:
	      return_value = (*key_func)(disp, '2');
	      break;
	      
	      /* Num-Pad 4*/
	    case XK_Left:
	      return_value = (*key_func)(disp, '4');
	      break;
	      
	      /* Num-Pad 6*/
	    case XK_Right:
	      return_value = (*key_func)(disp, '6');
	      break;
	      
	      /* Num-Pad 8*/
	    case XK_Up:
	      return_value = (*key_func)(disp, '8');
	      break;
	      
	      /* Num-Pad 5*/
	    case XK_R11:
	    case XK_Begin:
	      return_value = (*key_func)(disp, '5');
	      break;
	      
	    default:
	      if (num_keys != 0)
		{
#if QUIT_WITH_CONTROL_Q
		  if (key[0]==17)
		    {
#if DEVELOP
		      print_frames();
#endif
		      exit(0);
		    }
#endif
		  return_value = (*key_func)(disp, key[0]);
		}
	      break;
	    }
          break;
        }
    }
  return(return_value);
}



/* public function : init_block */

void init_block(disp, in_data, in_pix)
     int disp, in_data, in_pix;
{
  pix_block[disp][in_pix] =
    XCreatePixmapFromBitmapData(dpy[disp], pix[disp],
                                 block_tile[in_data], BLOCK_WIDTH,BLOCK_HEIGHT,
                                 0, 1, 1);
}


/* public function: init_explosion_blocks */

void init_explosion_blocks( disp )
     int disp;
{
  int i;
  static XGCValues xgcv;

  for (i=0; i < MAX_EXPLOSION; i++)
    {
      pix_expl_block[disp][i] =
	XCreatePixmap(dpy[disp], pix[disp], BLOCK_WIDTH, BLOCK_HEIGHT, 1);

      xgcv.tile = pix_block[disp][BTFree];
      XChangeGC(dpy[disp], gc_drawblock[disp],
		GCTile, 
		&xgcv);
      XFillRectangle(dpy[disp], pix_expl_block[disp][i], gc_drawblock[disp],
		     0, 0, BLOCK_WIDTH, BLOCK_HEIGHT);
      


      xgcv.stipple = pix_expl_mask[disp][i];
      xgcv.ts_y_origin = 0;
      xgcv.ts_x_origin = 0;
      XChangeGC(dpy[disp], gc_sprite_mask[disp],
		GCStipple | GCTileStipXOrigin |GCTileStipYOrigin,
		&xgcv);
      XFillRectangle(dpy[disp], pix_expl_block[disp][i], gc_sprite_mask[disp],
		     0, 0, BLOCK_WIDTH, BLOCK_HEIGHT);

      xgcv.stipple = pix_expl_bits[disp][i];
      xgcv.ts_y_origin = 0;
      xgcv.ts_x_origin = 0;
      XChangeGC(dpy[disp], gc_sprite_bits[disp],
		GCStipple | GCTileStipXOrigin |GCTileStipYOrigin,
		&xgcv);
      XFillRectangle(dpy[disp], pix_expl_block[disp][i], gc_sprite_bits[disp],
		     0, 0, BLOCK_WIDTH, BLOCK_HEIGHT);
    }
}



/* public function : free_block */

void free_block(disp, in_pix)
     int disp, in_pix;
{
  XFreePixmap(dpy[disp], pix_block[disp][in_pix]);
}



/* public function : free_explosion_blocks */

void free_explosion_blocks( disp )
     int disp;
{
  int i;
  
  for (i = 0; i < MAX_EXPLOSION; i ++ )
    XFreePixmap(dpy[disp], pix_expl_block[disp][i]);
}





/* public function : draw_block */

void draw_block(disp, x, y, block)
  int disp, x, y, block;
{
  XSetTile(dpy[disp], gc_drawblock[disp], pix_block[disp][block]);
  XFillRectangle(dpy[disp], pix[disp], gc_drawblock[disp],
                 x*BLOCK_WIDTH, y*BLOCK_HEIGHT,
                 BLOCK_WIDTH, BLOCK_HEIGHT );

}



/* public function : draw_explosion */

void draw_explosion(disp, x, y, block)
     int disp, x, y, block;
{
  XGCValues xgcv;

  xgcv.tile = pix_expl_block[disp][block];
  XChangeGC(dpy[disp], gc_drawblock[disp], GCTile, &xgcv);
  XFillRectangle(dpy[disp], pix[disp], gc_drawblock[disp],
                 (int)(BLOCK_WIDTH*x), (int)(BLOCK_HEIGHT*y),
                 BLOCK_WIDTH, BLOCK_HEIGHT);
}



/* local function flush_sync */

static void flush_sync(disp, num_disp)
     int disp, num_disp;
{
  if (disp == (num_disp - 1))
    XSync(dpy[disp], FALSE);
}



/* Public function clear_window */

void clear_window(disp)
     int disp;
{
  XClearWindow(dpy[disp], win[disp]);
}




/* globals for fade routines */

static XSegment line[PIXH+SCOREH];
static int fade_count;
static int fade_max;

void set_fade_max(max)
     int max;
{
  fade_max = max;
}


/* public function init_fade */

void init_fade(step)
     int step;
{
  int i;
  
  if (step == FADE_STEP)
    {
      fade_count = (fade_max/step);
      for (i=0; i< fade_count; i+=1)
	{
	  line[i].x1 = 0;
	  line[i].x2 = PIXW-1;
	  line[i].y2 = line[i].y1 = i*step;
	}
    }
  else
    {
      fade_count = ((fade_max - step)/step/2);
      for (i=0; i< fade_count; i+=1)
	{
	  line[i].x1 = 0;
	  line[i].x2 = PIXW-1;
	  line[i].y2 = line[i].y1 = (2*i+1)*step;
	}
    }
}



/* public function fade_out_window */

void fade_out_window(disp, num_disp)
     int disp, num_disp;
{
  XDrawSegments(dpy[disp], win[disp], gc_window[disp],
                line, fade_count);
  flush_sync(disp, num_disp);
}



/* public function fade_in_window */

void fade_in_window(disp, num_disp)
     int disp, num_disp;
{
  XDrawSegments(dpy[disp], win[disp], gc_frompix[disp],
                line, fade_count);
  flush_sync(disp, num_disp);
}



/* public function : clear_pixmap */

void clear_pixmap(disp)
    int disp;
{
  XFillRectangle(dpy[disp], pix[disp], gc_clearpix[disp], 
		 0,0,PIXW,PIXH+SCOREH);
}



/* public fucntion add_rectangle */

void add_rectangle(x,y)
     int x,y;
{

  if (y <MAZE_H +1 )
    xrec_max->height = BLOCK_HEIGHT;
  else
    xrec_max->height = LED_HEIGHT;

  xrec_max->x      = x*BLOCK_WIDTH;
  xrec_max->y      = y*BLOCK_HEIGHT;
  xrec_max->width  = BLOCK_WIDTH;

  xrec_max ++;
}



/* public function flush_score_board */

void flush_score_board(disp, num_disp)
     int disp;
{
  XFillRectangle( dpy[disp], win[disp], gc_frompix[disp],
                 0, PIXH, PIXW, SCOREH);
  flush_sync(disp, num_disp);
}



/* public function : flush_pixmap */

void flush_pixmap(disp, num_disp, flag)
    int disp, num_disp, flag;
{
  if (!flag)
    /* Copy Pixmap to Window */
    XFillRectangle( dpy[disp], win[disp], gc_frompix[disp],
                   0, 0, PIXW, PIXH + SCOREH );
  else
    {
#if 0
      XClearWindow( dpy[disp], win[disp] );
#endif 
      if (!iconified[disp])
        XFillRectangles( dpy[disp], win[disp], gc_frompix[disp],
                        xrec, xrec_max - xrec );
      if (disp == (num_disp -1))
        xrec_max = xrec;
    }
  flush_sync(disp, num_disp);
}



/* public function : free_block_pixmap */

void free_block_pixmap(disp)
  int disp;
{
  int i;

  for (i=0; i<MAX_BLOCK; i++)
    XFreePixmap(dpy[disp], pix_block[disp][i]);
}



/* public function draw_sprites */

void draw_sprites(disp)
      int disp;
{
  static XGCValues xgcvmask,xgcvbits;
  Sprite *spl;

  if (!iconified[disp])
    {
      spl = sprite_max;
      while  (spl != sprite_list)
        {
          spl --;
          switch(spl->type)
            {
            case STPlayer:
              xgcvmask.stipple = pix_sprite_mask[disp][spl->player.anime];
              xgcvbits.stipple
                = pix_sprite_bits[disp][spl->player.player]
                  [spl->player.anime];
              break;

            case STExplosion:
              xgcvmask.stipple = pix_expl_mask[disp][spl->expl.anime];
              xgcvbits.stipple = pix_expl_bits[disp][spl->expl.anime];
              break;

            }
          xgcvmask.ts_y_origin = spl->any.y /*% SPRITE_HEIGHT */;
          xgcvbits.ts_y_origin = spl->any.y  /* % SPRITE_HEIGHT*/;
          xgcvmask.ts_x_origin = spl->any.x /* % SPRITE_WIDTH */;
          xgcvbits.ts_x_origin = spl->any.x /* % SRPITE_WIDTH*/;

          XChangeGC(dpy[disp], gc_sprite_mask[disp],
                    GCStipple | GCTileStipXOrigin |GCTileStipYOrigin,
                    &xgcvmask);


          if (spl->any.mode)
            {
              XChangeGC(dpy[disp], gc_sprite_bits[disp],
                        GCStipple | GCTileStipXOrigin |GCTileStipYOrigin,
                        &xgcvbits);
            }

          switch(spl->type)
            {
            case STPlayer:
              XFillRectangle(dpy[disp], pix[disp], gc_sprite_mask[disp],
                             (int)spl->any.x, (int)spl->any.y,
                             (spl->player.anime == WINNER_ANIME) ? 
			      WINNER_WIDTH : SPRITE_WIDTH, 
                             (spl->player.anime == WINNER_ANIME) ? 
			      WINNER_HEIGHT : SPRITE_HEIGHT);
              if (spl->any.mode)
                XFillRectangle(dpy[disp], pix[disp], 
			       gc_sprite_bits[disp],
                               (int)spl->any.x, (int)spl->any.y,
			       (spl->player.anime == WINNER_ANIME) ? 
			       WINNER_WIDTH : SPRITE_WIDTH, 
			       (spl->player.anime == WINNER_ANIME) ? 
			       WINNER_HEIGHT : SPRITE_HEIGHT);
              break;
            case STExplosion:
              XFillRectangle(dpy[disp], pix[disp], gc_sprite_mask[disp],
                             (int)spl->any.x, (int)spl->any.y,
                             BLOCK_WIDTH, BLOCK_HEIGHT);
              if (spl->any.mode)
                XFillRectangle(dpy[disp], pix[disp], gc_sprite_bits[disp],
                               (int)spl->any.x, (int)spl->any.y,
                               BLOCK_WIDTH, BLOCK_HEIGHT);
              break;
            }
        }
    }
}



/* public function add_to_sprite_list */

void add_trophy_to_sprite_list(x, y)
     int x, y;
{
  sprite_max->type = STExplosion;
  sprite_max->expl.ysort = (y*2+4) * BLOCK_HEIGHT + 6 + 24;
  sprite_max->expl.x = (x*2+6) * BLOCK_WIDTH;
  sprite_max->expl.y = (y*2+4) * BLOCK_HEIGHT + 24;
  sprite_max->expl.anime = 0x10;
  sprite_max->expl.mode = TRUE;
  sprite_max ++;
}



/* public function add_to_sprite_list */

void add_explosion_to_sprite_list(x, y, an, mode)
     int x, y, an, mode;
{
  sprite_max->type = STExplosion;
  sprite_max->expl.ysort = y * BLOCK_HEIGHT + 6 ;
  sprite_max->expl.x = x * BLOCK_WIDTH;
  sprite_max->expl.y = y * BLOCK_HEIGHT;
  sprite_max->expl.anime = an;
  sprite_max->expl.mode = mode;
  sprite_max ++;
}



/* public function add_to_sprite_list */

void add_player_to_sprite_list(pl, x, y, an, m)
     int pl;
     int x, y, an;
     int m;
{
  sprite_max->type = STPlayer;
  sprite_max->player.player = pl;
  sprite_max->player.ysort = y + BLOCK_HEIGHT;
  sprite_max->player.x = 
    x + ( (an==WINNER_ANIME) ? WINNER_X_OFF : SPRITE_X_OFF );
  sprite_max->player.y = 
    y +( (an==WINNER_ANIME) ? WINNER_Y_OFF : SPRITE_Y_OFF );
  sprite_max->player.anime = an;
  sprite_max->player.mode = m;
  sprite_max ++;
}



/* public function clear_sprite_list */

void clear_sprite_list()
{
  sprite_max = sprite_list;
}



/* public sort_sprite_list */

void sort_sprite_list()
{
  static Sprite swap;
  Sprite *sp1,*sp2;

  for (sp1 = sprite_list ; sp1 < sprite_max; sp1++)
    for (sp2 = sp1 + 1 ; sp2 < sprite_max; sp2++)
      if (sp1->any.ysort < sp2->any.ysort)
        {
          swap = *sp1;
          *sp1 = *sp2;
          *sp2 = swap;
        }
}



/* public function draw_time_led */

void draw_time_led(disp, x, block)
     int disp, x, block;
{
  XSetTile(dpy[disp], gc_drawblock[disp],
           pix_leds[disp][block]);
  XFillRectangle(dpy[disp], pix[disp], gc_drawblock[disp],
                 x*LED_WIDTH, (MAZE_H+1)*BLOCK_HEIGHT,
                 LED_WIDTH, LED_HEIGHT );
}



/* public draw_score_board */

static int score_block[MAZE_W] =
{ SBPlayer, SBLives, SBPlayer+1, SBLives,
    SBTextLeft, SBTextMid, SBTextMid, SBTextMid,
    SBTextMid, SBTextMid, SBTextRight,
    SBPlayer+2, SBLives, SBPlayer+3, SBLives};

void draw_score_board(disp, num_player)
     int disp, num_player;
{
  int i,x;

  for (i=num_player; i < MAX_PLAYER; i++)
    {
      score_block[ (2*i + ( (i>1)?7:0))+0] = SBVoid;
      score_block[ (2*i + ( (i>1)?7:0))+1] = SBVoid;
    }

  for (x=0; x<MAZE_W; x++)
    {
      XSetTile(dpy[disp], gc_drawblock[disp],
               pix_score[disp][score_block[x]]);
      XFillRectangle(dpy[disp], pix[disp], gc_drawblock[disp],
                     x*BLOCK_WIDTH, MAZE_H*BLOCK_HEIGHT,
                     BLOCK_WIDTH, BLOCK_HEIGHT );
    }
  for (x=0; x<(4*MAZE_W); x++)
    draw_time_led(disp, x, 1);
}



/* public function draw_score_block */

void draw_score_block(disp, x, block)
     int disp, x, block;
{
      XSetTile(dpy[disp], gc_drawblock[disp],
               pix_score[disp][block]);
      XFillRectangle(dpy[disp], pix[disp], gc_drawblock[disp],
                     x*BLOCK_WIDTH, MAZE_H*BLOCK_HEIGHT,
                     BLOCK_WIDTH, BLOCK_HEIGHT );
}



/* public draw_polygon */

void draw_polygon( disp, x, y, w, h, points, npoints, black_white )
     int disp;
     int x, y, w, h;
     BMPoint *points;
     int npoints,black_white ;
{
  XPoint *xp;
  int i;

  xp = (XPoint *)calloc(sizeof(XPoint),npoints+1);
  
  for (i=0; i < npoints; i++)
    {
      xp[i].x = (int)(x + w*points[i].x);
      xp[i].y = (int)(y + h*points[i].y);
    }
  xp[npoints]=xp[0];

  XFillPolygon(dpy[disp], pix[disp], 
	       black_white ? gc_text_black[disp] : gc_text_white[disp],
	       xp, npoints, Complex, CoordModeOrigin);
  XDrawLines(dpy[disp], pix[disp],
	     black_white ? gc_text_white[disp] : gc_text_black[disp],
	     xp, npoints+1, CoordModeOrigin);

  cfree(xp);
}     



  /* public draw_text */

void draw_text(disp, x, y, text, black_white, boxed, w, h )
     int disp;
     int x,y;
     char *text;
     int black_white;
     int boxed,w,h;
{
  int width, height;

  width = XTextWidth(actfont, text, strlen(text));
  height = actfont->max_bounds.ascent - actfont->max_bounds.descent;


  if (boxed)
    {

      XFillRectangle(dpy[disp], pix[disp],
                     black_white ? gc_text_white[disp]:gc_text_black[disp],
                     x, y,
                     w, h);
      XDrawRectangle(dpy[disp], pix[disp],
                     black_white ? gc_text_black[disp]:gc_text_white[disp],
                     x, y,
                     w, h);
    }
  XDrawString(dpy[disp], pix[disp],
              black_white ? gc_text_black[disp] : gc_text_white[disp],
                  x + (w-width)/2, y + height/2 +h/2 , text, strlen(text));

}




/* public function draw_sprite_from_bitmap */

void draw_sprite_from_bitmap(disp, x, y, w, h, mask, bits)
     int disp;
     int x,y,w,h;
     char *mask, *bits;
{
  Pixmap pixm;
  XGCValues xgcv;

  xgcv.stipple = pixm = 
    XCreatePixmapFromBitmapData( dpy[disp], pix[disp], mask, w, h, 1, 0, 1);
  xgcv.ts_x_origin = x;
  xgcv.ts_y_origin = y;
  XChangeGC(dpy[disp], gc_sprite_mask[disp], 
	    GCStipple | GCTileStipYOrigin | GCTileStipXOrigin,
	    &xgcv);
  XFillRectangle(dpy[disp], pix[disp], gc_sprite_mask[disp], x, y, w, h);
  XFreePixmap(dpy[disp], pixm);

  xgcv.stipple = pixm = 
    XCreatePixmapFromBitmapData( dpy[disp], pix[disp], bits, w, h, 1, 0, 1);
  xgcv.ts_x_origin = x;
  xgcv.ts_y_origin = y;
  XChangeGC(dpy[disp], gc_sprite_bits[disp], 
	    GCStipple | GCTileStipYOrigin | GCTileStipXOrigin,
	    &xgcv);
  XFillRectangle(dpy[disp], pix[disp], gc_sprite_bits[disp], x, y, w, h);
  XFreePixmap(dpy[disp], pixm);

}




/* public function draw_circle_from_pixmap */

void draw_circle_from_pixmap(disp, x, y, r)
     int disp;
     int x,y,r;
{
  XFillArc(dpy[disp], win[disp], gc_frompix[disp], 
	   x - r , y -r, 2*r, 2*r,
	   0, 360*64);
}



/* public function do_bell */

void do_bell(disp)
     int disp;
{
  XBell(dpy[disp],BELL_VOLUME);
}


void no_bell(disp)
     int disp;
{
}
