/*
 * Programm XBLAST V0.97 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * 17.11.1993
 * started August 1993
 *
 * File: blastfunc.h
 * special functions for levels 
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */



/* void functions */

void special_init_void()
{
}

void special_revive_void(player)
     int player;
{
}

void special_game_void()
{
}

void special_extra_void(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
}

void special_key_void(ps, player)
     BMPlayer *ps;
     int player;
{
}


/* Invincible */

void special_extra_invincible(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
  int x, disp;

  ps->illtime = 0;
  ps->illness = Healthy;
  ps->invincible = EXTRA_INVINCIBLE;
  x = (2*player + (player > 1 ? 7 : 0));
  for (disp = 0; disp < num_disp; disp ++)
    draw_score_block(disp, x, SBPlayer + player);
  mark_maze(x, MAZE_H, x, MAZE_H);
}


/* racing */

void special_init_race()
{
  int player;
  
  for (player = 0; player < num_player; player ++)
    {
      player_stat[player].illness = IllRun;
      player_stat[player].illtime = GAME_TIME;
    }
}


void special_revive_race(player)
     int player;
{
  player_stat[player].illness = IllRun;
  player_stat[player].illtime = GAME_TIME;
}



/* Remote Control */

void special_extra_RC(ps, player, num_disp)
     BMPlayer *ps;
     int player, num_disp;
{
  ps->remote_control = TRUE;
}


void special_key_RC(ps, player)
     BMPlayer *ps;
     int player;
{
  if (ps->remote_control > 0)
    ignite_players_bombs(player);
}



/* shrinking */

static int next_shrink;
static int shrink_range;

void special_init_shrink()
{
  next_shrink = GAME_TIME/(int)(MAZE_H/2);
  shrink_range  = 1;
}


void special_game_shrink()
{
  int x,y;
  int player;
  BMPlayer *ps;

  if (game_time == next_shrink)
    {
      for (x = shrink_range; x < (MAZE_W - shrink_range); x++)
	{
	  set_maze_block(x, shrink_range, BTBlock);
	  set_maze_block(x, (int)(MAZE_H - 1 - shrink_range), BTBlock);
	}
      for (y = shrink_range; y < (MAZE_H - shrink_range); y++)
	{
	  set_maze_block(shrink_range, y, BTBlock);
	  set_maze_block((int)(MAZE_W - 1 - shrink_range), y, BTBlock);
	}
      
      shrink_range --;
      for (x = shrink_range; x < (MAZE_W - shrink_range); x++)
	{
	  set_maze_block(x, shrink_range, BTSpecial);
	  set_maze_block(x, MAZE_H-1-shrink_range, BTSpecial);
	}
      for (y = shrink_range; y < (MAZE_H - shrink_range); y++)
	{
	  set_maze_block(shrink_range, y, BTSpecial);
	  set_maze_block(MAZE_W-1-shrink_range,y, BTSpecial);
	}
      shrink_range ++;
      
      
      mark_maze(shrink_range-1, shrink_range-1, 
		shrink_range, MAZE_H-shrink_range);
      mark_maze(MAZE_W-1-shrink_range, shrink_range-1, 
		MAZE_W-shrink_range, MAZE_H-shrink_range);
      mark_maze(shrink_range-1, shrink_range-1, 
		MAZE_W-shrink_range, shrink_range);
      mark_maze(shrink_range-1, MAZE_H-1-shrink_range, 
		MAZE_W-shrink_range, MAZE_H-shrink_range);
      
      for (player = 0; player < num_player; player ++)
	{
	  ps = player_stat + player;
	  if ( ps->lives > 0 )
	    if ( (ps->x < (shrink_range+1)*BLOCK_WIDTH) 
		|| (ps->x > (MAZE_W-shrink_range-2)*BLOCK_WIDTH)
		|| (ps->y < shrink_range*BLOCK_HEIGHT) 	      
		|| (ps->y > (MAZE_H-shrink_range-3)*BLOCK_HEIGHT) )
	      {
		ps->lives = 1;
		ps->dying = DEAD_TIME;
	      }
	}

      delete_outer_bombs(shrink_range);

      if ( (shrink_range += 1) == (MAZE_H+1)/2)
	next_shrink = 0;
      else
	next_shrink = (shrink_range * GAME_TIME)/(int)(MAZE_H/2);
    }
}






