/*
xwdiff - generate the difference between two xwd format files

Copyright 1992 by Hal Computer Systems, Incorporated.  All Rights Reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of HaL not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

HaL disclaims all warranties with regard to this software, including
all implied warranties of metchantability and fitness, in no event shall
HaL be liable for any special, indirect or consequential damages or
any damages whatsoever resulting from loss of use, data or profits,
whether in an action of contract, negligence or other tortious action,
arising out of or in connection with the use of performance of this
software.
*/

/* The Swaplong and Swapshort functions were taken from the xwd client
so we need the following copyright statement from MIT */

/* Copyright 1985, 1986, 1988 Massachusetts Institute of Technology */
/*
Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior permission.  M.I.T. makes no representations about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/XWDFile.h>

typedef struct XWDfile_struct
	{
	XWDFileHeader header;
	char *winname;
	XColor *colors;
	char *pixmap;
	} *XWDfile;

/* Utility functions */

Swapshort(bp,n)
register char *bp;
register unsigned n;
	{
	register char c;
	register char *ep = bp + n;

	while (bp < ep)
		{
		c = *bp;
		*bp = *(bp + 1);
		bp++;
		*bp++ = c;
		}
	}

Swaplong (bp,n)
register char *bp;
register unsigned n;
	{
	register char c;
	register char *ep = bp + n;
	register char *sp;

	while (bp < ep)
		{
		sp = bp + 3;
		c = *sp;
		*sp = *bp;
		*bp++ = c;
		sp = bp + 1;
		c = *sp;
		*sp = *bp;
		*bp++ = c;
		bp += 2;
		}
	}

Error(message)
char *message;
	{
	fprintf (stderr,"Error: %s\n",message);
	exit(1);
	}

/* XWDfile operations */

XWDfile XWDfile_new(filename)
char *filename;
	{
	FILE *f;
	char *c;
	XWDfile xwd;
	unsigned long swaptest = 1;
	int size,loop;
	
	xwd = (XWDfile)malloc(sizeof(struct XWDfile_struct));
	if (!xwd)
		Error("allocating memory for xwd structure");
	f = fopen(filename,"r");
	if (!f)
		Error("opening file for read");
	if (!fread(&xwd->header,sizeof(xwd->header),1,f))
		Error("reading header");
	if (*(char *) &swaptest)
		Swaplong((char *)&xwd->header,sizeof(xwd->header));
	if (xwd->header.file_version != XWD_FILE_VERSION)
		Error("bad file version");
	size = xwd->header.header_size-sizeof(xwd->header);
	xwd->winname = (char *)malloc(size);
	if (!xwd->winname)
		Error("allocating memory for window name");
	if (!fread(&xwd->winname,size,1,f))
		Error("reading window name");
	size = (unsigned)xwd->header.ncolors*sizeof(XColor);
	if (size)
		{
		xwd->colors=(XColor *)malloc(size);
		if (!xwd->colors)
			Error("allocating memory for colors");
		if (!fread((char *)xwd->colors,size,1,f))
			Error("reading colors");
		}
	if (*(char *) &swaptest)
		{
		for (loop=0;loop<xwd->header.ncolors;loop++)
			{
			c = (char *)&xwd->colors[loop].pixel;
			Swaplong(c,sizeof(long));
			c = (char *)&xwd->colors[loop].red;
			Swapshort(c,3*sizeof(short));
			}
		}
	if (xwd->header.pixmap_format != ZPixmap)
		{
		size = xwd->header.pixmap_height*xwd->header.pixmap_depth;
		size *= xwd->header.bytes_per_line;
		}
	else
		size = xwd->header.bytes_per_line*xwd->header.pixmap_height;
	xwd->pixmap = (char *)malloc(size);
	if (!xwd->pixmap)
		Error("allocating memory for pixmap");
	if (!fread(xwd->pixmap,size,1,f))
		Error("reading image");
	fclose(f);
	return(xwd);
	}

XWDfile_free(xwd)
XWDfile xwd;
	{
	}

XWDfile_write(xwd)
XWDfile xwd;
/* write xwd file on standard output */
	{
	char *c;
	unsigned long swaptest = 1;
	int size,loop;
	
	if (*(char *) &swaptest)
		Swaplong((char *)&xwd->header,sizeof(xwd->header));
	if (!fwrite(&xwd->header,sizeof(xwd->header),1,stdout))
		Error("writing header");
	if (*(char *) &swaptest)
		Swaplong((char *)&xwd->header,sizeof(xwd->header));
	size = xwd->header.header_size-sizeof(xwd->header);
	if (!fwrite(&xwd->winname,size,1,stdout))
		Error("writing window name");
	size = (unsigned)xwd->header.ncolors*sizeof(XColor);
	if (*(char *) &swaptest)
		{
		for (loop=0;loop<xwd->header.ncolors;loop++)
			{
			c = (char *)&xwd->colors[loop].pixel;
			Swaplong(c,sizeof(long));
			c = (char *)&xwd->colors[loop].red;
			Swapshort(c,3*sizeof(short));
			}
		}
	if (size)
		{
		if (!fwrite((char *)xwd->colors,size,1,stdout))
			Error("writing colors");
		}
	if (*(char *) &swaptest)
		{
		for (loop=0;loop<xwd->header.ncolors;loop++)
			{
			c = (char *)&xwd->colors[loop].pixel;
			Swaplong(c,sizeof(long));
			c = (char *)&xwd->colors[loop].red;
			Swapshort(c,3*sizeof(short));
			}
		}
	if (xwd->header.pixmap_format != ZPixmap)
		{
		size = xwd->header.pixmap_height*xwd->header.pixmap_depth;
		size *= xwd->header.bytes_per_line;
		}
	else
		size = xwd->header.bytes_per_line*xwd->header.pixmap_height;
	if (!fwrite(xwd->pixmap,size,1,stdout))
		Error("writing image");
	}

int XWDfile_basic_compare(xwd1,xwd2)
XWDfile xwd1,xwd2;
	{
	if (xwd1->header.byte_order != xwd2->header.byte_order)
		return(0);
	if (xwd1->header.ncolors != xwd2->header.ncolors)
		return(0);
	if (xwd1->header.pixmap_width != xwd2->header.pixmap_width)
		return(0);
	if (xwd1->header.pixmap_height != xwd2->header.pixmap_height)
		return(0);
	if (xwd1->header.pixmap_depth != xwd2->header.pixmap_depth)
		return(0);
	return(1);
	}

XWDfile_xor_image(xwd1,xwd2)
XWDfile xwd1,xwd2;
	{
	int size,loop;

	if (xwd1->header.pixmap_format != ZPixmap)
		{
		size = xwd1->header.pixmap_height*xwd1->header.pixmap_depth;
		size *= xwd1->header.bytes_per_line;
		}
	else
		size = xwd1->header.bytes_per_line*xwd1->header.pixmap_height;
	for (loop=0;loop<size;loop++)
		xwd1->pixmap[loop] ^= xwd2->pixmap[loop];
	}

main(argc,argv)
int argc;
char **argv;
	{
	XWDfile xwd[2];

	if (argc != 3)
		{
		fprintf(stderr,"Usage: %s <file1> <file2>\n",argv[0]);
		exit(1);
		}
	xwd[0] = XWDfile_new(argv[1]);
	xwd[1] = XWDfile_new(argv[2]);
	if (XWDfile_basic_compare(xwd[0],xwd[1]))
		{
		XWDfile_xor_image(xwd[0],xwd[1]);
		XWDfile_write(xwd[0]);
		}
	else
		Error("basic attributes of the two files dont match");
	XWDfile_free(xwd[0]);
	XWDfile_free(xwd[1]);
	}
