.TH XTMRECORD 1
.ad b
.SH NAME
xtmrecord \- interactive test script recorder
.SH SYNOPSIS
.B xtmrecord
\fIfile\fB.scr\fR
.br
.SH DESCRIPTION
.I Xtmrecord
records a copy of the user's actions with the keyboard and mouse
(called a test script) in
\fIfile.scr\fR.
This test script will contain a record of which keys and mouse buttons were
pressed and released, where the mouse was moved to, and how long it took for
the user to do it.
.I Xtmexecute(1)
can then be invoked to play back what was recorded in the test script.
.PP
While recording a test script the user may request that information about
image data on the screen be recorded in the test script.
When the test script is played back this recorded information is used
to verify that image data currently on the screen is the same as
the image data that was on the screen when the test script was recorded.
.PP
This allows an interactive test to be recorded and replayed,
and the results of the test to be automatically verified.
This also allows the construction of automated "demos" with no
need for human intervention.
.SS File Name Syntax
The file name given to 
.I xtmrecord
must end in ".scr".
Thus:
.PP
.RS
xtmrecord file.scr
.RE
.PP
records an interactive test in 
.I file.scr.
If an incorrect file name or no file name is given,
.I xtmrecord
will display the correct invocation syntax.
.SS Running Xtmrecord
.I Xtmrecord
may be run in an X terminal emulator window or on a terminal.
If you run
.I xtmrecord
on a terminal, make sure that the
.SM
.B DISPLAY
environment variable is set to the name of the desired X server.
.PP
.I Xtmrecord
requires that the X server support the
.I Input Synthesis
extension.  This extension supplies the additional capabilities needed to
record a test script.
.PP
.I Xtmrecord
will communicate with the X server to start recording the user's actions as
soon as it is invoked.
The initial position of the mouse will be recorded, and the mouse will be moved
to that position when the recording is replayed.
.PP
The user's actions are recorded until the user wishes to
record some part of the display or terminate the recording.
At that point, 
.I xtmrecord
is placed in command mode by pressing the "command" key on the keyboard of the
X server.
.PP
The "command" key will vary from X server to X server
(on most Hewlett Packard X servers the "command" key is the
left-most blank key).  
The "command" key may be specified by the
.I CommandKey
.I .Xdefaults
variable.
.PP
While in command mode keyboard and mouse input are not passed on to the
clients that would otherwise see them but instead are only passed on
to 
.I xtmrecord.
Seven
commands are available in command mode, each invoked by pressing a single key:
.TP
.B c
Cause the checksum mode to be toggled.
The checksum mode is off at the start of the recording.
For more information mode see the
.B Checksum Mode
section.
This key leaves 
.I xtmrecord
in command mode.
.TP
.B m
Cause information about the contents of the window that is a child of the root
window and contains the mouse to be recorded in 
.I file.scr
for later use.
If the window you are interested in is not a child of the root window
(for example, if you are running a reparenting window manager)
then you may want to use the \fBp\fR (partial window) command instead.
This key leaves 
.I xtmrecord
in command mode.
.TP
.B p
Cause information about the contents of a user-specified partial window
to be recorded in 
.I file.scr
for later use.
This key leaves 
.I xtmrecord
in partial window specification mode.
For more information see the
.B Specifying a Partial Window
section.
.TP
.B s
Cause information about the contents of the entire screen to be recorded in 
.I file.scr
for later use.  This key leaves 
.I xtmrecord
in command mode.
.TP
.B t
Cause information about the contents of the top window
(as defined by the X server)
that is a child of the root window to be recorded in 
.I file.scr
for later use.  This key leaves 
.I xtmrecord
in command mode.
.TP
.B r
Cause
.I xtmrecord
to leave command mode and resume recording keyboard and mouse input.
.TP
.B q
Cause the recording (and \fIxtmrecord\fR) to be terminated.
.sp
.PP
The keys associated with the commands may be changed
by using the appropriate
.I .Xdefaults
variables.
For a list of acceptable keys see
.B X Server Key Names
in the
.I xtmconvert(1)
documentation.
.PP
If the "command" key is pressed while in command mode, the "command" key is
sent on to the the client, and 
.I xtmrecord
will leave command mode and resume recording keyboard and mouse input.
This is useful if you don't have an unused key on your keyboard.
Whatever key is selected as the "command" key can be used as an ordinary key
by pressing it twice.
.PP
If no error occurs during recording, 
.I xtmrecord
will terminate with an exit status of zero.
If an error occurs during recording,
.I xtmrecord
will terminate with a non-zero exit status.
.PP
If the user wishes to see what was recorded without replaying the test script,
the test script may be converted to human-readable form by
.I xtmconvert(1).
.SS Checksum Mode
The method of image data verification depends on the checksum mode.
If the checksum mode is off, the image data is stored in the test script.
If the checksum mode is on, a checksum is computed
from the image data and stored in the test script instead of the image data.
.PP
Test scripts that use checksums for image verification take up less space,
but lose the ability to reproduce the expected and actual images.
You know only that something has changed, but not exactly what.
.SS Verification of Obscured Windows
The \fBm\fR (mouse), \fBs\fR (screen), and \fBt\fR (top)
commands may cause requests to read image data
from a window that is partially or completely covered by other windows.
Also, a useful tactic to verify something of the area around a window
(such as title bars put on the window by a window manager) is to put 
the area of interest inside of
a larger window and attempt to verify the image data in the larger window.
.PP
The X protocol does not guarantee correct results if you read image data
from a window that is partially or completely covered by other windows,
but it often works anyway.
If reading from the obscured window doesn't work,
reading the desired information from the root window instead sometimes works.
If neither way works, then you will have to think of some other way to
verify what you are interested in, perhaps using the \fBp\fR (partial window)
command.
.PP
The
.I ReadFromRoot
.I .Xdefaults
variable gives you the option of reading all of the information for image
data verifications in a test script
from the root window instead of the window that would normally be used.
If you set
.I ReadFromRoot
to "\fByes\fR" to read image data information from the root window for 
.I xtmrecord,
make sure to also set it to "\fByes\fR" for
.I xtmexecute(1).
.SS Specifying a Partial Window
After the user has pressed the \fBp\fR (partial window) key,
.I xtmrecord
replaces the cursor with a rectangle outlining the current size
and location of the partial window area on the display,
and waits for the user to position the corners of the rectangle.
The rectangle outlines the partial window area but is not part of the partial
window area.
.PP
The user may then pick the upper-left corner of the rectangle
with a mouse button and then the lower-left corner position
by again pressing a button on the mouse.
If user is satisfied with the position of the rectangle,
the user may press the
.B y
key to accept the current position of the rectangle as the desired size and
location of the partial window area to be recorded for later verification.
.I Xtmrecord
then returns to command mode unless the specified partial window area is
in error.
A partial window area must be contained entirely in one window.
The partial window area may not be partially or completely covered by another
window.
If the specified partial window area does not meet these requirements
when the user presses the
.B y
key, an error message is generated and the user is left in partial window
specifying mode to permit the user to move the rectangle to fix the problem.
.PP
At any time the user may press the
.B n
key to cancel the partial window specification process
and return to command mode.
.PP
The keys associated with specifying a partial window may be changed by
using the appropriate
.I .Xdefaults
variables.
Any key not understood by
.I xtmrecord
is ignored in command or partial window specifying mode.
.sp
.sp
.SS .Xdefaults Variable Usage
.I Xtmrecord
recognizes the following
.I .Xdefaults
variables (shown with their default values):
.PP
.RS
xtmrecord.CommandKey:         KP_F1
.RE
.RS
xtmrecord.ResumeKey:          r
.RE
.RS
xtmrecord.QuitKey:            q
.RE
.RS
xtmrecord.ChecksumModeKey:    c
.RE
.RS
xtmrecord.MatchMouseKey:      m
.RE
.RS
xtmrecord.MatchScreenKey:     s
.RE
.RS
xtmrecord.MatchTopKey:        t
.RE
.RS
xtmrecord.MatchPartialKey:    p
.RE
.RS
xtmrecord.AcceptPartialKey:   y
.RE
.RS
xtmrecord.RejectPartialKey:   n
.RE
.RS
xtmrecord.MatchRetries:       3
.RE
.RS
xtmrecord.RetryInterval:      5000
.RE
.RS
xtmrecord.MatchBufferSize:    32760
.RE
.RS
xtmrecord.ReadFromRoot:       no
.RE
.PP
The
.I CommandKey
variable specifies the name of the key on the X server that
is the "command" key.
The default value is the name for the first function key on the numeric keypad,
which is the left-most blank key on most Hewlett Packard X servers.
Some other X servers may not have this key,
in which case some other key was chosen.
The name given here must match the key chosen by the X server you are going
to record from.
.PP
The
.I ResumeKey
variable specifies the name of the key on the X server that causes
.I xtmrecord
to leave command mode and resume recording keyboard and mouse input.
.PP
The
.I QuitKey
variable specifies the name of the key on the X server that causes the
recording (and \fIxtmrecord\fR)
to be terminated.
.PP
The
.I ChecksumModeKey
variable specifies the name of the key on the X server that causes the checksum
mode to be toggled.
.PP
The
.I MatchMouseKey
variable specifies the name of the key on the X server that causes information
about the contents
of the window containing the mouse to be recorded for later comparison.
.sp
.sp
.PP
The
.I MatchScreenKey
variable specifies the name of the key on the X server that causes information
about the contents
of the entire screen to be recorded for later comparison.
.PP
The
.I MatchTopKey
variable specifies the name of the key on the X server that causes information
about the contents
of the top window to be recorded for later comparison.
.PP
The
.I MatchPartialKey
variable specifies the name of the key on the X server that causes information
about the contents
of a partial window specified by the user to be recorded for later comparison.
.PP
The
.I AcceptPartialKey
variable specifies the name of the key on the X server that causes a partial
window specification to be accepted.
.PP
The
.I RejectPartialKey
variable specifies the name of the key on the X server that causes a partial
window specification to be cancelled.
.PP
The
.I MatchRetries
variable controls the number of times a failing image data verification will be
retried when the test script is executed using
.I xtmexecute(1).
.PP
The
.I RetryInterval
variable controls the interval in milliseconds between each retry when the
test script is executed using
.I xtmexecute(1).
It has a range of 0 to 2,147,483,647 milliseconds (approximately 25 days).
.sp
.PP
The
.I MatchBufferSize
variable controls the size in bytes of the buffer that is used to hold the
image data read from the display.
It does not limit the amount of image data that can be read from the display,
but only determines how much of the image data can be read at one time.
.PP
The value of this variable must be divisible by 8 and
at least large enough to hold one line
of pixels the width of the X server's display.
Larger than default values of this variable
may increase the performance of display reads
on machines with large amounts of memory.
It has a range of 0 to one-half the maximum value an unsigned integer can hold.
.PP
The
.I ReadFromRoot
variable controls whether or not to read all of the information
for image data verifications in a test script from the root window
instead of from the window that would normally be used.
.PP
If you set
.I ReadFromRoot
to "\fByes\fR", make sure to also set it to "\fByes\fR" for
.I xtmexecute(1).
.SH SEE ALSO
xtmexecute(1), xtmconvert(1).
.SH COPYRIGHT
.PP
Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
.PP
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology
.PP
Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.
.PP
This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.
