.TH XTMCONVERT 1
.ad b
.SH NAME
xtmconvert \- convert test scripts to and from other formats
.SH SYNOPSIS
.B xtmconvert
[\fB-s\fR] \fIfromfile\fR \fItofile\fR
.SH DESCRIPTION
.I Xtmconvert
converts test scripts in 
.B internal
format to or from
.B summary
or 
.B output
formats.
The type of conversion performed depends on the ending characters of the file
names.
.SS File Name Syntax
The file names given to
.I xtmconvert
must end in ".scr", ".out", or ".sum".
The first file name is the file to be converted.
The second file name is the file where the results of the conversion are placed.
.PP
To convert from
.B internal
format to
.B output
format, use:
.PP
.RS
xtmconvert testscript.scr testscript.out
.RE
.PP
To convert from
.B internal
format to
.B summary
format, use:
.PP
.RS
xtmconvert testscript.scr sumscript.sum
.RE
.PP
To convert from
.B output
format to
.B internal
format, use:
.PP
.RS
xtmconvert oldscript.out newscript.scr
.RE
.PP
To convert from
.B summary
format to
.B internal
format, use:
.PP
.RS
xtmconvert testscript.sum testscript.scr
.RE
.PP
.PP
If no file names or incorrect file names are given, 
.I xtmconvert
will display the correct invocation syntax
and terminate with a non-zero exit status value.
.SS Running Xtmconvert
.I Xtmconvert
may be run in an X terminal emulator or on a terminal.
If you run
.I xtmconvert
on a terminal, make sure that the
.B DISPLAY
environment variable is set to the name of the desired X server.
.PP
.I Xtmconvert
uses the X server to
convert between key codes and the corresponding key names.
.PP
If no error occurs during the conversion,
.I xtmconvert
will terminate with an exit status value of zero.
If an error occurs during the conversion,
.I xtmconvert
will terminate with a non-zero exit status value.
.PP
If the
.B -s
option is used then any recorded image data or checksums
contained in the test script are left out of the converted test script.
This is useful if you are moving test scripts to a different machine,
since the image data or checksums are almost always machine-specific.
.SS Contents of a Test Script
All test scripts must contain a version number.
The version number is checked when the test script is
converted to help deal with future changes to the test script format.
If a test script does not have a version number or has a version number that
.I xtmconvert
does not know how to convert,
.I xtmconvert
will terminate with a non-zero exit status.
.PP
A test script may contain four types of input actions:
.TP
.B
key or mouse button presses or releases
This input action contains which key or mouse button was pressed or released.
.TP
.B relative pointer motions
This input action contains the relative offset
from the current pointer position to the new pointer position.
This input action has a maximum range of 15 pixels
from the current pointer position.
If the pointer must move further than 15 pixels
then a pointer jump input action must be used.
.TP
.B pointer jumps
This input action contains x and y coordinates for the pointer to move to.
The coordinates are zero in the upper left corner of the screen,
the x coordinate increases horizontally from left to right,
and the y coordinate increases vertically from top to bottom.
.TP
.B time delays
This input action contains the amount of time to delay
before going on to the next input action.
.PP
Each input action has a time delay before the input action is performed.
Except for the time delay input action, the input actions have a limited range
of 0 to 65535 milliseconds (approximately one minute).
The time delay input action has a range of 0 to 2,147,483,647 milliseconds
(approximately 25 days).
.PP
A test script may contain four types of requests
for verification of image data from the display:
.TP
.B mouse
The image data to be verified comes from the window
that is a child of the root window and that contains the mouse (pointer)
at the time that the request occurs.
.TP
.B screen
The image data to be verified comes from the entire screen.
.TP
.B top
The image data to be verified comes from the window
that is a child of the root window and that is the "top" window
(as defined by the X server)
at the time that the request occurs.
.TP
.B partial
The image data to be verified comes from a partial window specified by the user.
.PP
The method of image data verification depends on the checksum mode.
If the checksum mode is turned off when the request occurs,
the image data is verified by comparing the image data
with image data stored in the test script.
If the checksum mode is turned on when the request occurs,
the image data is verified by comparing a checksum computed from the image data
with a checksum stored in the test script.
.PP
A test script may contain checksum mode commands that turn the checksum
mode on or off.
The checksum mode is turned off at the start of each test script.
.PP
To change the checksum mode for all or part of an existing test script,
convert the test script to
.B output
format, edit the
.B output
format of the test script to add or modify any desired checksum mode commands,
and convert the test script back to
.B internal
format.
.PP
A test script may also contain comments,
which have no effect on the execution of a test script.
.SS Internal Format
The data in the 
.B internal
format of the test script
is organized in a way that is convenient for
.I xtmrecord(1)
and
.I xtmexecute(1)
to use, but is not easily readable by human beings
or portable across different computer systems.
.PP
The 
.B internal
format of the test script may be created by
.I xtmconvert
or
.I xtmrecord(1)
and is the required format of the test script if it is to be played back by
.I xtmexecute(1).
.PP
The 
.B internal
format of the test script contains all of the data in the test script.
It is stored in a file whose name ends in ".scr".
.PP
A test script in
.B internal
format with no recorded image data for the image data comparison requests
would have to be updated
(by running
.I xtmexecute(1)
with the
.B -u
option)
before being used as a test script.
.SS Output Format
The data in the 
.B output
format of the test script
is organized in a way that is more portable across different computer systems.  
The data is possible for a human being to understand,
but the level of detail tends to obscure what the test script is doing.
.PP
The 
.B output
format of the test script may be created by
.I xtmconvert
or by an editor, but if you want to create a test script with an editor
it is much easier to create a test script in the
.B summary
format.
.PP
The 
.B output
format of the test script is stored in a file whose name ends in ".out".
.PP
The 
.B output
format of the test script contains all of the data in the test script.
When converting between
.B internal
format and
.B output
format all of the information in the test script is preserved.
.PP
When
.I xtmconvert
is converting from
.B internal
format to
.B output
format the version number is converted to a line containing:
.PP
.RS
.B VERSION [\fIversionnumber\fB]\fR
.RE
.PP
The
.I versionnumber
value holds the current version number of the test script.
.PP
When
.I xtmconvert
is converting from
.B internal
format to
.B output
format each input action is converted to a line containing the following
fields:
.TP
.B input action name
This field contains the name of the input action.
The contents of this field is described for each type of input action below.
.TP
\fBDEV [\fIdevicenumber\fB]\fR
The
.I devicenumber
value holds the value for the device that generated the input action.
This is a provision for future support of multiple (distinguishable) devices.
It should be 0 for most X servers.
For most Hewlett Packard X servers it will have the following values:
.RS
.RS
.sp
.TP
0
Pointer jump input actions generated by
.I xtmrecord(1)
or the
.I Input Synthesis
extension.  These may occur at several places in the test script.
.TP
1
Pointer jump and relative pointer motion input actions
generated by the X server.
Also mouse button press or release input actions.
.TP
3
Key press or release input actions.
.RE
.RE
.TP
.B input action specific information
This field contains information specific to the type of the input action.
The contents of this field are described for each type of input action below.
.TP
\fBTIME (ms) [\fItimedelay\fB]\fR
The
.I timedelay
value holds the time delay value associated with the input action.
.TP
\fBCOUNT [\fIcount\fB]\fR
The
.I count
value holds an input action counter to help make it easier to tell
how many input actions are in the test script.
.IP
This field must be present when converting a test script from
.B output
format to
.B internal
format, but the
.I count
value is ignored.
This allows someone to modify the input actions in a test script in
.B output
format without later causing an error while converting the test script back to
.B internal
format.
.PP
A key press input action has an input action name of
.B KEY_DOWN
and puts:
.PP
.RS
\fBKEY [\fIkeyname\fB]\fR
.RE
.PP
in the input action specific information field.
.PP
A key release input action has an input action name of
.B KEY_UP
and puts:
.PP
.RS
\fBKEY [\fIkeyname\fB]\fR
.RE
.PP
in the input action specific information field.
.PP
The
.I keyname
value is the X server's name for that key on the X server's keyboard.
It may be composed of a single character for common keys
(such as
.B a
for the key labled `A' on the keyboard),
or it may be composed of multiple characters for other keys
(such as
.B bracketleft
for the key labeled `[' on the keyboard).
.PP
The mouse buttons do not have a key name defined for them by the X server.
.I Xtmconvert
uses
.B Button1, Button2, Button3,
and so forth as the equivalent of the key name for the mouse buttons.
Otherwise, the mouse button input actions are treated the same as the
key input actions.
.PP
A pointer jump input action has an input action name of
.B JUMP
and puts:
.PP
.RS
\fBX [\fIxpixloc\fB] Y [\fIypixloc\fB]\fR
.RE
.PP
in the input action specific information field.
The
.I xpixloc
and
.I ypixloc
values are the x and y coordinates of the pixel that the pointer will move to.
.PP
A relative pointer motion input action has an input action name of
.B MOVE
and puts:
.PP
.RS
\fBX [\fIxpixmov\fB] Y [\fIypixmov\fB]\fR
.RE
.PP
in the input action specific information field.
The
.I xpixmov
and
.I ypixmov
values are the relative offsets from the current pointer position
to the new pointer position.
.PP
A time delay input action has an input action name of
.B TIME
and puts nothing in the input action specific information field.
Also, a time delay input action does not have a device field.
.PP
Requests for verification of image data from the display
are converted to six header lines containing the following fields:
.TP
\fB MATCH #\fImatchnum\fR
The
.I matchnum
value holds an counter of the number of requests for image data verifications
in the test script.
It will start at 1 for the first request, and may range up to 99
(the maximum number of requests permitted in one test script).
.TP
\fB TYPE[\fItypeletter\fB]\fR
The
.I typeletter
value holds a letter describing the type of the request:
.RS
.TP
.B m
The request is to verify the window that is a child of the root window
and that contains the mouse at this point in the test script.
.TP
.B p
The request is to verify a user-specified partial window on the X server.
.TP
.B s
The request is to verify the entire screen on the X server.
.TP
.B t
The request is to verify the window that is a child of the root window
and that is the "top" window (as defined by the X server)
at this point in the test script.
.RE
.TP
\fB REP[\fIrepcount\fB]\fR
The
.I repcount
value holds the number of times to retry the image data verification before 
deciding that the verification has failed.
.TP
\fB INTV[\fIinterval\fB]\fR
The
.I interval
value holds the amount of time to wait (in milliseconds) before each retry.
.TP
\fB CNT[\fIcount\fB]\fR
The
.I count
value holds the number of bytes of compressed image data for this request.
.TP
\fB CM[\fIchecksummode\fB]\fR
The
.I checksummode
value holds the checksum mode that was in effect for this request.
.TP
\fB S#\fIscreennum\fR
The
.I screenum
value holds the number of the screen that contained the image data.
.TP
\fB WX[\fIwindowxorg\fB]\fR
The
.I windowxorg
value holds the x coordinate of the upper left corner of the window that
contained the image data.
.TP
\fB WY[\fIwindowyorg\fB]\fR
The
.I windowyorg
value holds the y coordinate of the upper left corner of the window that
contained the image data.
.TP
\fB WW[\fIwindowwidth\fB]\fR
The
.I windowwidth
value holds the width of the window that contained the image data (in pixels).
.TP
\fB WH[\fIwindowheight\fB]\fR
The
.I windowheight
value holds the height of the window that contained the image data (in pixels).
.sp
.TP
\fB BW[\fIborderwidth\fB]\fR
The
.I borderwidth
value holds the border width of the window that contained the image data
(in pixels).
.TP
\fB WN"\fIwindowname\fB"\fR
The
.I windowname
value holds the name of the window that contained the image data.
.TP
\fB X[\fIxpixloc\fB]\fR
The
.I xpixloc
value holds the window-relative x coordinate of the image data.
.TP
\fB Y[\fIypixloc\fB]\fR
The
.I ypixloc
value holds the window-relative y coordinate of the image data.
.TP
\fB W[\fIwidth\fB]\fR
The
.I width
value holds the width of the image data (in pixels).
.TP
\fB H[\fIheight\fB]\fR
The
.I height
value holds the height of the image data (in pixels).
.TP
\fB D[\fIdepth\fB]\fR
The
.I depth
value holds the depth of the image data.
.TP
\fB F[\fIformat\fB]\fR
The
.I format
value holds the format of the image data.
.TP
\fB XOFF[\fIxoffset\fB]\fR
The
.I xoffset
value holds the horizontal offset of the image data.
.TP
\fB BO[\fIbyteorder\fB]\fR
The
.I byteorder
value holds the byte order of the image data.
.TP
\fB BU[\fIbitmapunit\fB]\fR
The
.I bitmapunit
value holds the bitmap unit of the image data.
.TP
\fB BBO[\fIbitmapbitorder\fB]\fR
The
.I bitmapbitorder
value holds the bitmap bit order of the image data.
.TP
\fB BP[\fIbitmappad\fB]\fR
The
.I bitmappad
value holds the bitmap pad boundary of the image data.
.sp
.TP
\fB BPL[\fIbytesperline\fB]\fR
The
.I bytesperline
value holds the number of bytes for each line
(padding included) of the image data.
.TP
\fB BPP[\fIbitsperpixel\fB]\fR
The
.I bitsperpixel
value holds the number of bits for each pixel of the image data.
.TP
\fB VC[\fIvisualclass\fB]\fR
The
.I visualclass
value holds the type of the color map of the window
that contained the image data.
.TP
\fB RM[\fIredmask\fB]\fR
The
.I redmask
value holds the red mask for the image data.
.TP
\fB GM[\fIgreenmask\fB]\fR
The
.I greenmask
value holds the green mask for the image data.
.TP
\fB BM[\fIbluemask\fB]\fR
The
.I bluemask
value holds the blue mask for the image data.
.TP
\fB BPR[\fIbitsperrgb\fB]\fR
The
.I bitsperrgb
value holds the log (base 2) of the number of distinct color 
values in the image data.
.TP
\fB CE[\fIcolormapentries\fB]\fR
The
.I colormapentries
value holds the number of color entries in the color map
of the window that contained the image data.
.TP
\fB C[\fIncolors\fB]\fR
The
.I ncolors
value holds the number of color structures used to describe the color entries
in the color map of the window that contained the image data.
.PP
The header lines will be followed by one line for each color map entry
containing the following fields:
.TP
\fB PIXEL[\fIpixelnumber\fB]\fR
The
.I pixelnumber
value holds the color map entry number for this color.
.TP
\fB RED[\fIredvalue\fB]\fR
The
.I redvalue
value holds the red value for this color.
.TP
\fB GREEN[\fIgreenvalue\fB]\fR
The
.I greenvalue
value holds the green value for this color.
.TP
\fB BLUE[\fIbluevalue\fB]\fR
The
.I bluevalue
value holds the blue value for this color.
.TP
\fB FLAGS[\fIflags\fB]\fR
The
.I flags
value holds the flags value for this color.
.PP
If the checksum mode if off,
the color map entry lines will be followed by many lines containing the
image data in a (run length encoded) compressed form.
The image data is compressed by counting the number of bytes 
of the same value in sequence in the image data (as read from the X server).
The count is output as two ascii characters representing hexadecimal digits.
The byte value follows as two more ascii characters
representing hexadecimal digits.
This is repeated until all of the image data is encoded.
.PP
If the checksum mode is on or the image data has been stripped
from the test script, only the header lines will remain.
The image data is often stripped when moving a test script from one type of
computer to another, since it is machine-dependent.
.PP
A checksum mode command is converted to a line containing:
.PP
.RS
.B CHECKSUMS \fIchecksummode\fR
.RE
.PP
The
.I checksummode
value holds the current checksum mode of the test script
(either \fBOFF\fR or \fBON\fR).
.PP
A comment is converted to a line containing:
.PP
.RS
.B COMMENT \fIcomment\fB
.RE
.PP
The
.I comment
may contain any printable characters except a ">".
It should be limited to less than 70 characters.
.SS Summary Format
The data in the 
.B summary
format of the test script
is organized in a way that is easier for a human being to understand and edit.
.PP
The 
.B summary
format of the test script (except for image verfication data)
is stored in a file whose name ends in ".sum".
The image verification data is stored in multiple files, one file for each
image data verification request in the test script.
.PP
If the checksum mode if off,
the recorded image data is stored in 
.I xwd(1)
format in a file whose name is created by replacing the ".sum"
with ".m\fBnn\fR".
.PP
If the checksum mode is on, the checksum and other needed image description
information is stored in a file whose name is created by replacing the ".sum"
with ".c\fBnn\fR".
.PP
The
.B nn
in the file name is replaced by a number corresponding to the image data
verification request in the test script.  The number will be 01 for the first
request in the test script, 02 for the second request, and so forth up to 99
(the maximum number of requests in one test script).
.PP
The 
.B summary
format of the test script may be created by
.I xtmconvert
or by an editor.
.PP
When
.I xtmconvert
is converting from
.B internal
format to
.B summary
format some of the information in the test script is not preserved:
.IP
Information about which device(s) generated the input actions is not preserved.
.IP
All adjacent relative pointer motion and pointer jump input actions are
consolidated into one pointer jump input action to the final pointer position.
The time delay for the pointer jump input action is the sum of the time delays
for all of the consolidated input actions.
.IP
The time delays for all adjacent key or mouse button input actions are
summed up into one time delay before the next input action
that is not a key or mouse button input action.
.PP
The key and mouse button input actions are converted into a form
that is easier for a human being to read:
.IP
The key codes associated with each key input action are converted to
their corresponding key name.
The key name is the X server's name for that key on the X server's keyboard.
It may be composed of a single character for common keys
(such as
.B a
for the key labled `A' on the keyboard),
or it may be composed of multiple characters for other keys
(such as
.B bracketleft
for the key labeled `[' on the keyboard).
.IP
A key press input action followed by a key release input action
for the same key is converted into a key stroke.
.sp
.sp
.sp
.IP
A key stroke that has a multi-character key name
is converted to a line containing:
.PP
.RS
.RS
.B <\fIkeyname\fB>
.RE
.RE
.PP
.IP
A key stroke that has a single-character key name
is converted to that character.
The first such character starts a new line,
and any immediately following single characters are put on the same line.
.IP
A key press input action not followed by a key release input action
for the same key is converted to a line containing:
.PP
.RS
.RS
.B <KEY_DOWN \fIkeyname\fB>
.RE
.RE
.PP
.IP
A key release input action not following a key press input action
for the same key is converted to a line containing:
.PP
.RS
.RS
.B <KEY_UP \fIkeyname\fB>
.RE
.RE
.PP
.IP
The mouse buttons do not have a key name defined for them by the X server.
.I Xtmconvert
uses
.B Button1, Button2, Button3,
and so forth as the equivalent of the key names for the mouse buttons.
Otherwise, the mouse button input actions are treated the same as the
key input actions.
.PP
The other types of input actions are converted to lines containing:
.TP
.B <JUMP \fIxpixloc ypixloc timedelay\fB>
This is a pointer jump input action.
The
.I xpixloc
and
.I ypixloc
values are the x and y coordinates of the pixel that the pointer will move to.
The
.I timedelay
value is the number of milliseconds to delay before moving the pointer.
.TP
.B <MOTION \fIxpixmov ypixmov timedelay\fB>
This is a relative pointer motion input action.
The
.I xpixmov
and
.I ypixmov
values are the relative offsets from the current pointer position
to the new pointer position.
The
.I timedelay
value is the number of milliseconds to delay before moving the pointer.
.TP
.B <TIME \fItimedelay\fB>
This is a time delay input action.
The
.I timedelay
value is the amount of time to delay before going on to the next input action.
.PP
The requests for verification of image data from the display
are converted to lines containing:
.TP
.B <MATCH MOUSE\fR[ \fIfilename screennum windowx windowy\fR]\fB>
The image verification data came from the window that was a child of the root
window and that contained the mouse
at the time that the request was put in the test script.
.TP
.B <MATCH PARTIAL\fR[ \fIfilename screennum windowx windowy\fR]\fB>
The image verification data came from a user-specified partial window
on the X server at the time that the request was put in the test script.
.TP
.B <MATCH SCREEN\fR[ \fIfilename screennum windowx windowy\fR]\fB>
The image verification data came from the entire screen on the X server
at the time that the request was put in the test script.
.TP
.B <MATCH TOP\fR[ \fIfilename screennum windowx windowy\fR]\fB>
The image verification data came from the window that was a child of the root
window and that was the "top" window (as defined by
the X server) at the time that the request was put in the test script.
.PP
The name of the image verification data file associated with a particular
request is placed as
.I filename
in the request.
.PP
The image verification data file
holds all of the information about the image data except for
the screen number and the x and y coordinates of the window containing
the image data.
Those values are placed in the request.
.PP
If there is no image verification data in the test script, then none of the
optional data will be placed in the request.
.PP
The version number is converted to a line containing:
.PP
.RS
.B <VERSION \fIversionnumber\fB>\fR
.RE
.PP
The
.I versionnumber
value holds the current version number of the test script.
.PP
A checksum mode command is converted to a line containing:
.PP
.RS
.B <CHECKSUMS \fIchecksummode\fB>\fR
.RE
.PP
The
.I checksummode
value holds the current checksum mode of the test script
(either \fBOFF\fR or \fBON\fR).
.PP
A comment is converted to a line containing:
.PP
.RS
.B <COMMENT \fIcomment\fB>
.RE
.PP
The
.I comment
may contain any printable characters except a ">".
It should be limited to less than 70 characters.
.PP
When
.I xtmconvert
is converting from
.B summary
format to
.B internal
format some of the information needed for the
.B internal
format of the test script is not in the
.B summary
format of the test script.
The additional information needed is taken from
.I .Xdefaults
variables.
.SS "Example of an Output Format Test Script"
.PP
The
.B internal
format of this test script was created by recording actual user actions 
using
.I xtmrecord(1).
.PP
This test script starts with the cursor on the right half of a display.
It moves the cursor to the left half of the display and types "echo it worked!"
followed by the "Return" key.
It then moves the cursor back to the right half of the display and terminates.
.PP
Contrast this with the
.B summary
format of the same test script shown below.
.PP
The
.B Count
field was deleted from the end of the input action lines in
this example to make it fit in the document.
.PP
.nf
VERSION [1]
JUMP       DEV [0]   X [ 547]  Y [ 339]  TIME (ms) [     0]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [   768]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [   199]
MOTION     DEV [1]   X [   0]  Y [  -1]  TIME (ms) [    79]
MOTION     DEV [1]   X [   0]  Y [  -1]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    60]
MOTION     DEV [1]   X [  -1]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [  -2]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    35]
MOTION     DEV [1]   X [  -2]  Y [  -1]  TIME (ms) [    11]
MOTION     DEV [1]   X [  -1]  Y [  -1]  TIME (ms) [    13]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -3]  Y [  -3]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -3]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -3]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -3]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -3]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -3]  Y [  -1]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -3]  Y [  -2]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -2]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -1]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [  -2]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -2]  Y [   0]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -1]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [  -2]  TIME (ms) [    27]
MOTION     DEV [1]   X [  -1]  Y [  -1]  TIME (ms) [    32]
MOTION     DEV [1]   X [  -1]  Y [  -1]  TIME (ms) [    39]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    40]
MOTION     DEV [1]   X [  -1]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    39]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [  -2]  TIME (ms) [    20]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [   0]  Y [  -2]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [   0]  TIME (ms) [    20]
MOTION     DEV [1]   X [   0]  Y [  -1]  TIME (ms) [    59]
MOTION     DEV [1]   X [  -1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -1]  Y [  -1]  TIME (ms) [    19]
MOTION     DEV [1]   X [  -2]  Y [   0]  TIME (ms) [   140]
KEY_DOWN   DEV [3]   KEY [e]             TIME (ms) [  2429]
KEY_UP     DEV [3]   KEY [e]             TIME (ms) [    39]
KEY_DOWN   DEV [3]   KEY [c]             TIME (ms) [   199]
KEY_UP     DEV [3]   KEY [c]             TIME (ms) [    60]
KEY_DOWN   DEV [3]   KEY [h]             TIME (ms) [    79]
KEY_UP     DEV [3]   KEY [h]             TIME (ms) [    59]
KEY_DOWN   DEV [3]   KEY [o]             TIME (ms) [   169]
KEY_UP     DEV [3]   KEY [o]             TIME (ms) [    80]
KEY_DOWN   DEV [3]   KEY [space]         TIME (ms) [   439]
KEY_UP     DEV [3]   KEY [space]         TIME (ms) [   100]
KEY_DOWN   DEV [3]   KEY [i]             TIME (ms) [   220]
KEY_UP     DEV [3]   KEY [i]             TIME (ms) [    99]
KEY_DOWN   DEV [3]   KEY [t]             TIME (ms) [   329]
KEY_UP     DEV [3]   KEY [t]             TIME (ms) [    80]
KEY_DOWN   DEV [3]   KEY [space]         TIME (ms) [  1109]
KEY_UP     DEV [3]   KEY [space]         TIME (ms) [    99]
KEY_DOWN   DEV [3]   KEY [w]             TIME (ms) [   450]
KEY_UP     DEV [3]   KEY [w]             TIME (ms) [   100]
KEY_DOWN   DEV [3]   KEY [o]             TIME (ms) [    19]
KEY_UP     DEV [3]   KEY [o]             TIME (ms) [   100]
KEY_DOWN   DEV [3]   KEY [r]             TIME (ms) [   119]
KEY_UP     DEV [3]   KEY [r]             TIME (ms) [    59]
KEY_DOWN   DEV [3]   KEY [k]             TIME (ms) [   240]
KEY_UP     DEV [3]   KEY [k]             TIME (ms) [    79]
KEY_DOWN   DEV [3]   KEY [e]             TIME (ms) [   159]
KEY_UP     DEV [3]   KEY [e]             TIME (ms) [    40]
KEY_DOWN   DEV [3]   KEY [d]             TIME (ms) [   229]
KEY_UP     DEV [3]   KEY [d]             TIME (ms) [    59]
KEY_DOWN   DEV [3]   KEY [Shift_L]       TIME (ms) [   480]
KEY_DOWN   DEV [3]   KEY [1]             TIME (ms) [   849]
KEY_UP     DEV [3]   KEY [1]             TIME (ms) [    99]
KEY_UP     DEV [3]   KEY [Shift_L]       TIME (ms) [    39]
KEY_DOWN   DEV [3]   KEY [Return]        TIME (ms) [  1920]
KEY_UP     DEV [3]   KEY [Return]        TIME (ms) [   100]
MOTION     DEV [1]   X [   1]  Y [   0]  TIME (ms) [  1920]
MOTION     DEV [1]   X [   1]  Y [   0]  TIME (ms) [    20]
MOTION     DEV [1]   X [   1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   1]  TIME (ms) [    19]
MOTION     DEV [1]   X [   3]  Y [   1]  TIME (ms) [    20]
MOTION     DEV [1]   X [   3]  Y [   2]  TIME (ms) [    19]
MOTION     DEV [1]   X [   3]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [   4]  Y [   2]  TIME (ms) [    20]
MOTION     DEV [1]   X [   4]  Y [   0]  TIME (ms) [    33]
MOTION     DEV [1]   X [   4]  Y [   1]  TIME (ms) [     6]
MOTION     DEV [1]   X [   2]  Y [   2]  TIME (ms) [    20]
MOTION     DEV [1]   X [   2]  Y [   2]  TIME (ms) [    19]
MOTION     DEV [1]   X [   1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   2]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   2]  TIME (ms) [    20]
MOTION     DEV [1]   X [   2]  Y [   1]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   1]  TIME (ms) [    19]
MOTION     DEV [1]   X [   1]  Y [   2]  TIME (ms) [    19]
MOTION     DEV [1]   X [   1]  Y [   2]  TIME (ms) [    19]
MOTION     DEV [1]   X [   1]  Y [   2]  TIME (ms) [    19]
MOTION     DEV [1]   X [   3]  Y [   2]  TIME (ms) [    20]
MOTION     DEV [1]   X [   2]  Y [   4]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   4]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   3]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   3]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   4]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   2]  TIME (ms) [    20]
MOTION     DEV [1]   X [   2]  Y [   3]  TIME (ms) [    19]
MOTION     DEV [1]   X [   3]  Y [   4]  TIME (ms) [    20]
MOTION     DEV [1]   X [   3]  Y [   4]  TIME (ms) [   108]
MOTION     DEV [1]   X [   3]  Y [   3]  TIME (ms) [     1]
MOTION     DEV [1]   X [   2]  Y [   3]  TIME (ms) [     1]
MOTION     DEV [1]   X [   2]  Y [   1]  TIME (ms) [    12]
MOTION     DEV [1]   X [   1]  Y [   1]  TIME (ms) [     1]
MOTION     DEV [1]   X [   1]  Y [   2]  TIME (ms) [    20]
MOTION     DEV [1]   X [   2]  Y [   0]  TIME (ms) [     5]
MOTION     DEV [1]   X [   0]  Y [   1]  TIME (ms) [     8]
MOTION     DEV [1]   X [   1]  Y [   1]  TIME (ms) [    19]
MOTION     DEV [1]   X [   1]  Y [   1]  TIME (ms) [    19]
MOTION     DEV [1]   X [   0]  Y [   1]  TIME (ms) [    20]
MOTION     DEV [1]   X [   1]  Y [   0]  TIME (ms) [    19]
MOTION     DEV [1]   X [   2]  Y [   2]  TIME (ms) [    20]
MOTION     DEV [1]   X [   2]  Y [   1]  TIME (ms) [    19]
MOTION     DEV [1]   X [   0]  Y [   1]  TIME (ms) [    19]
MOTION     DEV [1]   X [   1]  Y [   0]  TIME (ms) [    59]
TIME                                     TIME (ms) [  1179]
MOTION     DEV [1]   X [   0]  Y [   0]  TIME (ms) [     2]
JUMP       DEV [0]   X [ 556]  Y [ 357]  TIME (ms) [     0]
.fi
.SS "Example of a Summary Format Test Script"
The
.B internal
format of this test script was created by recording actual user actions 
using
.I xtmrecord(1).
.PP
This test script starts with the cursor on the right half of a display.
It moves the cursor to the left half of the display and types "echo it worked!"
followed by the "Return" key.
It then moves the cursor back to the right half of the display and terminates.
.PP
Contrast this with the
.B output
format of the same test script shown above.
.PP
.nf
<VERSION 1>
<JUMP    472  283   2217>
echo
<space>
it
<space>
worked
<KEY_DOWN Shift_L>
1
<KEY_UP Shift_L>
<Return>
<TIME  10690>
<JUMP    556  357   2811>
<TIME   1179>
<JUMP    556  357      2>
.fi
.SS X Server Key Names
This is a table of key names used by most Hewlett Packard X servers.
Other X servers should use most of the same key names,
with additions or deletions for keys not found on Hewlett Packard X servers.
.PP
These are the single-character key names:
.PP
.RS
.nf
1234567890
.sp
abcdefghijklmnopqrstuvwxyz
.fi
.RE
.PP
These are the multi-character key names:
.PP
.RS
.nf
Key Name            Corresponding Key Label
\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-
backslash           "\\"
bracketleft         "["
bracketright        "]"
comma               ","
equal               "="
minus               "-"
period              "."
quoteleft           "`"
quoteright          "'"
semicolon           ";"
slash               "/"
space               " " (generated by the space bar)
BackSpace           "Back space"
Break               "Break"
Cancel              "Stop"
Caps_Lock           "Caps"
Clear               "Clear display"
ClearLine           "Clear line"
Control_L           "CTRL"
DeleteChar          "Delete char"
DeleteLine          "Delete line"
Down                (the downward-pointing arrow)
Escape              "ESC"
Execute             "Enter"
Home                (the upper-left-pointing arrow)
InsertChar          "Insert char"
InsertLine          "Insert line"
Left                (the left-pointing arrow)
Menu                "Menu"
Meta_L              "Extend char" (left-hand)
Meta_R              "Extend char" (right-hand)
Next                "Next"
Prior               "Prev"
Return              "Return"
Right               (the right-pointing arrow)
Select              "Select"
Shift_L             "Shift" (left-hand)
Shift_R             "Shift" (right-hand)
System              "System"
Tab                 "Tab"
Up                  (the upper-pointing arrow)
F1                  "f1"
F2                  "f2"
F3                  "f3"
F4                  "f4"
F5                  "f5"
F6                  "f6"
Key Name            Corresponding Key Label
\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-
F7                  "f7"
F8                  "f8"
KP_0                "0"     (on the keypad)
KP_1                "1"     (on the keypad)
KP_2                "2"     (on the keypad)
KP_3                "3"     (on the keypad)
KP_4                "4"     (on the keypad)
KP_5                "5"     (on the keypad)
KP_6                "6"     (on the keypad)
KP_7                "7"     (on the keypad)
KP_8                "8"     (on the keypad)
KP_9                "9"     (on the keypad)
KP_Add              "+"     (on the keypad)
KP_Decimal          "."     (on the keypad)
KP_Divide           "/"     (on the keypad)
KP_Enter            "Enter" (on the keypad)
KP_F1               (leftmost blank key)
KP_F2               (second from the left blank key)
KP_F3               (second from the right blank key)
KP_F4               (rightmost blank key)
KP_Multiply         "*"     (on the keypad)
KP_Separator        ","     (on the keypad)
KP_Subtract         "-"     (on the keypad)
KP_Tab              "Tab"   (on the keypad)
.fi
.RE
.SS .Xdefaults Variable Usage
.I Xtmconvert
recognizes the following
.I .Xdefaults
variables (shown with their default values):
.PP
.RS
xtmconvert.MatchRetries:       3
.RE
.RS
xtmconvert.RetryInterval:      5000
.RE
.RS
xtmconvert.KeyDevice:          0
.RE
.RS
xtmconvert.PointerDevice:      0
.RE
.RS
xtmconvert.KeyInterval:        50
.RE
.RS
xtmconvert.StrokeInterval:     50
.RE
.PP
All of these variables are only used when converting a
.B summary
format test script to an
.B internal
format test script.
.PP
The
.I MatchRetries
variable controls the number of times a failing image data verification will be
retried when the test script is executed using
.I xtmexecute(1).
It has a range of 0 to 32767 retries.
.PP
The
.I RetryInterval
variable controls the interval in milliseconds between each retry when the
test script is executed using
.I xtmexecute(1).
It has a range of 0 to 2,147,483,647 milliseconds (approximately 25 days).
.PP
The
.I KeyDevice
variable holds the value for the keyboard device.
This is a provision for future support of multiple (distinguishable)
keyboard devices
(the default is 3 for Hewlett Packard X servers).
It has a range of 0 to 14.
.PP
The
.I PointerDevice
variable holds the value for the pointer (mouse) device.
This is a provision for future support of multiple (distinguishable)
pointer devices
(the default is 1 for Hewlett Packard X servers).
It has a range of 0 to 14.
.PP
The
.I KeyInterval
variable holds the time delay before each key transition.
It has a range of 0 to 2,147,483,647 milliseconds (approximately 25 days).
.PP
The
.I StrokeInterval
variable holds the time delay after the down transition of a key and before 
the up transition of the same key in a key stroke.
It has a range of 0 to 2,147,483,647 milliseconds (approximately 25 days).
.SH SEE ALSO
xtmrecord(1), xtmexecute(1), xwd(1).
.SH COPYRIGHT
.PP
Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
.PP
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology
.PP
Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.
.PP
This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.
