/************************************************************************
 *
 *	xtm.h
 *
 ***********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/************************************************************************
 *	defines for xtmrecord, xtmexecute, and xtmconvert
 ***********************************************************************/

/*
 * this version number should only change when the test script format changes
 */
#define VERSION_NUMBER				1

#ifdef hpux

/*
 * the device number corresponding to the mouse
 */
#define MOTION_DEVICE				1
/*
 * the device number corresponding to the keyboard
 */
#define KEYBOARD_DEVICE				3

#else

/*
 * the device number corresponding to the mouse
 */
#define MOTION_DEVICE				0
/*
 * the device number corresponding to the keyboard
 */
#define KEYBOARD_DEVICE				0

#endif

/*
 * the default delay time before key transitions
 */
#define KEY_INTERVAL				50
/*
 * the default delay time after the down transition of a key and before
 * the up transition of the same key in a key stroke sequence
 */
#define STROKE_INTERVAL				50

#define max(a,b) ((a) > (b) ? (a) : (b))
#define min(a,b) ((a) > (b) ? (b) : (a))

/*
 * This is the default size of the buffer used to hold image data from
 * the screen.  It must be divisible by 8.  It must be large enough to 
 * hold one line of pixels from the screen.  It must also be small
 * enough so that twice the value can still fit in an unsigned int.
 */
#define	DEFAULT_SCREEN_BUFFER_SIZE		32760
/*
 * This is the maximum size for an unsigned int
 */
#define UNSIGNED_INT_MAX			0xffffffff
/*
 * This is the size of the input action buffer in xtmrecord and xtmconvert.
 * It is used to improve performance, and may be changed if desired.
 */
#define	INPUT_ACTION_BUFFER_SIZE		4096
/*
 * record mode state value
 */
#define	RECORD_ACTIONS_MODE			0x00
/*
 * command mode state value
 */
#define	COMMAND_MODE				0x01
/*
 * default match interval
 */
#define	DEFAULT_INTERVAL			5000
/*
 * default # match retries
 */
#define	DEFAULT_RETRY				3
/*
 * default input action delta
 */
#define	DEFAULT_DELTA				0
/*
 * add to input action interval
 */
#define	ADD_TO_INPUT_ACTION_TIMES		1
/*
 * subtract from interval
 */
#define	SUBTRACT_FROM_INPUT_ACTION_TIMES	2
/*
 * multiply input action interval
 */
#define	MULTIPLY_INPUT_ACTION_TIMES		3
/*
 * divide input action interval
 */
#define	DIVIDE_INPUT_ACTION_TIMES		4
/*
 * use as minimum interval
 */
#define	MINIMUM_INPUT_ACTION_TIME		5
/*
 * flag to indicate short delay time size
 */
#define SHORT_DELAY_SIZE			0
/*
 * flag to indicate long delay time size
 */
#define LONG_DELAY_SIZE				1
/*
 * file name suffixes
 */
#define SCRIPT_ENDING				".scr"
#define SUMMARY_ENDING				".sum"
#define OUTPUT_ENDING				".out"
#define NEW_ENDING				".new"
#define LOG_FILE_ENDING				".log"
#define FAILURE_FILE_ENDING			".err"
/*
 * file name suffix length
 */
#define	ENDING_LENGTH				4
/*
 * maximum number of matches in one test script
 *
 * (this has to fit in two characters)
 */
#define MATCH_LIMIT				99
/*
 * Translation mode FLAGS
 */
#define SCRIPT_TO_SUMMARY			0
#define SCRIPT_TO_OUTPUT			1
#define SUMMARY_TO_SCRIPT			2
#define OUTPUT_TO_SCRIPT			3
/*
 * used in tranout.c to indicate that no input action is pending
 */
#define	NO_INPUT_ACTION_PENDING			-1
/*
 * maximum file name length
 */
#define	MAXPATH   			 	256
/*
 * file creation mode value (the file needs to be both readable and writable)
 */
#define FILE_CREATION_MODE			0666
/*
 * This is the name given to a window that did not otherwise have one.
 * It is set when reading match data from the display.  It is used if the
 * match data is later converted to xwd format for redisplay.
 */
#define	DEFAULT_WINDOW_NAME			"xwdump"
/*
 * This is the maximum size for a line of text written to an internal
 * format file.
 */
#define	WRITE_BUFFER_SIZE			512
/*
 * This is the maximum number of characters an integer can take when converted
 * to a character representation.
 */
#define	MAX_INTEGER_CHARS			20
/*
 * this string corresponds to the "command" key
 */
#define	COMMAND_KEY_STRING			"KP_F1"
/*
 * this string corresponds to the "toggle checksum mode" key
 */
#define	CHECKSUM_KEY_STRING			"c"
/*
 * this string corresponds to the "match the window the mouse is in" key
 */
#define	MATCHMOUSE_KEY_STRING			"m"
/*
 * this string corresponds to the "match screen" key
 */
#define	MATCHSCREEN_KEY_STRING			"s"
/*
 * this string corresponds to the "match the top window" key
 */
#define	MATCHTOP_KEY_STRING			"t"
/*
 * this string corresponds to the "match a partial window" key
 */
#define	MATCHPARTIAL_KEY_STRING			"p"
/*
 * this string corresponds to the "accept partial window" key
 */
#define	ACCEPTPARTIAL_KEY_STRING		"y"
/*
 * this string corresponds to the "reject partial window" key
 */
#define	REJECTPARTIAL_KEY_STRING		"n"
/*
 * this string corresponds to the "quit" key
 */
#define	QUIT_KEY_STRING				"q"
/*
 * this string corresponds to the "resume" key
 */
#define	RESUME_KEY_STRING			"r"

/****************************************************************************
 *
 *	This structure contains information on how to modify the input action
 *	timing interval recorded in the test script.  The fields contain the
 *	following information:
 *		1). retries  - # of times to retry a match.
 *		2). interval - time between match attempts, in seconds.
 *		3). delt     - type of change to make; +, -, *, /.
 *		4). fact     - amount to add, subtract, multiply, or divide,
 *			       or amount to use as a minimum interval.
 *			       Addition & subtraction are in milliseconds.
 *
 ****************************************************************************/

/*
 * factors for playback modification
 */
struct  playback_info
{
	/*
	 * # of match retries
	 */
	INT32	retries;
	/*
	 * interval between matches
	 */
	INT32	interval;
	/*
	 * type of delta
	 */
	INT32	delta;
	/*
	 * multiply or divide delta factor
	 */
	double	double_factor;
	/*
	 * other delta factor
	 */
	INT32	factor;
};

/*
 * this structure is used to describe match data while it is being used
 */
struct 	match_data
{
	/*
	 * retry count
	 */
	INT32		retry;
	/*
	 * match interval
	 */
	INT32		intv;
	/*
	 * number of bytes in the match data
	 */
	INT32		cnt;
	/*
	 * checksum of match data (used only if in checksum mode)
	 */
	CARD32		checksum;
	/*
	 * match type code (m, r, s, t, w)
	 */
	INT8		type;
	/*
	 * file descriptor for the temporary file holding
	 * the compressed match data
	 */
	int		tfd;
	/*
	 * screen number of the screen containing the window
	 * containing the match data
	 */
	int		screen_number;
	/*
	 * x origin of the window containing the match data
	 */
	int 		window_x;
	/*
	 * y origin of the window containing the match data
	 */
	int 		window_y;
	/*
	 * width of the window containing the match data
	 */
	int		window_width;
	/*
	 * height of the window containing the match data
	 */
	int		window_height;
	/*
	 * width of the border of the window containing the match data
	 */
	int		window_border_width;
	/*
	 * name of the window (if it had one)
	 */
	char		window_name[MAXPATH];
	/*
	 * x coord in window of match data
	 */
	int 		x;
	/*
	 * y coord in window of match data
	 */
	int 		y;
	/*
	 * width of match data in pixels
	 */
	int 		width;
	/*
	 * height of match data in pixels
	 */
	int 		height;
	/*
	 * depth of the match data
	 */
	int		depth;
	/*
	 * format of the match data (always ZPixmap for now)
	 */
	int		format;
	/*
	 * xoffset of the match data
	 */
	int		xoffset;
	/*
	 * data byte order of the match data
	 */
	int		byte_order;
	/*
	 * quant. of scanline (8, 16, 32) for the match data
	 */
	int		bitmap_unit;
	/*
	 * bit order (LSBFirst or MSBfirst) of the match data
	 */
	int		bitmap_bit_order;
	/*
	 * pad the match data to 8, 16, or 32 bit boundary
	 */
	int		bitmap_pad;
	/*
	 * number of bytes per line of match data (padding included)
	 */
	int 		bytes_per_line;
	/*
	 * # of bits/pixel in match data
	 */
	int 		bits_per_pixel;
	/*
	 * visual class of match data
	 */
	int		visual_class;
	/*
	 * ZPixmap format red mask for the match data
	 */
	unsigned long	red_mask;
	/*
	 * ZPixmap format green mask for the match data
	 */
	unsigned long	green_mask;
	/*
	 * ZPixmap format blue mask for the match data
	 */
	unsigned long	blue_mask;
	/*
	 * log base 2 of distinct color values for the match data
	 */
	int		bits_per_rgb;
	/*
	 * number of entries in the colormap for the match data
	 */
	int		colormap_entries;
	/*
	 * number of color structures used to describe the match data
	 */
	INT32		ncolors;
	/*
	 * pointer to the list of color structures
	 */
	XColor		*color_ptr;
};

/*
 * items used for partial rectangle matching
 */

typedef
struct _BoxGD
{
  Display	*display;
  int		screen;
  Window	rootWindow;
  GC		xorGC;
  Bool		preMove;
  int		preMoveX;
  int		preMoveY;
  int		moveThreshold;
  Cursor	ulcCursor;
  Cursor	lrcCursor;
} GD;

#define MOVE_OUTLINE_WIDTH	2
#define POINTER_NO		1

#define ULC			2
#define LRC			3

/*
 * values returned by get_rect_window
 */
#define GoodCoverage		0
#define NoCoverage		1
#define Obscures		2
