/**********************************************************************
 *
 *	temptoint.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * variables
 **********************************************************************/

extern FILE	*G_msg_file;
/*
 * if true then use checksums for match data
 */
extern int	G_checksum_flag;
extern int	errno;

/**********************************************************************
 * function declarations
 **********************************************************************/

void	write_match_data_to_internal();
void	copy_match_data();
long	lseek();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	temptoint
 *
 *	Writes match data contained in temporary format to a file
 *	in internal format.
 */
void
temptoint(internal_format_fd, match_data_ptr)
/*
 * file descriptor of the file (assumed to be in internal format)
 * where the match data is to be written
 */
int			internal_format_fd;
/*
 * this points to the structure that describes the match data
 */
struct match_data	*match_data_ptr;
{
	/*
	 * write the match data information to the internal format file
	 */
	write_match_data_to_internal(internal_format_fd, match_data_ptr);
	/*
	 * if not using checksums, copy the compressed match data to the
	 * internal format file
	 */
	if (!G_checksum_flag)
	{
		/*
		 * reset the file pointer to the beginning
		 * of the match data temp file
		 */
		if (lseek(match_data_ptr->tfd, 0L, 0) == -1)
		{
			(void) fprintf(G_msg_file,
				       "error %d while seeking in match data temp file\n",
				       errno);
			exit(1);
		}
		/*
		 * copy the match data from the temporary file
		 * to the internal format file
		 */
		copy_match_data(match_data_ptr->tfd,
				internal_format_fd,
				match_data_ptr->cnt);
		/*
		 * close the match data temp file
		 */
		if (close(match_data_ptr->tfd) == -1)
		{
			(void) fprintf(G_msg_file,
				       "error %d while closing match data temp file\n",
				       errno);
			exit(1);
		}
	}
	/*
	 * if there were any color map entries, free their space
	 */
	if ((match_data_ptr->ncolors > 0) &&
	    (match_data_ptr->color_ptr != (XColor *) 0))
	{
		free((char *) (match_data_ptr->color_ptr));
	}
	/*
	 * the match_data structure must be freed by the calling routine
	 */
}
