/**********************************************************************
 *
 *	sigcatch.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * for sigcatch function
 */
#include <signal.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>
/*
 * ???
 */
#include <X11/extensions/xtestext1.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * device file pointers 
 */
extern FILE		*G_msg_file;
/*
 * ???
 */
extern Display		*G_disp_ptr;

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *      err1
 */
static int
err1(sig, code)
/*
 * ???
 */
int     sig;
/*
 * ???
 */
int     code;
{

        /*
         * this function is defined in the X testing extension to Xlib
         */
	if (XTestStopInput(G_disp_ptr) == -1)
	{
		(void) fprintf(G_msg_file, "XTestStopInput failed\n");
		exit(1);
	}
        /*
         * should this function discard events or not??????
         * (this function should have had a parameter in the X10
         * version, but didn't)
         */
        XSync(G_disp_ptr, 0);

        /*
         * this function is defined in the X testing extension to Xlib
         */
	if (XTestReset(G_disp_ptr) == -1)
	{
		(void) fprintf(G_msg_file, "XTestReset failed\n");
		exit(1);
	}

        if (sig == SIGINT)
        {
                (void) printf("\nInterrupt received, program terminated.\n\n");
                exit(1);
        }
        (void) fprintf(G_msg_file,
		       "%sSignal was: %d.\nCode was: %d\n",
		       "Signal received and ignored.\n",
		       sig,
		       code);
        return(0);
}

/**********************************************************************
 *
 *      sigcatch
 *
 *      This function sets signal catching.
 */
void
sigcatch()
{
        (void) signal(SIGILL, err1);
        (void) signal(SIGTRAP, err1);
        (void) signal(SIGIOT, err1);
        (void) signal(SIGEMT, err1);
        (void) signal(SIGFPE, err1);
        (void) signal(SIGBUS, err1);
        (void) signal(SIGSEGV, err1);
        (void) signal(SIGSYS, err1);
        (void) signal(SIGPIPE, err1);
        (void) signal(SIGALRM, err1);
        (void) signal(SIGTERM, err1);
        (void) signal(SIGUSR1, err1);
        (void) signal(SIGUSR2, err1);
        (void) signal(SIGCLD, err1);
#ifndef XPI
#endif
        /*
         * catch hangup signal
         */
        (void) signal(SIGHUP, err1);
        /*
         * catch interrupt signal
         */
        (void) signal(SIGINT, err1);
        /*
         * catch quit
         */
        (void) signal(SIGQUIT, err1);
}
