/**********************************************************************
 *
 *	readchk.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>

/**********************************************************************
 * external variables
 **********************************************************************/

extern FILE		*G_msg_file;
extern int		errno;

/**********************************************************************
 * functions
 **********************************************************************/

/***********************************************************************
 *
 *      readchk
 *
 *      This routine reads from a file and checks the return code.
 */
void
readchk(filedesc, buffer, count, errmsg)
/*
 * file descriptor
 */
int		filedesc;
/*
 * Character string buffer
 */
char		*buffer;
/*
 * Number of characters to read
 */
unsigned int	count;
/*
 * Error message string
 */
char		*errmsg;
{
	/*
	 * holds the return value from the read call
	 */
	int	ret;

	/*
	 * read count characters from filedesc into buffer
	 */
        if((ret = read(filedesc, buffer, count)) != count)
        {
                (void) fprintf(G_msg_file, errmsg);
		(void) fprintf(G_msg_file, "errno was %d\n", errno);
		(void) fprintf(G_msg_file, "count was %d\n", count);
		(void) fprintf(G_msg_file, "return value was %d\n", ret);
                exit(1);
        }
}
