/**********************************************************************
 *
 *	inttotemp.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>
/*
 * X library files
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

extern int	G_checksum_flag;

/**********************************************************************
 * function definitions
 **********************************************************************/

void	read_match_data_from_internal();
void	gettmp();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************
 *
 *	inttotemp
 *
 *	Read the match data from an internal format file into a match data
 *	structure and (if not using checksums) a match data temp file.
 */
void
inttotemp(match_data_ptr, internal_format_fd)
/*
 * points to the match data structure
 */
struct match_data	*match_data_ptr;
/*
 * holds the file descriptor for the internal format file
 */
int			internal_format_fd;
{
	char	name_buffer[MAXPATH];

	/*
	 * read the match data information into the match data structure
	 */
	read_match_data_from_internal(internal_format_fd, match_data_ptr);
	if (!G_checksum_flag)
	{
		/*
		 * get a temporary file for the match data
		 */
		gettmp(&(match_data_ptr->tfd), name_buffer);
		/*
		 * if there is any match data, copy it to the temporary file
		 */
		if (match_data_ptr->cnt != 0)
		{
			copy_match_data(internal_format_fd,
					match_data_ptr->tfd,
					match_data_ptr->cnt);
		}
	}
}
