/**********************************************************************
 *
 *	inttomatd.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * pointer to diagnostic/error message file
 */
extern FILE		*G_msg_file;
extern int		errno;

/**********************************************************************
 * function definitions
 **********************************************************************/

void	readchk();
char	*malloc();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	read_match_data_from_internal
 *
 *	Reads the data into the match data structure from the
 *	internal format file.
 */
void
read_match_data_from_internal(internal_format_fd, match_data_ptr)
/*
 * file descriptor of the file (assumed to be in internal format)
 * from which the match data is to be read
 */
int			internal_format_fd;
/*
 * this points to the structure that describes the match data
 */
struct match_data	*match_data_ptr;
{
	/*
	 * points to a color map structure
	 */
	XColor	*color_ptr;
	/*
	 * keeps track of the number of color map structures
	 */
	INT32	i;
	/*
	 * holds the length of the window name
	 */
	int	window_name_length;

	/*
	 * read in the match type
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->type),
		sizeof(match_data_ptr->type),
		"Error while reading match type\n");
	/*
	 * read in the match retry count
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->retry),
		sizeof(match_data_ptr->retry),
		"Error while reading match retry count\n");
	/*
	 * read in the match retry interval
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->intv),
		sizeof(match_data_ptr->intv),
		"Error while reading match retry interval\n");
	/*
	 * read in the count of the compressed match image data bytes
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->cnt),
		sizeof(match_data_ptr->cnt),
		"Error while reading match cnt\n");
	/*
	 * read in the checksum
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->checksum),
		sizeof(match_data_ptr->checksum),
		"Error while reading match checksum\n");
	/*
	 * read in the match screen number
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->screen_number),
		sizeof(match_data_ptr->screen_number),
		"Error while reading match screen number\n");
	/*
	 * read in the match window x coordinate
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->window_x),
		sizeof(match_data_ptr->window_x),
		"Error while reading match window x coordinate\n");
	/*
	 * read in the match window y coordinate
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->window_y),
		sizeof(match_data_ptr->window_y),
		"Error while reading match window y coordinate\n");
	/*
	 * read in the match window width
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->window_width),
		sizeof(match_data_ptr->window_width),
		"Error while reading match window width\n");
	/*
	 * read in the match window height
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->window_height),
		sizeof(match_data_ptr->window_height),
		"Error while reading match window height\n");
	/*
	 * read in the match window border width
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->window_border_width),
		sizeof(match_data_ptr->window_border_width),
		"Error while reading match window border width\n");
	/*
	 * read in the match window name length (this includes
	 * one byte for the null character)
	 */
	readchk(internal_format_fd,
		(char *) &(window_name_length),
		sizeof(window_name_length),
		"Error while reading match window name length\n");
	/*
	 * read in the match window name
	 */
	readchk(internal_format_fd,
		match_data_ptr->window_name,
		(unsigned int) window_name_length,
		"Error while reading match window name\n");
	/*
	 * read in the match data x coordinate
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->x),
		sizeof(match_data_ptr->x),
		"Error while reading match data x coordinate\n");
	/*
	 * read in the match data y coordinate
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->y),
		sizeof(match_data_ptr->y),
		"Error while reading match data y coordinate\n");
	/*
	 * read in the match data width
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->width),
		sizeof(match_data_ptr->width),
		"Error while reading match data width\n");
	/*
	 * read in the match data height
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->height),
		sizeof(match_data_ptr->height),
		"Error while reading match data height\n");
	/*
	 * read in the match data depth
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->depth),
		sizeof(match_data_ptr->depth),
		"Error while reading match data depth\n");
	/*
	 * read in the match data format
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->format),
		sizeof(match_data_ptr->format),
		"Error while reading match data format\n");
	/*
	 * read in the match data xoffset
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->xoffset),
		sizeof(match_data_ptr->xoffset),
		"Error while reading match data xoffset\n");
	/*
	 * read in the match data byte order
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->byte_order),
		sizeof(match_data_ptr->byte_order),
		"Error while reading match data byte order\n");
	/*
	 * read in the match data bitmap unit
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->bitmap_unit),
		sizeof(match_data_ptr->bitmap_unit),
		"Error while reading match data bitmap unit\n");
	/*
	 * read in the match data bitmap bit order
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->bitmap_bit_order),
		sizeof(match_data_ptr->bitmap_bit_order),
		"Error while reading match data bitmap bit order\n");
	/*
	 * read in the match data bitmap pad
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->bitmap_pad),
		sizeof(match_data_ptr->bitmap_pad),
		"Error while reading match data bitmap pad\n");
	/*
	 * read in the match data bytes per line
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->bytes_per_line),
		sizeof(match_data_ptr->bytes_per_line),
		"Error while reading match data bytes per line\n");
	/*
	 * read in the match data bits per pixel
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->bits_per_pixel),
		sizeof(match_data_ptr->bits_per_pixel),
		"Error while reading match data bits per pixel\n");
	/*
	 * read in the match data visual class
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->visual_class),
		sizeof(match_data_ptr->visual_class),
		"Error while reading match data visual class\n");
	/*
	 * read in the match data red mask
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->red_mask),
		sizeof(match_data_ptr->red_mask),
		"Error while reading match data red mask\n");
	/*
	 * read in the match data green mask
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->green_mask),
		sizeof(match_data_ptr->green_mask),
		"Error while reading match data green mask\n");
	/*
	 * read in the match data blue mask
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->blue_mask),
		sizeof(match_data_ptr->blue_mask),
		"Error while reading match data blue mask\n");
	/*
	 * read in the match data bits per rgb
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->bits_per_rgb),
		sizeof(match_data_ptr->bits_per_rgb),
		"Error while reading match data bits per rgb\n");
	/*
	 * read in the match data colormap entries
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->colormap_entries),
		sizeof(match_data_ptr->colormap_entries),
		"Error while reading match data colormap entries\n");
	/*
	 * read in the match data color structure count
	 */
	readchk(internal_format_fd,
		(char *) &(match_data_ptr->ncolors),
		sizeof(match_data_ptr->ncolors),
		"Error while reading match data color structure count\n");
	/*
	 * if there are any color map entries, read them in
	 */
	if (match_data_ptr->ncolors > 0)
	{
		/*
		 * allocate the space needed to hold the color map entries
		 */
		if ((color_ptr = (XColor *) malloc(sizeof(XColor) *
						   match_data_ptr->ncolors))
		    == (XColor *) 0)
		{
			(void) fprintf(G_msg_file,
				       "error %d while mallocing color map entries\n",
				       errno);
			exit(1);
		}
		/*
		 * remember where the color map entries are
		 */
		match_data_ptr->color_ptr = color_ptr;
		/*
		 * read the color map entries in
		 */
		for (i = 0; i < match_data_ptr->ncolors; i++, color_ptr++)
		{
			/*
			 * read in the color map pixel value
			 */
			readchk(internal_format_fd,
				(char *) &(color_ptr->pixel),
				sizeof(color_ptr->pixel),
				"Error while reading color map pixel value\n");
			/*
			 * read in the color map red value
			 */
			readchk(internal_format_fd,
				(char *) &(color_ptr->red),
				sizeof(color_ptr->red),
				"Error while reading color map red value\n");
			/*
			 * read in the color map green value
			 */
			readchk(internal_format_fd,
				(char *) &(color_ptr->green),
				sizeof(color_ptr->green),
				"Error while reading color map green value\n");
			/*
			 * read in the color map blue value
			 */
			readchk(internal_format_fd,
				(char *) &(color_ptr->blue),
				sizeof(color_ptr->blue),
				"Error while reading color map blue value\n");
			/*
			 * read in the color map flags value
			 */
			readchk(internal_format_fd,
				(char *) &(color_ptr->flags),
				sizeof(color_ptr->flags),
				"Error while reading color map flags value\n");
		}
	}
	else
	{
		/*
		 * there are no color map entries
		 */
		match_data_ptr->color_ptr = (XColor *) 0;
	}
}
