/**********************************************************************
 *
 *	gettop.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * invocation options
 */
extern int		G_debug_flag;
/*
 * device file pointers 
 */
extern FILE		*G_msg_file;
/*
 * ???
 */
extern Display		*G_disp_ptr;

/**********************************************************************
 * function definitions
 **********************************************************************/

void	findchildren();
void	clipwin();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	gettop
 *
 *	Match the top window.
 */
int
gettop(p, top_window_ptr)
/*
 * ???
 */
struct match_data	*p;
/*
 * points to where to return the top window
 */
Window			*top_window_ptr;
{
	/*
	 * ???
	 */
	XWindowAttributes	*info;
	/*
	 * ???
	 */
	XWindowAttributes	*tmp_info;
	/*
	 * ???
	 */
	XWindowAttributes	topinfo;
	/*
	 * ???
	 */
	Window			*ids;
	/*
	 * ???
	 */
	Window			*tmp_ids;
	/*
	 * ???
	 */
	Window			top;
	/*
	 * number of children
	 */
	unsigned int		nc;
	/*
	 * ???
	 */
	int			i;
	/*
	 * ???
	 */
	int			xwinorg;
	/*
	 * ???
	 */
	int			ywinorg;

	p->screen_number = get_current_screen();
	findchildren(p->screen_number, &nc, &ids, &info);
	/*
	 * copy the window and window attribute pointers to temporary copies
	 */
	tmp_info = info;
	tmp_ids = ids;
	/*
	 * advance the temporary pointers to the end of the lists
	 */
	for (i = 0; i < nc - 1; i++)
	{
		tmp_info++;
		tmp_ids++;
	}
	/*
	 * search backwards from the end of the list until you find the top
	 * window
	 */
	for (i = nc - 1; i >= 0; i--, tmp_info--, tmp_ids--)
	{
		xwinorg = tmp_info->x + tmp_info->border_width;
		ywinorg = tmp_info->y + tmp_info->border_width;
		if ((tmp_info->map_state == IsViewable) &&
		    (xwinorg < DisplayWidth(G_disp_ptr, p->screen_number)) &&
		    (ywinorg < DisplayHeight(G_disp_ptr, p->screen_number)) &&
		    (xwinorg + tmp_info->width >= 0) &&
		    (ywinorg + tmp_info->height >= 0))
		{
			top = *tmp_ids;
			topinfo = *tmp_info;
			free((char *) ids);
			free((char *) info);
			break;
		}
	}
	if (i < 0)
	{
		(void) fprintf(G_msg_file,
			       "No windows are mapped.\n");
		/*
		 *    assign a window to top_window_ptr
		 *    but return a failure flag
		 */
		*top_window_ptr = top;
		return (0);
	}
	/*
	 * start out assuming that we want the whole window,
	 * and clip down to what is actually displayed
	 */
	p->width = topinfo.width;
	p->height = topinfo.height;
	clipwin (top, &topinfo, p);
	if (G_debug_flag)
	{
		(void) fprintf(G_msg_file,
			       "gettop: w= %d h=%d subw=%lx\n",
		               p->width,
		               p->height,
		               top);
	}
	/*
	 * set the return parameter to the top window
	 * and return success
	 */
	*top_window_ptr = top;
	return(1);
}
