/**********************************************************************
 *
 *	gettmp.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains standard i/o defines
 */
#include  <stdio.h>
/*
 * contains file control defines
 */
#include  <fcntl.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * client exerciser constants
 */
#include  <xtm.h>

/**********************************************************************
 * variables
 **********************************************************************/

/*
 * pointer to diagnostic/error message file
 */
extern FILE	*G_msg_file;
extern int	errno;

/**********************************************************************
 * function declarationss
 **********************************************************************/

char	*tmpnam();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *      gettmp
 *
 *      This function creates a temporary file.
 */
void
gettmp(tfd, tfname)
/*
 * ???
 */
int     *tfd;
/*
 * ???
 */
char     *tfname;
{

        (void) tmpnam(tfname);
	/*
	 * create the temp file with read/write access
	 */
        *tfd = open(tfname, (O_RDWR | O_CREAT | O_EXCL), FILE_CREATION_MODE);
        if (*tfd < 0)
        {
                (void) fprintf(G_msg_file,
			       "Error %d creating a temporary file.\n",
			       errno);
                exit(1);
        }
}
