/*
 *
 *	get_rect_window.c
 *
 **********************************************************************/

/**********************************************************************
 * include files
 **********************************************************************/

#include  <stdio.h>		/* for NULL constant */
/*
 * X library files
 */
#include  <X11/Xlib.h>
#include  <X11/Xmd.h>
/*
 * xtm-specific constants
 */
#include  <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

extern Display		*G_disp_ptr;		/* display */

extern int           	G_debug_flag;		/* undocumented! */

extern FILE		*G_msg_file;		/* diagnostic/error file */
extern int		errno;

/**********************************************************************
 * variables global to this module
 **********************************************************************/

/**********************************************************************
 * function declarationss
 **********************************************************************/

int		get_rect_window();

static void	failure_msg();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	get_rect_window
 *
 *	Examines subtree of a window for the deepest descendent
 *	which contains a given rectangle.
 *
 *	Returns GoodCoverage if such a window is found, Obscures if
 *	the rectangle is partially or wholly obscured, and NoCoverage
 *	if no window is found which contains or obscures the rectangle.
 *
 *	get_rect_window calls itself recursively.
 *
 */
int
get_rect_window(subw, select, rect, x_offset, y_offset)
Window		 subw;		/* id of window to examine */
Window		*select;	/* id of subwindow containing rectangle */
XRectangle	*rect;
int		*x_offset,	/* rectangle's offset wrt     */
		*y_offset;	/*  the current window, subw. */
{
	XWindowAttributes	win_info;
	Window	dummy;		/* used in call to XQueryTree */
	Window  *child_list;	/*     "		"     */
	unsigned int nchildren;	/*     "		"     */
	int	window_origin_x, window_origin_y;
	int	border_origin_x, border_origin_y;
	int	full_width, full_height;
	int	j;
	int	got_it;
	Bool    contains;
	Bool    x_intersects, y_intersects;

	if (G_debug_flag) 
	{
	    (void) fprintf(G_msg_file,
		"match: subw %lx x=%d y=%d width=%d height=%d.\n",
			subw,
			rect->x, rect->y, rect->width, rect->height);
	}

       /*
	* find out information about the window so that it can
	* be stored with the match data and used/compared later
	*/
	if(!XGetWindowAttributes(G_disp_ptr, subw, &win_info))
	{
	    failure_msg( "XGetWindowAttributes");
	    exit(1);
	}

       /*
	* if the window isn't visible, return False
	*/
	if (    (win_info.class == InputOnly)
	     || (win_info.map_state != IsViewable) )
	    return NoCoverage;

       /*
	* if visible, does the window contain the rectangle?
	* (for this, consider the border as part of the window)
	*/
     
       /*
	* get position of window origin wrt the reference window.
	*/
	border_origin_x = win_info.x + *x_offset;
	border_origin_y = win_info.y + *y_offset;
	full_width	= win_info.width + 2*win_info.border_width;
	full_height	= win_info.height+ 2*win_info.border_width;
	window_origin_x = border_origin_x + win_info.border_width;
	window_origin_y = border_origin_y + win_info.border_width;

       /*
	* (using modified win_info values)
	*/
	contains = ((border_origin_x <= rect->x) 
			&&  (border_origin_y  <= rect->y )
		 && (border_origin_x + full_width >= rect->x + rect->width)
		 && (border_origin_y + full_height >= rect->y + rect->height));
	
	if (contains)	/* check subwindows */
	{
	   *select = subw;	/* provisional result */

	   (void) XQueryTree( G_disp_ptr, subw, &dummy, &dummy,
				&child_list, &nchildren);
	    if (nchildren == 0)
	    {
	        *x_offset = window_origin_x;
	        *y_offset = window_origin_y;
		return GoodCoverage;
	    }
	    else 
	    {
	        for (j=nchildren-1; j>=0; j--)
		{
		    got_it = get_rect_window(child_list[j], select, rect,
				    &window_origin_x, &window_origin_y);
		    if (got_it != NoCoverage)
		    {
	        	*x_offset = window_origin_x;
	        	*y_offset = window_origin_y;
	                return got_it;
		    }
		}
	        *x_offset = window_origin_x;
	        *y_offset = window_origin_y;
		return GoodCoverage;
	    }
	}
	else  /* does it intersect the rectangle? */
        {
	    x_intersects = (border_origin_x <= rect->x + rect->width)
			    && (border_origin_x + full_width >= rect->x);
	    y_intersects = (border_origin_y <= rect->y + rect->height)
			    && (border_origin_y + full_height >= rect->y);
	    if (x_intersects && y_intersects)
	    {
		 return Obscures;
	    }
	    else
	    {
		 return NoCoverage;
	    }
	}	
}

static void
failure_msg( string )
char *string;
{
	(void) fprintf( G_msg_file, "%s failed\n", string );
}
