/**********************************************************************
 *
 *	getkeysym.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>
/*
 * ???
 */
#include  <X11/Xmd.h>
/*
 * X library files
 */
#include  <X11/Xlib.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * the button names
 */
extern char	*G_button_names[];
extern FILE	*G_msg_file;

/**********************************************************************
 * functions
 **********************************************************************/

/******************************************************************************
 *
 *      getkeysym
 *
 *      This routine translate key codes into key name strings.
 *
 *****************************************************************************/
char *
getkeysym(code, display)
/*
 * an X11 key code
 */
CARD8	code;
/*
 * pointer to X11 display
 */
Display	*display;
{
	/*
	 * local X11 struct KeySym for key symbols
	 */
	KeySym	keysym;
	/*
	 * local string for key name
	 */
	char    *keystring;
	/*
	 * to keep lint happy
	 */
	KeyCode	keycodecode;

	/*
	 * if the keycode is between 0 and 7, then it is a button.  Buttons
	 * don't have keysyms, so we have to fake it.
	 */
	if (code < 8)
	{
		keystring = G_button_names[code];
	}
	else
	{
		/*
		 * Convert the key code to the key name
		 */
		keycodecode = (KeyCode) code;
		keysym    = XKeycodeToKeysym(display, keycodecode, 0);
		/*
		 * if there is no keysym corresponding to the key name, error
		 */
		if (keysym == NoSymbol)
		{
			(void) fprintf(G_msg_file,
				       "no keysym corresponding to keycode %d\n",
				       code);
			exit(1);
		}
		keystring = XKeysymToString(keysym);
		/*
		 * if there is no string corresponding to the keysym, error
		 */
		if (keystring == (char *) 0)
		{
			(void) fprintf(G_msg_file,
				       "no string corresponding to keysym %d\n",
				       keysym);
			exit(1);
		}
	}
	return(keystring);
}
