/**********************************************************************
 *
 *	findmouse.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * ???
 */
#include <stdio.h>
/*
 * ???
 */
#include <X11/Xlib.h>
/*
 * ???
 */
#include <X11/Xutil.h>
/*
 * ???
 */
#include <X11/Xmd.h>
/*
 * ???
 */
#include <xtm.h>

/**********************************************************************
 * external variables
 **********************************************************************/

/*
 * invocation options
 */
extern int		G_debug_flag;
/*
 * device file pointers 
 */
extern FILE		*G_msg_file;
/*
 * ???
 */
extern Display		*G_disp_ptr;

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	findmouse
 *
 *	This function determines which window the mouse is in.
 */
void
findmouse(screen_number, subw_ptr)
/*
 * number of the screen to use
 */
int	screen_number;
/*
 * subwindow where mouse is
 */
Window	*subw_ptr;
{
	/*
	 * status returned from request
	 */
	Status		ret;
	/*
	 * x-coordinate of mouse
	 */
	int		x;
	/*
	 * y-coordinate of mouse
	 */
	int		y;
	/*
	 * holds root window id
	 */
	Window		root_id;
	/*
	 * holds root window x coord
	 */
	int		root_x;
	/*
	 * holds root window y coord
	 */
	int		root_y;
	/*
	 * holds modifier state
	 */
	unsigned int	mask_return;

	ret = XQueryPointer(G_disp_ptr,
			    RootWindow(G_disp_ptr, screen_number),
			    &root_id,
			    subw_ptr,
			    &root_x,
			    &root_y,
			    &x,
			    &y,
			    &mask_return);
	if (ret == 0)
	{
		(void) fprintf(G_msg_file, "XQueryPointer failed.\n");
		exit(1);
	}
	if (*subw_ptr != None)
	{
		if (G_debug_flag)
		{
			(void) fprintf(G_msg_file,
				       "Mouse is in subwindow %lx at %d, %d\n",
			               *subw_ptr,
			               x,
			               y);
		}
	}
	else
	{
		*subw_ptr = RootWindow(G_disp_ptr, screen_number);
		if (G_debug_flag)
		{
			(void) fprintf(G_msg_file,
				       "Mouse not in any window, using RootWindow.\n");
		}
	}
}
