/**********************************************************************
 *
 *	compress.c
 *
 **********************************************************************/

/*

Copyright 1986, 1987, 1988, 1989 by Hewlett-Packard Corporation
Copyright 1986, 1987, 1988, 1989 by the Massachusetts Institute of Technology

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of M.I.T. not be used in
advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

Hewlett-Packard and M.I.T. make no representations about the 
suitability of this software for any purpose.  It is provided 
"as is" without express or implied warranty.

This software is not subject to any license of the American
Telephone and Telegraph Company or of the Regents of the
University of California.

*/

/**********************************************************************
 * include files
 **********************************************************************/

/*
 * contains NULL constant
 */
#include  <stdio.h>

/**********************************************************************
 * variables
 **********************************************************************/

/*
 * size of the buffer for screen matches
 */
extern unsigned int	G_sb_size;
/*
 * this buffer holds the "compressed" data
 */
extern unsigned char	*G_c_data_buffer;

/**********************************************************************
 * function declarationss
 **********************************************************************/

void	up_array();

/**********************************************************************
 * functions
 **********************************************************************/

/**********************************************************************
 *
 *	compress
 *
 *	This routine compresses match data.  Consecutive bytes are compared,
 *	and a count is keep of the number of consecutive bytes that are the
 *	same.  The count and bytes value are then copied to a temporary buffer.
 */
int
compress(data_ptr, size, tfd)
/*
 * pointer to the data
 */
char	*data_ptr;
/*
 * size of data (bytes)
 */
int	size;
/*
 * temp file descriptor
 */
int	tfd;
{
	/*
	 * loop counter
	 */
	int		i;
	/*
	 * sum of all bytes
	 */
	int		sumcnt = 0;
	/*
	 * index into temp buffer
	 */
	unsigned int	ndx = 0;
	/*
	 * index into temp buffer
	 */
	int		tndx = 0;
	/*
	 * current byte count
	 */
	unsigned char	cnt = 0;
	/*
	 * current saved byte
	 */
	unsigned char	save;
	/*
	 * byte for comparison
	 */
	unsigned char	byt;

	/*
	 * handle the first byte specially, because the save value is not
	 * initialized yet
	 */
	save = *data_ptr;
	cnt = 1;
	sumcnt = 0;
	ndx = 0;
	for (i = 1; i < size; i++)
	{
		/*
		 * get new byte
		 */
		byt = *(data_ptr + i);
		/*
		 * is current byte the same?
		 */
		if (save == byt)
		{
			/*
			 * yes, increment the count
			 */
			cnt++;
			/*
			 * maximum count
			 */
			if (cnt == 255)
			{
				up_array(tfd, &ndx, &tndx, cnt, save);
				/*
				 * increment total byte count
				 */
				sumcnt += cnt;
				/*
				 * reset current byte count
				 */
				cnt = 0;
			}
		}
		else
		{
			up_array(tfd, &ndx, &tndx, cnt, save);
			/*
			 * increment total byte count
			 */
			sumcnt += cnt;
			/*
			 * reset current byte count
			 */
			cnt = 1;
			/*
			 * new save value
			 */
			save = byt;
		}
	}
	up_array(tfd, &ndx, &tndx, cnt, save);
	/*
	 * increment total byte count
	 */
	sumcnt += cnt;
	if (ndx > 0)
	{
		wrchk2(tfd,
		       (char *) G_c_data_buffer,
		       ndx,
		       "error during write of compressed data\n");
		tndx += ndx;
	}
	return(tndx);
}

/**********************************************************************
 *
 *	up_array
 *
 *	Update the array of compressed data.  Write it to a file if the
 *	array is full.
 */
static void
up_array(tfd, ndx, tndx, cnt, byt)
/*
 * ???
 */
int		tfd;
/*
 * ???
 */
unsigned int	*ndx;
/*
 * ???
 */
int		*tndx;
/*
 * ???
 */
int		cnt;
/*
 * current saved byte
 */
int		byt;
{
	/*
	 * save the byte count
	 */
	*(G_c_data_buffer + (*ndx)) = (unsigned char) cnt;
	/*
	 * save the byt value
	 */
	*(G_c_data_buffer + (*ndx) + 1) = (unsigned char) byt;
	/*
	 * if the compressed data buffer is full, write it out
	 */
	if (*ndx == (G_sb_size * 2) - 2)
	{
		wrchk2(tfd,
		       (char *) G_c_data_buffer,
		       (G_sb_size * 2),
		       "error during write of compressed data\n");
		*tndx += *ndx;
		*ndx = 0;
	}
	else
	{
		(*ndx) += 2;
	}
}
