#!/usr/X/bin/wksh -motif

#
#	Test program for playing with the Table widget from within WKSH
#

#
#	Compile the Table widget (Wcl2.5/Xmp) like this to make a DSO:
#
#		cc -G -K PIC -o Table.so -I/usr/X/include Tab*.c
#
#	Put the DSO in one of these places:
#		
#		/usr/ccs/lib
#		/usr/lib
#		/usr/X/lib
#		./
#

#
#	Load the DSO, and load the xmpTable widget from the DSO
#
libload Table.so
widload xmpTable

#
#	Create the test widgets
#
XtAppInitialize topLevel TableTest TableTest "$@"

XtCreateManagedWidget table table xmpTable $topLevel \

XtCreateManagedWidget lab1 lab1 label $table \
				labelString:"Label Number 1" \

XtCreateManagedWidget but1 but1 pushButton $table \
				labelString:"Button1" \

XtCreateManagedWidget lab2 lab2 label $table \
				labelString:"Label 2" \

XtCreateManagedWidget but2 but2 pushButton $table \
				labelString:"Button Number 2" \

#	Name	Col	Row	ColSpan	RowSpan	Options
XtSetValues $table layout:"
	lab1	0	0	1	1	lwW;
	but1	1	0	1	1	lw;
	lab2	0	1	1	1	lwW;
	but2	1	1	1	1	lw;
"
#	Name	Col	Row	ColSpan	RowSpan	Options

#
#	Run the main loop
#
XtRealizeWidget $topLevel
XtMainLoop

exit	# Just in case

	Here's part of the Table widget man page, for convenience

#############################################################
  New Resources
     The following table defines a set of widget  resources  used
     by	 the programmer	to specify data.  The programmer can also
     set the resource values for the  inherited	 classes  to  set
     attributes	for this widget.  To reference a resource by name
     or	by class in an application defaults file, remove the  XtN
     or	XtC prefix and use the remaining letters.

     The codes	in  the	 access	 column	 indicate  if  the  given
     resource  can  be	set  at	 creation  time	(C), set by using
     XtSetValues (S), retrieved	by using XtGetValues (G),  or  is
     not applicable (N/A).

     XmpTable Resource Set
     Name	       Class		 Type	      Default Access

     XtNlayout	       XtCLayout	 XmpTableLoc  NULL    CSG
     XtNdefaultOptions XtCDefaultOptions XmpTableOpts NULL    CSG
     XtNsameWidth      XtCSameSize	 XrmName**    NULL    CSG
     XtNsameHeight     XtCSameSize	 XrmName**    NULL    CSG
     XtNsameBorder     XtCSameSize	 XrmName**    NULL    CSG
     XtNshrinkSimple   XtCShrinkSimple	 Boolean      True    CSG
     XtNforceShrink    XtCForceShrink	 Boolean      True    CSG
     XtNcolumnSpacing  XtCSpacing	 int	      0	      CSG
     XtNrowSpacing     XtCSpacing	 int	      0	      CSG

     XtNlayout
	  Specifies the	column,	row, column span, row  span,  and
	  options for each child.  The options field is	optional,
	  and takes the	identical form of  the	XtNdefaultOptions
	  resource  discussed below.  If no options are	specified
	  for a	child, that childs options will	be the	value  of
	  the  XtNdefaultOptions resource when the child is first
	  managed.  Children which are not named  in  the  layout
	  specification	 are  positioned in column 0, row 0, with
	  colum	and  row  spans	 of  1,	 and  using  the  default
	  options.   If	 the layout is changed after the XmpTable
	  is created, then a  complete	re-layout  is  performed.
	  The  internal	 type XmpTableLoc which	must be	passed to
	  XtCreateWidget() or to  XtSetValues()	 is  obtained  by
	  passing  a string representation of the layout specifi-
	  cation to XmpTableLocParse() which  will  be	discussed
	  below.   A  layout  resource	consists  of  one  layout
	  specification	per named child, with each layout specif-
	  ication  being  separated  (or terminated) by	a ";" and
	  with each layout specification of the	form:


	       <name> <col> <row> [<opts>]

     XtNdefaultOptions
	  Specifies  the  layout  options  which  apply	 to   all
	  children  which  do not have specific	layout options in
	  the child's layout specification.  The  layout  options
	  allow	 a  child widget to be justified within	the table
	  cell,	and allow the initial size and	dynamic	 resizing
	  of children to be constrained.  Combinations of options
	  can be used: tr means	top and	right, or north-east jus-
	  tification.	Note  that  the	justification does not do
	  anything special with	labels	of  XmLabel  widgets,  or
	  text	in XmText widgets: it simply sets the positioning
	  of the entire	child  widget  within  the  cell  of  the
	  XmpTable.  The  layout  options  consist of a	series of
	  adjacent case	sensitive letters, each	of which  sets	a
	  layout option:

	       l    left justify child in table	cell.

	       r    right justify child	in table cell.

	       t    top	 justify child in table	cell.

	       b    bottom justify child in table cell.

	       w    do not stretch width of column in which child
		    is	positioned during resizing.  Column width
		    will remain	wide enough to contain the widest
		    child in the column.

	       h    do not stretch height of row in  which  child
		    is	positioned  during  resizing.  Row height
		    will remain	high enough to contain	the  tal-
		    lest child in the row.

	       W    do not stretch width of child  during  resiz-
		    ing.   The	width  of  the	column	may  grow
		    (unless constrained	by w), and the child will
		    be justified according to its layout options.

	       H    do not stretch height of child during  resiz-
		    ing.  The height of	the row	 may grow (unless
		    constrained	by h), and the child will be jus-
		    tified according to	its layout options.

     XtNsameWidth XtNsameHeight	XtNsameBorder
	  These	three resources	are used to specify the	names  of
	  children of a	Table which will be constrained	to remain
	  the same size	as the table shrinks and grows,	and  when
	  children  are	 managed and unmanaged,	and when children
	  are allowed to resize.

	  These	three resources	are often set together	by  using
	  their	common resource	class SameSize in resource files.

	  If you have been using WcSameSize() with  limited  suc-
	  cess,	 you  will  probably  like to use these	resources
	  instead.

     XtNshrinkSimple
	  Specifies if simple widgets (widgets	which  have  NULL
	  query_geometry  methods)  should be forced smaller when
	  the table widget is made smaller.  Such simple  widgets
	  will	be  forced to their original preferred sizes, but
	  not smaller.	Widgets	suffering from this malady in the
	  Motif	 widget	 set  include  XmArrowButton, XmArrowBut-
	  tonGadget,   XmDrawnButton,	 XmScale,    XmScrollBar,
	  XmSeparator.	By default, this is True.  Older versions
	  of XmpTable did not provide this feature, and	 so  set-
	  ting	this  resource	False will give	the old	behavior,
	  which	the author found obnoxious.

     XtNforceShrink
	  Specifies if widgets should be made smaller than  their
	  "preferred"	sizes.	 The  XmpTable	widget	tries  to
	  respect the preferred	geometries of its children.  This
	  virtually  always  works  when  the  table is	initially
	  created, but after widgets are  managed,  many  widgets
	  simply  respond  with	 their	current	sizes: this means
	  when the Table is made larger, some children will claim
	  they	do  not	 want to be made smaller.  The difficulty
	  arises because the vocabulary	 of  the  query	 geometry
	  prototcol  is	 somewhat  limited.   Widgets  which  are
	  locked using options including any of	"whWH" will  con-
	  tinue	 to  be	excluded from stretching, but others will
	  be stretched and then	can be shrunk back to their  ini-
	  tial	preferred  sizes  from	the  time  they	were last
	  managed.  When the table is shrunk further,  all  chil-
	  dren	are  shrunk  an	equal number of	pixels until they
	  are of size 1	(the smallest legal size  of  a	 Widget).
	  By  default,	this resource is True.	Older versions of
	  XmpTable did not provide this	feature, and  so  setting
	  this	resource  False	will give the old behavior, which
	  the author found obnoxious.

     XtNcolumnSpacing
	  Specifies the	number of pixels between columns.

     XtNrowSpacing
	  Specifies the	number of pixels between rows.
#############################################################
