#!/usr/X/bin/wksh -motif

#########################################################################
#									
#	Program name, version, and description				
#
#	hw_info:
#		Display kernel configuration of hardware devices
#									
#########################################################################

#########################################################################
#									#
#	Global constants that the user might want to change		#
#									#
#########################################################################

export FPATH=xrerfuncs:/usr/local/X/lib/wksh/xrerfuncs	#Convenience functions

SortOptions="-4 +3"
Source=/etc/conf/sdevice.d/*

#########################################################################
#									#
#	Useful functions						#
#									#
#########################################################################

function create_list
{
	typeset i n
	typeset a si ei sm em d

	#
	#	Delete the old list items, if any
	#
	XtUnmanageChildren $sl

	XtGetValues $sl itemCount:n
	((i=$n))
	while ((i >= 1))
	do
		listdel $sl $i
		((i=i-1))
	done

	#
	#	Construct new list
	#
	cat $Source | grep "	Y" |
		nawk '
			function fix(s) {
				gsub("A", "a", s); gsub("B", "b", s)
				gsub("C", "c", s); gsub("D", "d", s)
				gsub("E", "e", s); gsub("F", "f", s)
				return s
			}
			{
			si=ei=sm=em=""; n=0; i="-"; d="-"
			if ($6) { i=$6; n = 1; }
			if ($7) { si=$7; n = 1; }
			if ($8) { ei=$8; si=$7; n = 1; }
			if ($9) { sm=$9; n = 1; }
			if ($10) { em=$10; n = 1; }
			if ($11 != -1) { d=$11; n = 1; }
			if (n)
			{
				si=fix(si); ei=fix(ei)
				sm=fix(sm); em=fix(em)
				printf "%s\t%2s   %s\t%4s - %4s\t%s-%s\n", \
					$1, i, d, si, ei, sm, em
			}
	}' | newform -i |
	sort $SortOptions | while read a
	do
		listadd $sl "$a"
	done

	XtManageChildren $sl
}


#########################################################################
#									#
#	Callbacks							#
#									#
#########################################################################

function edit_cb
{
	echo "Not Implemented Yet"
}

function help_cb
{
	echo "Help button was pressed"
}

#########################################################################
#									#
#	Main Program							#
#									#
#########################################################################

#
#	Initialize
#
XrerInitialize topLevel hw_info hw_info "$@" \
				allowResize:true \

XtSetValues $topLevel title:"hw_info - by Rick Richardson (rick@digibd.com)"

#
#	Create the dialog itself.  The control area parent is $dialog_ca
#
XrerCreateStandardDialog dialog $topLevel \
			"By IO"		"SortOptions='-4 +3'; create_list" \
			"By MEM"	"SortOptions='-7 +6'; create_list" \
			"By IV"		"SortOptions='-n -2 +1'; create_list" \
			"By DMA"	"SortOptions='-n -3 +2'; create_list" \
			"Change"	edit_cb \
			"Exit"		exit \
			Help		help_cb \

#
#	Create the control area itself
#
XtCreateManagedWidget slLabel slLabel label $dialog_ca \
		labelString:"Device  IV DMA  IO-Addresses    MEM-Addresses" \
		topAttachment:attach_form \
		leftAttachment:attach_form \

XmCreateScrolledList sl $dialog_ca sl \
			visibleItemCount:20 \
			topAttachment:attach_widget \
			topWidget:$slLabel \
			leftAttachment:attach_form \
			bottomAttachment:attach_form \
			rightAttachment:attach_form \

XtAddCallback $sl defaultActionCallback edit_cb

create_list

#
#	Run the main loop
#
XtManageChildren $dialog_ca
XtManageChildren $dialog
XtRealizeWidget $topLevel
XtMainLoop
