#include <stdio.h>
#include <Xm/Xm.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "compact.h"
#include "color.h"
#include "list.h"

#define	DEF_BLACK	BlackPixel(dsp, DefaultScreen(dsp))
#define	DEF_DEPTH	DefaultDepth(dsp, DefaultScreen(dsp))


extern void MakeVisList();
extern void Rotate();
extern void InitCHash();
extern void FreeCHash();
extern unsigned char *ImageToData();
extern void WriteEbcFile();
extern void WriteGif();
extern void Show();
extern void Detail();
extern void DetailZero();
extern void TravelTree();
extern void FreeTree();
extern void Read();

extern int DumpCnt;
extern int DumpFormat;
extern struct col_rec	Colors[];
extern int	Npts, Npolys;
extern int	*AllPolys;
extern float	*AllPts;
extern int	NumCells;
extern int	BaseCount;
extern int	Erode;
extern Display	*dsp;
extern Window	Dwindow;
extern GC	DrawGC;
extern XColor color[];
extern Widget	drawingcore;
extern unsigned int Width, Height;
extern struct node_rec *TreeRoot;
extern float	distance;
extern int count;
extern struct col_rec DynColors[];
extern int Iter;



Bool ScriptMode = False;

static int s_repeat, s_iter, s_dx, s_dy, s_dz, s_draw;
static float s_dd;


/*
 * Start the reading of a script file
 */
void
ReadScript(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	ScriptMode = True;
	Read(w, client_data, call_data);
}


/*
 * A waste of space which does nothing but try and open the passed
 * file for reading, and exits if it fails.
 */
FILE *
OpenScript(file)
	char *file;
{
	FILE *fp;

	/*
	 * Open the filename passed for read.  If cannot read or filename is
	 * invalid, then report error.
	 */
	if ((file == NULL)||(*file == '\0'))
	{
		fp = NULL;
	}
	else
	{
		fp = fopen(file, "r");
		if (fp == NULL)
		{
			fprintf(stderr, "cannot open file (%s) for reading\n",
				file);
		}
	}

	if (fp == NULL)
	{
		exit(1);
	}
	return(fp);
}


/*
 * Get the next Move or Draw command from the script file.
 * return -1 if there are no more in the file.
 */
int
GetScript(fp)
	FILE *fp;
{
	int temp1;
	float ftemp;
	char line[100];

	line[0] = '\0';
	fscanf(fp, "%s %d\n", line, &temp1);

	if (strcmp(line, "Draw") == 0)
	{
		s_draw = 1;
		s_repeat = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_iter = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_dx = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_dy = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_dz = temp1;
		fscanf(fp, "%f\n", &ftemp);
		s_dd = ftemp;
	}
	else if (strcmp(line, "Move") == 0)
	{
		s_draw = 0;
		s_repeat = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_iter = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_dx = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_dy = temp1;
		fscanf(fp, "%d\n", &temp1);
		s_dz = temp1;
		fscanf(fp, "%f\n", &ftemp);
		s_dd = ftemp;
	}
	else
	{
		return(-1);
	}
	return(0);
}


/*
 * Almost identical to the dump routine in dump.c.  But since it is dumping
 * a Pixmap, it doesn't need to check if the window is mapped.
 */
void
ScriptDump()
{
        char filename[256];
        unsigned char *imagedata;
        XImage *grabImage;

	XSetSubwindowMode(dsp, DrawGC, IncludeInferiors);
	XFlush(dsp);
	grabImage = XGetImage(dsp, Dwindow, 0, 0,
		Width, Height, AllPlanes, ZPixmap);
	imagedata = ImageToData(grabImage, Width, Height,
		DefaultDepth(dsp, DefaultScreen(dsp)));
	XDestroyImage(grabImage);
	XSetSubwindowMode(dsp, DrawGC, ClipByChildren);
	sprintf(filename, "dump%03d", DumpCnt);
	DumpCnt++;
	if (DumpFormat == EBC)
	{
		strcat(filename, ".ebc");
		WriteEbcFile(filename, imagedata, Width, Height, color);
	}
	else if (DumpFormat == GIF)
	{
		strcat(filename, ".gif");
		WriteGif(filename, imagedata, Width, Height, color);
	}
	XtFree(imagedata);
printf("Dump (%s) Done!\n", filename);
}



/*
 * Unmanage the drawing window.  Allocate a pixmap and fake it to be
 * the drawing window.  Execute a series of movements from the script
 * file, taking image dumps as you go.
 */
void
DoScript(file)
	char *file;
{
	FILE *fp;
	int i, j;
	Pixmap Ppix;

	if (XtIsManaged(drawingcore))
	{
		Show((Widget)NULL, (caddr_t)NULL, (caddr_t)NULL);
	}

	Ppix = XCreatePixmap(dsp, Dwindow, Width, Height, DEF_DEPTH);
	Dwindow = Ppix;

	fp = OpenScript(file);
	while (GetScript(fp) != -1)
	{
		if ((s_iter != Iter)&&(s_iter == 0))
		{
			DetailZero((Widget)NULL, (caddr_t)NULL, (caddr_t)NULL);
		}
		else if (s_iter != Iter)
		{
			Detail((Widget)NULL, (caddr_t)s_iter, (caddr_t)NULL);
		}

		for (j=0; j < s_repeat; j++)
		{
			if (s_draw)
			{
				TreeRoot = NULL;
				MakeVisList(AllPolys, AllPts, Npolys, Erode,
					distance);
				XSetForeground(dsp, DrawGC, DEF_BLACK);
				XFillRectangle(dsp, Dwindow, DrawGC, 0, 0,
					Width, Height);
				count = BaseCount;
				for (i=0; i<NumCells; i++)
				{
					DynColors[i].red = Colors[i].red;
					DynColors[i].green = Colors[i].green;
					DynColors[i].blue = Colors[i].blue;
				}
				if (TreeRoot != NULL)
				{
					InitCHash();
					TravelTree(TreeRoot, distance);
					XFlush(dsp);
					FreeTree(TreeRoot);
					FreeCHash();
				}
				ScriptDump();
			}

			Rotate(AllPts, Npts, s_dx, s_dy, s_dz);
			distance = distance + s_dd;
		}
	}
	fclose(fp);
	exit(0);
}

