#include <Xm/Xm.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "edit.h"

#define DEF_BLACK       BlackPixel(dsp, DefaultScreen(dsp))


extern void doTriangles();
extern void free_pt_list();
extern void FreeLines();


extern Display *dsp;
extern GC DrawGC;
extern float distance;
extern Widget controlform;
extern Widget listlist;
extern int EditType;


Bool EditMode = False;
Bool Perspective = True;


/*
 * Toggle on and off edit mode, which toggles hidden surface removal.
 * Also pop up the control panel that moves points.
 */
void
Edit(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	if (EditMode == True)
	{
		EditMode = False;
		free_pt_list();
		FreeLines();
		XtUnmanageChild(controlform);
		XtUnmanageChild(listlist);
	}
	else
	{
		EditMode = True;
		if (!XtIsManaged(controlform))
		{
			XtManageChild(controlform);
		}
		if (!XtIsManaged(listlist))
		{
			XtManageChild(listlist);
		}
	}
	EditType = SELECT;
	/*
	 * force a redraw
	 */
	doTriangles(0, 0, 0, distance);
}


/*
 * Toggle on and off perspective mode, which warps x and y coordinates
 * based on z coordinate.
 */
void
ChangePerspective(w, client_data, call_data)
	Widget w;
	caddr_t client_data, call_data;
{
	if (Perspective == True)
	{
		Perspective = False;
	}
	else
	{
		Perspective = True;
	}
	/*
	 * force a redraw
	 */
	doTriangles(0, 0, 0, distance);
}


/*
 * The editing control panel has been exposed.  Redraw it.
 * This involves checking its size (we really should catch resize events
 * to track size) and then drawing it accordingly.
 */
void
ControlExpose(w, data, event)
        Widget w;
        caddr_t data;
        XEvent *event;
{
        XExposeEvent *ExEvent = (XExposeEvent *)event;
	Window rwin;
	int x1, y1, x2, y2;
	int x, y;
	unsigned int width, height;
	unsigned int border;
	unsigned int depth;
	unsigned int lwidth;

	XGetGeometry(dsp, XtWindow(w), &rwin, &x, &y,
		&width, &height, &border, &depth);

	XSetForeground(dsp, DrawGC, DEF_BLACK);
	XSetSubwindowMode(dsp, DrawGC, IncludeInferiors);
	XClearArea(dsp, XtWindow(w), 0, 0, 0, 0, False);

	/*
	 * Draw Y-axis line
	 */
	x1 = 50 * width / 100;
	y1 = 12 * height / 100;
	x2 = x1;
	y2 = 88 * height / 100;
	lwidth = 1 * width / 100;
	XSetLineAttributes(dsp, DrawGC, lwidth, LineSolid, CapButt, JoinMiter);
	XDrawLine(dsp, XtWindow(w), DrawGC, x1, y1, x2, y2);

	/*
	 * Draw X-axis line
	 */
	x1 = 12 * width / 100;
	y1 = 50 * height / 100;
	x2 = 88 * width / 100;
	y2 = y1;
	lwidth = 1 * height / 100;
	XSetLineAttributes(dsp, DrawGC, lwidth, LineSolid, CapButt, JoinMiter);
	XDrawLine(dsp, XtWindow(w), DrawGC, x1, y1, x2, y2);

	/*
	 * Draw Z-axis line
	 */
	x1 = 12 * width / 100;
	y1 = 88 * height / 100;
	x2 = 88 * width / 100;
	y2 = 12 * height / 100;
	lwidth = 1 * (width + height) / 200;
	XSetLineAttributes(dsp, DrawGC, lwidth, LineSolid, CapButt, JoinMiter);
	XDrawLine(dsp, XtWindow(w), DrawGC, x1, y1, x2, y2);

	XSetLineAttributes(dsp, DrawGC, 0, LineSolid, CapButt, JoinMiter);
	XSetSubwindowMode(dsp, DrawGC, ClipByChildren);
}

