

#include <stdio.h>
#include <math.h>

int TwoSides;
int NPTS;
float RAD;

main(argc, argv)
    int argc;
    char **argv;
{
	int i;
	double f, turn, x, y, z;
	int t1, t2, t3, t4;

	if (argc > 3)
	{
		fprintf(stderr, "usage: %s [-p<num_pts>] [-r<radius>] [-two]\n",
			argv[0]);
	}
	TwoSides = 0;
	NPTS = 0;
	RAD = 0.2;
	for (i = 1; i < argc; i++)
	{
		if ((argv[i][0] == '-')&&(argv[i][1] == 'p'))
		{
			NPTS = atoi(&argv[i][2]);
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 'r'))
		{
			RAD = atof(&argv[i][2]);
			if (RAD <= 0.0)
			{
				fprintf(stderr, "Warning RAD (%f) is too small setting it to 0.2\n", RAD);
				RAD = 0.2;
			}
		}
	}

	if (NPTS == 0)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}

	printf("%d\n", ((NPTS + 1) * 2));
	printf("%d\n", (NPTS * 4));
	for (i=0; i<=NPTS; i++)
	{
		x = ((double)i * 2 / NPTS) - 1.0;
		turn = ((double)i / NPTS);
		z = RAD * cos(turn * M_PI);
		y = RAD * sin(turn * M_PI);
		printf("%lf %lf %lf\n", x, y, z);
		printf("%lf %lf %lf\n", x, -y, -z);
	}

	t1 = 0;
	t2 = 1;
	t3 = 2;
	t4 = 3;
	for (i=0; i<NPTS; i++)
	{
		printf("%d %d %d P2\n", t1, t2, t4);
		printf("%d %d %d P2\n", t1, t4, t3);
		t1 += 2;
		t2 += 2;
		t3 += 2;
		t4 += 2;
	}

	t1 = 0;
	t2 = 1;
	t3 = 2;
	t4 = 3;
	for (i=0; i<NPTS; i++)
	{
		printf("%d %d %d P3\n", t1, t4, t2);
		printf("%d %d %d P3\n", t1, t3, t4);
		t1 += 2;
		t2 += 2;
		t3 += 2;
		t4 += 2;
	}
	printf("Colormap 256\n");
	printf("red green blue\n");
	printf("0 0 0\n");
	printf("0 0 0\n");
	printf("255 0 0\n");
	printf("0 0 255\n");
}

